<?php namespace Phpcmf\Model;

class Zhanzhang extends \Phpcmf\Model
{

    private $zzurl = [
        'add' => 'http://data.zz.baidu.com/urls',
        'edit' => 'http://data.zz.baidu.com/update',
        'del' => 'http://data.zz.baidu.com/del',
    ];
    private $zzconfig;

    // 配置信息
    public function getConfig() {

        if ($this->zzconfig) {
            return $this->zzconfig;
        }

        if (is_file(WRITEPATH.'config/zhanzhang.php')) {
            $this->zzconfig = require WRITEPATH.'config/zhanzhang.php';
            return $this->zzconfig;
        }

        return [];
    }

    // 配置信息
    public function setConfig($data) {

        \Phpcmf\Service::L('Config')->file(WRITEPATH.'config/zhanzhang.php', '站长配置文件', 32)->to_require($data);

    }

    // 进行百度推送
    public function bdts($url, $action = 'add') {

        $uri = parse_url($url);
        $site = $uri['host'];
        if (!$site) {
            return;
        }

        $config = $this->getConfig();
        if (!$config) {
            return;
        } elseif (!$config['bdts']) {
            return;
        }

        $token = '';
        $bdts = explode(PHP_EOL, $config['bdts']);
        foreach ($bdts as $t) {
            list($st, $tk) = explode(' ', $t);
            if (strcasecmp($st, $site) == 0) {
                $token = $tk;
                break;
            }
        }
        if (!$token) {
            return;
        }

        $api = $this->zzurl[$action].'?site='.$site.'&token='.$token;
        $urls = [$url];
        $ch = curl_init();
        $options =  array(
            CURLOPT_URL => $api,
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS => implode("\n", $urls),
            CURLOPT_HTTPHEADER => array('Content-Type: text/plain'),
        );
        curl_setopt_array($ch, $options);
        $rt = json_decode(curl_exec($ch), true);
        if ($rt['error']) {
            // 错误日志
            log_message('error', '站长工具-百度主动推送（'.$url.'）- '.$rt['message']);
        }

    }

    // 网站地图
    public function sitemap() {

        $xml = '<?xml version="1.0" encoding="utf-8"?>'.PHP_EOL;
        $xml.= '<urlset>'.PHP_EOL;
        $config = $this->getConfig();
        if ($config['sitemap']) {
            // 判断站点id
            $site_domain = []; // 全网域名对应的站点id
            if (is_file(WRITEPATH.'config/domain_site.php')) {
                $site_domain = require WRITEPATH.'config/domain_site.php';
            }
            $siteid = max(1, intval($site_domain[DOMAIN_NAME]));
            // 显示数量
            $limit = intval($config['sitemap_limit']);
            !$limit && $limit = 1000;

            if (APP_DIR) {
                // 单独模块
                $data = $this->_sitemap_module_xml($siteid, APP_DIR, $limit);
                if ($data) {
                    foreach ($data as $t) {
                        $xml.= $t['xml'];
                    }
                }
            } else {
                // 全站模块
                $data = [];
                foreach ($config['sitemap'] as $mid => $t) {
                    $my = $this->_sitemap_module_xml($siteid, $mid, $limit);
                    $my && $data = array_merge($data, $my);
                }
                if ($data) {
                    usort($data, function($a, $b) {
                        if ($a['time'] == $b['time'])
                            return 0;
                        return ($a['time'] > $b['time']) ? -1 : 1;
                    });
                    foreach ($data as $t) {
                        $xml.= $t['xml'];
                    }
                }
            }

        }

        $xml.= '</urlset>'.PHP_EOL;

        return $xml;
    }

    // 模块内容生成xml
    private function _sitemap_module_xml($siteid, $mid, $limit) {

        $data = [];
        $query = $this->db->table($siteid.'_'.$mid)->select('url,updatetime')->orderBy('updatetime desc')->limit($limit)->get();
        if ($query) {
            $rows = $query->getResultArray();
            if ($rows) {
                foreach ($rows as $t) {
                    $xml = '';
                    $xml.= '    <url>'.PHP_EOL;
                    $xml.= '        <loc>'.htmlspecialchars(dr_url_prefix($t['url'], '', $siteid)).'</loc>'.PHP_EOL;
                    $xml.= '        <lastmod>'.date('Y-m-d', $t['updatetime']).'</lastmod>'.PHP_EOL;
                    $xml.= '        <changefreq>daily</changefreq>'.PHP_EOL;
                    $xml.= '        <priority>1.0</priority>'.PHP_EOL;
                    $xml.= '    </url>'.PHP_EOL;
                    $data[] = [
                        'xml' => $xml,
                        'time' => $t['updatetime'],
                    ];
                }
            }
        }

        return $data;
    }

}