<?php

/**
 * 菜单配置
 */


return [

    'admin' => [

        'home' => [
            'name' => '首页',
            'icon' => 'fa fa-home',
            'left' => [
                'home-my' => [
                    'name' => '我的面板',
                    'icon' => 'fa fa-home',
                    'link' => [
                        [
                            'name' => '后台首页',
                            'icon' => 'fa fa-home',
                            'uri' => 'home/main',
                        ],
                        [
                            'name' => '资料修改',
                            'icon' => 'fa fa-user',
                            'uri' => 'api/my',
                        ],
                        [
                            'name' => '系统更新',
                            'icon' => 'fa fa-refresh',
                            'uri' => 'cache/index',
                        ],
                    ]
                ],
            ],
        ],


        'system' => [
            'name' => '系统',
            'icon' => 'fa fa-globe',
            'left' => [
                'system-wh' => [
                    'name' => '系统维护',
                    'icon' => 'fa fa-cog',
                    'link' => [
                        [
                            'name' => '系统环境',
                            'icon' => 'fa fa-cog',
                            'uri' => 'system/index',
                        ],
                        [
                            'name' => '系统缓存',
                            'icon' => 'fa fa-clock-o',
                            'uri' => 'system_cache/index',
                        ],
                        [
                            'name' => '短信设置',
                            'icon' => 'fa fa-envelope',
                            'uri' => 'sms/index',
                        ],
                        [
                            'name' => '邮件设置',
                            'icon' => 'fa fa-envelope-open',
                            'uri' => 'email/index',
                        ],
                        [
                            'name' => '系统提醒',
                            'icon' => 'fa fa-bell',
                            'uri' => 'notice/index',
                        ],
                        [
                            'name' => '数据字典',
                            'icon' => 'fa fa-database',
                            'uri' => 'db/index',
                        ],
                    ]
                ],
                'system-log' => [
                    'name' => '日志管理',
                    'icon' => 'fa fa-calendar',
                    'link' => [
                        [
                            'name' => 'PHP错误',
                            'icon' => 'fa fa-bug',
                            'uri' => 'error_php/index',
                        ],
                        [
                            'name' => '系统错误',
                            'icon' => 'fa fa-shield',
                            'uri' => 'error/index',
                        ],
                        [
                            'name' => '操作日志',
                            'icon' => 'fa fa-calendar',
                            'uri' => 'system_log/index',
                        ],
                        [
                            'name' => '短信日志',
                            'icon' => 'fa fa-envelope',
                            'uri' => 'sms_log/index',
                        ],
                        [
                            'name' => '邮件日志',
                            'icon' => 'fa fa-envelope-open',
                            'uri' => 'email_log/index',
                        ],
                    ]
                ],
            ],
        ],

        'config' => [
            'name' => '设置',
            'icon' => 'fa fa-cogs',
            'left' => [
                'config-web' => [
                    'name' => '网站设置',
                    'icon' => 'fa fa-cog',
                    'link' => [
                        [
                            'name' => '网站设置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'site_config/index',
                        ],
                        [
                            'name' => '手机设置',
                            'icon' => 'fa fa-mobile',
                            'uri' => 'site_mobile/index',
                        ],
                        [
                            'name' => '域名绑定',
                            'icon' => 'fa fa-globe',
                            'uri' => 'site_domain/index',
                        ],
                    ]
                ],

                'config-seo' => [
                    'name' => 'SEO设置',
                    'icon' => 'fa fa-internet-explorer',
                    'link' => [
                        [
                            'name' => '站点SEO',
                            'icon' => 'fa fa-cog',
                            'uri' => 'seo_site/index',
                        ],
                    ]
                ],
                'config-member' => [
                    'name' => '用户设置',
                    'icon' => 'fa fa-user',
                    'link' => [
                        [
                            'name' => '用户设置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'member_setting/index',
                        ],
                        
                    ]
                ],
                'config-pay' => [
                    'name' => '支付设置',
                    'icon' => 'fa fa-rmb',
                    'link' => [
                        [
                            'name' => '支付设置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'member_payconfig/index',
                        ],
                        [
                            'name' => '支付接口',
                            'icon' => 'fa fa-code',
                            'uri' => 'member_payapi/index',
                        ],
                    ],
                ],
            ],
        ],

        'auth' => [
            'name' => '权限',
            'icon' => 'fa fa-user-circle',
            'left' => [
                'auth-admin' => [
                    'name' => '后台权限',
                    'icon' => 'fa fa-cog',
                    'link' => [
                        [
                            'name' => '后台菜单',
                            'icon' => 'fa fa-list-alt',
                            'uri' => 'menu/index',
                        ],
                        [
                            'name' => '角色权限',
                            'icon' => 'fa fa-users',
                            'uri' => 'role/index',
                        ],
                        [
                            'name' => '角色账号',
                            'icon' => 'fa fa-user',
                            'uri' => 'root/index',
                        ],
                        [
                            'name' => '审核流程',
                            'icon' => 'fa fa-sort-numeric-asc',
                            'uri' => 'verify/index',
                        ],
                    ]
                ],
                'auth-h5' => [
                    'name' => 'H5游戏权限',
                    'icon' => 'fa fa-cog',
                    'link' => [
                        [
                            'name' => 'H5菜单',
                            'icon' => 'fa fa-reorder',
                            'uri' => 'h5_menu/index',
                        ],

                    ]
                ],
            ],
        ],

        'content' => [
            'name' => '内容',
            'icon' => 'fa fa-th-large',
            'left' => [
                'content-module' => [
                    'name' => '内容管理',
                    'icon' => 'fa fa-th-large',
                    'link' => [
                        [
                            'name' => '栏目管理',
                            'icon' => 'fa fa-reorder',
                            'uri' => 'module_category/index',
                        ],
                       
                        [
                            'name' => '自定义链接',
                            'icon' => 'fa fa-link',
                            'uri' => 'navigator/index',
                        ],
                    ]
                ],
                'content-form' => [
                    'name' => '网站表单',
                    'icon' => 'fa fa-table',
                    'link' => []
                ],
                'content-verify' => [
                    'name' => '内容审核',
                    'icon' => 'fa fa-edit',
                    'link' => [
                    ]
                ],
            ],
        ],


        'code' => [
            'name' => '界面',
            'icon' => 'fa fa-html5',
            'left' => [
                'code-html' => [
                    'name' => '模板管理',
                    'icon' => 'fa fa-home',
                    'link' => [
                        [
                            'name' => '电脑模板',
                            'icon' => 'fa fa-desktop',
                            'uri' => 'tpl_pc/index',
                        ],
                    ]
                ],
                'code-css' => [
                    'name' => '风格管理',
                    'icon' => 'fa fa-css3',
                    'link' => [
                        [
                            'name' => '系统文件',
                            'icon' => 'fa fa-chrome',
                            'uri' => 'system_theme/index',
                        ],
                        [
                            'name' => '网站风格',
                            'icon' => 'fa fa-photo',
                            'uri' => 'theme/index',
                        ],
                    ],
                    'displayorder' => 99
                ],
            ],
        ],

        'member' => [
            'name' => '用户',
            'icon' => 'fa fa-user',
            'left' => [
                'member-list' => [
                    'name' => '用户管理',
                    'icon' => 'fa fa-user',
                    'link' => [
                        [
                            'name' => '用户管理',
                            'icon' => 'fa fa-user',
                            'uri' => 'member/index',
                        ],
                        [
                            'name' => '用户组管理',
                            'icon' => 'fa fa-users',
                            'uri' => 'member_group/index',
                        ],
                    ]
                ],
                'member-verify' => [
                    'name' => '审核管理',
                    'icon' => 'fa fa-edit',
                    'link' => [
                        [
                            'name' => '注册审核',
                            'icon' => 'fa fa-edit',
                            'uri' => 'member_verify/index',
                        ],
                        [
                            'name' => '申请审核',
                            'icon' => 'fa fa-users',
                            'uri' => 'member_apply/index',
                        ],
                    ]
                ],

            ],
        ],

        'pay' => [
            'name' => '财务',
            'icon' => 'fa fa-rmb',
            'left' => [
                'pay-list' => [
                    'name' => '财务管理',
                    'icon' => 'fa fa-rmb',
                    'link' => [
                        [
                            'name' => '已付流水',
                            'icon' => 'fa fa-calendar-check-o',
                            'uri' => 'member_paylog/index',
                        ],
                        [
                            'name' => '未付流水',
                            'icon' => 'fa fa-calendar-times-o',
                            'uri' => 'member_paylog/not_index',
                        ],
                        [
                            'name' => '转账汇款',
                            'icon' => 'fa fa-credit-card',
                            'uri' => 'member_payremit/index',
                        ],
                        [
                            'name' => '上门收款',
                            'icon' => 'fa fa-user',
                            'uri' => 'member_paymeet/index',
                        ],
                        [
                            'name' => '提现管理',
                            'icon' => 'fa fa-credit-card',
                            'uri' => 'member_cash/index',
                        ],
                        [
                            'name' => '用户充值',
                            'icon' => 'fa fa-plus',
                            'uri' => 'member_pay/index',
                        ],
                    ]
                ],

            ],
        ],

        'app' => [
            'name' => '插件',
            'icon' => 'fa fa-puzzle-piece',
            'left' => [
                'app-plugin' => [
                    'name' => '功能插件',
                    'icon' => 'fa fa-puzzle-piece',
                    'link' => [
                        [
                            'name' => '联动菜单',
                            'icon' => 'fa fa-columns',
                            'uri' => 'linkage/index',
                        ],
                        [
                            'name' => '任务队列',
                            'icon' => 'fa fa-indent',
                            'uri' => 'cron/index',
                        ],
                       
                        [
                            'name' => 'H5游戏管理',
                            'icon' => 'fa fa-cog',
                            'uri' => 'hd/hd_module/index',
                        ],
                    ]
                ],
            ],
        ],

        'product' => [
            'name' => '授权服务',
            'icon' => 'fa fa-cloud',
            'displayorder' => 99,
            'left' => [
                'product' => [
                    'name' => '会员服务',
                    'icon' => 'fa fa-cloud',
                    'link' => [
                        [
                            'name' => '授权类型',
                            'icon' => 'fa fa-puzzle-piece',
                            'uri' => 'product/index',
                        ],
                        [
                            'name' => '新增类型',
                            'icon' => 'fa fa-puzzle-piece',
                            'uri' => 'product/add',
                        ],
                        [
                            'name' => '权限功能',
                            'icon' => 'fa fa-puzzle-piece',
                            'uri' => 'option/index',
                        ],
                        [
                            'name' => '功能添加',
                            'icon' => 'fa fa-puzzle-piece',
                            'uri' => 'option/add',
                        ]
                    ]
                ]
            ],
        ],


    ],


    'member' => [

        'service' => [
            'name' => '会员服务',
            'link' => [
                [
                    'name' => '待支付订单',
                    'uri' => 'order_pay/index',
                ],
                [
                    'name' => '已完成订单',
                    'uri' => 'order_success/index',
                ],
            ],
        ],

        'account' => [
            'name' => '个人信息',
            'link' => [
                [
                    'name' => '修改资料',
                    'uri' => 'account/index',
                ],
                [
                    'name' => '修改密码',
                    'uri' => 'account/password',
                ],
                [
                    'name' => '便捷登录',
                    'uri' => 'account/oauth',
                ],
            ],
        ],


    ],
];