<?php namespace My\Field;

class Myid extends \Phpcmf\Library\A_Field {
	
	/**
     * 构造函数
     */
    public function __construct(...$params) {
        parent::__construct(...$params);
		$this->fieldtype = TRUE;
		$this->defaulttype = 'INT';
    }
	
	/**
	 * 字段相关属性参数
	 *
	 * @param	array	$value	值
	 * @return  string
	 */
	public function option($option) {

		$style = '';
		$option = '';

		return [$option, $style];
	}

    /**
     * 创建sql语句
     */
    public function create_sql($name, $option, $cname) {
        $sql = 'ALTER TABLE `{tablename}` ADD `myid` int( 10 ) UNSIGNED NULL COMMENT \''.$cname.'\'';
        return $sql;
    }

    /**
     * 修改sql语句
     */
    public function alter_sql($name, $value, $cname) {
        return NULL;
    }

    /**
     * 删除sql语句
     */
    public function drop_sql($name) {
        return 'ALTER TABLE `{tablename}` DROP `myid`';
    }

    /**
     * 字段入库值
     *
     * @param	array	$field	字段信息
     * @return  void
     */
    public function insert_value($field) {
        \Phpcmf\Service::L('Field')->data[$field['ismain']][$field['fieldname']] = (int)\Phpcmf\Service::L('Field')->post[$field['fieldname']];
    }

    /**
     * 字段表单输入
     *
     * @param	string	$field	字段数组
     * @param	array	$value	值
     * @return  string
     */
    public function input($field, $value = null) {

        // 字段禁止修改时就返回显示字符串
        if ($this->_not_edit($field, $value)) {
            return $this->show($field, $value);
        }

        // 字段存储名称
        $name = $field['fieldname'];

        // 字段显示名称
        $text = ($field['setting']['validate']['required'] ? '<span class="required" aria-required="true"> * </span>' : '').$field['name'];

        // 字段提示信息
        $tips = $field['setting']['validate']['tips'] ? '<span class="help-block" id="dr_'.$field['fieldname'].'_tips">'.$field['setting']['validate']['tips'].'</span>' : '';

        // 字段默认值
        $value = strlen($value) ? $value : $this->get_default_value($field['setting']['option']['value']);
        !$value && isset($_GET['myid']) && $value = intval($_GET['myid']);


        $str = '<label>'.\Phpcmf\Service::L('Tree')->select_category(
            $this->_get_category(),
            $value,
            'id=\'dr_myid\' name=\'data[myid]\'',
            ' -- ', 1, 1).'</label>';


        return $this->input_format($name, $text, $str.$tips);
    }

    /**
     * 字段表单显示
     *
     * @param	string	$field	字段数组
     * @param	array	$value	值
     * @return  string
     */
    public function show($field, $value = null) {
        $category = $this->_get_category();
        return $this->input_format($field['fieldname'], $field['name'], '<div class="form-control-static">'.$category[$value]['name'].'</div>');
    }

    // 查询本模块的栏目
    private function _get_category() {

        $data = \Phpcmf\Service::M()->table(SITE_ID.'_space_mycategory')->where('uid', \Phpcmf\Service::C()->uid)->order_by('displayorder ASC,id ASC')->getAll();
        if (!$data) {
            return;
        }

        // 全部栏目数据
        $category = [];
        foreach ($data as $t) {
            if (!$t['child'] && $t['tid'] == 1 && $t['mid'] != MOD_DIR) {
                continue;
            }
            $category[$t['id']] = $t;
        }

        return $category;
    }
}