<?php

// 初始化程序执行代码
$this->weixin_id = 99; // 已经关注的微信用户id
$this->weixin = []; // 微信用户信息

// 子站url规则
function dr_space_urlrule($id = 0) {

    $data = [

        1 => [
            'name' => '/news/和/news/123.html',
            'value' => [
                'category' => '{dirname}/',
                'category_page' => '{dirname}/p{page}.html',
                'show' => '{dirname}/{id}.html',
            ],
            'rewrite' => [
                'is_test' => 'index.php?c=home&m=test',
                "([\w]+)\/p([0-9]+).html(.*)"  => 'index.php?c=category&dir=$1&page=$2',
                "([\w]+)\/([0-9]+).html(.*)"  => 'index.php?c=show&id=$2',
                "([\w]+)"  => 'index.php?c=category&dir=$1',
            ],
        ],

        2 => [
            'name' => '/list_news.html和/news_123.html',
            'value' => [
                'category' => 'list_{dirname}.html',
                'category_page' => 'list_{dirname}_p{page}.html',
                'show' => '{dirname}_{id}.html',
            ],
            'rewrite' => [
                'is_test' => 'index.php?c=home&m=test',
                "list_([\w]+)_p([0-9]+).html(.*)"  => 'index.php?c=category&dir=$1&page=$2',
                "list_([\w]+).html"  => 'index.php?c=category&dir=$1',
                "([\w]+)_([0-9]+).html(.*)"  => 'index.php?c=show&id=$2',
            ],
        ],

    ];

    if ($id) {
        return $data[$id];
    } else {
        return $data;
    }

}

/**
 * 模型内容URL地址
 */
function dr_space_show_url($rule, $data, $cat) {


    // URL模式为自定义，且已经设置规则
    $cat['pdirname'].= $cat['dirname'];
    $data['dirname'] = $cat['dirname'];
    $inputtime = $data['inputtime'];
    $data['y'] = date('Y', $inputtime);
    $data['m'] = date('m', $inputtime);
    $data['d'] = date('d', $inputtime);
    $data['pdirname'] = str_replace('/', $rule['catjoin'], $cat['pdirname']);
    $url = ltrim($rule, '/');

    // 兼容php5.5
    if (version_compare(PHP_VERSION, '5.5.0') >= 0) {
        $rep = new php5replace($data);
        $url = preg_replace_callback("#{([a-z_0-9]+)}#Ui", array($rep, 'php55_replace_data'), $url);
        $url = preg_replace_callback('#{([a-z_0-9]+)\((.*)\)}#Ui', array($rep, 'php55_replace_function'), $url);
        unset($rep);
    } else {
        $url = preg_replace('#{([a-z_0-9]+)}#Uei', "\$data[\\1]", $url);
        $url = preg_replace('#{([a-z_0-9]+)\((.*)\)}#Uie', "\\1(dr_safe_replace('\\2'))", $url);
    }

    return '/'.$url;
}



/**
 * 模型栏目URL地址
 */
function dr_space_category_url($rule, $data, $page = 0) {

    $page && $data['page'] = $page = is_numeric($page) ? max((int)$page, 1) : $page;


    // URL模式为自定义，且已经设置规则
    $data['pdirname'].= $data['dirname'];
    $url = ltrim($rule , '/');
    // 兼容php5.5
    if (version_compare(PHP_VERSION, '5.5.0') >= 0) {
        $rep = new php5replace($data);
        $url = preg_replace_callback("#{([a-z_0-9]+)}#Ui", array($rep, 'php55_replace_data'), $url);
        $url = preg_replace_callback('#{([a-z_0-9]+)\((.*)\)}#Ui', array($rep, 'php55_replace_function'), $url);
        unset($rep);
    } else {
        $url = preg_replace('#{([a-z_0-9]+)}#Uei', "\$data[\\1]", $url);
        $url = preg_replace('#{([a-z_0-9]+)\((.*)\)}#Uie', "\\1(dr_safe_replace('\\2'))", $url);
    }

    return '/'.$url;

}

// 获取子站图片
function dr_space_image_file($img) {

    if (is_numeric($img)) {
        $attach = \Phpcmf\Service::C()->get_attachment($img);
        if (!$attach) {
            return $img;
        } elseif (!in_array($attach['fileext'], ['png', 'jpeg', 'jpg', 'gif'])) {
            return dr_get_file($img);
        } elseif ($attach['remote']) {
            return $attach['url'];
        }
        // 图片处理
        $file = $attach['file'];
        if (!is_file($file)) {
            return $attach['url'];
        }

        // 储存临时文件数组
        $name = $img.'.'.$attach['fileext'];
        \Phpcmf\Service::C()->space_image_file[$name] = $attach['url'];
        return '/uploadfile/'.$name;
    } else {
        return $img;
    }
}