<?php

if (! function_exists('array_value_dot'))
{
	/**
	 * Searches an array through dot syntax. Supports
	 * wildcard searches, like foo.*.bar
	 *
	 * @param string $index
	 * @param array  $array
	 *
	 * @return mixed|null
	 */
	function dot_array_search(string $index, array $array)
	{
		$segments = explode('.', rtrim(rtrim($index, '* '), '.'));

		return _array_search_dot($segments, $array);
	}
}

if (! function_exists('array_search_dot'))
{
	/**
	 * Used by array_value_dot to recursively search the
	 * array with wildcards.
	 *
	 * @param array $indexes
	 * @param array $array
	 *
	 * @return mixed|null
	 */
	function _array_search_dot(array $indexes, array $array)
	{
		// Grab the current index
		$currentIndex = count($indexes)
			? array_shift($indexes)
			: null;

		if (empty($currentIndex) || (! isset($array[$currentIndex]) && $currentIndex != '*'))
		{
			return null;
		}

		// Handle Wildcard (*)
		if ($currentIndex == '*')
		{
			// If $array has more than 1 item, we have to loop over each.
			if (is_array($array))
			{
				foreach ($array as $key => $value)
				{
					$answer = _array_search_dot($indexes, $value);

					if ($answer !== null)
					{
						return $answer;
					}
				}

				// Still here after searching all child nodes?
				return null;
			}
		}

		// If this is the last index, make sure to return it now,
		// and not try to recurse through things.
		if (empty($indexes))
		{
			return $array[$currentIndex];
		}

		// Do we need to recursively search this value?
		if (is_array($array[$currentIndex]) && count($array[$currentIndex]))
		{
			return _array_search_dot($indexes, $array[$currentIndex]);
		}

		// Otherwise we've found our match!
		return $array[$currentIndex];
	}
}


