var $,table,laydate;
layui.use(['jquery','table','laydate'],function(){
    $(document).ready(function() {
        search();
    });
    $ = layui.jquery;
    table = layui.table;
    laydate = layui.laydate;

    // 整体趋势开始时间
    laydate.render({
        elem: '#start'
    });
    // 整体趋势结束时间
    laydate.render({
        elem: '#end'
    });

    $('.hd a').click(function(){
        var index = $(this).index();
        $(this).addClass('active').siblings().removeClass('active');
        $('.bd .tab').eq(index).show().siblings().hide();

        // 将他切换后的放在点击之后加载，以免加载不出来
        // 性别比例
        var sex = document.getElementById("sex");
        var myChart_sex = echarts.init(sex);
        option_sex = null;
        var params_sex = {
            color: ['#5D9CEC', '#FC6F6D', '#73D68F'],
            data:['男','女','未知'],
            name:'性别比例',
            dataValue:[
                {value:125, name:'男'},
                {value:310, name:'女'},
                {value:10, name:'未知'}
            ]
        }
        option_sex = ech(params_sex);

        if (option_sex && typeof option_sex === "object") {
            myChart_sex.setOption(option_sex, true);
        }


        // 次日回访比例
        var visit = document.getElementById("visit");
        var myChart_visit = echarts.init(visit);
        option_visit = null;

        var params_visit = {
            color: ['#5D9CEC', '#73D68F'],
            data:['有回访玩家','无回访玩家'],
            name:'次日回访比例',
            dataValue:[
                {value:125, name:'有回访玩家'},
                {value:310, name:'无回访玩家'}
            ]
        }
        option_visit = ech(params_visit);

        if (option_visit && typeof option_visit === "object") {
            myChart_visit.setOption(option_visit, true);
        }


        // 终端网络类型
        var internet = document.getElementById("internet");
        var myChart_internet = echarts.init(internet);
        option_internet = null;

        var params_internet = {
            color: ['#73D68F', '#FFB847'],
            data:['运营商','WIFI'],
            name:'终端网络类型',
            dataValue:[
                {value:125, name:'运营商'},
                {value:310, name:'WIFI'}
            ]
        }
        option_internet = ech(params_internet);

        if (option_internet && typeof option_internet === "object") {
            myChart_internet.setOption(option_internet, true);
        }


        // 设备
        var equipment = document.getElementById("equipment");
        var myChart_equipment = echarts.init(equipment);
        option_equipment = null;

        var params_equipment = {
            color: ['#5D9CEC', '#FC6F6D', '#73D68F'],
            data:['安卓','苹果','其他'],
            name:'设备',
            dataValue:[
                {value:125, name:'安卓'},
                {value:310, name:'苹果'},
                {value:0, name:'其他'}
            ]
        }
        option_equipment = ech(params_equipment);

        if (option_equipment && typeof option_equipment === "object") {
            myChart_equipment.setOption(option_equipment, true);
        }
    })
})

// 整体趋势
var trend = document.getElementById("trend");
var myChart = echarts.init(trend);

var seriesArr = [
    [11, 1, 10, 11, 11, 11, 11],
    [1, 0, 2, 5, 3, 2, 0],
    [5, 7, 2, 3, 0, 2, 0],
    [1, 5,3, 9, 3, 1, 0]
];
option_trend = null;
option_trend = {
    tooltip: {
        trigger: 'axis'
    },
    legend: {
        data:['浏览人数','参与人数','获奖人数','分享人数']
    },
    toolbox: {
        show: false,
        feature: {
            dataZoom: {
                yAxisIndex: 'none'
            },
            dataView: {readOnly: false},
            magicType: {type: ['line', 'bar']},
            restore: {},
            saveAsImage: {}
        }
    },
    xAxis:  {
        type: 'category',
        boundaryGap: false,
        data: ['周一','周二','周三','周四','周五','周六','周日']
    },
    yAxis: {
        type: 'value',
        axisLabel: {
            formatter: '{value}'
        }
    },
    series: [
        {
            name:'浏览人数',
            type:'line',
            data:seriesArr[0],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        },
        {
            name:'参与人数',
            type:'line',
            data:seriesArr[1],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        },
        {
            name:'获奖人数',
            type:'line',
            data:seriesArr[2],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        },
        {
            name:'分享人数',
            type:'line',
            data:seriesArr[3],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        }
    ]
};
option_trend2 = {
    tooltip: {
        trigger: 'axis'
    },
    legend: {
        data:['浏览人数','参与人数','获奖人数','分享人数']
    },
    toolbox: {
        show: false,
        feature: {
            dataZoom: {
                yAxisIndex: 'none'
            },
            dataView: {readOnly: false},
            magicType: {type: ['line', 'bar']},
            restore: {},
            saveAsImage: {}
        }
    },
    xAxis:  {
        type: 'category',
        boundaryGap: false,
        data: ['周一','周二','周三','周四','周五','周六','周日']
    },
    yAxis: {
        type: 'value',
        axisLabel: {
            formatter: '{value}'
        }
    },
    series: [
        {
            name:'浏览人数',
            type:'line',
            data:[17, 16, 55, 23, 56, 23, 45],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        },
        {
            name:'参与人数',
            type:'line',
            data:[1, 0, 2, 5, 3, 2, 0],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        },
        {
            name:'获奖人数',
            type:'line',
            data:[5, 7, 2, 3, 0, 2, 0],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        },
        {
            name:'分享人数',
            type:'line',
            data:[1, 5,3, 9, 3, 1, 0],
            markPoint: {
                data: [
                    {type: 'max', name: '最大值'},
                    {type: 'min', name: '最小值'}
                ]
            },
            markLine: {
                data: [
                    {type: 'average', name: '平均值'}
                ]
            }
        }
    ]
};
if (option_trend && typeof option_trend === "object") {
    myChart.setOption(option_trend, true);
}


// 传播层级
var level = document.getElementById("level");
var myChart_level = echarts.init(level);
var app_level = {};
option = null;
var posList = [
    'left', 'right', 'top', 'bottom',
    'inside',
    'insideTop', 'insideLeft', 'insideRight', 'insideBottom',
    'insideTopLeft', 'insideTopRight', 'insideBottomLeft', 'insideBottomRight'
];


app_level.configParameters = {
    rotate: {
        min: -90,
        max: 90
    },
    align: {
        options: {
            left: 'left',
            center: 'center',
            right: 'right'
        }
    },
    verticalAlign: {
        options: {
            top: 'top',
            middle: 'middle',
            bottom: 'bottom'
        }
    },
    position: {
        options: echarts.util.reduce(posList, function (map, pos) {
            map[pos] = pos;
            return map;
        }, {})
    },
    distance: {
        min: 0,
        max: 100
    }
};

app_level.config = {
    rotate: 90,
    align: 'left',
    verticalAlign: 'middle',
    position: 'insideBottom',
    distance: 15,
    onChange: function () {
        var labelOption = {
            normal: {
                rotate: app_level.config.rotate,
                align: app_level.config.align,
                verticalAlign: app_level.config.verticalAlign,
                position: app_level.config.position,
                distance: app_level.config.distance
            }
        };
        myChart_level.setOption({
            series: [{
                label: labelOption
            }, {
                label: labelOption
            }, {
                label: labelOption
            }]
        });
    }
};


var labelOption = {
    normal: {
        position: app_level.config.position,
        distance: app_level.config.distance,
        align: app_level.config.align,
        verticalAlign: app_level.config.verticalAlign,
        rotate: app_level.config.rotate,
        formatter: '{c}  {name|{a}}',
        fontSize: 16,
        rich: {
            name: {
                textBorderColor: '#fff'
            }
        }
    }
};

option_level = {
    color: ['#5D9CEC', '#71D58D', '#FFB847'],
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'shadow'
        }
    },
    legend: {
        data: ['浏览人数', '参与人数', '分享人数']
    },
    toolbox: {
        show: true,
        orient: 'vertical',
        left: 'right',
        top: 'center'
    },
    calculable: true,
    xAxis: [
        {
            type: 'category',
            axisTick: {show: false},
            data: ['传播源', '第一层', '第二层', '第三层', '第四层', '第五层', '第六层', '第七层', '第八层', '第九层', '其他层']
        }
    ],
    yAxis: [
        {
            type: 'value'
        }
    ],
    series: [
        {
            name: '浏览人数',
            type: 'bar',
            barGap: 0,
            label: labelOption,
            data: [63, 10, 10, 4, 0, 0, 0, 0, 0, 0, 0]
        },
        {
            name: '参与人数',
            type: 'bar',
            label: labelOption,
            data: [51, 8, 6, 4, 3, 0, 0, 0, 0, 0, 0]
        },
        {
            name: '分享人数',
            type: 'bar',
            label: labelOption,
            data: [7, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0]
        }
    ]
};
if (option_level && typeof option_level === "object") {
    myChart_level.setOption(option_level, true);
}


// 进入来源
var source = document.getElementById("source");
var myChart_source = echarts.init(source);
option_source = null;

option_source = {
    tooltip: {
        trigger: 'item',
        formatter: "{a} <br/>{b}: {c} ({d}%)"
    },
    legend: {
        orient: 'vertical',
        x: 'right',
        data:['朋友','其他','好友','图文信息','二维码']
    },
    series: [
        {
            name:'访问来源',
            type:'pie',
            radius: ['40%', '80%'],
            avoidLabelOverlap: false,
            label: {
                normal: {
                    show: false,
                    position: 'center'
                },
                emphasis: {
                    show: true,
                    textStyle: {
                        fontSize: '30',
                        fontWeight: 'bold'
                    }
                }
            },
            labelLine: {
                normal: {
                    show: false
                }
            },
            data:[
                {value:335, name:'朋友'},
                {value:310, name:'其他'},
                {value:234, name:'好友'},
                {value:135, name:'图文信息'},
                {value:1548, name:'二维码'}
            ]
        }
    ]
};

if (option_source && typeof option_source === "object") {
    myChart_source.setOption(option_source, true);
}


// 分享去向
var share = document.getElementById("share");
var myChart_share = echarts.init(share);
option_share = null;

option_share = {
    color: ['#5D9CEC', '#73D68F'],
    tooltip: {
        trigger: 'item',
        formatter: "{a} <br/>{b}: {c} ({d}%)"
    },
    legend: {
        orient: 'vertical',
        x: 'right',
        data:['朋友圈','好友及群聊']
    },
    series: [
        {
            name:'分享去向',
            type:'pie',
            radius: ['40%', '80%'],
            avoidLabelOverlap: false,
            label: {
                normal: {
                    show: false,
                    position: 'center'
                },
                emphasis: {
                    show: true,
                    textStyle: {
                        fontSize: '30',
                        fontWeight: 'bold'
                    }
                }
            },
            labelLine: {
                normal: {
                    show: false
                }
            },
            data:[
                {value:125, name:'朋友圈'},
                {value:310, name:'好友及群聊'}
            ]
        }
    ]
};

if (option_share && typeof option_share === "object") {
    myChart_share.setOption(option_share, true);
}



// 饼状图公用部分
function ech (params) {
    var opt = {
        color: params.color,
        tooltip: {
            trigger: 'item',
            formatter: "{a} <br/>{b}: {c} ({d}%)"
        },
        legend: {
            orient: 'vertical',
            x: 'right',
            data:params.data
        },
        series: [
            {
                name:params.name,
                type:'pie',
                radius: ['40%', '80%'],
                avoidLabelOverlap: false,
                label: {
                    normal: {
                        show: false,
                        position: 'center'
                    },
                    emphasis: {
                        show: true,
                        textStyle: {
                            fontSize: '30',
                            fontWeight: 'bold'
                        }
                    }
                },
                labelLine: {
                    normal: {
                        show: false
                    }
                },
                data:params.dataValue
            }
        ]
    }
    return opt;
}

function search(obj){
    if(obj!=undefined) {
        var type = obj.getAttribute('type');
        var id = $(".filter").attr('id');
    }else {
        if (type == undefined) {
            type = 'week';
        }
        if (id == undefined) {
            id = GetUrlParam('id');
        }
    }
    $.ajax({
        type: "post",
        url:"index.php?s=member&app=hd&c=my&m=average",
        dataType: "json",
        data:{id:id,type:type,csrf_token: $("input[name='csrf_token']").val()} ,
        success: function(json){
            console.log(json);
            option_trend.series[0].data = json.data.number;
            option_trend.series[1].data = json.data.view;
            option_trend.series[2].data = json.data.win;
            option_trend.series[3].data = json.data.number;
            option_trend.xAxis.data = json.data.time;
            myChart.setOption(option_trend, true);

        },
        error: function(HttpRequest, ajaxOptions, thrownError){
        }
    });
}
function searchLimit(){
    var id = $(".filter").attr('id');
    var start = $('#start').val();
    var end = $('#end').val();
    $.ajax({
        type: "post",
        url:"index.php?s=member&app=hd&c=my&m=average",
        dataType: "json",
        data:{id:id,type:'search',start:start,end:end,csrf_token: $("input[name='csrf_token']").val()} ,
        success: function(json){
            console.log(json);
            option_trend.series[0].data = json.data.number;
            option_trend.series[1].data = json.data.view;
            option_trend.series[2].data = json.data.win;
            option_trend.series[3].data = json.data.number;
            option_trend.xAxis.data = json.data.time;
            myChart.setOption(option_trend, true);

        },
        error: function(HttpRequest, ajaxOptions, thrownError){
        }
    });
}
function GetUrlParam(paraName) {
    var url = document.location.toString();
    var arrObj = url.split("?");

    if (arrObj.length > 1) {
        var arrPara = arrObj[1].split("&");
        var arr;

        for (var i = 0; i < arrPara.length; i++) {
            arr = arrPara[i].split("=");

            if (arr != null && arr[0] == paraName) {
                return arr[1];
            }
        }
        return "";
    }
    else {
        return "";
    }
}

