'use strict';
layui.use(['form', 'jquery', 'laydate', 'upload', 'element'], function () {
  var $ = layui.jquery,
      form = layui.form,
      laydate = layui.laydate,
      upload = layui.upload,
      element = layui.element;

  // 核销搜索开始时间
  laydate.render({
    elem: '#date_start',
    type: 'datetime'
  });
  // 核销搜索结束时间
  laydate.render({
    elem: '#date_end',
    type: 'datetime'
  });

});

//搜索筛选


function day_screening(n){
  var hd = $('#hd').val();
  if(hd==0){
    layer.msg("请选择活动", {
      time: 2000 //2秒关闭（如果不配置，默认是3秒）
    }, function(){
      //do something
      return false;
    });
  }else{
    switch (n) {
      case 1:
          ajax_day_screening('1','/index.php?s=member&app=hd&c=nuclear&m=day_screening',hd);
        break;
      case 2:
          ajax_day_screening('2','/index.php?s=member&app=hd&c=nuclear&m=day_screening',hd);
        break;
      case 3:
           ajax_day_screening('3','/index.php?s=member&app=hd&c=nuclear&m=day_screening',hd);
        break;
      case 4:
          ajax_day_screening('4','/index.php?s=member&app=hd&c=nuclear&m=day_screening',hd);
        break;
      case 5:
         ajax_day_screening('5','/index.php?s=member&app=hd&c=nuclear&m=day_screening',hd);
        break;
    }
  }

}


function ajax_day_screening(id,url,hd){
  $.ajax({
    type: "post",
    url:url,
    dataType: "json",
    data:{id:id,hd:hd,csrf_token: $("input[name='csrf_token']").val()} ,
    success: function(json){
      //alert(json.msg);
      var str = '';
      if(json.code == 1){

        $.each(json.data, function(i,item){
          str += '<tr class="odd gradeX" id="dr_row_'+item.id+'">' +
              ' <td >'+UnixToDate(item.nuclear_create_time)+'</td>' +
              ' <td >'+item.nuclear_person+'</td>' +
              ' <td >'+item.coupons_code+'</td>' +
              ' <td >'+item.hd_id+'</td>' +
              ' <td >'+item.hd_name+'</td>' +
              ' <td >'+item.exchange+'</td>' +
              ' <td >'+item.level+'</td>' +
              ' <td >'+item.p_name+'</td>' +
              ' <td >'+item.win_user+'</td>' +
              ' <td >'+item.note+'</td>' +
              ' </tr>'
        });
        $("#thead").children('tr').hide();
        $("#thead").html(str);
        $('#coupons_code').val('');
        $('#date_start').val('');
        $('#date_end').val('');
        $('#mypages').children('li').hide();
        $('#mypages').html(json.data[0].mypages);
      }else if( json.code == 0 ){
        str += json.msg;
        $("#thead").children('tr').hide();
        $("#thead").html(str);
        $('#coupons_code').val('');
        $('#date_start').val('');
        $('#date_end').val('');
        $('#mypages').children('li').hide();
        $('#mypages').html(json.data.mypages);
      }

    }
  });
}


function time_screening(){
  var date_start = $("#date_start").val();
  var date_end = $("#date_end").val();
  var hd = $('#hd').val();
  var url = '/index.php?s=member&app=hd&c=nuclear&m=time_screening';
  if(hd==0){
    layer.msg("请选择活动", {
      time: 2000 //2秒关闭（如果不配置，默认是3秒）
    }, function(){
      //do something
      return false;
    });
  }else if(date_start == '' || date_end == ''){
    layer.msg('时间请填完整', {
      time: 2000 //2秒关闭（如果不配置，默认是3秒）
    }, function(){
      //do something
      return false;
    });
  }else{
    $.ajax({
      type: "post",
      url:url,
      dataType: "json",
      data:{hd:hd,date_start:date_start,date_end:date_end,csrf_token: $("input[name='csrf_token']").val()} ,
      success: function(json){
        //alert(json.msg);
        var str = '';
        if(json.code == 1){
          $.each(json.data, function(i,item){
            str += '<tr class="odd gradeX" id="dr_row_'+item.id+'">' +
                ' <td >'+UnixToDate(item.nuclear_create_time)+'</td>' +
                ' <td >'+item.nuclear_person+'</td>' +
                ' <td >'+item.coupons_code+'</td>' +
                ' <td >'+item.hd_id+'</td>' +
                ' <td >'+item.hd_name+'</td>' +
                ' <td >'+item.exchange+'</td>' +
                ' <td >'+item.level+'</td>' +
                ' <td >'+item.p_name+'</td>' +
                ' <td >'+item.win_user+'</td>' +
                ' <td >'+item.note+'</td>' +
                ' </tr>'
          });
          $("#thead").children('tr').hide();
          $("#thead").html(str);
          $('#coupons_code').val('');
        }else if( json.code == 0 ){
          str += json.msg;
          $("#thead").children('tr').hide();
          $("#thead").html(str);
          $('#coupons_code').val('');
        }

      }
    });
  }
}


function coupons(){
  var coupons_code = $("#coupons_code").val();
  var url = '/index.php?s=member&app=hd&c=nuclear&m=coupons_code';
  if(coupons_code==''){
    layer.msg('请填写劵号', {
      time: 2000 //2秒关闭（如果不配置，默认是3秒）
    }, function(){
      return false;
    });
  }else{
    $.ajax({
      type: "post",
      url:url,
      dataType: "json",
      data:{coupons_code:coupons_code,csrf_token: $("input[name='csrf_token']").val()} ,
      success: function(json){
        //alert(json.msg);
        var str = '';
        if(json.code == 1){
          $.each(json.data, function(i,item){
            str += '<tr class="odd gradeX" id="dr_row_'+item.id+'">' +
                ' <td >'+UnixToDate(item.nuclear_create_time)+'</td>' +
                ' <td >'+item.nuclear_person+'</td>' +
                ' <td >'+item.coupons_code+'</td>' +
                ' <td >'+item.hd_id+'</td>' +
                ' <td >'+item.hd_name+'</td>' +
                ' <td >'+item.exchange+'</td>' +
                ' <td >'+item.level+'</td>' +
                ' <td >'+item.p_name+'</td>' +
                ' <td >'+item.win_user+'</td>' +
                ' <td >'+item.note+'</td>' +
                ' </tr>'
          });
          $("#thead").children('tr').hide();
          $("#thead").html(str);
          $('#hd').val('0','请选择');
          $('#date_start').val('');
          $('#date_end').val('');

        }else if( json.code == 0 ){
          str += json.msg;
          $("#thead").children('tr').hide();
          $("#thead").html(str);
          $('#hd').val('0','请选择');
          $('#date_start').val('');
          $('#date_end').val('');
        }

      }
    });
  }

}


function from_select(){
    $("#myfrom").submit();
}

function log_select(){
    $("#myform").submit();
}

//取消兑奖资格
function cancel_prize(user_id, hd_id,id){
    layer.prompt({
        formType: 2,
        value: '该用户存在异常刷奖品行为',
        title: '请输入取消资格的原因',
        area: ['300px', '100px'] //自定义文本域宽高
    }, function(value, index, elem){
            $.ajax({
                type: "post",
                url: "index.php?s=member&app=hd&c=nuclear&m=cancel_prize",
                dataType: "json",
                data: {
                    'hd_id': hd_id,
                    'user_id': user_id,
                    'id': id,
                    'value': value,
                    csrf_token: $("input[name='csrf_token']").val()
                },
                success: function (json) {
                    if(json.code){

                        layer.msg(json.msg, {
                            time: 2000 //2秒关闭（如果不配置，默认是3秒）
                        }, function(){
                            //do something
                            window.location.reload();
                        });
                    }else{
                        layer.msg(json.msg, {
                            time: 2000 //2秒关闭（如果不配置，默认是3秒）
                        }, function(){
                            //do something
                        });
                    }
                }
            });
        layer.close(index);
    });
}
