'use strict';

var $ = void 0,
    layer = void 0,
    laypage = void 0,
    form = void 0,
    laydate = void 0;
layui.use(['jquery', 'layer', 'laypage', 'form', 'laydate'], function () {
  $ = layui.jquery;
  layer = layui.layer;
  laypage = layui.laypage;
  form = layui.form;
  laydate = layui.laydate;
  //完整功能
  laypage.render({
    elem: 'rulePage',
    count: 100,
    layout: ['count', 'prev', 'page', 'next', 'limit', 'skip'],
    jump: function jump(obj) {
      console.log(obj);
    }
  });

  // 生日
  //常规用法
  laydate.render({
    elem: '#birthday'
  });

  form.on('radio(rule_)', function (data) {
    if (data.value === '互动核销权限' || data.value === '部分互动权限') {
      layer.open({
        title: '设置核销权限',
        type: 1,
        skin: 'layui-layer-rim', //加上边框
        area: ['660px', '572px'], //宽高
        content: '<div class="ruleSet">'+
          '<p><span><input type="checkbox" id="_rule1" /><label for="_rule1">活动管理</label></span></p>'+
          '<p>'+
            '<span><input type="checkbox" id="_rule2" /><label for="_rule2">新建编辑活动</label></span>'+
            '<span><input type="checkbox" id="_rule3" /><label for="_rule3">发布活动</label></span>'+
            '<span><input type="checkbox" id="_rule4" /><label for="_rule4">删除活动</label></span>'+
            '<span><input type="checkbox" id="_rule5" /><label for="_rule5">配置活动核销员</label></span>'+
            '<span><input type="checkbox" id="_rule6" /><label for="_rule6">修改成绩</label></span>'+
            '<span><input type="checkbox" id="_rule7" /><label for="_rule7">派发奖品</label></span>'+
            '<span><input type="checkbox" id="_rule8" /><label for="_rule8">查看活动数据</label></span>'+
          '</p>'+
          '<p><span><input type="checkbox" id="_rule9" checked /><label for="_rule9">核销管理</label></span></p>'+
          '<p>'+
            '<span><input type="checkbox" id="_rule10" checked /><label for="_rule10">核销券码</label></span>'+
            '<span><input type="checkbox" id="_rule11" checked /><label for="_rule11">查看核销记录</label></span>'+
          '</p>'+
          '<p><span><input type="checkbox" id="_rule12" /><label for="_rule12">个人中心</label></span></p>'+
          '<p><span><input type="checkbox" id="_rule13" /><label for="_rule13">微信授权管理</label></span></p>'+
          '<p><span><input type="checkbox" id="_rule14" /><label for="_rule14">操作日志</label></span></p>'+
          '<p><span><input type="checkbox" id="_rule15" /><label for="_rule15">查看操作日志</label></span></p>'+
        '</div>'+
        '<div class="ruleSetBtn">'+
          '<span>确定</span>'+
          '<span onclick="closeAll()">取消</span>'+
        '</div>'
      });
    }
  });
});
// 删除
function del() {
  layer.confirm('您确定要删除此用户？', {
    btn: ['确定', '取消'] //按钮
  }, function () {
    layer.msg('已删除', { icon: 1 });
  });
}

// 保存
function save() {
  $('form').submit();
}