<?php

if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Dayrui Website Management System
 *
 * @since		version 2.7.0
 * @author		Dayrui <dayrui@gmail.com>
 * @license     http://www.dayrui.com/license
 * @copyright   Copyright (c) 2011 - 9999, Dayrui.Com, Inc.
 * @filesource	svn://www.dayrui.net/v2/member/controllers/admin/tpl.php
 */

require FCPATH.'branch/fqb/D_Admin_Table.php';

class Invite extends D_Admin_Table {

    /**
     * 构造函数
     */
    public function __construct() {
        parent::__construct();
        $this->mydb = $this->db; // 数据库
		$this->tfield = 'regtime'; // 时间字段用于搜索和排序
		$this->mytable = 'member_invite'; // 表名
		$this->myfield = array(
			'uid' => array(
				'ismain' => 1,
				'fieldname' => 'uid',
				'name' => fc_lang('邀请人id'),
			),
			'username' => array(
				'ismain' => 1,
				'fieldname' => 'username',
				'name' => fc_lang('邀请人账号'),
			),
			'rid' => array(
				'ismain' => 1,
				'fieldname' => 'rid',
				'name' => fc_lang('受邀人id'),
			),
			'rname' => array(
				'ismain' => 1,
				'fieldname' => 'rname',
				'name' => fc_lang('受邀人账号'),
			),
		); // 表字段
        $this->template->assign(array(
			'menu' => $this->get_menu(array(
				fc_lang('邀请管理') => 'invite/admin/invite/index',
			)),
			'field' => $this->myfield,
		));
    }

	// 管理
	public function index() {

		if ($this->input->post('action') == 'del') {
			$ids = $this->input->post('ids');
			if (!$ids) {
				exit(dr_json(0, fc_lang('您还没有选择呢')));
			}
			foreach ($ids as $id) {
				$row = $this->mydb->where('id', (int)$id)->get($this->mytable)->row_array();
				if ($row) {
					$this->mydb->where('id', (int)$id)->delete($this->mytable);
					$this->system_log('删除会员关系：邀请人【'.$row['username'].'】，受邀人【'.$row['rname'].'】'); // 记录日志
				}
			}
			exit(dr_json(1, fc_lang('操作成功，正在刷新...')));
		}

		$this->_index();
		$this->template->display('invite_index.html');
	}
	
}