<?php

if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Dayrui Website Management System
 *
 * @since		version 2.7.0
 * @author		Dayrui <dayrui@gmail.com>
 * @license     http://www.dayrui.com/license
 * @copyright   Copyright (c) 2011 - 9999, Dayrui.Com, Inc.
 * @filesource	svn://www.dayrui.net/v2/member/controllers/admin/tpl.php
 */


class Home extends M_Controller {

    /**
     * 构造函数
     */
    public function __construct() {
        parent::__construct();
    }

	// 管理
	public function index() {

		$kw = dr_safe_replace($this->input->get('kw', TRUE));
		$page = (int)$this->input->get('page');
		$order = dr_get_order_string(isset($_GET['order']) && strpos($_GET['order'], "undefined") !== 0 ? $this->input->get('order', TRUE) : 'regtime desc', 'regtime desc');

		// 会员
		if ($kw) {
			$this->db->where('uid IN (select rid from '.$this->db->dbprefix('member_invite').' where uid='.$this->uid.' and rname like "%'.$kw.'%")');
		} else {
			$this->db->where('uid IN (select rid from '.$this->db->dbprefix('member_invite').' where uid='.$this->uid.')');
		}
		// 排序
		$this->db->order_by($order);
		$this->load->library('dip');
		if ($this->input->get('action') == 'search') {
			// ajax搜索数据
			$page = max((int)$this->input->get('page'), 1);
			$data = $this->db->limit($this->pagesize, $this->pagesize * ($page - 1))->get('member')->result_array();
			if (!$data) {
				exit('null');
			}
			$this->template->assign(array(
				'kw' => $kw,
				'list' => $data,
			));
			$this->template->display('invite_data.html');
		} else {
			$this->template->assign(array(
				'kw' => $kw,
				'page' => max(2, $page + 1),
				'list' => $this->db->limit($page ? $page * $this->pagesize : $this->pagesize)->get('member')->result_array(),
				'order' => $order,
				'invite' => dr_get_invite($this->uid, 'username'),
				'moreurl' => 'index.php?s=member&app=invite&c=home&m=index&action=search&order='.$order.'&kw='.$kw,
				'meta_name' => fc_lang('我的邀请'),
				'invite_url' => SITE_URL.'index.php?s=member&c=register&uid='.$this->uid.'&invite='.$this->member['username'],
			));
			$this->template->display('invite_index.html');
		}
	}
	
}