<?php
error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);

define('PRODUCT', 'pzone');
define('AUTH_CLASS', 'Affiliate_Affiliates_Bl_AffiliateDBAuth');

require_once('settings/settings.php');
require_once('settings/globalConst.php');
require_once($GLOBALS['CORE_INCLUDE_PATH'].'/QUnit/Global.class.php');

// ---------------------------------------------------------------------------
// include files
// ---------------------------------------------------------------------------
QUnit_Global::includeClass('QUnit_GlobalFuncs');
QUnit_Global::includeClass('QCore_Sql_DBUnit');
QUnit_Global::includeClass('QUnit_Messager');
QUnit_Global::includeClass('QCore_History');
QUnit_Global::includeClass('QCore_Logs');
require_once('settings/emailTemplates.php');

QUnit_Global::includeClass('QCore_Constants');
QCore_Constants::initConstants();

define('AUTH_CLASS', 'Affiliate_Scripts_Bl_Auth');
QUnit_Global::includeClass(AUTH_CLASS);
QUnit_Global::includeClass('Affiliate_Merchants_Views_Settings');

require_once('settings/trafficLimits.php');



QUnit_Global::includeClass('QUnit_Page');
QUnit_Page::init_page();

// ---------------------------------------------------------------------------
// log in to database
// ---------------------------------------------------------------------------
$dbObj =& QUnit_Global::newObj('QUnit_Sql_DbConnection', DB_HOSTNAME,DB_USERNAME,DB_PASSWORD,DB_DATABASE);
$GLOBALS['db'] = $dbObj->getConnection();


begin_auth();

// ---------------------------------------------------------------------------
// set template and style
// ---------------------------------------------------------------------------
QUnit_Global::includeClass('Affiliate_Merchants_Views_PZoneSettings');
$settings = Affiliate_Merchants_Views_PZoneSettings::loadSettings();
$theme = !empty($settings['theme']['svalue'])?$settings['theme']['svalue']:md5(time());
$themePath = $GLOBALS['PROJECT_ROOT_PATH'].'/templates/pzone/'.$theme;
$GLOBALS['default_template'] = !file_exists($themePath)?DEFAULT_TEMPLATE:$theme;
//$webpath = !empty($GLOBALS['WEB_PATH'])?'/'.$GLOBALS['WEB_PATH']:'';
$GLOBALS['themePath'] = $settings['siteurl']['svalue'].'/templates/pzone/'.$GLOBALS['default_template'];
define('THEME_PATH', $GLOBALS['themePath']);
?>