<?php
QUnit_Global::includeClass('QUnit_UI_TemplatePage');
class Affiliate_Affiliates_Views_DynamicLink extends QUnit_UI_TemplatePage {

function Affiliate_Affiliates_Views_DynamicLink() {
    $this->navigationAddURL(L_G_HOME,'index.php?md=home');
    $this->navigationAddURL(L_G_TOPMENU_CAMPAIGNS, 'javascript:;');
    $this->navigationAddURL(L_G_CUSTOMDYNAMICLINK,'index.php?md=Affiliate_Merchants_Views_DynamicLink');
}

//--------------------------------------------------------------------------

function process(){
    if($GLOBALS['Auth']->getSetting('Aff_default_campaign') == '_') {
        $this->addErrorMessage(L_G_MANAGE_DYNLINKDISABLED);
        return false;
    }
    $this->addContent('dynamiclink_style');
    $this->addContent('dynamiclink_js');
    if($_POST['commited']=="yes"){
        switch($_POST['action']) {
            case 'delete': $this->processDelete();
            break;
        }
    }
    switch($_REQUEST['action']) {
        case 'merchants': $this->drawMerchantsDynLinkList();break;
        default: $this->drawDynLinkList();
    }
}

function drawDynLinkList() {
    $query = 'select * from `wd_g_dynamiclink` where `userid`="'.$GLOBALS['Auth']->userID.'" order by `insertdate` desc limit 0,30';
    $rs = $GLOBALS['db']->Query($query);
    if(!$rs || $rs->EOF) $this->assign('listdata',array());
    $this->assign('listdata',$rs);
    $this->addContent('dynamiclink');
}

function processDelete() {
    if(is_array($_POST['checkeditems'])) {
        $query = 'delete from `wd_g_dynamiclink` where `dlid` in ("'.join('","',$_POST['checkeditems']).'")';
        $rs = $GLOBALS['db']->Execute($query);
    }
}

//--------------------------------------------------------------------------

function drawMerchantsDynLinkList() {
    $limit = 30;

    $query = 'select count(1) as "total" from `wd_g_dynamiclink` where `userid` = "default1"';
    $rs = $GLOBALS['db']->Query($query);
    $total = $rs->fields['total'];
    $totalpage = ceil($total/$limit);
    $totalpage = $totalpage<1?1:$totalpage;

    $page = (int) $_GET['page'];
    $page = $page<1?1:($page>$totalpage?$totalpage:$page);

    $start = ($page-1)*$limit;
    $this->assign('page',$page);
    $this->assign('totalpage',$totalpage);
    $this->assign('total',$total);
    $this->assign('limit',$limit);


    $query = 'select * from `wd_g_dynamiclink` where `userid`="default1" order by `insertdate` desc limit '.$start.','.$limit;
    $rs = $GLOBALS['db']->Query($query);
    if(!$rs || $rs->EOF) $this->assign('listdata',array());
    $this->assign('listdata',$rs);
    $this->addContent('dynamiclink_merchants');
}

}

?>