<?php
QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class Affiliate_Install_Views_DbConvertTo410 extends QUnit_UI_TemplatePage
{
    var $model;

    //------------------------------------------------------------------------

    function Affiliate_Install_Views_DbConvertTo410() {
        $this->init();
    }

    //------------------------------------------------------------------------

    function init() {
        parent::init();
        $this->model =& QUnit_Global::newObj('Affiliate_Install_Bl_Install');
    }

    //------------------------------------------------------------------------

    function getName() {
        return 'DbConvertTo410';
    }

    //------------------------------------------------------------------------

    function getContent() {
        if($this->convert()) {
            $this->updateSettingsFile();
            $this->assign('check', 'ok');
        } else {
            $this->assign('check', 'failed');
        }
        $this->assign('action', 'DbConvertTo410');
        return $this->fetch('db_convert');
    }

    //------------------------------------------------------------------------

    function process() {
        if(isset($_POST['check']) && $_POST['check'] == 'ok') {
            return true;
        }
        return false;
    }

    //------------------------------------------------------------------------

    function convert() {
        if(!$this->model->executeSqlFile2('./sql/affiliate/update_mt_400_410_mysql.sql')) {
            QUnit_Messager::setErrorMessage(L_G_CONVERTFAILED);
            return false;
        }
        return true;
    }

    //------------------------------------------------------------------------

    function updateSettingsFile() {
        $addtions = array(
            "//----------------------------------------------------------------------------\r\n",
            "// 跟踪安全码，整合跟踪时请确保此值与 /api/track.php 中的常量MT_API_SECURITYCODE一致\r\n",
            "define('API_SECURITYCODE','".md5(rand(0,9).time())."');\r\n",
            "//----------------------------------------------------------------------------\r\n",
            "// MT推广易的绝对路径\r\n",
            "define('ABSPATH', str_replace('settings','',dirname(__FILE__)) . '/');\r\n",
            "//----------------------------------------------------------------------------\r\n",
            "// 文件上传路径 必须以 “/” 开头，如果MT推广易被安装在子目录，请修改此值 \r\n",
            "// 例如：你的MT推广易安装在 http://yourdomain.com/union/ 那么请将此值设置为 /union/banners/uploadfiles/ \r\n",
            "define('UPLOADPATH', '/banners/uploadfiles/');\r\n"
        );

        $f = '../settings/settings.php';
        $h = file($f);

        $handle = @fopen('../settings/settings.php', "w");
        if($handle === false) {
            QUnit_Messager::setErrorMessage(L_G_SETTINGSFILENOTWRITABLE);
            return false;
        }

        $lines = count($h);
        foreach($h as $k=>$l) {
            if($k==$lines-1)
            foreach($addtions as $a) {
                fwrite($handle, $a);
            }
            fwrite($handle, $l);
        }

        $cFile = @fopen($GLOBALS['PROJECT_ROOT_PATH'].'/settings/upgrade.lock', 'w');
        @fclose($cFile);
    }

}
?>
