<?php
QUnit_Global::includeClass('Affiliate_Merchants_Views_Banner');

class Affiliate_Merchants_Views_BannerHtml extends Affiliate_Merchants_Views_Banner
{
    //------------------------------------------------------------------------

    function Affiliate_Merchants_Views_BannerHtml() {
        $this->currbannertype = 'Html';
        parent::Affiliate_Merchants_Views_Banner();
    }

    function showBanner() {
        $this->assign('a_bannertemplate', 'banner_edit_html.tpl.php');
        $this->assign('a_md', 'Affiliate_Merchants_Views_BannerHtml');
        $this->assign('a_type_text', L_G_BANNERTYPE_HTML);
        $this->assign('a_hlp', L_G_HTMLBANNERHELP);
        $this->assign('a_example', L_G_HTMLBANNEREXAMPLES);

        $this->navigationAddURL(L_G_HTMLBANNER,'index.php?md=Affiliate_Merchants_Views_BannerHtml');

        $this->getBannerHtmlData();

        parent::showBanner();
    }

    //------------------------------------------------------------------------

    function checkCorrectness($pvars)
    {
        $pvars = parent::checkCorrectness($pvars);

        $pvars['ptype'] = BANNERTYPE_HTML;
        checkCorrectness($_POST['desc'], $pvars['pdesc'], L_G_DESCRIPTION, CHECK_ALLOWED);

        return $pvars;
    }

    function printListHeader() {
        $this->assign('a_list_cols', "3");
        echo '<td width="20%">'.L_G_ID.' / '.L_G_BANNERNAME.'</td>'
             .'<td>'.L_G_PREVIEW.'</td>'
             .'<td width="50">'.L_G_ACTIONS.'</td>';
    }

    function getBannerHtmlData() {
        $query = 'select count(1) as "total" from `wd_pa_banners` where `bannertype`=3 and `deleted`=0';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) {
            $total = 0;
            $this->assign('a_allcount',$total);
            return;
        }else {
            $total = $rs->fields['total'];
        }

        $numrows = empty($_REQUEST['numrows'])?10:$_REQUEST['numrows'];
        $_REQUEST["numrows"] = $numrows;

        $pages = ceil($total/$numrows);
        $page  = empty($_REQUEST['list_page'])?0:$_REQUEST['list_page'];
        $page  = $page>$pages?$pages:$page;
        $_REQUEST['list_page'] = $page;

        $this->assign('a_list_page',$page);
        $this->assign('a_list_pages',$pages);
        $this->assign('a_allcount',$total);
        $this->assign('a_numrows',$numrows);

        $query = 'select * from `wd_pa_banners` where `bannertype`=3 and `deleted`=0 order by `dateinserted` desc limit '.$page*$numrows.','.$numrows;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;

        //$this->assign('a_list_data',$rs);
        $this->listdata = $rs;
    }

    function printListData() {
        foreach($this->listdata as $row) {
            echo '<tr onmouseout="this.className=\'listresult\';" onmouseover="this.className=\'listresultMouseOver\'"><td>'.$row['bannerid'].'<br/><b>'.$row['name'].'</b></td>'
                .'<td>'.$row['description'].'</td>'
                .'<td><a href="javascript:editBanner(\'Html\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('edit.gif').'" border="0" width="16" height="16"></a>&nbsp;<a href="javascript:deleteBanner(\'Html\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('delete.png').'" border="0" width="16" height="16"></a></td></tr>';
        }
    }

}
?>
