<?php
QUnit_Global::includeClass('Affiliate_Merchants_Views_Banner');

class Affiliate_Merchants_Views_BannerImage extends Affiliate_Merchants_Views_Banner
{
    //------------------------------------------------------------------------

    function Affiliate_Merchants_Views_BannerImage() {
        $this->currbannertype = 'Image';
        parent::Affiliate_Merchants_Views_Banner();
    }

    function showBanner() {
        $this->assign('a_bannertemplate', 'banner_edit_image.tpl.php');
        $this->assign('a_md', 'Affiliate_Merchants_Views_BannerImage');
        $this->assign('a_hlp', L_G_IMAGEBANNERHELP);
        $this->assign('a_size_msg', '('.L_G_LOADEDFROMIMAGE.')');
        $this->assign('a_type_text', L_G_BANNERTYPE_IMAGE);

        $this->navigationAddURL(L_G_IMAGEBANNER,'index.php?md=Affiliate_Merchants_Views_BannerImage');

        $this->getBannerImageData();

        parent::showBanner();
    }

    //------------------------------------------------------------------------

    function protectVariables()
    {
        $pvars = parent::protectVariables();
        $pvars['psourceurl'] = preg_replace('/[\'\"]/', '', $_POST['sourceurl']);

        return $pvars;
    }

    //------------------------------------------------------------------------

    function checkCorrectness($pvars)
    {
        $pvars = parent::checkCorrectness($pvars);

        $pvars['ptype'] = BANNERTYPE_IMAGE;

        checkCorrectness($_POST['desc'], $pvars['pdesc'], L_G_PICTUREALT, CHECK_ALLOWED);
        $pvars['pdesc'] = htmlspecialchars($pvars['pdesc'], ENT_QUOTES);

        // check file upload
        if($_FILES['sourcebanner']['name'] == '')
        {
            if($_POST['sourceurl'] != '')
            {
                checkCorrectness($_POST['sourceurl'], $pvars['psourceurl'], L_G_PICTUREURL, CHECK_EMPTYALLOWED);
            } else {
                QUnit_Messager::setErrorMessage(L_G_YOUHAVETOSELECTIMAGE);
                return false;
            }
        }
        else
        {
            // check if the file doesn't exist in the banners directory
            if(file_exists($GLOBALS['Auth']->getSetting('Aff_banners_dir').$_FILES['sourcebanner']['name']))
            {
                QUnit_Messager::setErrorMessage(L_G_SPECIFIEDIMAGENAMEALREADYEXISTS);
                return false;
            }
            else
            {
                $oUpload = QUnit_Global::newObj('QUnit_Net_FileUpload',  $GLOBALS['Auth']->getSetting('Aff_banners_dir'), $_FILES['sourcebanner']);

                $oUpload->setAllowedTypes($GLOBALS['UPLOAD_ALLOWED_FILE_TYPES']);

                if($oUpload->handleUpload() === false) {
                    return false;
                }

                $pvars['psourceurl'] = $GLOBALS['Auth']->getSetting('Aff_banners_url').$_FILES['sourcebanner']['name'];

                if ($pvars['pwindow_size_type'] == 0) {
                $size = @GetImageSize($GLOBALS['Auth']->getSetting('Aff_banners_dir').$_FILES['sourcebanner']['name']);
                    if ($size != '') {
                        $pvars['psize'] = WINDOWSIZE_OWN.'_'.$size[0].'_'.$size[1];
                    }
                }
            }
        }
        return $pvars;
    }

    function printListHeader() {
        $this->assign('a_list_cols', "3");
        echo '<td width="20%">'.L_G_ID.' / '.L_G_BANNERNAME.'</td>'
             .'<td>'.L_G_PICPREVIEW.'</td>'
             .'<td width="50">'.L_G_ACTIONS.'</td>';
    }

    function getBannerImageData() {
        $query = 'select count(1) as "total" from `wd_pa_banners` where `bannertype`=2 and `deleted`=0';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) {
            $total = 0;
            $this->assign('a_allcount',$total);
            return;
        }else {
            $total = $rs->fields['total'];
        }

        $numrows = empty($_REQUEST['numrows'])?10:$_REQUEST['numrows'];
        $_REQUEST["numrows"] = $numrows;

        $pages = ceil($total/$numrows);
        $page  = empty($_REQUEST['list_page'])?0:$_REQUEST['list_page'];
        $page  = $page>$pages?$pages:$page;
        $_REQUEST['list_page'] = $page;

        $this->assign('a_list_page',$page);
        $this->assign('a_list_pages',$pages);
        $this->assign('a_allcount',$total);
        $this->assign('a_numrows',$numrows);

        $query = 'select * from `wd_pa_banners` where `bannertype`=2 and `deleted`=0 order by `dateinserted` desc limit '.$page*$numrows.','.$numrows;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;

        //$this->assign('a_list_data',$rs);
        $this->listdata = $rs;
    }

    function printListData() {
        foreach($this->listdata as $row) {
            $size = explode('_',$row['size']);
            echo '<tr onmouseout="this.className=\'listresult\';" onmouseover="this.className=\'listresultMouseOver\'"><td>'.$row['bannerid'].'<br/><b>'.$row['name'].'</b></td>'
                .'<td><a href="'.$row['destinationurl'].'" title="'.$row['description'].'" target="_blank"><img width="'.$size[1].'" height="'.$size[2].'" src="'.$row['sourceurl'].'" border="0" /></a></td>'
                .'<td><a href="javascript:editBanner(\'Image\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('edit.gif').'" border="0" width="16" height="16"></a>&nbsp;<a href="javascript:deleteBanner(\'Image\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('delete.png').'" border="0" width="16" height="16"></a></td></tr>';
        }
    }

}
?>
