<?php
QUnit_Global::includeClass('Affiliate_Merchants_Views_Banner');

class Affiliate_Merchants_Views_BannerPopup extends Affiliate_Merchants_Views_Banner
{
    //------------------------------------------------------------------------

    function Affiliate_Merchants_Views_BannerPopup() {
        $this->currbannertype = 'Popup';
        parent::Affiliate_Merchants_Views_Banner();
    }

    function showBanner() {
        $this->assign('a_bannertemplate', 'banner_edit_popup.tpl.php');
        $this->assign('a_md', 'Affiliate_Merchants_Views_BannerPopup');
        $this->assign('a_hide_banner_size', '1');
        $this->assign('a_type_text', L_G_BANNERTYPE_POPUP.' / '.L_G_BANNERTYPE_POPUNDER);
        $this->assign('a_hlp', L_G_POPUPBANNERHELP);

        $params = array(
            'AccountID' => $GLOBALS['Auth']->getAccountID(),
            'notIn' => array(BANNERTYPE_POPUP, BANNERTYPE_POPUNDER, BANNERTYPE_ROTATOR)
        );

        $banners = $this->blBanners->getBannersAsArray($params);
        $list_data = QUnit_Global::newObj('QCore_RecordSet');
        $list_data->setTemplateRS($banners);
        $this->assign('a_list_data2', $list_data);

        $this->navigationAddURL(L_G_POPUPBANNER,'index.php?md=Affiliate_Merchants_Views_BannerPopup');

        $this->getBannerPopupData();

        parent::showBanner();
    }

    //------------------------------------------------------------------------

    function loadBannerInfo() {
        $data = parent::loadBannerInfo();

        $_REQUEST['type'] = 'popup';
        $_POST['rtype'] = $data['bannertype'];
        $_POST['exist_banner'] = $data['sourceurl'];
        $this->parseBannerDescription($data['description']);
    }

    //------------------------------------------------------------------------

    function protectVariables()
    {
        $pvars = parent::protectVariables();

        $pvars['prtype'] = preg_replace('/[^0-9]/', '', $_POST['rtype']);
        $pvars['psourceurl'] = preg_replace('/[\'\"]/', '', $_POST['sourceurl']);
        $pvars['pdisplay'] = preg_replace('/[^0-9]/', '', $_POST['display']);
        $pvars['psourceurl'] = preg_replace('/[\'\"]/', '', $_POST['sourceurl']);
        $pvars['pexist_banner'] = preg_replace('/[\'\"]/', '', $_POST['exist_banner']);
        $pvars['pwindow_size_type'] = preg_replace('/[^0-9]/', '', $_POST['window_size_type']);
        $pvars['pwindow_size'] = preg_replace('/[^0-9_]/', '', $_POST['window_size']);
        $pvars['prwidth'] = preg_replace('/[^0-9]/', '', $_POST['rwidth']);
        $pvars['prheight'] = preg_replace('/[^0-9]/', '', $_POST['rheight']);
        $pvars['pwindow_resizable'] = preg_replace('/[^0-9]/', '', $_POST['window_resizable']);
        $pvars['pwindow_status'] = preg_replace('/[^0-9]/', '', $_POST['window_status']);
        $pvars['pwindow_toolbar'] = preg_replace('/[^0-9]/', '', $_POST['window_toolbar']);
        $pvars['pwindow_location'] = preg_replace('/[^0-9]/', '', $_POST['window_location']);
        $pvars['pwindow_directories'] = preg_replace('/[^0-9]/', '', $_POST['window_directories']);
        $pvars['pwindow_menubar'] = preg_replace('/[^0-9]/', '', $_POST['window_menubar']);
        $pvars['pwindow_scrollbars'] = preg_replace('/[^0-9]/', '', $_POST['window_scrollbars']);

        return $pvars;
    }

    //------------------------------------------------------------------------

    function checkCorrectness($pvars)
    {
        $pvars = parent::checkCorrectness($pvars);

        checkCorrectness($_POST['rtype'], $pvars['prtype'], L_G_BANNER.' '.strtolower(L_G_TYPE), CHECK_EMPTYALLOWED);

        $pvars['ptype'] = $pvars['prtype'];

        checkCorrectness($_POST['display'], $pvars['pdisplay'], L_G_DISPLAY.' '.strtolower(L_G_TYPE), CHECK_EMPTYALLOWED);

        if($pvars['pdisplay'] == URL_OWN)
        {
            checkCorrectness($_POST['sourceurl'], $pvars['psourceurl'], L_G_LINK_TO_YOUR_OWN_URL, CHECK_EMPTYALLOWED);
        }
        else if($pvars['pdisplay'] == URL_EXIST)
        {
            checkCorrectness($_POST['exist_banner'], $pvars['pexist_banner'], L_G_EXISTING_BANNER_LINK, CHECK_EMPTYALLOWED);
            $pvars['psourceurl'] = $pvars['pexist_banner'];
        }

        checkCorrectness($_POST['window_size_type'], $pvars['pwindow_size_type'], L_G_WINDOW_SIZE.' '.strtolower(L_G_TYPE), CHECK_EMPTYALLOWED);

        $pvars['pdesc'] = $pvars['pdisplay'].'_'.$pvars['pwindow_size_type'];

        if($pvars['pwindow_size_type'] == WINDOWSIZE_PREDEFINED)
        {
            checkCorrectness($_POST['window_size'], $pvars['pwindow_size'], L_G_WINDOW_SIZE, CHECK_EMPTYALLOWED);
            $pvars['pdesc'] = $pvars['pdesc'].'_'.$pvars['pwindow_size'];
        }
        else if($pvars['pwindow_size_type'] == WINDOWSIZE_OWN)
        {
            checkCorrectness($_POST['rwidth'], $pvars['prwidth'], L_G_WIDTH, CHECK_EMPTYALLOWED | CHECK_NUMBER);
            checkCorrectness($_POST['rheight'], $pvars['prheight'], L_G_HEIGHT, CHECK_EMPTYALLOWED | CHECK_NUMBER);
            $pvars['pdesc'] = $pvars['pdesc'].'_'.$pvars['prwidth'].'_'.$pvars['prheight'];
        }

        checkCorrectness($_POST['window_resizable'], $pvars['pwindow_resizable'], L_G_WINDOW_RESIZABLE, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['window_status'], $pvars['pwindow_status'], L_G_WINDOW_STATUS_FIELD, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['window_toolbar'], $pvars['pwindow_toolbar'], L_G_WINDOW_TOOLBAR, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['window_location'], $pvars['pwindow_location'], L_G_WINDOW_LOCATION, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['window_directories'], $pvars['pwindow_directories'], L_G_WINDOW_DIRECTORIES, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['window_menubar'], $pvars['pwindow_menubar'], L_G_WINDOW_MENUBAR, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['window_scrollbars'], $pvars['pwindow_scrollbars'], L_G_WINDOW_SCROLLBARS, CHECK_EMPTYALLOWED);

        $pvars['pdesc'] .= '_'.$pvars['pwindow_resizable'].'_'.$pvars['pwindow_status'].
                           '_'.$pvars['pwindow_toolbar'].'_'.$pvars['pwindow_location'].
                           '_'.$pvars['pwindow_directories'].'_'.$pvars['pwindow_menubar'].
                           '_'.$pvars['pwindow_scrollbars'];

        // format values: display type, window size type, width & height of banner,
        //                resizable, status field, toolbar, location, directories,
        //                menubar, scrollbars

        if(QUnit_Messager::getErrorMessage() == '')
        {
            if(!preg_match_all("/_/", $pvars['pdesc'], $matches) || !is_array($matches[0]) || count($matches[0]) != 10)
                QUnit_Messager::setErrorMessage(L_G_BUILD_DESCRIPTION_FAILED);
        }

        return $pvars;
    }

    //------------------------------------------------------------------------

    function parseBannerDescription($desc, $toPost = true)
    {
        $descArray = explode('_', $desc);

        $parsed = array();
        $parsed['display'] = $descArray[0];
        if($parsed['display'] == URL_EXIST)
        {
            $parsed['sourceurl'] = '';
        }
        else
        {
            $parsed['exist_banner'] = '';
        }

        $parsed['window_size_type'] = $descArray[1];
        if($parsed['window_size_type'] == WINDOWSIZE_OWN)
        {
            $parsed['rwidth'] = $descArray[2];
            $parsed['rheight'] = $descArray[3];
        }
        else
        {
            $parsed['window_size'] = $descArray[2].'_'.$descArray[3];
            $parsed['rwidth'] = $descArray[2];
            $parsed['rheight'] = $descArray[3];
        }

        $parsed['window_resizable'] = $descArray[4];
        $parsed['window_status'] = $descArray[5];
        $parsed['window_toolbar'] = $descArray[6];
        $parsed['window_location'] = $descArray[7];
        $parsed['window_directories'] = $descArray[8];
        $parsed['window_menubar'] = $descArray[9];
        $parsed['window_scrollbars'] = $descArray[10];

        if($toPost === true)
            $_POST = array_merge($_POST, $parsed);
        else
            return $parsed;
    }

    function printListHeader() {
        $this->assign('a_list_cols', "4");
        echo '<td width="20%">'.L_G_ID.' / '.L_G_BANNERNAME.'</td>'
             .'<td width="10%">'.L_G_TYPE.'</td>'
             .'<td>'.L_G_DESTURL.'</td>'
             .'<td width="75">'.L_G_ACTIONS.'</td>';
    }

    function getBannerPopupData() {
        $query = 'select count(1) as "total" from `wd_pa_banners` where (`bannertype`=4 || `bannertype`=5) and `deleted`=0';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) {
            $total = 0;
            $this->assign('a_allcount',$total);
            return;
        }else {
            $total = $rs->fields['total'];
        }

        $numrows = empty($_REQUEST['numrows'])?10:$_REQUEST['numrows'];
        $_REQUEST["numrows"] = $numrows;

        $pages = ceil($total/$numrows);
        $page  = empty($_REQUEST['list_page'])?0:$_REQUEST['list_page'];
        $page  = $page>$pages?$pages:$page;
        $_REQUEST['list_page'] = $page;

        $this->assign('a_list_page',$page);
        $this->assign('a_list_pages',$pages);
        $this->assign('a_allcount',$total);
        $this->assign('a_numrows',$numrows);

        $query = 'select * from `wd_pa_banners` where (`bannertype`=4 || `bannertype`=5) and `deleted`=0 order by `dateinserted` desc limit '.$page*$numrows.','.$numrows;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;

        //$this->assign('a_list_data',$rs);
        $this->listdata = $rs;
    }

    function printListData() {
        foreach($this->listdata as $row) {


        $banner_details = $this->parseBannerDescription($row['description'], false);
        $banner_content = '';
        if($banner_details['display'] == URL_EXIST) {
          $blBanners =& QUnit_Global::newObj('Affiliate_Merchants_Bl_Banners');
          $original_banner = $blBanners->getBannerInfo(array('bannerid' => $row['sourceurl']));

          $bannerData = $original_banner[$row['sourceurl']];

          if($bannerData['bannertype'] == BANNERTYPE_TEXT) {
            $banner_content = "<b>".$bannerData['sourceurl']."</b><br>".$bannerData['description'];
          } else if($bannerData['bannertype'] == BANNERTYPE_HTML) {
            $banner_content = $bannerData['description'];
          } else if($bannerData['bannertype'] == BANNERTYPE_IMAGE) {
            $banner_content = "<br><img src=".$bannerData['sourceurl']." border=0 alt=".$bannerData['description']."><br>";
          }
        } else {
          $banner_content = "<iframe src=".$row['sourceurl']." scrolling=no frameborder=0 marginwidth=0 marginheight=0 width=".$banner_details['rwidth']." height=".$banner_details['rheight']."></iframe>";
        }

        $testbutton = '<a title="'.L_G_TEST.L_G_POPUP.'" href="javascript:;"><img src="'.QUnit_UI_TemplatePage::getImage('ad_view.png').'"
              onClick="showPopupPopunder(\''.urlencode($banner_content).'\',\''.$row['bannertype'].'\',
                    \''.$banner_details['rwidth'].'\',\''.$banner_details['rheight'].'\',
                    \''.$banner_details['window_resizable'].'\',\''.$banner_details['window_status'].'\',
                    \''.$banner_details['window_toolbar'].'\',\''.$banner_details['window_location'].'\',
                    \''.$banner_details['window_directories'].'\',\''.$banner_details['window_menubar'].'\',
                    \''.$banner_details['window_scrollbars'].'\')" /></a>';
        $typetext = $row['bannertype'] ==4?L_G_POPUP:L_G_POPUNDER;

            echo '<tr onmouseout="this.className=\'listresult\';" onmouseover="this.className=\'listresultMouseOver\'"><td>'.$row['bannerid'].'<br/><b>'.$row['name'].'</b></td>'
                .'<td>'.$typetext.'</td>'
                .'<td><a href="'.$row['destinationurl'].'" target="_blank">'.cut_str($row['destinationurl'],40).'</a></td>'
                .'<td>'.$testbutton.'&nbsp;<a href="javascript:editBanner(\'Popup\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('edit.gif').'" border="0" width="16" height="16"></a>&nbsp;<a href="javascript:deleteBanner(\'Popup\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('delete.png').'" border="0" width="16" height="16"></a></td></tr>';
        }
    }

}
?>
