<?php
QUnit_Global::includeClass('Affiliate_Merchants_Views_Banner');

class Affiliate_Merchants_Views_BannerText extends Affiliate_Merchants_Views_Banner
{

    function Affiliate_Merchants_Views_BannerText() {
        $this->currbannertype = 'Text';
        parent::Affiliate_Merchants_Views_Banner();
    }

    //------------------------------------------------------------------------

    function showBanner() {
        $this->assign('a_bannertemplate', 'banner_edit_text.tpl.php');
        $this->assign('a_md', 'Affiliate_Merchants_Views_BannerText');
        $this->assign('a_hlp', L_G_TEXTBANNERHELP);
        $this->assign('a_type_text', L_G_BANNERTYPE_TEXT);
        $this->assign('a_hide_banner_size', "1");


        $this->navigationAddURL(L_G_TEXTBANNER,'index.php?md=Affiliate_Merchants_Views_BannerText');

        $this->getBannerTextData();

        parent::showBanner();
    }

    //------------------------------------------------------------------------

    function protectVariables()
    {
        $pvars = parent::protectVariables();
        $pvars['psourceurl'] = preg_replace('/[\'\"]/', '', $_POST['sourceurl']);

        return $pvars;
    }

    //------------------------------------------------------------------------

    function checkCorrectness($pvars)
    {
        checkCorrectness($_POST['desturl'], $pvars['pdesturl'], L_G_DESTURL, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['name'], $pvars['pname'], L_G_BANNERNAME, CHECK_ALLOWED);
        checkCorrectness($_POST['campaign'], $pvars['CampaignID'], L_G_PCNAME, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['bannercategory'], $pvars['BannerCategoryID'], L_G_BANNERCATEGORY, CHECK_EMPTYALLOWED);

        checkCorrectness($_POST['sourceurl'], $pvars['psourceurl'], L_G_TITLE, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['desc'], $pvars['pdesc'], L_G_DESCRIPTION, CHECK_ALLOWED);
        $pvars['ptype'] = BANNERTYPE_TEXT;

        return $pvars;
    }

    function printListHeader() {
        $this->assign('a_list_cols', "4");
        echo '<td width="20%">'.L_G_ID.' / '.L_G_BANNERNAME.'</td>'
             .'<td width="35%">'.L_G_TITLE.' / '.L_G_BANNERTEXT.'</td>'
             .'<td>'.L_G_DESTURL.'</td>'
             .'<td width="50">'.L_G_ACTIONS.'</td>';
    }

    function getBannerTextData() {
        $query = 'select count(1) as "total" from `wd_pa_banners` where `bannertype`=1 and `deleted`=0';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) {
            $total = 0;
            $this->assign('a_allcount',$total);
            return;
        }else {
            $total = $rs->fields['total'];
        }

        $numrows = empty($_REQUEST['numrows'])?10:$_REQUEST['numrows'];
        $_REQUEST["numrows"] = $numrows;

        $pages = ceil($total/$numrows);
        $page  = empty($_REQUEST['list_page'])?0:$_REQUEST['list_page'];
        $page  = $page>$pages?$pages:$page;
        $_REQUEST['list_page'] = $page;

        $this->assign('a_list_page',$page);
        $this->assign('a_list_pages',$pages);
        $this->assign('a_allcount',$total);
        $this->assign('a_numrows',$numrows);

        $query = 'select * from `wd_pa_banners` where `bannertype`=1 and `deleted`=0 order by `dateinserted` desc limit '.$page*$numrows.','.$numrows;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;

        //$this->assign('a_list_data',$rs);
        $this->listdata = $rs;
    }

    function printListData() {
        foreach($this->listdata as $row) {
            echo '<tr onmouseout="this.className=\'listresult\';" onmouseover="this.className=\'listresultMouseOver\'"><td>'.$row['bannerid'].'<br/><b>'.$row['name'].'</b></td>'
                .'<td><b>'.$row['sourceurl'].'</b><br/>'.cut_str($row['description'],18).'</td>'
                .'<td><a href="'.$row['destinationurl'].'" target="_blank">'.cut_str($row['destinationurl'],20).'</a></td>'
                .'<td><a href="javascript:editBanner(\'Text\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('edit.gif').'" border="0" width="16" height="16"></a>&nbsp;<a href="javascript:deleteBanner(\'Text\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('delete.png').'" border="0" width="16" height="16"></a></td></tr>';
        }
    }

}//end class.
?>
