<?php

QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class Affiliate_Merchants_Views_PZoneSettings extends QUnit_UI_TemplatePage
{

    public $settings = array();

    function Affiliate_Merchants_Views_PZoneSettings() {
        $this->navigationAddURL(L_G_HOME,'index.php?md=home');
        $this->navigationAddURL(L_G_PZONE,'javascript:;');

        if($_GET['action']=='setfooter') {
            $this->navigationAddURL(L_G_PZONE_SETFOOTER,'');
        }elseif($_GET['action']=='flashad') {
            $this->navigationAddURL(L_G_PZONE_FLASHAD,'');
        }else {
            $this->navigationAddURL(L_G_PZONE_SETTINGS,'index.php?md=Affiliate_Merchants_Views_PZoneSettings');
        }
    }

    //------------------------------------------------------------------------

    function initSettings() {
        $query = 'select * from wd_pz_settings';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if($rs && !$rs->EOF) {
            foreach($rs as $row) {
                $this->settings[$row['code']] = $row;
            }
        }
    }

    //------------------------------------------------------------------------

    function loadSettings() {
        $query = 'select * from wd_pz_settings where `autoload`="yes"';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        $tmp = false;
        if($rs && !$rs->EOF) {
            foreach($rs as $row) {
                $tmp[$row['code']] = $row;
            }
        }
        return $tmp;
    }

    //------------------------------------------------------------------------

    function process()
    {

        $this->initSettings();
        $this->assign('a_settings',$this->settings);

        //$this->addContent('dynamiclink_style');
        $this->addContent('dynamiclink_js');

        if($_POST['commited']=="yes"){
            switch($_REQUEST['action']) {
                case 'setfooter': return $this->processEditFooter();break;
                case 'flashad': return $this->processEditFlashAD();break;
                case 'basicsettings': return $this->processBasicSettings();break;
                default: $this->addErrorMessage(L_G_PZONE_ALERT_UNKNOWMETHOD);
            }
        }

        switch($_REQUEST['action']) {
            case 'setfooter': {
                return $this->drawEditFooter();
            }
            case 'flashad': {
                return $this->drawFlashAD();
            }
        }

        $this->drawBasicSettings();
    }

    //--------------------------------------------------------------------------

    function drawEditFooter() {
        $this->addContent('pzonesettings_footer');
    }

    //--------------------------------------------------------------------------

    function drawFlashAD() {
        $this->assign('flashAdData', $this->getFlashAds());
        $this->assign('flashAdString', $this->getFlashAds2String());
        $this->addContent('pzonesettings_flashad');
    }

    //--------------------------------------------------------------------------

    function drawBasicSettings() {
        $this->addContent('pzonesettings_basic');
    }

    //--------------------------------------------------------------------------

    function processEditFooter() {
        //if(empty($this->settings['footer'])) {  //如果从没有设置过
        //    $query = 'INSERT INTO `wd_pz_settings` (`ID`, `code`, `svalue`, `autoload`) VALUES ("%s","%s","%s","yes");';
        //    $id = QCore_Sql_DBUnit::createUniqueID('wd_pz_settings','ID');
        //    $GLOBALS['db']->Execute(sprintf($query,$id,'footer',$_POST['svalue']));
        //    //$GLOBALS['dbrequests']++; //重定向后会重新设定抓取次数，故此句无效
        //}else { //已经设置过，则进行更新即可
            $query = "update `wd_pz_settings` set `svalue`='%s' where `ID`='%s'";
            $query = sprintf($query, $_POST['svalue'], $_POST['id']);
            $GLOBALS['db']->Execute($query);
        //}
        header("Location: index.php?md=".$_POST['md']."&action=setfooter");
        //$this->redirect($_POST['md']."&action=setfooter");
    }

    //--------------------------------------------------------------------------

    function processEditFlashAD() {
        if(!is_array($_POST['img']) || !is_array($_POST['lnk'])) {
            $this->addErrorMessage(L_G_PZONE_PARAMS_ERROR);
            $this->drawFlashAD();
        }else {
            foreach($_POST['img'] as $key=>$value) {
                if(empty($value)) continue;
                //$data['img'][] = urlencode($value);
                //$data['lnk'][] = urlencode($_POST['lnk'][$key]);
                $data['img'][] = $value;
                $data['lnk'][] = $_POST['lnk'][$key];
            }
            $dataString = serialize($data);

            if(empty($this->settings['flashad'])) {  //如果从没有设置过
                $query = "INSERT INTO `wd_pz_settings` (`ID`, `code`, `svalue`, `autoload`) VALUES ('%s','%s','%s','yes')";
                $id = QCore_Sql_DBUnit::createUniqueID('wd_pz_settings','ID');
                $GLOBALS['db']->Execute(sprintf($query,$id,'flashad',$dataString));
                //$GLOBALS['dbrequests']++; //重定向后会重新设定抓取次数，故此句无效
            }else { //已经设置过，则进行更新即可
                $query = "update `wd_pz_settings` set `svalue`='%s' where `ID`='%s'";
                $GLOBALS['db']->Execute(sprintf($query,$dataString,$_POST['id']));
                //$GLOBALS['dbrequests']++;
            }
            header("Location: index.php?md=".$_POST['md']."&action=flashad");
        }
    }


    //--------------------------------------------------------------------------

    function processBasicSettings() {
        $sql = 'update `wd_pz_settings` set `svalue`="%s" where `code`="%s"';
        if(!empty($_POST['sitename'])) {
            $GLOBALS['db']->Execute(sprintf($sql,$_POST['sitename'],'sitename'));
        }
        if(!empty($_POST['siteurl'])) {
            $GLOBALS['db']->Execute(sprintf($sql,$_POST['siteurl'],'siteurl'));
        }
        //if(!empty($_POST['sitelogo'])) {
            $GLOBALS['db']->Execute(sprintf($sql,$_POST['sitelogo'],'sitelogo'));
        //}
        //$GLOBALS['dbrequests']++;
        header("Location: index.php?md=".$_POST['md']);
        //$this->redirect($_POST['md']);
    }

    //--------------------------------------------------------------------------

    function getFlashAds() {
        return unserialize($this->settings['flashad']['svalue']);
    }

    //--------------------------------------------------------------------------

    function getFlashAds2String() {
        $tmp = $this->getFlashAds();
        if(is_array($tmp['img']) && is_array($tmp['lnk']))
            $string = 'bcastr_file='.join('|',$tmp['img']).'&bcastr_link='.join('|',$tmp['lnk']);
        return $string;
    }

    //--------------------------------------------------------------------------

}
?>
