<?php

QUnit_Global::includeClass('Affiliate_Merchants_Views_PZoneSettings');

class Affiliate_Merchants_Views_PZoneThemes extends Affiliate_Merchants_Views_PZoneSettings
{
    function Affiliate_Merchants_Views_PZoneThemes() {
        $this->navigationAddURL(L_G_HOME,'index.php?md=home');
        $this->navigationAddURL(L_G_PZONE,'javascript:;');
        $this->navigationAddURL(L_G_PZONE_CHOOSETHEME,'index.php?md=Affiliate_Merchants_Views_PZoneThemes');
    }

    //------------------------------------------------------------------------

    function process()
    {

        $this->initSettings();
        $this->assign('a_settings',$this->settings);

        //$this->addContent('dynamiclink_style');

        if($_POST['commited']=="yes"){
            switch($_REQUEST['action']) {
                case 'changetheme': return $this->processSetTheme();break;
                default: $this->addErrorMessage(L_G_PZONE_ALERT_UNKNOWMETHOD);
            }
        }

        $this->showThemes();
    }

    //--------------------------------------------------------------------------


    function showThemes() {
        $this->assign('a_themes', $this->getExistsThemes());
        $this->addContent('pzonethemes_list');
    }

    function processSetTheme() {
        if(empty($this->settings['theme'])) {  //如果从没有设置过
            $query = 'INSERT INTO `wd_pz_settings` (`ID`, `code`, `svalue`, `autoload`) VALUES ("%s","%s","%s","yes");';
            $id = QCore_Sql_DBUnit::createUniqueID('wd_pz_settings','ID');
            $GLOBALS['db']->Execute(sprintf($query,$id,'theme',$_POST['currtheme']));
            //$GLOBALS['dbrequests']++; //重定向后会重新设定抓取次数，故此句无效
        }else { //已经设置过，则进行更新即可
            $query = 'update `wd_pz_settings` set `svalue`="%s" where `ID`="%s"';
            $GLOBALS['db']->Execute(sprintf($query,$_POST['currtheme'],$_POST['id']));
            //$GLOBALS['dbrequests']++;
        }


        //设置表
        $settings = QCore_Settings::getAccountSettings(SETTINGTYPE_ACCOUNT, $GLOBALS['Auth']->getAccountId());
        if(!empty($settings['Aff_style_pzone_theme'])) {
            $query = 'update `wd_g_settings` set `value`="'.$_POST['currtheme'].'" where `code`="Aff_style_pzone_theme" and `accountid`="default1"';
        }else {
            $id = QCore_Sql_DBUnit::createUniqueID('wd_g_settings','settingsid');
            $query = 'insert into `wd_g_settings` values ("%s",3,"Aff_style_pzone_theme","%s","default1",NULL,NULL,NULL)';
            $query = sprintf($query,$id,$_POST['currtheme']);
            //$GLOBALS['dbrequests']++;
        }
        $GLOBALS['db']->Execute($query);

        header("Location: index.php?md=".$_POST['md']);
    }

    function getExistsThemes() {
        $themes = array();
        $path = '../templates/pzone/';
        $pdir = dir($path);
        $i = 0;
        while($file=$pdir->read()) {
            if((is_dir("$path/$file")) && ($file!=".") && ($file!="..")) {
                //if(file_exists("$path/$file/LC_MESSAGES/common.mo")) $langs[] = $file;
                $themes[$i]['name'] = $file;
                $themes[$i]['data'] = $this->getThemeData($file);
                $i++;
            }
        }
        $pdir->close();
        return $themes;
    }

    function getThemeData($theme) {
        //Name,Version,Author,AuthorHomePage,AuthorHomeEmail,Desc
        $data = array();
        $path = '../templates/pzone/'.$theme.'/pzone.themes';
        $f = @file($path);
        if($f)
        foreach($f as $line) {
            //$ls = explode(':',$line);
            //$data[$ls[0]] = $ls[1];
            $data[] = $line;
        }
        return $data;
    }

}
?>
