<?php

QUnit_Global::includeClass('Affiliate_PZone_Views_MainPage');

class Affiliate_PZone_Views_Post extends Affiliate_PZone_Views_MainPage
{

    public $ptype = 'post';

    function Affiliate_PZone_Views_Post() {
        parent::__construct();
    }

    //------------------------------------------------------------------------

    function assignPost() {
        //如果有传入ID，以ID的优先级高，即有限显示文章
        if(isset($_GET['id'])) {
            $this->ptype = 'post';
            $post = $this->bl_core->getSinglePost($_GET['id']);
            if(!$post) {
                $this->assign('p_havepost',false);
            }else {
                $title = $_GET['so']!=''?str_replace($_GET['so'],'<span style="color:red;">'.$_GET['so'].'</span>',$post->fields['title']):$post->fields['title'];
                $context = $_GET['so']!=''?str_replace($_GET['so'],'<span style="color:red;">'.$_GET['so'].'</span>',$post->fields['context']):$post->fields['context'];

                $this->assign('p_havepost',true);
                $this->assign('p_id',$post->fields['ID']);
                $this->assign('p_cateid',$post->fields['cateid']);
                $this->assign('p_authorid',$post->fields['authorid']);
                $this->assign('p_postime',$post->fields['postime']);
                $this->assign('p_title',$title);
                $this->assign('p_context',$context);
                $this->assign('p_catename',$post->fields['catename']);
                $this->assign('p_authorname',$post->fields['authorname']);
            }
        }elseif(isset($_GET['cateid'])) {       //显示某个文章分类的文章列表
            $this->ptype = 'category';
            $params = array(
                'paged'=>true,                 //是否分页
                'pageid'=>$_GET['pageid'],     //当前页码
                'limit'=>30,                   //每页显示条数
                'cateid'=>$_GET['cateid']      //文章分类ID
            );
            $posts = $this->bl_core->getPosts($params);
            if(!$posts) {
                $this->assign('p_haveposts',false);
            }else {
                $this->assign('p_haveposts',true);
                $this->assign('p_cateid',$_GET['cateid']);
                $this->assign('p_posts',$posts);
            }
        }elseif(isset($_GET['so'])) {           //全文搜索
            $this->ptype = 'search';
            $params = array(
                'paged'=>true,                 //是否分页
                'limit'=>30,                   //每页显示条数
                'search'=>$_GET['so']          //搜索条件
            );
            $posts = $this->bl_core->getPosts($params);
            $this->assign('p_so',$_GET['so']);
            if(!$posts) {
                $this->assign('p_haveposts',false);
            }else {
                $this->assign('p_haveposts',true);
                $this->assign('p_posts',$posts);
            }
        }
    }

    //------------------------------------------------------------------------

    function process()
    {
        $this->assignData();
        $this->assignPost();
        $this->addContent('header');
        $this->addContent($this->ptype);
        $this->addContent('footer');
    }

    //--------------------------------------------------------------------------

}
?>
