<?php

define('LANG_PATH', 'langs/');
setLanguage();

begin_loadsettings();


// ---------------------------------------------------------------------------
// load param names
// ---------------------------------------------------------------------------
if (GLOBAL_DB_ENABLED == 1) {
    if(!@include_once(CACHE_PATH.$GLOBALS['Auth']->getLiteAccountID().'_paramNames.php')) {
        if(!include_once(CACHE_PATH.'paramNames.php')) {
            echo CACHE_PATH."paramNames.php don't exist, exiting";
            exit;
        }
    }
} else {
    require_once(CACHE_PATH.'paramNames.php');
}

require_once('settings/paramNamesCheck.php');
require_once('settings/ucconfig.inc.php');
require_once('uc_client/client.php');



QUnit_Global::includeClass('Affiliate_PZone_Views_MainPage');
class Affiliate_PZone_Views_Register extends Affiliate_PZone_Views_MainPage
{

    public $accountId;

    function Affiliate_PZone_Views_Register() {
        parent::__construct();
    }

    //------------------------------------------------------------------------

    function process()
    {
        QUnit_Global::includeClass('QUnit_Countries');
        QUnit_Global::includeClass('QCore_Bl_Accounts');
        QUnit_Global::includeClass('QUnit_Messager');
        QUnit_Global::includeClass('QCore_Settings');
        QUnit_Global::includeClass('Affiliate_Scripts_Bl_SignupUserNew');

        $this->accountId = 'default1';
		$settings = $this->getSettings();

        if(!($this->accountId = $GLOBALS['Auth']->getAccountID()) && !($this->accountId = $_POST['aid'])) {
            QUnit_Messager::setErrorMessage(L_G_ACCOUNTNOTKNOWN);
        }

        if($_POST['commited'] == 'yes')
        {
            $signup = QUnit_Global::newObj('Affiliate_Scripts_Bl_SignupUserNew');

            if($signup->processSignup() == false) {
            } else {
                QUnit_Messager::setOkMessage(L_G_SUCCESS);
                $this->assign('upforsuccess', 'ok');
                /*
                if(!empty($_GET['ref']))
                    $signup->redirect(base64_decode($_GET['ref']));
                else
                    $signup->redirect($signup->settings['Aff_affpostsignupurl']);*/
            }

        } else {
            if ($_REQUEST['pid'] == '') {
                $_REQUEST['pid'] = $this->checkCookie();
            } else {
                $this->saveCookie($_REQUEST['pid']);
                $_REQUEST['pid'] = $this->checkCookie();
            }
        }

        $this->assign('settings', $settings);
        $this->assign('model', $this);
        $this->assign('aid', $this->accountId);
        $this->assign('p_title', L_G_TYPESIGNUP);


        $this->assignData();
        $this->addContent('header');
        $this->addContent('register');
        $this->addContent('footer');
    }

    //------------------------------------------------------------------------

    function getSettings() {
        $settings = QCore_Settings::getAccountSettings(SETTINGTYPE_ACCOUNT, $this->accountId);
        $settings = array_merge($settings, QCore_Settings::getGlobalSettings());
        return $settings;
    }

    //------------------------------------------------------------------------

    function getFieldRow($code, $caption) {
        $settings = $this->getSettings();
        if($settings['Aff_signup_'.$code] == "1") {
            if($settings['Aff_signup_'.$code.'_mandatory'] === "true") {
                $caption = "<b>$caption</b>";
                $mandatSign = "*";
            } else {
                $mandatSign = "";
            }
            return "<tr>\n" .
                "<td class=\"dir_form\">$caption</td>\n" .
                "<td><input type=\"text\" name=\"$code\" size=64 value=\"".$_POST[$code]."\">$mandatSign</td>" .
                "</tr>";
        }
    }

    //------------------------------------------------------------------------

    function isDisplayed($code) {
        $settings = $this->getSettings();
        if (is_array($code)) {
            if (count($code) > 0) {
                foreach ($code as $c) {
                	if ($settings['Aff_signup_'.$c] == "1") {
                	    return true;
                	}
                }
            }
            return false;
        } else {
            return ($settings['Aff_signup_'.$code] == "1");
        }
    }

    //--------------------------------------------------------------------------

    function checkCookie()
    {
        if($_COOKIE[COOKIE_NAME] != '')
            $cookieval = $_COOKIE[COOKIE_NAME];
        else
            return '';

        $arr = split ( '_', $cookieval);

        if(!is_array($arr))
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: cookie value is not array', __FILE__, __LINE__);
            return '';
        }

        if(count($arr) != 2)
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: cookie value has not 2 elements', __FILE__, __LINE__);
            return '';
        }

        $userID = $arr[0];

        //------------------------------------------------------------------------
        // check user and campaign
        $blUsers = QUnit_Global::newObj('QCore_Bl_Users');
        if(!$blUsers->checkUserExists($userID))
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: User with ID '.$userID.' doesn\'t exist', __FILE__, __LINE__);
            return '';
        }

        return $userID;
    }

    //--------------------------------------------------------------------------

    function saveCookie($pid)
    {
        //------------------------------------------------------------------------
        // check user and campaign
        $blUsers = QUnit_Global::newObj('QCore_Bl_Users');
        $ppid = $blUsers->getUserID($pid);
        if(!$ppid)
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: User with ID '.$pid.' doesn\'t exist', __FILE__, __LINE__);
            return false;
        }

        if($_COOKIE[COOKIE_NAME] == '') {
            setcookie(COOKIE_NAME, $ppid."_null");
        }

        return true;
    }

}
?>
