<?php
QUnit_Global::includeClass('QCore_Bl_JobScheduler');

class Affiliate_Scripts_Bl_JobScheduler extends QCore_Bl_JobScheduler
{
    //--------------------------------------------------------------------------

    function getJobClass($rtype)
    {
        $jobClasses = array(JOB_TYPE_DAILYREPORTS           => 'Affiliate_Scripts_Bl_DailyReports',
                            JOB_TYPE_WEEKLYREPORTS          => 'Affiliate_Scripts_Bl_WeeklyReports',
                            JOB_TYPE_MONTHLYREPORTS         => 'Affiliate_Scripts_Bl_MonthlyReports',
                            JOB_TYPE_RECURRINGCOMMISSIONS   => 'Affiliate_Scripts_Bl_RecurringCommissions',
                            JOB_TYPE_CACHECLEAN             => 'Affiliate_Scripts_Bl_CacheClean');

        if ($jobClasses[$rtype] == '') {
            return false;
        }

        return $jobClasses[$rtype];
    }

    //--------------------------------------------------------------------------
    // schedules new jobs

    function scheduleJobs()
    {
        $this->saveRunningDate();
        $this->scheduleRecurringCommissions();
        $this->scheduleDailyReports();;
        $this->scheduleWeeklyReports();
        $this->scheduleMonthlyReports();
        $this->scheduleCacheClean();
    }

    //--------------------------------------------------------------------------

    function saveRunningDate() {
        QCore_Settings::_update('Aff_last_job_time', time(), SETTINGTYPE_GLOBAL);
    }

    //--------------------------------------------------------------------------

    function scheduleDailyReports()
    {
        $settings = $GLOBALS['Auth']->getSettings();

        if (($settings['Aff_email_dailyreport'] != '1') && ($settings['Aff_email_merch_dailyreport'] != '1')) return;

        $jobexists = $this->existsJob(JOB_TYPE_DAILYREPORTS,
                                      mktime( 0,  0,  0, date("m"), date("d"), date("Y")),
                                      mktime(23, 59, 59, date("m"), date("d"), date("Y")));

        if ($jobexists) return;

        $job = QUnit_Global::newObj('QCore_Bl_Job');
        $job->createJob(JOB_TYPE_DAILYREPORTS);
    }

    //--------------------------------------------------------------------------

    function scheduleWeeklyReports()
    {
        $settings = $GLOBALS['Auth']->getSettings();

        if (($settings['Aff_email_weeklyreport'] != '1') && ($settings['Aff_email_merch_weeklyreport'] != '1')) return;

        if ($settings['Aff_email_weeklysendday'] != date("w")) return;

        $jobexists = $this->existsJob(JOB_TYPE_WEEKLYREPORTS,
                                      mktime( 0,  0,  0, date("m"), date("d")-date("w"), date("Y")),
                                      mktime(23, 59, 59, date("m"), date("d"),           date("Y")));

        if ($jobexists) return;

        $job = QUnit_Global::newObj('QCore_Bl_Job');
        $job->createJob(JOB_TYPE_WEEKLYREPORTS);
    }

    //--------------------------------------------------------------------------

    function scheduleMonthlyReports()
    {
        $settings = $GLOBALS['Auth']->getSettings();

        if (($settings['Aff_email_monthlyreport'] != '1') && ($settings['Aff_email_merch_monthlyreport'] != '1')) return;

        if ($settings['Aff_email_monthlysendday'] <= date("t")) {
            if ($settings['Aff_email_monthlysendday'] != date("j")) return;
        } elseif(date("t") != date("j")) {
            return;
        }

        $jobexists = $this->existsJob(JOB_TYPE_MONTHLYREPORTS,
                                      mktime( 0,  0,  0, date("m"), 0,         date("Y")),
                                      mktime(23, 59, 59, date("m"), date("t"), date("Y")));

        if ($jobexists) return;

        $job = QUnit_Global::newObj('QCore_Bl_Job');
        $job->createJob(JOB_TYPE_MONTHLYREPORTS);
    }

    //--------------------------------------------------------------------------

    function scheduleRecurringCommissions()
    {
        $jobexists = $this->existsJob(JOB_TYPE_RECURRINGCOMMISSIONS,
                                      mktime( 0,  0,  0, date("m"), date("d"), date("Y")),
                                      mktime(23, 59, 59, date("m"), date("d"), date("Y")));

        if ($jobexists) return;

        $job = QUnit_Global::newObj('QCore_Bl_Job');
        $job->createJob(JOB_TYPE_RECURRINGCOMMISSIONS);
    }

    //--------------------------------------------------------------------------

    function scheduleCacheClean()
    {
        $job = QUnit_Global::newObj('QCore_Bl_Job');
        $job->createJob(JOB_TYPE_CACHECLEAN);
    }

}
?>
