<?php
QUnit_Global::includeClass('Affiliate_Scripts_Bl_Signup');

define('WD_PATTERN_DEFAULT', '/[^\'\"]*/');

class Affiliate_Scripts_Bl_SignupUserNew extends Affiliate_Scripts_Bl_Signup
{
    function Affiliate_Scripts_Bl_SignupUserNew() {
        $this->user = QUnit_Global::newObj('Affiliate_Scripts_Bl_Affiliate');
        $this->blForcedMatrix =& QUnit_Global::newObj('Affiliate_Merchants_Bl_ForcedMatrix');
        $this->blUsers =& QUnit_Global::newObj('QCore_Bl_Users');
        parent::Affiliate_Scripts_Bl_Signup();
    }

    //--------------------------------------------------------------------------

    function getErrorMessage() {
        return QUnit_Messager::getErrorMessage();
    }

    //--------------------------------------------------------------------------

    function addErrorMessage($msg) {
        QUnit_Messager::setErrorMessage($msg);
    }

    //--------------------------------------------------------------------------

    function validateMail($mail) {
        if($mail !== "") {
            if(ereg("^[-A-Za-z0-9_]+[-A-Za-z0-9_.]*[@]{1}[-A-Za-z0-9_]+[-A-Za-z0-9_.]*[.]{1}[A-Za-z]{2,5}$", $mail)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    //--------------------------------------------------------------------------

    function checkForm() {
        $correct = true;
        if($this->blUsers->checkUserExists('', $_POST['username']) === true) {
            $this->addErrorMessage(L_G_UNAMEEXISTS);
            $correct = false;
        }

        if(($_POST['email'] != '') && !$this->validateMail($_POST['email'])) {
            $this->addErrorMessage(L_G_EMAIL_FORMAT_ERROR);
            $correct = false;
        }

        if($_POST['refid'] != preg_replace('/[^A-Za-z0-9\-\_]/', '', $_POST['refid'])) {
        	$this->addErrorMessage(L_G_REFERERID.' '.L_G_UNALLOWED);
        	$correct = false;
        }

        //限制用户名不能是中文 utf8
        $num = preg_match_all("/[\xB0-\xF7][\xA1-\xFE]/", $_POST['username'], $ff);
        if(0!=$num) {
            $this->addErrorMessage(L_G_USERNAME_NOUNIQUECHAR);
            $correct = false;
        }

        if(($_POST['refid'] != '') && ($this->checkRefidUnique($_POST['refid']) === false)) {
            $this->addErrorMessage(L_G_REFIDEXISTS);
            $correct = false;
        }

        if(($_POST['add_campaign_id'] != '') && ($this->checkCampaignId($_POST['add_campaign_id']) === false)) {
            $this->addErrorMessage(L_G_SELECTEDCAMPAIGNDOESNOTEXIST);
            $correct = false;
        }

        if($this->settings['Aff_signup_force_acceptance'] == "1") {
            if(!isset($_POST['tos']) || $_POST['tos'] !== "1") {
                $this->addErrorMessage(L_G_TOSAGREE);
                $correct = false;
            }
        }

        if($this->user->check() == false) {
            $correct = false;
        }

        if($_POST['parentuserid'] != '' && $this->checkParentUser($_POST['parentuserid']) === false) {
            $this->addErrorMessage(L_G_PARENTAFFDOESNTEXISTS);
            $correct = false;
        }

//        if(!in_array($pcountry, $GLOBALS['countries'])) {
//            $this->addErrorMessage(L_G_COUNTRYNOTINLIST);
//            $correct = false;
//        }

        return $correct;
    }

    //--------------------------------------------------------------------------
    function loadSettings($accountId) {
        $this->settings = QCore_Settings::getAccountSettings(SETTINGTYPE_ACCOUNT, $accountId);
        $this->settings = array_merge($this->settings, QCore_Settings::getGlobalSettings());
        //$default_lang = ($this->settings['Aff_default_lang'] != '' ? $this->settings['Aff_default_lang'] : $this->settings['Glob_default_lang']);
    }

    //--------------------------------------------------------------------------

    function setMandatoryFields() {
        $columns = $this->user->getColumns();
        foreach($columns as $key => $val) {
            if($this->settings['Aff_signup_'.$key.'_mandatory'] === "true") {
                $this->user->setNeeded($key, true);
            } else {
               $this->user->setNeeded($key, false);
            }
        }
    }

    //--------------------------------------------------------------------------

    function getStatus() {
        $approval = $this->settings['Aff_affiliateapproval'];
        if($approval == APPROVE_AUTOMATIC) {
            $status = AFFSTATUS_APPROVED;
            $this->user->setColumn('dateapproved', strftime('%y-%m-%d %H:%M:%S', time()));
        } else if($approval == APPROVE_MANUAL) {
            $status = AFFSTATUS_NOTAPPROVED;
        } else {
            $status = AFFSTATUS_NOTAPPROVED;
        }
        return $status;
    }

    //--------------------------------------------------------------------------

    function getParentUserId($userId) {
        $parentuserid =  $this->getParentUser();
        $this->user->setColumn('originalparentid', $parentuserid);

        if($parentuserid == '' && $this->settings['Aff_nonreferred_signup'] != '' && $this->settings['Aff_nonreferred_signup'] != '_') {
            $parentuserid = $this->settings['Aff_nonreferred_signup'];
        }

        if($this->settings['Aff_matrix_width'] > 0 && $this->settings['Aff_matrix_height'] > 0
                && $this->settings['Aff_use_forced_matrix'] == '1') {
            if( ($temp_parentuserid = $this->blForcedMatrix->useForcedMatrix($userID,
                $parentuserid, $this->settings)) != false)
                $parentuserid = $temp_parentuserid;
        }
        return $parentuserid;
    }

    function setDataFieldsCaption() {
        for($i=1;$i<=5;$i++) {
            $this->user->setCaption("data$i", $this->settings["Aff_signup_data{$i}_name"]);
        }
    }

    function fill() {
        $this->user->fillColumnsFromArray($_POST);
        $this->user->setColumn('rtype', USERTYPE_USER);
        $this->user->setColumn('dateinserted', strftime('%y-%m-%d %H:%M:%S', time()));
        $this->user->setColumn('deleted', '0');
        $this->user->setColumn('product', PRODUCT_AFFILIATE);

        $aid = $this->getAccountId();
        $this->user->setColumn('accountid', $aid);

        $this->loadSettings($aid);

        $this->setMandatoryFields();
        $this->setDataFieldsCaption();

        $pwd = substr(uniqid(rand(),1), 0, 5);
        $this->user->setColumn('rpassword', $pwd);
        $userId = QCore_Sql_DBUnit::createUniqueID('wd_g_users', 'userid');
        $this->user->setColumn('userid', $userId);

        if($this->user->getColumn('refid') == '') $this->user->setColumn('refid', $userId);
        //$this->user->setColumn('refid', $this->user->getColumn('username'));

        $initial_min_payout = $this->settings['Aff_initial_min_payout'];

        $status = $this->getStatus();
        $this->user->setColumn('rstatus', $status);

        $parentuserid = $this->getParentUserId($userId);
        $this->user->setColumn('parentuserid', $parentuserid);
    }

    //--------------------------------------------------------------------------

    function processSignup()
    {
        $this->fill();

        if($this->checkForm() == false) {
            return false;
        }

        //UC同步注册，使在MT注册的会员可以直接登陆其他UCENTER应用
        include_once('settings/ucconfig.inc.php');
        if(UC_ENABLE) {
            include_once('uc_client/client.php');

            $udata = uc_get_user($this->user->getColumn('username'));
            if($udata) {
                //判断需要注册的用户如果是需要激活的用户，则需跳转到登录页面验证
                QUnit_Messager::setErrorMessage('该用户('.$udata[1].')已注册到本站UCenter，请直接<a href="index.php?md=Affiliate_PZone_Views_Login">登陆</a>使用，如果此账号不是您注册的，请选用其他用户名注册。');
                return false;
            }

            $uid = uc_user_register(
                $this->user->getColumn('username'),
                $this->user->getColumn('rpassword'),
                $this->user->getColumn('email')
            );

            if($uid <= 0) {
                if($uid == -1) {
                    QUnit_Messager::setErrorMessage('用户名不合法');
                } elseif($uid == -2) {
                    QUnit_Messager::setErrorMessage('包含不允许注册的词语');
                } elseif($uid == -3) {
                    QUnit_Messager::setErrorMessage('用户名已经存在');
                } elseif($uid == -4) {
                    QUnit_Messager::setErrorMessage('Email 格式有误');
                } elseif($uid == -5) {
                    QUnit_Messager::setErrorMessage('Email 不允许注册');
                } elseif($uid == -6) {
                    QUnit_Messager::setErrorMessage('该 Email 已经被注册');
                } else {
                    QUnit_Messager::setErrorMessage('未定义');
                }
                return false;
            }
        }


        //MT会员保存
        if($this->save() == false) {
            return false;
        }

        $this->addUserToCampaign($this->user->getColumn('userid'), $_POST['add_campaign_id'], $_POST['add_campaign_category_id']);

        $this->addProgramSignupBonus($this->user->getColumn('userid'), $this->user->getColumn('accountid'), $this->user->getColumn('rstatus'), $this->user->getColumn('parentuserid'));

        $this->saveSettings();
        $this->sendMail();
        $this->signupToNewsletter();

        return true;
    }

    //--------------------------------------------------------------------------

    function save() {
        return $this->user->insertUser();
    }

    //--------------------------------------------------------------------------

    function saveSettings() {
        QCore_Settings::_update('Aff_min_payout', $_POST['minpayout'], SETTINGTYPE_USER, $this->user->getColumn('accountid'), $this->user->getColumn('userid'));
        QCore_Settings::_update('Aff_user_ip', $_SERVER['REMOTE_ADDR'], SETTINGTYPE_USER, $this->user->getColumn('accountid'), $this->user->getColumn('userid'));
    }

    //--------------------------------------------------------------------------

    function sendMail() {
        $this->sendMailToMerchant($this->user->getColumn('userid'), $this->user->getColumn('accountid'));

        if(!$this->sendMailToUser($this->user->getColumn('userid'), $this->user->getColumn('accountid'), $this->user->getColumn('email'), $this->user->getColumn('rpassword'), $this->user->getColumn('rstatus') == AFFSTATUS_APPROVED)) {
            return false;
        }

        if($this->sendMailToParentUser($this->user->getColumn('userid'), $this->user->getColumn('parentuserid'), $this->user->getColumn('accountid'))) {
            return false;
        }

        return true;
    }

    //--------------------------------------------------------------------------

    function signupToNewsletter() {
        if ($this->settings['Aff_newsletter_signup_enabled'] != '1')
            return false;

        $emaildata = $this->blEmailTemplates->getFilledEmailMessage($this->user->getColumn('userid'), $this->accountid, 'AFF_EMAIL_AFF_NL_SGN', '', '');
        if ($emaildata == false) {
            $emaildata = array('subject' => '', 'email' => '');
        }

        $params = array('email' => $this->settings['Aff_newsletter_signup_email'],
                        'text' => $emaildata['email'],
                        'subject' => $emaildata['subject'],
                        'settings' => $this->settings,
                        'returnpath' => $this->user->getColumn('username'),
                        'returnpath_name' => $this->user->getColumn('name').' '.$this->user->getColumn('surname'));

        $params['settings']['Aff_system_email_name'] = $this->user->getColumn('name').' '.$this->user->getColumn('surname');
        $params['settings']['Aff_system_email'] = $this->user->getColumn('username');

        return $this->blCommunications->sendEmailDirect($params);
    }
}
?>
