<?php
class QCore_Auth
{
    var $logged = false;
    var $accountID = 'default1';
    var $userID = '';
    var $refID = '';
    var $userName = '';
    var $userType = '';
    var $params = null;
    var $className = 'Auth';
    var $settings = null;
    var $sessionPrefix = 'auth';
    var $permissions = array();
    var $logintime = null;

    //------------------------------------------------------------------------

    function QCore_Auth()
    {
    }

    //------------------------------------------------------------------------

    function init()
    {
                                            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        //$this->loadSettings();            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                                            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    }

    //------------------------------------------------------------------------

    function getProgramType()
    {
        return AFF_PROGRAM_TYPE;
    }

    //------------------------------------------------------------------------

    function getAccountID()
    {
        if($GLOBALS['Auth']->accountID == '') {
            $GLOBALS['Auth']->accountID = DEFAULT_ACCOUNT;
        }
        return $GLOBALS['Auth']->accountID;
    }

    //------------------------------------------------------------------------

    function getLiteAccountID()
    {
        if (GLOBAL_DB_ENABLED == 1) {
            if($_SESSION['lite_accountid'] != '') {
                return $_SESSION['lite_accountid'];
            }

            if($_SESSION['lid'] != '') {
                return $_SESSION['lid'];
            }
        }

        return $this->getSetting('AffPlanet_account_id');
    }

    //------------------------------------------------------------------------

    function setAccountID($accountID)
    {
        $this->accountID = $accountID;
    }

    //------------------------------------------------------------------------

    function getUserID()
    {
        return $GLOBALS['Auth']->userID;
    }

    //------------------------------------------------------------------------

    function getRefD()
    {
        return ($GLOBALS['Auth']->refID != '' ? $GLOBALS['Auth']->refID : $GLOBALS['Auth']->userID);
    }

    //------------------------------------------------------------------------

    function getUserType()
    {
        return $GLOBALS['Auth']->userType;
    }

    //------------------------------------------------------------------------

    function getAccountData()
    {
        return $GLOBALS['Auth']->accountData;
    }

    //------------------------------------------------------------------------

    function isLogged()
    {
        return $GLOBALS['Auth']->logged;
    }

    //------------------------------------------------------------------------

    function getPermissions()
    {
        return $GLOBALS['Auth']->permissions;
    }

    //------------------------------------------------------------------------

    function checkLogon($uname, $pwd, $type, $accountid)
    {
        if($GLOBALS['Auth']->getSetting('Aff_login_protection_retries') != '' && $GLOBALS['Auth']->getSetting('Aff_login_protection_delay') != '')
        {
            if(isset($_SESSION['lastbadlogin']))
            {
                if((time()-$_SESSION['lastbadlogin'])<$GLOBALS['Auth']->getSetting('Aff_login_protection_delay'))
                    return $GLOBALS['Auth']->getSetting('Aff_login_protection_delay')-(time()-$_SESSION['lastbadlogin']);
            }
        }

        // protection against sql injection
        $username = preg_replace('/[\'\"]/', '', $uname);
        $password = md5(preg_replace('/[\'\"]/', '', $pwd));
        $cpassword = preg_replace('/[\'\"]/', '', $pwd);
        $accountid = preg_replace('/[\'\"]/', '', $accountid);

        $sql = 'select userid, accountid '.
               'from wd_g_users '.
               'where username='._q($username);
        if($type != USERTYPE_SUPERADMIN)  {
            $sql .= '  and accountid='._q($accountid);
        }

        $sql .= ' and (rpassword='._q($password).' or rpassword='._q($cpassword).')';

        $sql .= '  and deleted='._q('0').
                '  and rtype='._q($type);
        if($type == USERTYPE_USER) {
            $sql .= ' and rstatus='._q(AFFSTATUS_APPROVED);
        } elseif ($type == USERTYPE_ADMIN) {
            $sql .= ' and rstatus='._q(STATUS_ENABLED);
        }

        $rs = $GLOBALS['db']->execute($sql);
        $GLOBALS['dbrequests']++;
        if (!$rs || $rs->EOF)
        {

            if($GLOBALS['Auth']->getSetting('Aff_login_protection_retries') != '' && $GLOBALS['Auth']->getSetting('Aff_login_protection_delay') != '')
            {
                if(!isset($_SESSION['loginretries']))
                {
                    $_SESSION['lastbadlogin'] = 0;
                    $_SESSION['loginretries'] = 1;
                }
                else
                    $_SESSION['loginretries']++;

                if($_SESSION['loginretries'] >= $GLOBALS['Auth']->getSetting('Aff_login_protection_retries'))
                {
                    unset($_SESSION['loginretries']);
                    $_SESSION['lastbadlogin'] = time();
                }
            }

            return false;
        }

        // user is ok
        unset($_SESSION['lastbadlogin']);
        unset($_SESSION['loginretries']);
        return array( 'userid' => $rs->fields['userid'], 'accountid' => $rs->fields['accountid']);
    }

    //------------------------------------------------------------------------

    function saveLoginTime($accountID, $userID) {

        if (empty($GLOBALS['Auth']->settings['Aff_logincount'])) {
            $GLOBALS['Auth']->settings['Aff_logincount'] = 0;
        }

        QCore_Settings::_update('Aff_logincount', $GLOBALS['Auth']->settings['Aff_logincount']+1, SETTINGTYPE_USER, $accountID, $userID);
        QCore_Settings::_update('Aff_lastlogintime', date("Y-m-d H:i:s"), SETTINGTYPE_USER, $accountID, $userID);
    }

    //------------------------------------------------------------------------

    function logUser($userID, $username, $type)
    {
        // load data about user
        // protection against sql injection
        $userID = preg_replace('/[\'\"]/', '', $userID);

        $sql = 'select userid, accountid, name'.
        	   (($type == USERTYPE_USER) ? ', refid ' : ' ').
               'from wd_g_users '.
               'where userid='._q($userID['userid']).
               '  and deleted='._q('0');
        if($type != USERTYPE_SUPERADMIN)
            $sql .= ' and accountid='._q($userID['accountid']);
        else if($type == USERTYPE_ADMIN || $type == USERTYPE_USER)
            $sql .= ' and rstatus='._q(AFFSTATUS_APPROVED);

        $rs = $GLOBALS['db']->execute($sql);
        if (!$rs || $rs->EOF)
            return false;

        $accountID = $rs->fields['accountid'];
        $userID = $rs->fields['userid'];
        $username = $rs->fields['name'];
        $refID = ($type == USERTYPE_USER) ? $rs->fields['refid'] : '';

        $params = array();

        if(QCore_Auth::logUserData($userID, $username, $params, $type, $accountID, $refID))
        {
            $this->loadSettings();

            // login time and login count
            if ($type == USERTYPE_USER) {
                $this->saveLoginTime($accountID, $userID);
            }

            // log this to history
            QCore_History::DebugMsg(WLOG_ACTIONS, 'User logged in', __FILE__, __LINE__);
            return true;
        }
        else
        {
            $historyMsg = 'Can not log in super admin';
            QCore_History::DebugMsg(WLOG_DEBUG, $historyMsg, __FILE__, __LINE__);
            return false;
        }
    }

    //------------------------------------------------------------------------

    function loadSettings() {
        if($GLOBALS['Auth']->accountID != '') {
            $GLOBALS['Auth']->settings = QCore_Settings::getAccountSettings(SETTINGTYPE_ACCOUNT, $this->accountID);
        }
    }

    //------------------------------------------------------------------------

    function loadPermissions()
    {
        if(QCore_Auth::getUserID() == '' || QCore_Auth::getAccountID() == '')
            return false;

        $sql = 'select rt.code, rt.righttype '.
               'from wd_g_righttypes rt, wd_g_users u, wd_g_userrights ur '.
               'where u.userid='._q(QCore_Auth::getUserID()).
               '  and u.accountid='._q(QCore_Auth::getAccountID()).
               '  and u.userprofileid=ur.userprofileid'.
               '  and ur.righttypeid=rt.righttypeid';
        $rs = $GLOBALS['db']->execute($sql);
        $GLOBALS['dbrequests']++;
        if(!$rs) return false;

        if($rs->EOF)
        {
            // try load default permissions
            $sql = 'select rt.code, rt.righttype '.
                   'from wd_g_righttypes rt, wd_g_userrights ur '.
                   'where ur.userprofileid='._q(DEFAULT_USER_PROFILE).
                   '  and ur.righttypeid=rt.righttypeid';
            $rs = $GLOBALS['db']->execute($sql);
            $GLOBALS['dbrequests']++;
            if(!$rs) return false;
        }

        $GLOBALS['Auth']->permissions = array();

        while(!$rs->EOF)
        {
            $GLOBALS['Auth']->permissions[] = $rs->fields['code'].'_'.$rs->fields['righttype'];

            $rs->MoveNext();
        }

        return true;
    }

    //------------------------------------------------------------------------

    function checkPermission($permission)
    {
        if($GLOBALS['Auth']->getUserType() == USERTYPE_USER)
            return true;

        if(is_array($GLOBALS['Auth']->permissions) && in_array($permission, $GLOBALS['Auth']->permissions))
            return true;

        return false;
    }

    //------------------------------------------------------------------------

    function logUserData($userID, $username, $params = null, $userType, $accountID = '', $refID = '')
    {
        $GLOBALS['Auth']->accountID = $accountID;
        $GLOBALS['Auth']->userID = $userID;
        $GLOBALS['Auth']->userName = $username;
        $GLOBALS['Auth']->userType = $userType;
        $GLOBALS['Auth']->params = $params;
        $GLOBALS['Auth']->refID = $refID;
        $GLOBALS['Auth']->logged = true;

        QCore_Auth::loadPermissions();

        QCore_Auth::saveToSession();

        return true;
    }

    //------------------------------------------------------------------------

    function logout()
    {
        switch($GLOBALS['Auth']->userType)
        {
            case USERTYPE_ADMIN:      $historyMsg = "Merchant '".$this->userName."' logged out."; break;
            case USERTYPE_SUPERADMIN: $historyMsg = "Super admin '".$this->userName."' logged out."; break;
            case USERTYPE_USER:       $historyMsg = "User '".$this->userName."' logged out."; break;
            default: $historyMsg = 'Logged out. User type do not known.'; break;
        }

        QCore_History::DebugMsg(WLOG_ACTIONS, $historyMsg, __FILE__, __LINE__);

        $GLOBALS['Auth']->logged = false;
        $GLOBALS['Auth']->accountID = '';
        $GLOBALS['Auth']->userID = '';
        $GLOBALS['Auth']->refID = '';
        $GLOBALS['Auth']->userName = '';
        $GLOBALS['Auth']->userType = '';
        $GLOBALS['Auth']->params = null;
        $GLOBALS['Auth']->settings = null;
        $GLOBALS['Auth']->permissions = array();

        QCore_Auth::saveToSession();
    }

    //------------------------------------------------------------------------

    function getParams()
    {
        return $GLOBALS['Auth']->params;
    }

    //------------------------------------------------------------------------

    function getParam($paramName)
    {
        return $GLOBALS['Auth']->params[$paramName];
    }

    //------------------------------------------------------------------------

    function hasRights($rights)
    {
        return true;
    }

    //------------------------------------------------------------------------

    function showLoginPage()
    {
        $_REQUEST['md'] = LOGIN_PAGE;
    }

    //------------------------------------------------------------------------

    function showNoRightsPage()
    {
    }

    //------------------------------------------------------------------------

    function getSetting($code)
    {
        if(is_array($GLOBALS['Auth']->settings) && count($GLOBALS['Auth']->settings)>0)
            return $GLOBALS['Auth']->settings[$code];

        return false;
    }

    //------------------------------------------------------------------------

    function getSettings()
    {
        return $GLOBALS['Auth']->settings;
    }

    //------------------------------------------------------------------------

    function getUsernameForUser($userID, $accountID = '')
    {
        $sql = 'select username from wd_g_users '.
               'where userid='._q($userID);
        if($accountID != '')
            $sql .= '  and accountid='._q($accountID);

        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if (!$rs || $rs->EOF)
            return false;

        return $rs->fields['username'];
    }

    //------------------------------------------------------------------------

    function getFromSession()
    {
        if($_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'accountID'] != '') {
            $GLOBALS['Auth']->accountID = $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'accountID'];
        }
        $GLOBALS['Auth']->userID = $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'userID'];
        $GLOBALS['Auth']->refID = $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'refID'];
        $GLOBALS['Auth']->userName = $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'userName'];
        $GLOBALS['Auth']->userType = $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'userType'];
        $GLOBALS['Auth']->params = $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'params'];
        $GLOBALS['Auth']->logged = $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'logged'];
        $GLOBALS['Auth']->settings = unserialize($_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'settings']);
        $GLOBALS['Auth']->permissions = unserialize($_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'permissions']);

    }

    //------------------------------------------------------------------------

    function saveToSession()
    {
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'accountID'] = $GLOBALS['Auth']->accountID;
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'userID'] = $GLOBALS['Auth']->userID;
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'refID'] = $GLOBALS['Auth']->refID;
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'userName'] = $GLOBALS['Auth']->userName;
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'userType'] = $GLOBALS['Auth']->userType;
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'params'] = $GLOBALS['Auth']->params;
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'logged'] = $GLOBALS['Auth']->logged;
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'settings'] = serialize($GLOBALS['Auth']->settings);
        $_SESSION[SESSION_PREFIX.$GLOBALS['Auth']->sessionPrefix.'permissions'] = serialize($GLOBALS['Auth']->permissions);
    }

    //------------------------------------------------------------------------

    function setAccountByUser($userID)
    {
        $sql = 'select userid, accountid '.
               'from wd_g_users '.
               'where (userid='._q($userID).' or refid='._q($userID).')'.
               '  and rtype='._q(USERTYPE_USER);

        $rs = $GLOBALS['db']->execute($sql);
        if (!$rs || $rs->EOF)
        {
            return false;
        }

        $this->accountID = $rs->fields['accountid'];

        $this->loadSettings();

        return true;
    }

    //------------------------------------------------------------------------

    function getRefererID() {
    	if ($this->getUserType() == USERTYPE_USER)
    		return $GLOBALS['Auth']->refID;

    	return '';
    }

    //------------------------------------------------------------------------

    function setUserType($userType) {
        $GLOBALS['Auth']->userType = $userType;
    }

    //------------------------------------------------------------------------

    function hasSubaffiliates()
    {
        $sql = 'select userid '.
               'from wd_g_users '.
               'where parentuserid='._q($GLOBALS['Auth']->getUserID());
        $rs = $GLOBALS['db']->execute($sql);
        $GLOBALS['dbrequests']++;
        if (!$rs || $rs->EOF) return false;

        return true;
    }
}
?>
