<?php
class QCore_Bl_Job
{
    var $jobid;
    var $jobtype;
    var $jobstatus;
    var $jobprogress;
    var $jobcurrentprogress;
    var $datecreated;
    var $datefinished;
    var $jobscheduler;
    
    //--------------------------------------------------------------------------
    
    function createJob($jobtype)
    {
        $jobID = QCore_Sql_DBUnit::createUniqueID('wd_g_jobs', 'jobid');
        $sql = 'insert into wd_g_jobs (jobid, rtype, rstatus, progress, datecreated) '.
                'values ('._q($jobID).', '._q($jobtype).', '._q(JOB_NEW).', '._q(0).', NOW())';
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }
        return true;
    }
    
    //--------------------------------------------------------------------------
    
    function loadJob($jobid, $jobscheduler)
    {
        $this->jobscheduler = $jobscheduler;
        $this->jobid = $jobid;
        
        $sql = 'select * from wd_g_jobs where jobid='._q($this->jobid);
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs || $rs->EOF) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }
        
        $this->jobtype = $rs->fields['rtype'];
        $this->jobstatus = $rs->fields['rstatus'];
        $this->jobprogress = $rs->fields['progress'];
        $this->jobcurrentprogress = 0;
        $this->datecreated = $rs->fields['datecreated'];
        $this->datefinished = $rs->fields['datefinished'];
        
        return true;
    }
    
    //--------------------------------------------------------------------------
    
    function start()
    {
        if ($this->jobstatus == JOB_NEW) {
            $this->jobstatus = JOB_RUNNING;
            $this->updateJob();
        }
        
        return true;
    }
    
    //--------------------------------------------------------------------------
    
    function updateJob() {
        $sql = 'update wd_g_jobs set rstatus='._q($this->jobstatus).', '.
               ' progress='._q($this->jobcurrentprogress);
        if ($this->jobstatus == JOB_FINISHED) {
            $sql .= ', datefinished=NOW() ';
        }
        $sql .= ' where jobid='._q($this->jobid);
               
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs || $rs->EOF) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }
        
        return true;
    }
    
    //--------------------------------------------------------------------------
    
    function interrupt() {
        $this->jobcurrentprogress++;
        if ($this->jobscheduler->interrupt()) {
            $this->updateJob();
            return true;
        }
        
        return false;
    }
    
    //--------------------------------------------------------------------------
    
    function skip() {
        if ($this->jobcurrentprogress < $this->jobprogress) {
            $this->jobcurrentprogress++;
            return true;
        }
        
        return false;
    }
    
    //--------------------------------------------------------------------------
    
    function finish() {
        $this->jobstatus = JOB_FINISHED;
        $this->updateJob();
        
        return true;
    }
    
    //--------------------------------------------------------------------------
    // virtual
    function process() {
        
        $this->interrupt();
        
    }
    
}
?>
