<?php
class QCore_Constants
{
    function initConstants()
    {
        define('PRODUCT_AFFILIATE', 'affiliate');

        define('DEFAULT_ACCOUNT', 'default1');
        define('DEFAULT_USER_PROFILE', 'default1');

        define('AFFSTATUS_NOTAPPROVED', 1);
        define('AFFSTATUS_APPROVED',    2);
        define('AFFSTATUS_SUPPRESSED',  3);

        define('WD_MAX_PROCESSED_IDS', 50);

        define('APPROVE_MANUAL',    1);
        define('APPROVE_AUTOMATIC', 2);

        define('WLOG_NOTHING',   0);
        define('WLOG_DBERROR',   1);
        define('WLOG_ERROR',     2);
        define('WLOG_ACTIONS',   4);
        define('WLOG_DEBUG',     8);

        define('STATUS_ENABLED',     '0');
        define('STATUS_DISABLED',    '1');

        define('USERTYPE_SUPERADMIN',   1);
        define('USERTYPE_ACCOUNT',      2);
        define('USERTYPE_ADMIN',        3);
        define('USERTYPE_USER',         4);
        define('USERTYPE_CUSTOMER',     5);

        define('SETTINGTYPE_GLOBAL',       1);
        define('SETTINGTYPE_SUPERADMIN',   2);
        define('SETTINGTYPE_ACCOUNT',      3);
        define('SETTINGTYPE_ADMIN',        4);
        define('SETTINGTYPE_USER',         5);
        define('SETTINGTYPE_AFF_CAMP',     6);

        define('SETTINGTYPEPREFIX_GLOBAL',       'Glob_');
        define('SETTINGTYPEPREFIX_SUPERADMIN',   'SupA_');
        define('SETTINGTYPEPREFIX_ACCOUNT',      'Aff_');
        define('SETTINGTYPEPREFIX_ADMIN',        'Admn_');
        define('SETTINGTYPEPREFIX_USER',         'User_');
        define('SETTINGTYPEPREFIX_AFF_CAMP',     'Aff_camp_');
        define('SETTINGTYPEPREFIX_LISTVIEW',     'List_view_');

        // Merchant to Affiliates messages
        define('MESSAGETYPE_EMAIL',   1);
        define('MESSAGETYPE_NEWS',    2);
        // SuperAdmin to Merchants messages
        define('SA_MESSAGETYPE_EMAIL',   3);
        define('SA_MESSAGETYPE_NEWS',    4);

        // SuperAdmins Account_ID
        define('SA_ACCOUNT_ID', 'sa_id');

        define('MESSAGESTATUS_NOT_READED',  1);
        define('MESSAGESTATUS_SHOW',        2);
        define('MESSAGESTATUS_NOT_SHOW',    3);

        define('EMAILBY_MAIL',      1);
        define('EMAILBY_SMTP',      2);

        define('MAIL_TEXT',      1);
        define('MAIL_HTML',      2);
        
        define('DOMAIN_MERCHANTS',  1);
        define('DOMAIN_USERS',      2);

        define('SWITCH_TRUE',   1);
        define('SWITCH_FALSE',  0);
        
        // Geo-Targetting
        define('ALLOW_TRAFFIC', 1);
        define('BAN_TRAFFIC', 2);
        define('AC_DEFAULT_DEST', 1);
        define('AC_SIGNUP_FORM', 2);
        define('AC_CUSTOM_DEST', 3);

        define('VERIFICATION_SERVER', '127.0.0.1');
        define('VERIFICATION_SCRIPT', '/projectssvn/spanel/scripts/verify.php?lid=');
        
        // New filters
        define('TIME_PRESET',       1);
        define('TIME_CUSTOM',       2);

        define('TIME_TODAY',        1);
        define('TIME_YESTERDAY',    2);
        define('TIME_LAST7DAYS',    3);
        define('TIME_THISWEEK',     4);
        define('TIME_LASTWEEK',     5);
        define('TIME_LASTWORKWEEK', 6);
        define('TIME_THISMONTH',    7);
        define('TIME_LASTMONTH',    8);
        define('TIME_THISYEAR',     9);
        define('TIME_ALL',          10);
        
        define('TIME_OLDER_THAN_WEEK',       20);
        define('TIME_OLDER_THAN_MONTH',      21);
        define('TIME_OLDER_THAN_TWOMONTH',   22);
        define('TIME_OLDER_THAN_THREEMONTH', 23);
        
        // AffLite accounts
        define('ACCOUNT_TEMP', 0);
        define('ACCOUNT_FREE', 1);
        define('ACCOUNT_LITE', 2);
        
        // AffPlanet payments
        define('PAYMENT_ADDITIONAL_TRAFFIC', 6);
        define('PAYMENT_LITE_ACCOUNT',       7);
        define('PAYMENT_PAID_INTEGRATION',   10);
        
        // Update status
        define('UPDATE_WAITING',    1);
        define('UPDATE_DONE_OK',    2);
        define('UPDATE_DONE_ERROR', 3);
        
        // Jobs
        define("JOB_NEW",      1);
        define("JOB_RUNNING",  2);
        define("JOB_FINISHED", 3);
	
	//----------------------------
	//added by AdAstra
	// Selects transactions by inserted date or approved date
	define("DATE_SELECT_MODE_INSERTED",1);
	define("DATE_SELECT_MODE_APPROVED",2);
	//---------------------------
    }
}
?>
