<?php
QUnit_Global::includeClass('QCore_Settings');

class QCore_EmailTemplates
{
    function getFilledEmailMessage($id, $accountId, $emailcategory, $lang, $params)
    {
        $templateLang = $lang;
        if($templateLang == '')
            $templateLang = $GLOBALS['Auth']->getSetting('Aff_default_lang');

        // check if template in this language exists in templates
        $sql = 'select * from wd_g_emailtemplates where deleted=0 and lang='.myquotes(substr($templateLang, 0, 10)).
               ' and categorycode='.myquotes($emailcategory).' and accountid='._q($accountId);
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if (!$rs)
        {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            QCore_History::DebugMsg(WLOG_DBERROR, 'Template does not exist (emailcategory = '.$emailcategory.')', __FILE__, __LINE__);
            return;
        }

        if($rs->EOF)
        {
            if($lang != $templateLang)
                return false;

            $templateLang = $GLOBALS['Auth']->getSetting('Aff_default_lang');

            // check if template in default language exists in templates
            $sql = 'select * from wd_g_emailtemplates where deleted=0 and lang='.myquotes(substr($templateLang, 0, 10)).
                   ' and categorycode='.myquotes($emailcategory).' and accountid='._q($accountId);
            $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
            if (!$rs)
            {
                QUnit_Messager::setErrorMessage(L_G_DBERROR);
                QCore_History::DebugMsg(WLOG_DBERROR, 'Template in default language does not exist (emailcategory = '.$emailcategory.')', __FILE__, __LINE__);
                return;
            }
        }

        if($rs->EOF) {
            if(!defined('L_G_DEFAULT_TEXT_'.$emailcategory) || !defined('L_G_DEFAULT_SUBJ_'.$emailcategory)) {
                return false;
            }
            $subject = constant('L_G_DEFAULT_SUBJ_'.$emailcategory);
            $text    = constant('L_G_DEFAULT_TEXT_'.$emailcategory);
            $text = str_replace('\n', "\n", $text);
            $text = str_replace('\r', "\r", $text);
        } else {
            $subject = $rs->fields['emailsubject'];
            $text    = $rs->fields['emailtext'];
        }

        return $this->replaceConstatntsInEmailMessage($id, $emailcategory, $subject, $text, $params);
    }

    //--------------------------------------------------------------------------
    // function renames _2ndtier constants to _multitier
    // function is implemented to ensure backward compatibility with pap_2.0
    function renameOldConstants($text) {
        $text = str_replace('$Sales_approved_2ndtier',        '$Sales_approved_multitier',        $text);
        $text = str_replace('$Sales_waitingapproval_2ndtier', '$Sales_waitingapproval_multitier', $text);
        $text = str_replace('$Sales_declined_2ndtier',        '$Sales_declined_multitier',        $text);

        $text = str_replace('$Leads_approved_2ndtier',        '$Leads_approved_multitier',        $text);
        $text = str_replace('$Leads_waitingapproval_2ndtier', '$Leads_waitingapproval_multitier', $text);
        $text = str_replace('$Leads_declined_2ndtier',        '$Leads_declined_multitier',        $text);

        $text = str_replace('$Commissions_approved_2ndtier',        '$Commissions_approved_multitier',        $text);
        $text = str_replace('$Commissions_waitingapproval_2ndtier', '$Commissions_waitingapproval_multitier', $text);
        $text = str_replace('$Commissions_declined_2ndtier',        '$Commissions_declined_multitier',        $text);

        return $text;
    }
    
    //--------------------------------------------------------------------------
    
    function getTextStatus($statusInt) {
        $status = '';
        
        if(!defined('L_G_APPROVED')) setLanguage();
        
        if($statusInt == AFFSTATUS_APPROVED) $status = L_G_APPROVED;
        else if($statusInt == AFFSTATUS_NOTAPPROVED) $status = L_G_WAITINGAPPROVAL;
        else if($statusInt == AFFSTATUS_SUPPRESSED) $status = L_G_SUPPRESSED;
        
        return $status;
    }
    
	//--------------------------------------------------------------------------
    
    function replaceAffiliateConstants($text, $user, $preffix = '$Affiliate_') {
        $text = str_replace($preffix.'id',         $user['userid'], $text);
        $text = str_replace($preffix.'refid',      $user['refid'], $text);
        $text = str_replace($preffix.'name',       $user['name'].' '.$user['surname'], $text);
        $text = str_replace($preffix.'firstname',  $user['name'], $text);
        $text = str_replace($preffix.'lastname',   $user['surname'], $text);
        $text = str_replace($preffix.'username',   $user['username'], $text);
        $text = str_replace($preffix.'password',   $user['rpassword'], $text);
        $text = str_replace($preffix.'status',     $this->getTextStatus($user['rstatus']), $text);
        
        $text = str_replace($preffix.'company',   $user['company'], $text);
        $text = str_replace($preffix.'website',   $user['weburl'], $text);
        $text = str_replace($preffix.'street',    $user['street'], $text);
        $text = str_replace($preffix.'city',      $user['city'], $text);
        $text = str_replace($preffix.'state',     $user['state'], $text);
        $text = str_replace($preffix.'country',   $user['country'], $text);
        $text = str_replace($preffix.'zipcode',   $user['zipcode'], $text);
        $text = str_replace($preffix.'phone',     $user['phone'], $text);
        $text = str_replace($preffix.'fax',       $user['fax'], $text);
        $text = str_replace($preffix.'tax_ssn',   $user['tax_ssn'], $text);
        
        $text = str_replace($preffix.'data1',      $user['data1'], $text);
        $text = str_replace($preffix.'data2',      $user['data2'], $text);
        $text = str_replace($preffix.'data3',      $user['data3'], $text);
        $text = str_replace($preffix.'data4',      $user['data4'], $text);
        $text = str_replace($preffix.'data5',      $user['data5'], $text);
        
        return $text;
    }
    
    //--------------------------------------------------------------------------
    
    function replaceDateTimeConstants($text) {
        $text = str_replace('$Date', date("Y-m-d"), $text);
        $text = str_replace('$Time', date("h:j:s"), $text);
        
        return $text;
    }
    
    //--------------------------------------------------------------------------
    
    function getUserInfo($userid) {
        if ($userid == '')
            return false;
        
        $sql = 'select * from wd_g_users where deleted=0 and userid='._q($userid);
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if (!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            QCore_History::DebugMsg(WLOG_ERROR, 'Error getting user info (user id = '.$userid.')', __FILE__, __LINE__);
            return;
        }

        if($rs->EOF)
            return false;
        
        return $rs->fields;
    }

    //--------------------------------------------------------------------------

    function replaceConstatntsInEmailMessage($id, $emailcategory, $subject, $text, $params) {
        // replace old constants
        $subject = $this->renameOldConstants($subject);
        $text = $this->renameOldConstants($text);

        // replace AccountName
        $globalSettings = QCore_Settings::getGlobalSettings();

        //--------------------------------------
        // replace constants depending on type of email template
        if(in_array($emailcategory, array('AFF_EMAIL_SIGNUP', 'AFF_EMAIL_ONSIGN', 'AFF_EMAIL_FORGOTPAS1', 'AFF_EMAIL_FORGOTPAS2', 'AFF_EMAIL_NTF_SIGNUP', 'AFF_EMAIL_AF_NTF_SGN', 'AFF_EMAIL_AFF_NL_SGN')))
        {
            // get affiliate info
            if (($user = $this->getUserInfo($id)) == false) return false;

            // replace password
            $Affiliate_password = $params['pwd'];
            if($emailcategory == 'AFF_EMAIL_FORGOTPAS1') {
                $subject = str_replace('$Affiliate_verification_code', $Affiliate_password, $subject);
                $text = str_replace('$Affiliate_verification_code', $Affiliate_password, $text);
            } else {
                $subject = str_replace('$Affiliate_password', $Affiliate_password, $subject);
                $text = str_replace('$Affiliate_password', $Affiliate_password, $text);
            }
            
            // replace status
            if(in_array($emailcategory, array('AFF_EMAIL_NTF_SIGNUP', 'AFF_EMAIL_AF_NTF_SGN')))
            {
                $Affiliate_status = $this->getTextStatus($user['rstatus']);
                if (in_array($emailcategory, array('AFF_EMAIL_NTF_SIGNUP'))) {
                    if($user['rstatus'] == AFFSTATUS_NOTAPPROVED) $Affiliate_status = L_G_WAITINGAPPROVAL.' '.L_G_APPROVALWARNING;
                }
                $subject = str_replace('$Affiliate_status', $Affiliate_status, $subject);
                $text = str_replace('$Affiliate_status', $Affiliate_status, $text);
            }

            $subject = $this->replaceDateTimeConstants($subject);
            $text = $this->replaceDateTimeConstants($text);
            
            $subject = $this->replaceAffiliateConstants($subject, $user);
            $text = $this->replaceAffiliateConstants($text, $user);
            
            if (($parentUser = $this->getUserInfo($user['parentuserid'])) != false) {
                $subject = $this->replaceAffiliateConstants($subject, $parentUser, "\$Parent_");
                $text = $this->replaceAffiliateConstants($text, $parentUser, "\$Parent_");
            }
        }
        else if($emailcategory == AFF_EMAIL_NTF_SALE || $emailcategory == AFF_EMAIL_AF_NTF_SLE || $emailcategory == AFF_EMAIL_AF_PAR_SLE)
        {
            // SALE NOTIFICATION
            // get affiliate info
            if (($user = $this->getUserInfo($params['userid'])) == false) return false;
            
            $subject = $this->replaceDateTimeConstants($subject);
            $text = $this->replaceDateTimeConstants($text);
            
            $subject = $this->replaceAffiliateConstants($subject, $user);
            $text = $this->replaceAffiliateConstants($text, $user);
            
            if (($parentUser = $this->getUserInfo($user['parentuserid'])) != false) {
                $subject = $this->replaceAffiliateConstants($subject, $parentUser, "\$Parent_");
                $text = $this->replaceAffiliateConstants($text, $parentUser, "\$Parent_");
            }
            
            switch($params['status']) {
                case AFFSTATUS_APPROVED:
                    $status = L_G_APPROVED; 
                    break;
                case AFFSTATUS_NOTAPPROVED;
                    $status = L_G_PENDING;
                    break;
                case AFFSTATUS_SUPPRESSED;
                    $status = L_G_SUPPRESSED;
                    break;
                default: 
                    $status = L_G_UNKNOWN;
                    break;  
            }

            $subject = str_replace('$Sale_id', $params['id'], $subject);
            $subject = str_replace('$Sale_commission', _rnd($params['commission']), $subject);
            $subject = str_replace('$Sale_totalcost', _rnd($params['totalcost']), $subject);
            $subject = str_replace('$Sale_orderid', $params['orderid'], $subject);
            $subject = str_replace('$Sale_productid', $params['productid'], $subject);
            $subject = str_replace('$Sale_date', $params['date'], $subject);
            $subject = str_replace('$Sale_affiliate', $params['userid'].' - '.$user['name'].' '.$user['surname'], $subject);
            $subject = str_replace('$Sale_status', $status, $subject);
            $subject = str_replace('$Sale_ip', $params['ip'], $subject);
            $subject = str_replace('$Sale_referrer', $params['referrer'], $subject);
            $subject = str_replace('$Sale_data1', $params['data1'], $subject);
            $subject = str_replace('$Sale_data2', $params['data2'], $subject);
            $subject = str_replace('$Sale_data3', $params['data3'], $subject);

            $text = str_replace('$Sale_id', $params['id'], $text);
            $text = str_replace('$Sale_commission', _rnd($params['commission']), $text);
            $text = str_replace('$Sale_totalcost', _rnd($params['totalcost']), $text);
            $text = str_replace('$Sale_orderid', $params['orderid'], $text);
            $text = str_replace('$Sale_productid', $params['productid'], $text);
            $text = str_replace('$Sale_date', $params['date'], $text);
            $text = str_replace('$Sale_affiliate', $params['userid'].' - '.$Affiliate_name, $text);
            $text = str_replace('$Sale_status', $status, $text);
            $text = str_replace('$Sale_ip', $params['ip'], $text);
            $text = str_replace('$Sale_referrer', $params['referrer'], $text);
            $text = str_replace('$Sale_data1', $params['data1'], $text);
            $text = str_replace('$Sale_data2', $params['data2'], $text);
            $text = str_replace('$Sale_data3', $params['data3'], $text);
        }
        else if($emailcategory == AFF_EMAIL_DAILY_REP || $emailcategory == AFF_EMAIL_AF_DL_REP)
        {
             // get affiliate info
            if ($emailcategory == AFF_EMAIL_AF_DL_REP) {
                if ($params['userid'] == '') $params['userid'] = $id;
                
                if (($user = $this->getUserInfo($params['userid'])) == false) return false;
            
             
                $subject = $this->replaceAffiliateConstants($subject, $user);
                $text = $this->replaceAffiliateConstants($text, $user);
            
                if (($parentUser = $this->getUserInfo($user['parentuserid'])) != false) {
                    $subject = $this->replaceAffiliateConstants($subject, $parentUser, "\$Parent_");
                    $text = $this->replaceAffiliateConstants($text, $parentUser, "\$Parent_");
                }
            }
                        
            // subject
            $subject = str_replace('$Date', date("Y-m-d", time() - 3600*24), $subject);
            $subject = str_replace('$Time', date("h:j:s", time() - 3600*24), $subject);
            $subject = str_replace('$Impressions', $params['impressions'], $subject);
            $subject = str_replace('$Clicks', $params['clicks'], $subject);

            $subject = str_replace('$Sales_approved_multitier', $params['st_sales_approved'], $subject);
            $subject = str_replace('$Sales_approved', $params['sales_approved'], $subject);
            $subject = str_replace('$Sales_waitingapproval_multitier', $params['st_sales_waitingapproval'], $subject);
            $subject = str_replace('$Sales_waitingapproval', $params['sales_waitingapproval'], $subject);
            $subject = str_replace('$Sales_declined_multitier', $params['st_sales_declined'], $subject);
            $subject = str_replace('$Sales_declined', $params['sales_declined'], $subject);

            $subject = str_replace('$Leads_approved_multitier', $params['st_leads_approved'], $subject);
            $subject = str_replace('$Leads_approved', $params['leads_approved'], $subject);
            $subject = str_replace('$Leads_waitingapproval_multitier', $params['st_leads_waitingapproval'], $subject);
            $subject = str_replace('$Leads_waitingapproval', $params['leads_waitingapproval'], $subject);
            $subject = str_replace('$Leads_declined_multitier', $params['st_leads_declined'], $subject);
            $subject = str_replace('$Leads_declined', $params['leads_declined'], $subject);

            $subject = str_replace('$Commissions_approved_multitier', _rnd($params['st_revenue_approved']), $subject);
            $subject = str_replace('$Commissions_approved', _rnd($params['revenue_approved']), $subject);
            $subject = str_replace('$Commissions_waitingapproval_multitier', _rnd($params['st_revenue_waitingapproval']), $subject);
            $subject = str_replace('$Commissions_waitingapproval', _rnd($params['revenue_waitingapproval']), $subject);
            $subject = str_replace('$Commissions_declined_multitier', _rnd($params['st_revenue_declined']), $subject);
            $subject = str_replace('$Commissions_declined', _rnd($params['revenue_declined']), $subject);
            $subject = str_replace('$Sales_list', $params['sales_list'], $subject);
            $subject = str_replace('$Leads_list', $params['leads_list'], $subject);
            $subject = str_replace('$Sales_list_approved', $params['sales_list_approved'], $subject);
            $subject = str_replace('$Leads_list_approved', $params['leads_list_approved'], $subject);
            
            // text
            $text = str_replace('$Date', date("Y-m-d", time() - 3600*24), $text);
            $text = str_replace('$Time', date("h:j:s", time() - 3600*24), $text);
            $text = str_replace('$Impressions', $params['impressions'], $text);
            $text = str_replace('$Clicks', $params['clicks'], $text);

            $text = str_replace('$Sales_approved_multitier', $params['st_sales_approved'], $text);
            $text = str_replace('$Sales_approved', $params['sales_approved'], $text);
            $text = str_replace('$Sales_waitingapproval_multitier', $params['st_sales_waitingapproval'], $text);
            $text = str_replace('$Sales_waitingapproval', $params['sales_waitingapproval'], $text);
            $text = str_replace('$Sales_declined_multitier', $params['st_sales_declined'], $text);
            $text = str_replace('$Sales_declined', $params['sales_declined'], $text);

            $text = str_replace('$Leads_approved_multitier', $params['st_leads_approved'], $text);
            $text = str_replace('$Leads_approved', $params['leads_approved'], $text);
            $text = str_replace('$Leads_waitingapproval_multitier', $params['st_leads_waitingapproval'], $text);
            $text = str_replace('$Leads_waitingapproval', $params['leads_waitingapproval'], $text);
            $text = str_replace('$Leads_declined_multitier', $params['st_leads_declined'], $text);
            $text = str_replace('$Leads_declined', $params['leads_declined'], $text);

            $text = str_replace('$Commissions_approved_multitier', _rnd($params['st_revenue_approved']), $text);
            $text = str_replace('$Commissions_approved', _rnd($params['revenue_approved']), $text);
            $text = str_replace('$Commissions_waitingapproval_multitier', _rnd($params['st_revenue_waitingapproval']), $text);
            $text = str_replace('$Commissions_waitingapproval', _rnd($params['revenue_waitingapproval']), $text);
            $text = str_replace('$Commissions_declined_multitier', _rnd($params['st_revenue_declined']), $text);
            $text = str_replace('$Commissions_declined', _rnd($params['revenue_declined']), $text);
            $text = str_replace('$Sales_list', $params['sales_list'], $text);
            $text = str_replace('$Leads_list', $params['leads_list'], $text);
            $text = str_replace('$Sales_list_approved', $params['sales_list_approved'], $text);
            $text = str_replace('$Leads_list_approved', $params['leads_list_approved'], $text); 
            
        }
        else if($emailcategory == AFF_EMAIL_MONTH_REP || $emailcategory == AFF_EMAIL_AF_ML_REP ||
                $emailcategory == AFF_EMAIL_WE_REP || $emailcategory == AFF_EMAIL_AF_WE_REP)
        {
            $subject = $this->replaceDateTimeConstants($subject);
            $text = $this->replaceDateTimeConstants($text);
            
            // get affiliate info
            if ($emailcategory == AFF_EMAIL_AF_ML_REP || $emailcategory == AFF_EMAIL_AF_WE_REP) {
                if ($params['userid'] == '') $params['userid'] = $id;
                
                if (($user = $this->getUserInfo($params['userid'])) == false) return false;
                
                $subject = $this->replaceAffiliateConstants($subject, $user);
                $text = $this->replaceAffiliateConstants($text, $user);
            
                if (($parentUser = $this->getUserInfo($user['parentuserid'])) != false) {
                    $subject = $this->replaceAffiliateConstants($subject, $parentUser, "\$Parent_");
                    $text = $this->replaceAffiliateConstants($text, $parentUser, "\$Parent_");
                }
            } 
            
            // subject            
            $subject = str_replace('$Month', date("F", mktime(0,0,0,date("m")-1, date("d"), date("Y"))), $subject);
            $subject = str_replace('$Year', date("Y", mktime(0,0,0,date("m")-1, date("d"), date("Y"))), $subject);
            
            $subject = str_replace('$Week_start', date("Y-m-d", $params['timestamp_begin']), $subject);
            $subject = str_replace('$Week_end',   date("Y-m-d", $params['timestamp_end']),   $subject);
            
            $subject = str_replace('$Impressions', $params['impressions'], $subject);
            $subject = str_replace('$Clicks', $params['clicks'], $subject);

            $subject = str_replace('$Sales_approved_multitier', $params['st_sales_approved'], $subject);
            $subject = str_replace('$Sales_approved', $params['sales_approved'], $subject);
            $subject = str_replace('$Sales_waitingapproval_multitier', $params['st_sales_waitingapproval'], $subject);
            $subject = str_replace('$Sales_waitingapproval', $params['sales_waitingapproval'], $subject);
            $subject = str_replace('$Sales_declined_multitier', $params['st_sales_declined'], $subject);
            $subject = str_replace('$Sales_declined', $params['sales_declined'], $subject);

            $subject = str_replace('$Leads_approved_multitier', $params['st_leads_approved'], $subject);
            $subject = str_replace('$Leads_approved', $params['leads_approved'], $subject);
            $subject = str_replace('$Leads_waitingapproval_multitier', $params['st_leads_waitingapproval'], $subject);
            $subject = str_replace('$Leads_waitingapproval', $params['leads_waitingapproval'], $subject);
            $subject = str_replace('$Leads_declined_multitier', $params['st_leads_declined'], $subject);
            $subject = str_replace('$Leads_declined', $params['leads_declined'], $subject);

            $subject = str_replace('$Commissions_approved_multitier', _rnd($params['st_revenue_approved']), $subject);
            $subject = str_replace('$Commissions_approved', _rnd($params['revenue_approved']), $subject);
            $subject = str_replace('$Commissions_waitingapproval_multitier', _rnd($params['st_revenue_waitingapproval']), $subject);
            $subject = str_replace('$Commissions_waitingapproval', _rnd($params['revenue_waitingapproval']), $subject);
            $subject = str_replace('$Commissions_declined_multitier', _rnd($params['st_revenue_declined']), $subject);
            $subject = str_replace('$Commissions_declined', _rnd($params['revenue_declined']), $subject);
            $subject = str_replace('$Sales_list', $params['sales_list'], $subject);
            $subject = str_replace('$Leads_list', $params['leads_list'], $subject);
            $subject = str_replace('$Sales_list_approved', $params['sales_list_approved'], $subject);
            $subject = str_replace('$Leads_list_approved', $params['leads_list_approved'], $subject);

            // text
            
            $text = str_replace('$Month', date("F", mktime(0,0,0,date("m")-1, date("d"), date("Y"))), $text);
            $text = str_replace('$Year', date("Y", mktime(0,0,0,date("m")-1, date("d"), date("Y"))), $text);
            
            $text = str_replace('$Week_start', date("Y-m-d", $params['timestamp_begin']), $text);
            $text = str_replace('$Week_end',   date("Y-m-d", $params['timestamp_end']),   $text);
            
            $text = str_replace('$Impressions', $params['impressions'], $text);
            $text = str_replace('$Clicks', $params['clicks'], $text);

            $text = str_replace('$Sales_approved_multitier', $params['st_sales_approved'], $text);
            $text = str_replace('$Sales_approved', $params['sales_approved'], $text);
            $text = str_replace('$Sales_waitingapproval_multitier', $params['st_sales_waitingapproval'], $text);
            $text = str_replace('$Sales_waitingapproval', $params['sales_waitingapproval'], $text);
            $text = str_replace('$Sales_declined_multitier', $params['st_sales_declined'], $text);
            $text = str_replace('$Sales_declined', $params['sales_declined'], $text);

            $text = str_replace('$Leads_approved_multitier', $params['st_leads_approved'], $text);
            $text = str_replace('$Leads_approved', $params['leads_approved'], $text);
            $text = str_replace('$Leads_waitingapproval_multitier', $params['st_leads_waitingapproval'], $text);
            $text = str_replace('$Leads_waitingapproval', $params['leads_waitingapproval'], $text);
            $text = str_replace('$Leads_declined_multitier', $params['st_leads_declined'], $text);
            $text = str_replace('$Leads_declined', $params['leads_declined'], $text);

            $text = str_replace('$Commissions_approved_multitier', _rnd($params['st_revenue_approved']), $text);
            $text = str_replace('$Commissions_approved', _rnd($params['revenue_approved']), $text);
            $text = str_replace('$Commissions_waitingapproval_multitier', _rnd($params['st_revenue_waitingapproval']), $text);
            $text = str_replace('$Commissions_waitingapproval', _rnd($params['revenue_waitingapproval']), $text);
            $text = str_replace('$Commissions_declined_multitier', _rnd($params['st_revenue_declined']), $text);
            $text = str_replace('$Commissions_declined', _rnd($params['revenue_declined']), $text);
            $text = str_replace('$Sales_list', $params['sales_list'], $text);
            $text = str_replace('$Leads_list', $params['leads_list'], $text);
            $text = str_replace('$Sales_list_approved', $params['sales_list_approved'], $text);
            $text = str_replace('$Leads_list_approved', $params['leads_list_approved'], $text); 
        }
        else if($emailcategory == AFF_EMAIL_NOTIFY_RC)
        {
            $subject = $this->replaceDateTimeConstants($subject);
            $text = $this->replaceDateTimeConstants($text);
            
            if (($user = $this->getUserInfo($params['userid'])) == false) return false;
             
            $subject = $this->replaceAffiliateConstants($subject, $user);
            $text = $this->replaceAffiliateConstants($text, $user);
            
            if (($parentUser = $this->getUserInfo($user['parentuserid'])) != false) {
                $subject = $this->replaceAffiliateConstants($subject, $parentUser, "\$Parent_");
                $text = $this->replaceAffiliateConstants($text, $parentUser, "\$Parent_");
            }
            
            $subject = str_replace('$Rc_id', $params['id'], $subject);
            $subject = str_replace('$Rc_commission', $params['commission'], $subject);
            $subject = str_replace('$Rc_orderid', $params['orderid'], $subject);
            $subject = str_replace('$Rc_affiliate', $Affiliate_name, $subject);
            $subject = str_replace('$Rc_status', $status, $subject);
            $subject = str_replace('$Rc_recurringcommissionid', $params['recurringcommid'], $subject);

            $text = str_replace('$Rc_id', $params['id'], $text);
            $text = str_replace('$Rc_commission', _rnd($params['commission']), $text);
            $text = str_replace('$Rc_orderid', $params['orderid'], $text);
            $text = str_replace('$Rc_affiliate', $Affiliate_name, $text);
            $text = str_replace('$Rc_status', $status, $text);
            $text = str_replace('$Rc_recurringcommissionid', $params['recurringcommid'], $text);
        }
        else if($emailcategory == AFF_EMAIL_AFF_CAMP_A)
        {
            $subject = $this->replaceDateTimeConstants($subject);
            $text = $this->replaceDateTimeConstants($text);
            
            if (($user = $this->getUserInfo($id)) == false) return false;
            
            $subject = $this->replaceAffiliateConstants($subject, $user);
            $text = $this->replaceAffiliateConstants($text, $user);
            
            if (($parentUser = $this->getUserInfo($user['parentuserid'])) != false) {
                $subject = $this->replaceAffiliateConstants($subject, $parentUser, "\$Parent_");
                $text = $this->replaceAffiliateConstants($text, $parentUser, "\$Parent_");
            }

            $subject = str_replace('$camp_name', $params['camp_name'], $subject);

            $text = str_replace('$camp_name', $params['camp_name'], $text);
        }
        else if($emailcategory == AFF_EMAIL_CONTACT_US)
        {   
            $subject = $this->replaceDateTimeConstants($subject);
            $text = $this->replaceDateTimeConstants($text);
            
            if (($user = $this->getUserInfo($params['UserID'])) == false) return false;
             
            $subject = $this->replaceAffiliateConstants($subject, $user);
            $text = $this->replaceAffiliateConstants($text, $user);
            
            if (($parentUser = $this->getUserInfo($user['parentuserid'])) != false) {
                $subject = $this->replaceAffiliateConstants($subject, $parentUser, "\$Parent_");
                $text = $this->replaceAffiliateConstants($text, $parentUser, "\$Parent_");
            }
           
            $subject = str_replace('$Affiliate_emailsubject', $params['title'], $subject);
            $subject = str_replace('$Affiliate_emailtext', $params['body'], $subject);
           
            $text = str_replace('$Affiliate_emailsubject', $params['title'], $text);
            $text = str_replace('$Affiliate_emailtext', $params['body'], $text);
        }

        $data = array();
        $data['subject'] = $subject;
        $data['text'] = $text;

        return $data;
    }
}
?>
