<?php
/**
 * Class handles displaying of history information as well as adding new history records.  
 */
 
class QCore_History
{
    /**
    * function writes history record into DB. 
    */  
    function writeHistory($type, $text, $file, $line, $userType = '', $userid = '')
    {
        $Auth_exist = is_object($GLOBALS['Auth']);
        
        //if($Auth_exist)
        {
            //$logLevel = $GLOBALS['Auth']->getSetting('Aff_log_level');

            //if(!((int)$type & (int)$logLevel))
            {
            //    return false;
            }
        }

        $historyid = QCore_Sql_DBUnit::createUniqueID('wd_g_history', 'historyid');

        $sql = "insert into wd_g_history(".
                            " historyid,".
                            " rtype,";
        if($Auth_exist)
            $sql .= " accountid,";
        $sql .=             " value,".
                            " dateinserted,".
                            " hfile,".
                            " line,".
                            " ip)".
                            " values (".
                            _q($historyid).", ".
                            _q($type).",";
        if($Auth_exist)
            $sql .= _qOrNull($GLOBALS['Auth']->getAccountID()).",";
        $sql .=             _q($text).",".
                            sqlNow().",".
                            _q($file).",".
                            _q($line).",".
                            _q($_SERVER['REMOTE_ADDR']).")";
                          
        $ret = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$ret) {
            return false;
        }
        
        return true;
    }
    
    //------------------------------------------------------------------------
    
    function DebugMsg($logType,$log_msg,$file='',$line='',$userType='',$userID='')
    {
        $errorMsg = '';

        if($userID == '' && is_object($GLOBALS['Auth']))
        {
            $method = 'getUserID';

            if( method_exists($GLOBALS['Auth'], $method) )
            {
                $userID = $GLOBALS['Auth']->getUserID();
            }
            else
            {
                $errorMsg .= L_G_METHOD.' '.$method.' '.L_G_NOT_REACHABLE.'. ';
            }
        }

        if($userID == '')
        {
            $errorMsg .= L_G_CANNOT_GET_USERID.'. ';
        }


        if($userType == '' && is_object($GLOBALS['Auth']))
        {
            $method = 'getUserType';

            if( method_exists($GLOBALS['Auth'], $method) )
            {
                $userType = $GLOBALS['Auth']->getUserType();
            }
            else
            {
                $errorMsg .= L_G_METHOD.' '.$method.' '.L_G_NOT_REACHABLE.'. ';
            }
        }

        if($userType == '')
        {
            $errorMsg .= L_G_CANNOT_GET_USERTYPE.'. ';
        }

    
        if($log_msg == '')
        {
            $errorMsg .= L_G_LOG_MESSAGE_NOT_SPECIFIED.'. ';
        }
        
        if( is_object($GLOBALS['Auth']) )
        {
            if($userType == USERTYPE_ADMIN || $userType == USERTYPE_USER) {
                $log_level = (int)$GLOBALS['Auth']->settings['Aff_log_level'];
            } else if($userType == USERTYPE_SUPERADMIN) {
                $log_level = (int)$GLOBALS['Auth']->settings['Glob_log_level'];
            }
        }

        if($log_level == '' || !is_int($log_level) || (int)$log_level < 0)
        {
            $errorMsg .= L_G_LOG_LEVEL.' '.L_G_NOT_REACHABLE.'. ';
        }

        if(((int)$log_level & (int)$logType) == (int)$logType)
        {
            if(QCore_History::writeHistory($logType, $log_msg, $file, $line, $userType, $userID))
                return true;
            else return false;
        }
        /*else if($userID == '' ||  $userType == '')
        {
            if(QCore_History::writeHistory($logType, $log_msg, $file, $line)) return true;
            else return false;
        }*/
    }
    
    //------------------------------------------------------------------------
    
    function logWithCondition($condition, $logLevel, $message, $file, $line, $userType = '') {
        if($condition) {
            return QCore_History::log($logLevel, $message, $file, $line, $userType);
        }
        
        return false;
    }

    //------------------------------------------------------------------------
    
    function log($logLevel, $message, $file, $line, $userType = '') {
        if($message == '') {
            return false;
        }
        
        $accountID = '';
        if(is_object($GLOBALS['Auth'])) {
            $accountID = $GLOBALS['Auth']->getAccountID();
        }
        
        // get user type
        if($userType == '' && is_object($GLOBALS['Auth'])) {
            $method = 'getUserType';
            
            if( method_exists($GLOBALS['Auth'], $method) ) {
                $userType = $GLOBALS['Auth']->getUserType();
            }
            
            if($userType == '') {
                //dbg("User type cannot be determined, set to topmost. [$message, $file, $line]");
                
                if(defined('AFF_PROGRAM_TYPE') && AFF_PROGRAM_TYPE == PROG_TYPE_PRO && $accountID != '') {
                    $userType = USERTYPE_ACCOUNT;
                } else {
                    $userType = USERTYPE_SUPERADMIN;
                    $accountID = '';
                }
            }
        }

        // get log level
        if( is_object($GLOBALS['Auth']) ) {
            if($userType == USERTYPE_ADMIN || $userType == USERTYPE_USER || $userType == USERTYPE_ACCOUNT) {
                $systemLogLevel = (int)$GLOBALS['Auth']->settings['Aff_log_level'];
            } else if($userType == USERTYPE_SUPERADMIN) {
                $systemLogLevel = (int)$GLOBALS['Auth']->settings['Glob_log_level'];
            }
        }
        
        if($systemLogLevel == '' || !is_int($systemLogLevel) || (int)$systemLogLevel < 0) {
            //dbg("Log level cannot be determined, set to all. [$message, $file, $line]");
            $systemLogLevel = WLOG_DBERROR | WLOG_ERROR | WLOG_ACTIONS | WLOG_DEBUG;
        }
        
        if(((int)$logLevel & (int)$systemLogLevel) > 0) {
            $params = array();
            $params['accountID'] = $accountID;
            $params['type'] = $logLevel;
            $params['text'] = $message;
            $params['file'] = $file;
            $params['line'] = $line;
            
            if(QCore_History::_insert($params)) {
                return true;
            } else {
                return false;
            }
        }
        
        return true;
    }
    
    //------------------------------------------------------------------------
    
    function _insert($params) {
        $historyID = QCore_Sql_DBUnit::createUniqueID('wd_g_history', 'historyid');

        $sql = "insert into wd_g_history(".
                            " historyid,".
                            " rtype,";
                            
        if($params['accountID'] != '') {
            $sql .= " accountid,";
        }
        
        $sql .=             " value,".
                            " dateinserted,".
                            " hfile,".
                            " line,".
                            " ip)".
                            " values (".
                            _q($historyID).", ".
                            _q($params['type']).",";
                            
        if($params['accountID'] != '') {
            $sql .= _q($params['accountID']).",";
        }
                            
        $sql .=             _q($params['text']).",".
                            sqlNow().",".
                            _q($params['file']).",".
                            _q($params['line']).",".
                            _q($_SERVER['REMOTE_ADDR']).")";
                         
        $ret = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$ret) {
            return false;
        }
        
        return true;
    }
}
?>
