<?php
/**
 * Class handles displaying of log information as well as adding new log records.  
 */
 
class QCore_Logs
{
    
    //--------------------------------------------------------------------------
    
    function QCore_Logs() {
    }
    
    //--------------------------------------------------------------------------
    
    function &getInstance() {
        static $instance;
        if (is_object($instance)) {
            return $instance;
        }
        return new QCore_Logs();
    }
    
    //--------------------------------------------------------------------------
    
    function writeLog($code, $text)
    {
        $Auth_exist = is_object($GLOBALS['Auth']);

        $logid = QCore_Sql_DBUnit::createUniqueID('wd_g_logs', 'logid');

        $sql = "insert into wd_g_logs(".
                            " logid,";
        if($Auth_exist)
            $sql .= " accountid,";
        $sql .=             " code,".
                            " value,".
                            " dateinserted)".
                            " values (".
                            _q($logid).", ";
        if($Auth_exist)
            $sql .= _qOrNull($GLOBALS['Auth']->getAccountID()).",";
        $sql .=             _q($code).",".
                            _q($text).",".
                            sqlNow().")";
                          
        $ret = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$ret) {
            return false;
        }
        
        return true;
    }
    
    //--------------------------------------------------------------------------
    
    function writeMonthlyTrafficLog($params)
    {
        $msg = array(date("Y"),
                     date("n"), 
                     $params['transMonth'],
                     $params['transBonus'],
                     $params['transBought'],
                     $params['accountType'],
                     $params['trafficLevel'],
                     $params['limitSoft'],
                     $params['limitHard']
                     );
        return $this->writeLog('Monthly_traffic_log', implode('_', $msg));
    }
    
}
?>
