<?php
QUnit_Global::includeClass('QCore_Sql_Table');

class QCore_Sql_Table_AccountsSettings extends QCore_Sql_Table {

    function QCore_Sql_Table_AccountsSettings() {
        $this->addColumn('company_name', WD_PATTERN_DEFAULT, false);
        $this->setCaption('company_name', L_G_COMPANYNAME);
        $this->addColumn('weburl', WD_PATTERN_DEFAULT, false);
        $this->setCaption('weburl', L_G_WEBURL);
        $this->addColumn('street', WD_PATTERN_DEFAULT, false);
        $this->setCaption('street', L_G_STREET);
        $this->addColumn('city', WD_PATTERN_DEFAULT, false);
        $this->setCaption('city', L_G_CITY);
        $this->addColumn('state', WD_PATTERN_DEFAULT, false);
        $this->setCaption('state', L_G_STATE);
        $this->addColumn('country', WD_PATTERN_DEFAULT, false);
        $this->setCaption('country', L_G_COUNTRY);
        $this->addColumn('zipcode', WD_PATTERN_DEFAULT, false);
        $this->setCaption('zipcode', L_G_ZIPCODE);
        $this->addColumn('phone', WD_PATTERN_DEFAULT, false);
        $this->setCaption('phone', L_G_PHONE);
        $this->addColumn('fax', WD_PATTERN_DEFAULT, false);
        $this->setCaption('fax', L_G_FAX);
        $this->addColumn('tax_ssn', WD_PATTERN_DEFAULT, false);
        $this->setCaption('tax_ssn', L_G_TAXSSN);
        $this->addColumn('data1', WD_PATTERN_DEFAULT, false);
        $this->addColumn('data2', WD_PATTERN_DEFAULT, false);
        $this->addColumn('data3', WD_PATTERN_DEFAULT, false);
        $this->addColumn('data4', WD_PATTERN_DEFAULT, false);
        $this->addColumn('data5', WD_PATTERN_DEFAULT, false);
    }
        
    function saveSettings($accountId, $prefix = '') {        
        foreach($this->getColumns() as $col => $value) {
            if($this->isFilled($col) != false) {
                if(!QCore_Settings::_update($prefix.$col, $this->getColumn($col), SETTINGTYPE_ACCOUNT, $accountId)) {
                    return false;
                }
            }
        }        
        return true;      
    }    
    
}
?>
