<?php
class QUnit_GlobalFuncs
{
    /** combines directory and file to full path, also inserts last slash after directory
    * if it is missing
    */
    function makePath($dir, $file)
    {
        if($dir == '' || $file == '')
        {
            return $dir.$file;
        }

        // check that dir ends with / or \ slash
        $lastChar = $dir[strlen($dir)-1];

        if($lastChar != '\\' && $lastChar != '/')
        {
            return $dir.'/'.$file;
        }
        else
        {
            return $dir.$file;
        }
    }
}

//----------------------------------------------------------------------------

function dbConnect()
{
    $db = ADONewConnection(DB_TYPE);
    $ret = $db->Connect(DB_HOSTNAME,DB_USERNAME,DB_PASSWORD,DB_DATABASE);
    if(!$ret || !$db)
    {
        echo "Error connecting database!";
        exit;
    }

    $db->SetFetchMode(ADODB_FETCH_BOTH);
    $GLOBALS['db'] = $db;
    $GLOBALS['db']->Execute("SET NAMES 'utf8'");
    $GLOBALS['dbrequests'] = 1;
}

//----------------------------------------------------------------------------

function csvFormat($str)
{
    //  if(strpos($str, ' ') == false)
    //    return $str;
    //  else
    return "'".addslashes($str)."'";
}

//----------------------------------------------------------------------------

function utf2ascii($str)
{
    $s2 = preg_replace('/[^a-zA-Z\'\;\-\ ]/', '', $str);
    return (string) $s2;
    $str2 = '';

    for($i=0; $i<strlen($str); $i++)
    {
        if(ord($str[$i])>190)
        continue;

        if($i>0 && ord($str[$i-1])>190)
        $str2 .= '?';
        else
        $str2 .= $str[$i];
    }

    return $str2;
}

//----------------------------------------------------------------------------

function showPopupHelp($helpID)
{
//    echo "<a href=index_popup.php?md=QUnit_Help_Help&hid=$helpID target=helpwnd width=300 height=300><img src='".QUnit_UI_TemplatePage::getImage('help.gif')."' border=0></a>";
    echo "<a href='javascript:showPopupHelp(\"".$helpID."\")'><img src='".QUnit_UI_TemplatePage::getImage('help.gif')."' border=0></a>";
}

//----------------------------------------------------------------------------

define('QUICK_HELP_TIMEOUT', 500);

function initQuickHelp() {
    ?>
    <div id="toolTipLayer" style="position:absolute; z-index: 5000;visibility:hidden;" class="InfoTooltipPopup TooltipPopup" onmouseover="javascript:hideToolTip=false;" onmouseout="javascript:hideToolTip=true; setTimeout('toolTip()', <?php echo QUICK_HELP_TIMEOUT?>);">
    <div class="popupContent">
    <div class="TooltipBottomRight">
        <!-- tooltip_popup -->
        <div class="TooltipArrow">&nbsp;</div>
        <div class="TooltipPopupTopLeft"><div class="TooltipPopupTopRight"><div class="TooltipPopupTop">&nbsp;</div></div></div>
        <div class="TooltipPopupLeft"><div class="TooltipPopupRight"><div class="TooltipPopupContent">
            <div class="TooltipTitle">
                <div class="MessageWindowButtonClose" onclick="javascript:toolTipHide();" title="close"></div>
                <h3><?php echo L_G_DETAILS; ?></h3>
            </div>
            <div id="toolTipLayerContent">&nbsp;</div>
        </div></div></div>
        <div class="TooltipPopupBottomLeft"><div class="TooltipPopupBottomRight"><div class="TooltipPopupBottom">&nbsp;</div></div></div>
    </div>
    </div>
    </div>
    <iframe id="DivShim" src="javascript:false;" scrolling="no" frameborder="0" style="position:absolute; top:0px; left:0px; display:none;"></iframe>
    <script type="text/javascript">initToolTips();</script>
    <?php
}

//----------------------------------------------------------------------------

function showQuickHelp($msg, $width=250) {
?>
    <a href="javascript:;" onClick="javascript:hideToolTip=false; toolTip(event, '<?php echo str_replace("'", "\'", $msg)?>', '1', WIDTH,'<?php echo $width?>')"
        onmouseout="javascript:hideToolTip=true; setTimeout('toolTip()', <?php echo QUICK_HELP_TIMEOUT?>);"
        class="helplink" title="<?php echo L_G_CLICKTOVIEWHELP?>">[?]</a>
<?php
}

//----------------------------------------------------------------------------

function showQuickInfo($msg, $width=250) {
?>
    <a href="javascript:;" onClick="javascript:hideToolTip=false; toolTip(event, '<?php echo str_replace("'", "\'", $msg)?>', '2', WIDTH,'<?php echo $width?>')"
        onmouseout="javascript:hideToolTip=true; setTimeout('toolTip()', <?php echo QUICK_HELP_TIMEOUT?>);"
        class="helplink" title="<?php echo L_G_CLICK2SHOWDETAILS; ?>">[i]</a>
<?php
}

function getQuickInfo($msg, $width=250) {
    $s = '<div class="MessageWindowIcon" title="%s" onclick="%s" onmouseout="%s"></div>';
    return sprintf($s,
        L_G_CLICK2SHOWDETAILS,
        'javascript:hideToolTip=false; toolTip(event,\''.str_replace("'", "\'", $msg).'\',\'2\',WIDTH,'.$width.');',
        'javascript:hideToolTip=true;setTimeout(\'toolTip()\', '.QUICK_HELP_TIMEOUT.');"'
    );
}

function getQuickDetails($msg, $width=250) {
    $s = '<div class="MessageWindowIcon" title="%s" onclick="%s" onmouseout="%s"></div>';
    return sprintf($s,
        L_G_CLICK2SHOWDETAILS,
        'javascript:hideToolTip=false; toolTip(event,\''.str_replace("'", "\'", $msg).'\',\'4\',WIDTH,'.$width.');',
        'javascript:hideToolTip=true;setTimeout(\'toolTip()\', '.QUICK_HELP_TIMEOUT.');"'
    );
}

//----------------------------------------------------------------------------

function showQuickDetails($contenturl, $width=250) {
    $contenturl .= (strpos($contenturl, "?") == false) ? '?'.SID : '&'.SID;
?>
    <div class="MessageWindowIcon" onClick="javascript:hideToolTip=false; toolTip(event, '<?php echo str_replace("'", "\'", $contenturl)?>', '4', WIDTH,'<?php echo $width?>')"
        onmouseout="javascript:hideToolTip=true; setTimeout('toolTip()', <?php echo QUICK_HELP_TIMEOUT?>);"
        title="<?php echo L_G_CLICK2SHOWDETAILS; ?>"></div>
<?php
}

//----------------------------------------------------------------------------

function showLoadedDataDiv($url, $refreshLink = false, $forceRefresh = false) {
    $divID = uniqid("div_");
?>
	<div>
    	<div id="<?php echo $divID?>"><?php echo L_G_LOADING?></div>
    <?php if ($refreshLink) { ?>
    	<a align="right" href="javascript: document.getElementById('<?php echo $divID?>').innerHTML = '<?php echo L_G_LOADING?>'; loadDataForWindow('<?php echo $url."&refresh=1"?>', '<?php echo $divID?>');"><?php echo L_G_REFRESH?></a>
    <?php } ?>
    </div>
    <script language="javascript"> loadDataForWindow('<?php echo $url.($forceRefresh ? "&refresh=1" : "")?>', '<?php echo $divID?>'); </script>
<?php
}

//----------------------------------------------------------------------------

function showHelp($helpID, $force = false)
{
    switch($GLOBALS['Auth']->userType)
    {
        case USERTYPE_ADMIN:      $prefix = SETTINGTYPEPREFIX_ACCOUNT; break;
        case USERTYPE_SUPERADMIN: $prefix = SETTINGTYPEPREFIX_GLOBAL; break;
        case USERTYPE_USER:       $prefix = SETTINGTYPEPREFIX_ACCOUNT; break;
        default: $prefix = ''; break;
    }

    if(!$force)
    {
        if($GLOBALS['Auth']->getSetting($prefix.'show_minihelp') != 1)
        return;
    }
    ?>
    <table border=0 width=100% cellspacing=0 cellpadding=0>
    <tr>
    <td class=minihelp align=left valign=top>
        <?php echo (defined($helpID) ? constant($helpID) : $helpID)?>
    </td>
    </tr>
    </table>
    <?php
}

//----------------------------------------------------------------------------
function PrepareSqlParameter($param, $fieldname, $checktype, $arr = '') {
    $rparam = preg_replace('/[\'\"]/', '', $param);
    checkCorrectness($param, $rparam, $fieldname, $checktype, $arr);
    return($rparam);
}

//----------------------------------------------------------------------------

define('CHECK_EMPTY', 1);
define('CHECK_ALLOWED', 2);
define('CHECK_EMPTYALLOWED', 3);
define('CHECK_NUMBER', 4);
define('CHECK_INARRAY', 8);

//----------------------------------------------------------------------------

function checkCorrectness($postfield, $protectedfield, $fieldname, $checktype, $arr = '')
{
    $isBlank = false;
    if(($checktype & CHECK_EMPTY) == CHECK_EMPTY)
    {
        if($postfield == '')
        {
            $isBlank = true;
            QUnit_Messager::setErrorMessage($fieldname.' '.L_G_EMPTY);
        }
    }

    if(($checktype & CHECK_ALLOWED) == CHECK_ALLOWED)
    {
        if($postfield != $protectedfield)
        {
            if(!$isBlank) {
                QUnit_Messager::setErrorMessage($fieldname.' '.L_G_UNALLOWED);
            }
        }
    }

    if(($checktype & CHECK_NUMBER) == CHECK_NUMBER)
    {
        if($postfield != '' && !is_numeric($postfield))
        {
            if(QUnit_Messager::getErrorMessage() == '')
            QUnit_Messager::setErrorMessage($fieldname.' '.L_G_NOTNUMBER);
        }
    }

    if(($checktype & CHECK_INARRAY) == CHECK_INARRAY && $arr != '' && is_array($arr))
    {
        if(!in_array($postfield, $arr))
        {
            if(QUnit_Messager::getErrorMessage() == '')
            QUnit_Messager::setErrorMessage($fieldname.' '.L_G_NOTALLOWED);
        }
    }
}

//----------------------------------------------------------------------------

function &class_new($class)
{
    return new $class;
}

//----------------------------------------------------------------------------

function begin_auth()
{
    session_start();

    $GLOBALS['Auth'] = QUnit_Global::newObj(AUTH_CLASS);
    $GLOBALS['Auth']->getFromSession();
}

//----------------------------------------------------------------------------

function begin_loadsettings()
{
    if($GLOBALS['Auth']->settings == false || (is_array($GLOBALS['Auth']->settings) && count($GLOBALS['Auth']->settings) <1)) {
        $GLOBALS['Auth']->loadSettings();
    }
}

//----------------------------------------------------------------------------

function begin_page()
{
    $GLOBALS['Auth'] = QUnit_Global::newObj(AUTH_CLASS);
    $GLOBALS['Auth']->getFromSession();

    if($GLOBALS['Auth']->settings == false || (is_array($GLOBALS['Auth']->settings) && count($GLOBALS['Auth']->settings) <1)) {
        $GLOBALS['Auth']->loadSettings();
    }
}

//----------------------------------------------------------------------------

function end_page()
{
    $_SESSION[SESSION_PREFIX.'Auth'] = serialize($GLOBALS['Auth']);
}

//----------------------------------------------------------------------------

function check_security($rights = '')
{
    if(!$GLOBALS['Auth']->isLogged()) {
        $GLOBALS['Auth']->showLoginPage();
    }
    if(!$GLOBALS['Auth']->hasRights($rights)) {
        $GLOBALS['Auth']->showNoRightsPage();
    }
}

//----------------------------------------------------------------------------

function showMsg($str, $type = 'error')
{
    echo "<center><span class='$type'>$str</span></center><br>";
}

//----------------------------------------------------------------------------

function showMsgNoBR($str, $type = 'error')
{
    echo "<span class='$type'>$str</span>";
}

//============================================================================
// function will redirects to the new page
//============================================================================
function Redirect($url, $time = 0)
{
    echo "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"$time;URL=$url\">";

    echo "<br><center><span class=redirecttext>".L_G_WAITTRANSFER."</a><br><br><a class=redirectlink href=$url>".L_G_TRANSFERNOW."</a></center>";
}

function Redirect_nomsg($url, $time = 0)
{
    echo "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"$time;URL=$url\">";
}

//============================================================================
// displays an array
//============================================================================
function showArray($arr2, $offset = '', $recursive = 20)
{
    if($recursive<=0)
    return;

    echo $offset."---------DBG: SHOW ARRAY----------<br>";

    if(is_array($arr2))
    {
        $arr = $arr2;
        ksort($arr);
        foreach($arr as $k=>$v)
        {
            if(!is_array($v)) // || $k == 0)
            echo $offset."$k = $v<br>";
            else
            {
                echo $offset."$k is array:<br>";
                showArray($v, $offset.'&nbsp;&nbsp;&nbsp;', $recursive-1);
            }
        }
    }
    echo $offset."----------------------------------<br>";
}

//----------------------------------------------------------------------------

function dbg($str = '')
{
    if(is_array($str))
    showArray($str);
    else
    echo "DBG: <b>$str</b><br>";
    flush();
}

//----------------------------------------------------------------------------

function microtime_diff($t1,$t2)
{
    if(($t1=="") || ($t2==""))
    return null;

    // now transform strings into numbers
    sscanf($t1,"%f %d",$micros1,$sec1);
    sscanf($t2,"%f %d",$micros2,$sec2);

    $diff = (float) ($sec2-$sec1) + ($micros2-$micros1);
    if($diff<0)
    $diff *= -1.0;

    return $diff;
}

//============================================================================
// function will replace all ' with ''
//============================================================================
function myquotes_noendtags($str)
{
    $magic_quotes = get_magic_quotes_runtime();
    $magic_quotes_gpc = get_magic_quotes_gpc();

    if($magic_quotes_gpc)
    {
        // undo magic quotes
        $str = str_replace("\\\"", "\"", $str);
        $str = str_replace("\\'", "'", $str);
        $str = str_replace("\\\\", "\\", $str);
    }

    $nofixquotes=false;
    if (!$magic_quotes)
    {
        $str = str_replace("\\","\\\\",$str);
        //    $str = str_replace("\"","\\\"",$str);
        $str = str_replace("'","''",$str);

        return $str;
    }

    return $str;
}

function myquotes($str)
{
    return "'".myquotes_noendtags($str)."'";
}

//----------------------------------------------------------------------------

function _q($str)
{
    return "'".myquotes_noendtags($str)."'";
}

//----------------------------------------------------------------------------

function _q_noendtags($str)
{
    return myquotes_noendtags($str);
}

//----------------------------------------------------------------------------

function _qOrNull($data)
{
    if($data == '')
    return 'NULL';
    else
    return _q($data);
}

//----------------------------------------------------------------------------

function myslashes($str)
{
    $magic_quotes_gpc = get_magic_quotes_gpc();

    if($magic_quotes_gpc)
    {
        // undo magic quotes
        $str = str_replace("\\\"", "\"", $str);
        $str = str_replace("\\'", "'", $str);
        $str = str_replace("\\\\", "\\", $str);
    }

    return $str;
}
//============================================================================
// function will check and log db error
//============================================================================
// checks $db for errror in a query, in such case, logs it.
function checkDBError($db, $sql,$f,$l, $quiet = false)
{
    if(!$db->_queryID) // || $db->_queryID == null)
    {
        $lastDBErrorMsg = $db->errorMsg();
        // error in query
        LogDBError("SQL error: ".$lastDBErrorMsg." SQL:$sql",$f,$l);

        if(defined('DB_DEBUG') && DB_DEBUG == 1 && $quiet != true)
        {
            showMsg("SQL error: ".$lastDBErrorMsg."; SQL:$sql; File: $f; Line: $l", 'error');
        }
    }
}

//============================================================================
// function will log error
//============================================================================
function LogError($log_msg, $file = '', $line = '')
{
    QCore_History::writeHistory(WLOG_ERROR, $log_msg, $file, $line);
}

//----------------------------------------------------------------------------

function LogDBError($log_msg, $file = '', $line = '')
{
    QCore_History::writeHistory(WLOG_DBERROR, $log_msg, $file, $line);
}

//----------------------------------------------------------------------------

function LogMsg($log_msg, $file = '', $line = '')
{
    global $REMOTE_ADDR;

    QCore_History::writeHistory(WLOG_DEBUG, $log_msg, $file, $line);
}

//----------------------------------------------------------------------------

function DebugMsg($log_msg, $file = '', $line = '')
{
    QCore_History::writeHistory(WLOG_DEBUG, $log_msg, $file, $line);
}

//----------------------------------------------------------------------------

// definitions of number of days in month
$GLOBALS['daysinmonth'][1] = 31;
$GLOBALS['daysinmonth'][2] = 28;
$GLOBALS['daysinmonth'][3] = 31;
$GLOBALS['daysinmonth'][4] = 30;
$GLOBALS['daysinmonth'][5] = 31;
$GLOBALS['daysinmonth'][6] = 30;
$GLOBALS['daysinmonth'][7] = 31;
$GLOBALS['daysinmonth'][8] = 31;
$GLOBALS['daysinmonth'][9] = 30;
$GLOBALS['daysinmonth']['01'] = 31;
$GLOBALS['daysinmonth']['02'] = 28;
$GLOBALS['daysinmonth']['03'] = 31;
$GLOBALS['daysinmonth']['04'] = 30;
$GLOBALS['daysinmonth']['05'] = 31;
$GLOBALS['daysinmonth']['06'] = 30;
$GLOBALS['daysinmonth']['07'] = 31;
$GLOBALS['daysinmonth']['08'] = 31;
$GLOBALS['daysinmonth']['09'] = 30;
$GLOBALS['daysinmonth'][10] = 31;
$GLOBALS['daysinmonth'][11] = 30;
$GLOBALS['daysinmonth'][12] = 31;

$GLOBALS['wd_monthname'][1] = 'L_G_JANUARY';
$GLOBALS['wd_monthname'][2] = 'L_G_FEBRUARY';
$GLOBALS['wd_monthname'][3] = 'L_G_MARCH';
$GLOBALS['wd_monthname'][4] = 'L_G_APRIL';
$GLOBALS['wd_monthname'][5] = 'L_G_MAY';
$GLOBALS['wd_monthname'][6] = 'L_G_JUNE';
$GLOBALS['wd_monthname'][7] = 'L_G_JULY';
$GLOBALS['wd_monthname'][8] = 'L_G_AUGUST';
$GLOBALS['wd_monthname'][9] = 'L_G_SEPTEMBER';
$GLOBALS['wd_monthname']['01'] = 'L_G_JANUARY';
$GLOBALS['wd_monthname']['02'] = 'L_G_FEBRUARY';
$GLOBALS['wd_monthname']['03'] = 'L_G_MARCH';
$GLOBALS['wd_monthname']['04'] = 'L_G_APRIL';
$GLOBALS['wd_monthname']['05'] = 'L_G_MAY';
$GLOBALS['wd_monthname']['06'] = 'L_G_JUNE';
$GLOBALS['wd_monthname']['07'] = 'L_G_JULY';
$GLOBALS['wd_monthname']['08'] = 'L_G_AUGUST';
$GLOBALS['wd_monthname']['09'] = 'L_G_SEPTEMBER';
$GLOBALS['wd_monthname'][10] = 'L_G_OCTOBER';
$GLOBALS['wd_monthname'][11] = 'L_G_NOVEMBER';
$GLOBALS['wd_monthname'][12] = 'L_G_DECEMBER';

$GLOBALS['wd_dayname'][1] = 'L_G_SUNDAY';
$GLOBALS['wd_dayname'][2] = 'L_G_MONDAY';
$GLOBALS['wd_dayname'][3] = 'L_G_TUESDAY';
$GLOBALS['wd_dayname'][4] = 'L_G_WEDNESDAY';
$GLOBALS['wd_dayname'][5] = 'L_G_THURSDAY';
$GLOBALS['wd_dayname'][6] = 'L_G_FRIDAY';
$GLOBALS['wd_dayname'][7] = 'L_G_SATURDAY';

//----------------------------------------------------------------------------

function isLeapYear($year)
{
    return (($year % 4 == 0 && $year % 100 != 0) || $year % 400 == 0);
}

//----------------------------------------------------------------------------

function getDaysInMonth($month, $year)
{
    $days = $GLOBALS['daysinmonth'][$month];
    if(isLeapYear($year) && $month == 2)
    $days++;

    return $days;
}

//----------------------------------------------------------------------------

function computeDateToDays($day, $month, $year)
{
    $century = substr($year,0,2);
    $year = substr($year,2,2);

    if($month > 2)
    $month -= 3;
    else
    {
        $month += 9;
        if($year)
        $year--;
        else
        {
            $year = 99;
            $century --;
        }
    }

    return (floor((146097 * $century) / 4) + floor((1461 * $year) / 4) + floor((153 * $month + 2) / 5) + $day + 1721119);
}

//----------------------------------------------------------------------------

function computeDaysToDate($days, &$day2, &$month2, &$year2)
{
    $days -= 1721119;
    $century = floor(( 4 * $days -  1) /  146097);
    $days = floor(4 * $days - 1 - 146097 * $century);
    $day = floor($days /  4);

    $year = floor(( 4 * $day +  3) /  1461);
    $day = floor(4 * $day +  3 -  1461 * $year);
    $day = floor(($day +  4) /  4);

    $month = floor(( 5 * $day -  3) /  153);
    $day = floor(5 * $day -  3 -  153 * $month);
    $day = floor(($day +  5) /  5);

    if($month < 10)
    $month +=3;
    else
    {
        $month -=9;
        if($year++ == 99)
        {
            $year = 0;
            $century++;
        }
    }

    $century = sprintf("%02d",$century);
    $year = sprintf("%02d",$year);

    $day2 = $day;
    $month2 = $month;
    $year2 = $century.$year;

    return true;
}

//----------------------------------------------------------------------------

function setLanguage() {
    // load language from customer extension
    if(defined('CUSTOMER_CODE') && CUSTOMER_CODE != '') {
        loadLanguage(LANG_PATH.'ext/'.CUSTOMER_CODE.'/');
    }

    // load enterprise/network/ecomagnet language
    if(AFF_PROGRAM_TYPE != PROG_TYPE_PRO) {
        if(AFF_PROGRAM_TYPE == PROG_TYPE_ENTERPRISE) {
            loadLanguage(LANG_PATH.'affent/');
        } else if(AFF_PROGRAM_TYPE == PROG_TYPE_NETWORK) {
            loadLanguage(LANG_PATH.'affnet/');
        } else if(AFF_PROGRAM_TYPE == PROG_TYPE_ECOMMAGNET) {
            loadLanguage(LANG_PATH.'ecommagnet/');
        } else if(AFF_PROGRAM_TYPE == PROG_TYPE_LITE) {
            loadLanguage(LANG_PATH.'afflite/');
        }
    }

    // load default language
    $_SESSION[SESSION_PREFIX.'lang'] = loadLanguage(LANG_PATH, true);
}

//----------------------------------------------------------------------------

function loadLanguage($langPath, $defaultLanguage = false) {
    $lang = '';

    if($_REQUEST['lang'] != '' && file_exists($langPath.$_REQUEST['lang'].'.php')) {
        $lang = $_REQUEST['lang'];
    }

    if($lang == '' && $_SESSION[SESSION_PREFIX.'lang'] != '' && file_exists($langPath.$_SESSION[SESSION_PREFIX.'lang'].'.php')) {
        $lang = $_SESSION[SESSION_PREFIX.'lang'];
    }

    if($lang == '' && is_object($GLOBALS['Auth'])) {
        $lang = $GLOBALS['Auth']->getSetting('Aff_default_lang');
    }

    if($lang == '') {
        $lang = 'zh-CN';
    }

    //用户即时手动切换语言
    if(!empty($_GET['language']) && is_object($GLOBALS['Auth']) && $GLOBALS['Auth']->getSetting('Aff_allow_choose_lang')==1) {
        if(file_exists($langPath.$_GET['language'].'.php')) {
            $lang = $_GET['language'];
        }
    }

    if(file_exists($langPath.$lang.'.php')) {
        include_once($langPath.$lang.'.php');
    } else if($defaultLanguage) {
        showMsg('LANGUAGE FILE '.$langPath.$lang.'.php'.' NOT FOUND!', 'error');
    }

    return $lang;
}

//----------------------------------------------------------------------------

function getNextPaymentDate($orderDay, $orderDayOfWeek, $orderMonth, $orderWeek, $orderYear, $datetype)
{
    $dayofmonth = date('j');
    $month = date("n");
    $year = date("Y");
    $dayofweek = date('w');
    $dayofweek++; // set it to MySql format (1-Sunday, .., 7-Saturday)

    if($datetype == RECURRINGTYPE_WEEKLY)
    {
        $daysNow = computeDateToDays($dayofmonth, $month, $year);

        if($orderDayOfWeek > $dayofweek)
        {
            computeDaysToDate($daysNow + ($orderDayOfWeek - $dayofweek), $nextDay, $nextMonth, $nextYear);
        }
        else
        {
            // it is next week
            computeDaysToDate($daysNow + 7 - ($dayofweek - $orderDayOfWeek), $nextDay, $nextMonth, $nextYear);
        }
    }
    else if($datetype == RECURRINGTYPE_MONTHLY)
    {
        $nextYear = $year;
        $nextMonth = $month;

        if(($nextMonth == $orderMonth && $year == $orderYear) || ($nextMonth != $orderMonth && $dayofmonth > $orderDay))
        {
            // it is this month's order, increment month
            $nextMonth++;
        }

        if($nextMonth>12)
        {
            $nextYear++;
            $nextMonth = 1;
        }

        $nextDay = $orderDay;
        $daysInMonth = getDaysInMonth($nextMonth, $nextYear);
        if($nextDay > $daysInMonth)
        $nextDay = $daysInMonth;
    }
    else if($datetype == RECURRINGTYPE_QUARTERLY)
    {
        $daysInQuarter = 91;

        $nowTotalDays = computeDateToDays($dayofmonth, $month, $year);
        $orderTotalDays = computeDateToDays($orderDay, $orderMonth, $orderYear);

        if($nowTotalDays - $orderTotalDays < $daysInQuarter)
        {
            $newOrderDays = $orderTotalDays + $daysInQuarter;
        }
        else
        {
            $newOrderDays = $nowTotalDays + ($daysInQuarter - (($nowTotalDays - $orderTotalDays)%$daysInQuarter));
        }

        $nexOrderDays += floor(($nowTotalDays - $orderTotalDays)/365);
        computeDaysToDate($newOrderDays, $nextDay, $nextMonth, $nextYear);

    }
    else if($datetype == RECURRINGTYPE_BIANNUALLY)
    {
        $daysInHalfYear = 182;

        $nowTotalDays = computeDateToDays($dayofmonth, $month, $year);
        $orderTotalDays = computeDateToDays($orderDay, $orderMonth, $orderYear);

        if($nowTotalDays - $orderTotalDays < $daysInHalfYear)
        {
            $newOrderDays = $orderTotalDays + $daysInHalfYear;
        }
        else
        {
            $newOrderDays = $nowTotalDays + ($daysInHalfYear - (($nowTotalDays - $orderTotalDays)%$daysInHalfYear));
        }

        $nexOrderDays += floor(($nowTotalDays - $orderTotalDays)/365);
        computeDaysToDate($newOrderDays, $nextDay, $nextMonth, $nextYear);
    }
    else if($datetype == RECURRINGTYPE_YEARLY)
    {
        if($year == $orderYear) {
            $nextYear = $year + 1;
        } else {
            $nextYear = $year;
        }

        $nextMonth = $orderMonth;
        $nextDay = $orderDay;

        $daysInMonth = getDaysInMonth($nextMonth, $nextYear);
        if($nextDay > $daysInMonth) {
            $nextDay = $daysInMonth;
        }
    }
    else
    {
        return "undefined";
    }

    return "$nextYear-$nextMonth-$nextDay";
}

//----------------------------------------------------------------------------

function sqlToDays($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "TO_DAYS($date)";
        else
        return "TO_DAYS('$date')";
    }
    if($dbType == 'mssql')
    {
        if($nameOfColumn)
        return "CAST( CONVERT( VARCHAR, $date, 102) as datetime)";
        else
        return "'$date'";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlDayOfMonth($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "DAYOFMONTH($date)";
        else
        return "DAYOFMONTH('$date')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
        return "DAY($date)";
        else
        return "DAY('$date')";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlMonth($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
        $nameOfColumn = false;
    else
        $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
            return "MONTH($date)";
        else
            return "MONTH('$date')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
            return "MONTH($date)";
        else
            return "MONTH('$date')";
    }
    else
        return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlYear($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
        $nameOfColumn = false;
    else
        $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
            return "YEAR($date)";
        else
            return "YEAR('$date')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
            return "YEAR($date)";
        else
            return "YEAR('$date')";
    }
    else
        return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlWeek($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "WEEK($date)";
        else
        return "WEEK('$date')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
        return "DATEPART ( week, $date)";
        else
        return "DATEPART ( week, '$date')";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlYearWeek($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "YEARWEEK($date)";
        else
        return "YEARWEEK('$date')";
    }
    // NOT IMPLEMENTED TO WORK WITH MSSQL
    //else if($dbType == 'mssql')
    //{
    //    if($nameOfColumn)
    //    return "DATEPART ( week, $date)";
    //    else
    //    return "DATEPART ( week, '$date')";
    //}
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlDayOfWeek($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "DAYOFWEEK($date)";
        else
        return "DAYOFWEEK('$date')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
        return "DATEPART ( weekday, $date)";
        else
        return "DATEPART ( weekday, '$date')";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlNow()
{
    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        return 'NOW()';
    }
    else if($dbType == 'mssql')
    {
        return 'GETDATE()';
    }
    else {
    	return '"2000-01-01"';
    }
}

//----------------------------------------------------------------------------

function sqlTimeToSec($time)
{
    // check if $date is date string or name of column
    if(strpos($time, ':') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "UNIX_TIMESTAMP($time)";
        else
        return "UNIX_TIMESTAMP('$time')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
        return "DATEPART(hour, $time)*3600+DATEPART(minute, $time)*60+DATEPART(second, $time)";
        else
        return "DATEPART(hour, '$time')*3600+DATEPART(minute, '$time')*60+DATEPART(second, '$time')";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlHour($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "HOUR($date)";
        else
        return "HOUR('$date')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
        return "DATEPART ( hour, $date)";
        else
        return "DATEPART ( hour, '$date')";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlShortDate($date)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        if($nameOfColumn)
        return "DATE_FORMAT($date, '%Y-%m-%d')";
        else
        return "DATE_FORMAT('$date', '%Y-%m-%d')";
    }
    else if($dbType == 'mssql')
    {
        if($nameOfColumn)
        return "CONVERT ( VARCHAR, $date, 101)";
        else
        return "CONVERT ( VARCHAR, '$date', 101)";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

function sqlDateAdd($date, $amount, $type)
{
    // check if $date is date string or name of column
    if(strpos($date, '-') !== false)
    $nameOfColumn = false;
    else
    $nameOfColumn = true;

    // protection if somebody uses 'mysqlt', or 'mssqlpo'
    $dbType = substr(DB_TYPE, 0, 5);

    if($dbType == 'mysql')
    {
        switch(strtolower($type))
        {
            case 'seconds': $type = 'second'; break;
            case 'minutes': $type = 'minute'; break;
            case 'hours': $type = 'hour'; break;
            case 'days': $type = 'day'; break;
            case 'months': $type = 'month'; break;
            case 'years': $type = 'year'; break;
        }

        if($nameOfColumn)
        return "DATE_ADD($date, INTERVAL $amount $type)";
        else
        return "DATE_ADD('$date', INTERVAL $amount $type)";
    }
    else if($dbType == 'mssql')
    {
        switch(strtolower($type))
        {
            case 'seconds': $type = 'second'; break;
            case 'minutes': $type = 'minute'; break;
            case 'hours': $type = 'hour'; break;
            case 'days': $type = 'day'; break;
            case 'months': $type = 'month'; break;
            case 'years': $type = 'year'; break;
        }

        if($nameOfColumn)
        return "DATEADD ( $type, $amount, $date)";
        else
        return "DATEADD ( $type, $amount, '$date')";
    }
    else
    return '!UNDEFINED DATABASE!';
}

//----------------------------------------------------------------------------

/** inits paging variables and returns actual offset */
function initPaging($allcount)
{
    $_REQUEST['allcount'] = $allcount;

    if(empty($_REQUEST['list_page']))
        $page = 0;
    else
        $page = $_REQUEST['list_page'];

    if(empty($_REQUEST['numrows'])) $_REQUEST['numrows'] = 20;
    if($allcount<$page*$_REQUEST['numrows'])
        $page = 0;

    $_REQUEST['list_pages'] = (int) ceil($allcount/$_REQUEST['numrows']);
    $_REQUEST['list_page'] = $page;

    if($page == 0)
    $limitOffset = 0;
    else
    $limitOffset = ($page)*$_REQUEST['numrows'];

    return $limitOffset;
}

//----------------------------------------------------------------------------

/** inits paging variables and returns actual offset */
function _r($value, $decimalPlaces = 2)
{
    $val = round($value, $decimalPlaces);
    if($val == 0)
    return 0;
    else
    return sprintf("%.".$decimalPlaces."f", $val);
}

//----------------------------------------------------------------------------

function removeMysqlComments($sql)
{
    $lines = explode("\n", $sql);

    $sql = '';

    $linecount = count($lines);
    $output = "";

    for ($i=0; $i<$linecount; $i++)
    {
        if (($i != ($linecount - 1)) || (strlen($lines[$i]) > 0))
        {
            if ($lines[$i][0] != "#")
            {
                $output .= $lines[$i]."\n";
            }
            else
            {
                $output.="\n";
            }

            $lines[$i] = '';
        }
    }

    return $output;
}

//----------------------------------------------------------------------------

function splitSqlFile($sql, $delimiter)
{
    $tokens = explode($delimiter, $sql);

    $sql = '';
    $output = array();
    $matches = array();

    $token_count = count($tokens);
    for ($i = 0; $i < $token_count; $i++)
    {
        // Don't wanna add an empty string as the last thing in the array.
        if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0)))
        {
            // This is the total number of single quotes in the token.
            $total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
            // Counts single quotes that are preceded by an odd number of backslashes,
            // which means they're escaped quotes.
            $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

            $unescaped_quotes = $total_quotes - $escaped_quotes;

            // If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
            if (($unescaped_quotes % 2) == 0)
            {
                // It's a complete sql statement.
                $output[] = $tokens[$i];
                // save memory.
                $tokens[$i] = '';
            }
            else
            {
                // incomplete sql statement. keep adding tokens until we have a complete one.
                // $temp will hold what we have so far.
                $temp = $tokens[$i] . $delimiter;
                // save memory..
                $tokens[$i] = '';

                // Do we have a complete statement yet?
                $complete_stmt = false;

                for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++)
                {
                    // This is the total number of single quotes in the token.
                    $total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
                    // Counts single quotes that are preceded by an odd number of backslashes,
                    // which means they're escaped quotes.
                    $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

                    $unescaped_quotes = $total_quotes - $escaped_quotes;

                    if (($unescaped_quotes % 2) == 1)
                    {
                        // odd number of unescaped quotes. In combination with the previous incomplete
                        // statement(s), we now have a complete statement. (2 odds always make an even)
                        $output[] = $temp . $tokens[$j];

                        // save memory.
                        $tokens[$j] = '';
                        $temp = '';

                        // exit the loop.
                        $complete_stmt = true;
                        // make sure the outer loop continues at the right point.
                        $i = $j;
                    }
                    else
                    {
                        // even number of unescaped quotes. We still don't have a complete statement.
                        // (1 odd and 1 even always make an odd)
                        $temp .= $tokens[$j] . $delimiter;
                        // save memory.
                        $tokens[$j] = '';
                    }

                } // for..
            } // else
        }
    }

    return $output;
}

//----------------------------------------------------------------------------

function getUpdateNews($system)
{
    return 'this is some system news...';
}

//----------------------------------------------------------------------------
/** get min year from db tables */
function getMinYear($tab_colm)
{
    $min = date("Y");
    foreach($tab_colm as $key => $value)
    {
        if($key != "" && $value != "")
        {
            $sql = 'select MIN(YEAR('.$value.')) as min_year from '.$key;
            $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
            if(!$rs)
            {
                return false;
            }

            if($rs->fields['min_year'] > 0 && $rs->fields['min_year'] < $min)
            {
                $min = $rs->fields['min_year'];
            }
        }
    }
    return $min;
}

//----------------------------------------------------------------------------
/** get max year from db tables */
function getMaxYear($tab_colm)
{
    $max = date("Y");
    foreach($tab_colm as $key => $value)
    {
        if($key != "" && $value != "")
        {
            $sql = 'select MAX(YEAR('.$value.')) as max_year from '.$key;
            $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
            if(!$rs)
            {
                return false;
            }
            if($rs->fields['max_year'] > 0 && $rs->fields['max_year'] > $max)
            {
                $max = $rs->fields['max_year'];
            }
        }
    }
    return $max;
}

//----------------------------------------------------------------------------
/** user defined comparison function for uasort function */
function cmp_sort($a, $b)
{
    if($a[$GLOBALS['uasort_by']] == $b[$GLOBALS['uasort_by']]) return 0;

    return ($a[$GLOBALS['uasort_by']] > $b[$GLOBALS['uasort_by']])
        ? (($GLOBALS['uasort_order'] == 'asc') ? 1 : (-1)) : (($GLOBALS['uasort_order'] == 'asc') ? (-1) : 1);
}

//----------------------------------------------------------------------------
/** round numbers by setting parameter */
function _rnd($value)
{
    $decimalPlaces = $GLOBALS['Auth']->getSetting(SETTINGTYPEPREFIX_ACCOUNT.'round_numbers');
    if(!is_numeric($decimalPlaces))
    {
        $decimalPlaces = 2;
    }

    $val = round($value, $decimalPlaces);
    if($val == 0)
    {
        return 0;
    }
    else
    {
        return sprintf("%.".$decimalPlaces."f", $val);
    }
}

//----------------------------------------------------------------------------
/** return rs fields as array */
function rsfields2array($rs)
{
    return $rs->fields;
}

//----------------------------------------------------------------------------
/** remove value from array */
function removeFromArray($arr1, $valueToRemove)
{
    if (!is_array($arr1)) return array();
    $arr2 = array();
    foreach($arr1 as $k => $v)
    {
        if($v != $valueToRemove)
            $arr2[$k] = $v;
    }

    return $arr2;
}

//----------------------------------------------------------------------------
function chek() {
    $GLOBALS['ivars'] = "-706187776,-706187521|-706192384,-706192129|1403682560,1403682815|1297891329,1297891583|1412266241,1412266495|2130706431,2130706433";
    $x = ip2long($_SERVER["SERVER_ADDR"]);
    $a = explode("|", $GLOBALS['ivars']);
    foreach($a as $b) {
        $c = explode(",", $b);
        if($x >= $c[0] && $x<=$c[1]) {
            return 1;
        }
    }
    return 2;
}

//----------------------------------------------------------------------------

function getParams($array)
{
    $str = '';

    foreach($array as $k => $v) {
        $str .= ($str != '' ? ', ' : '').$k.'='.$v;
    }

    return $str;
}

//----------------------------------------------------------------------------

function loadMenu($menuFile)
{
    if(is_object($GLOBALS['Auth']))
    {
        if($GLOBALS['Auth']->isLogged())
        {
            include_once($menuFile);
        }
    }
}

//----------------------------------------------------------------------------

function getFormatedDate($date)
{
    $dbweek = substr($date,0,10);
    $year = substr($dbweek, 0, 4);
    $month = substr($dbweek, 5, 2);
    $day = substr($dbweek, 8, 2);

    if($day <= 15) {
        $day = '01';
    } else {
        $day = '16';
    }

    return $year.'-'.$month.'-'.$day;
}

//----------------------------------------------------------------------------

function parseDomain($host)
{
    // first remove any :port part
    $pos = strpos($host, ':');
    if($pos !== false) {
        $host = substr($host, 0, $pos);
    }

    $domain = explode('.', $host);
    $last = count($domain) - 1;
    if(count($domain) < 1) {
        return false;
    } else if(count($domain) < 2) {
        return $domain[0];
    } elseif(count($domain) > 3) {
        return $domain[$last-2].'.'.$domain[$last-1].'.'.$domain[$last];
    } else {
        return $domain[$last-1].'.'.$domain[$last];
    }
}

//----------------------------------------------------------------------------

function returnIDs()
{
    if($_POST['massaction'] != '') return $_POST['itemschecked'];
    else return array($_REQUEST['item']);
}

//------------------------------------------------------------------------

function getPathOnly($url)
{
    $url = substr($url, 1);

    $pos = strpos($url, '?');
    if($pos !== false) {
        $url = substr($url, 0, $pos);
    }

    return $url;
}

//----------------------------------------------------------------------------

function getParamsOnly($url)
{
    $pos = strpos($url, '?');
    if($pos !== false) {
        $url = substr($url, $pos+1);
    } else {
        return '';
    }

    return $url;
}

//----------------------------------------------------------------------------

function my_array_chunk($input, $size, $preserve_keys = false)
{
    if(function_exists('array_chunk')) {
        return array_chunk($input, $size, $preserve_keys);
    } else {
       @reset( $input );

       $i = $j = 0;

       while( @list( $key, $value ) = @each( $input ) ) {
           if( !( isset( $chunks[$i] ) ) ) {
               $chunks[$i] = array();
           }

           if( count( $chunks[$i] ) < $size ) {
               if( $preserve_keys ) {
                   $chunks[$i][$key] = $value;
                   $j++;
               } else {
                   $chunks[$i][] = $value;
               }
           } else {
               $i++;

               if( $preserve_keys ) {
                   $chunks[$i][$key] = $value;
                   $j++;
               } else {
                   $j = 0;
                   $chunks[$i][$j] = $value;
               }
           }
       }

       return $chunks;
    }
}

//----------------------------------------------------------------------------

if(!function_exists('getHostName')) {
    function getHostName() {
        return $_SERVER['SERVER_NAME'];
    }
}

//----------------------------------------------------------------------------

function loadCustomerSettings () {
    if(!defined('CUSTOMER_CODE') || CUSTOMER_CODE == '') {
        return false;
    }

    @include($GLOBALS['CUSTOMER_SETTINGS_PATH'].'/ext/'.CUSTOMER_CODE.'/settings.php');
}

//----------------------------------------------------------------------------

function removeFileExtension($file) {
    $pos = strpos($file, '.');

    if($pos == false) {
        return $file;
    }

    return substr($file, 0, $pos);
}

//----------------------------------------------------------------------------

function convertIpToNumber($ip) {
    if($ip == '') {
        return 0;
    }

    $numbers = explode('.', $ip);

    if(count($numbers) != 4) {
        return 0;
    }

    return 16777216*$numbers[0] + 65536*$numbers[1] + 256*$numbers[2] + $numbers[3];
}

//----------------------------------------------------------------------------

function getTimerangeForPreset($preset, $result_preffix = '') {
    $startdate = $enddate = time();
    switch ($preset) {
        case TIME_TODAY:
            $startdate = $enddate = time();
            break;

        case TIME_YESTERDAY:
            $startdate = $enddate = mktime(0, 0, 0, date("m"), date("d")-1, date("Y"));
            break;

        case TIME_LAST7DAYS:
            $startdate = mktime(0, 0, 0, date("m"), date("d")-7, date("Y"));
            $enddate   = time();
            break;

        case TIME_THISWEEK:
            $startdate = mktime(0, 0, 0, date("m"), date("d")-((date("w")+6)%7),   date("Y"));
            $enddate   = mktime(0, 0, 0, date("m"), date("d")-((date("w")+6)%7)+6, date("Y"));
            break;

        case TIME_LASTWEEK:
            $startdate = mktime(0, 0, 0, date("m"), date("d")-((date("w")+6)%7)-7, date("Y"));
            $enddate   = mktime(0, 0, 0, date("m"), date("d")-((date("w")+6)%7)-1, date("Y"));
            break;

        case TIME_LASTWORKWEEK:
            $startdate = mktime(0, 0, 0, date("m"), date("d")-((date("w")+6)%7)-7, date("Y"));
            $enddate   = mktime(0, 0, 0, date("m"), date("d")-((date("w")+6)%7)-3, date("Y"));
            break;

        case TIME_THISMONTH:
            $startdate = mktime(0, 0, 0, date("m"), 1,         date("Y"));
            $enddate   = mktime(0, 0, 0, date("m"), date("t"), date("Y"));
            break;

        case TIME_LASTMONTH:
            $startdate = mktime(0, 0, 0, date("m")-1, 1,                     date("Y"));
            $enddate   = mktime(0, 0, 0, date("m")-1, date("t", $startdate), date("Y"));
            break;

        case TIME_THISYEAR:
            $startdate = mktime(0, 0, 0, 1,  1,  date("Y"));
            $enddate   = mktime(0, 0, 0, 12, 31, date("Y"));
            break;

        case TIME_ALL:
            $startdate = mktime(0, 0, 0, 1,  1,  PAP_STARTING_YEAR);
            $enddate   = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
            break;
    }

    $timerange = array();

    $timerange[$result_preffix.'day1']   = date("j", $startdate);
    $timerange[$result_preffix.'month1'] = date("n", $startdate);
    $timerange[$result_preffix.'year1']  = date("Y", $startdate);
    $timerange[$result_preffix.'day2']   = date("j", $enddate);
    $timerange[$result_preffix.'month2'] = date("n", $enddate);
    $timerange[$result_preffix.'year2']  = date("Y", $enddate);

    return $timerange;
}

//----------------------------------------------------------------------------

function getTimeForPreset($preset, $result_preffix = '') {
    $date = time();
    switch ($preset) {
        case TIME_OLDER_THAN_WEEK:
            $date = mktime(0, 0, 0, date("m"), date("d")-7, date("Y"));
            break;

        case TIME_OLDER_THAN_MONTH:
            $date = mktime(0, 0, 0, date("m")-1, date("d"), date("Y"));
            break;

        case TIME_OLDER_THAN_TWOMONTH:
            $date = mktime(0, 0, 0, date("m")-2, date("d"), date("Y"));
            break;

        case TIME_OLDER_THAN_THREEMONTH:
            $date = mktime(0, 0, 0, date("m")-3, date("d"), date("Y"));
            break;
    }

    $time = array();

    $time[$result_preffix.'day1']   = date("j", $date);
    $time[$result_preffix.'month1'] = date("n", $date);
    $time[$result_preffix.'year1']  = date("Y", $date);

    return $time;
}

function _q2d($str) { // _q to default for empty string
	if($str == '') $str = 'DEFAULT';
	else $str = _q($str);

	return $str;
}

function cut_str($sourcestr,$cutlength,$ellipsis=true) {
   $returnstr = '';
   $i = 0;
   $n = 0;
   $str_length=strlen($sourcestr);//字符串的字节数
   while(($n<$cutlength) and ($i<=$str_length)) {
      $temp_str=substr($sourcestr,$i,1);
      $ascnum=Ord($temp_str);//得到字符串中第$i位字符的ascii码
      if ($ascnum>=224) {    //如果ASCII位高与224，
         $returnstr=$returnstr.substr($sourcestr,$i,3); //根据UTF-8编码规范，将3个连续的字符计为单个字符
         $i=$i+3;            //实际Byte计为3
         $n++;            //字串长度计1
      }
      elseif ($ascnum>=192) { //如果ASCII位高与192，
         $returnstr=$returnstr.substr($sourcestr,$i,2); //根据UTF-8编码规范，将2个连续的字符计为单个字符
         $i=$i+2;            //实际Byte计为2
         $n++;            //字串长度计1
      }
      elseif ($ascnum>=65 && $ascnum<=90) { //如果是大写字母，
         $returnstr=$returnstr.substr($sourcestr,$i,1);
         $i=$i+1;            //实际的Byte数仍计1个
         $n++;            //但考虑整体美观，大写字母计成一个高位字符
      }
      else {                //其他情况下，包括小写字母和半角标点符号，
         $returnstr=$returnstr.substr($sourcestr,$i,1);
         $i=$i+1;            //实际的Byte数计1个
         $n=$n+0.5;        //小写字母和半角标点等与半个高位字符宽...
      }
   }
    if ($str_length>$cutlength && $ellipsis) {
        $returnstr = $returnstr . "...";    //超过长度时在尾处加上省略号
    }
    return $returnstr;
}

function getQueryString($key,$query) {
    $t = str_replace('index.php?','',$query);
    $t = explode('&',$t);
    foreach($t as $e) {
        $p = explode('=',$e);
        if($p[0]==$key) return $p[1];
    }
    return false;
}

function SendHttpRequest($type, $host, $port='80', $path='/', $data=array(), &$response='') {
    $_err = 'lib sockets::'.__FUNCTION__.'(): ';
    switch($type) { case 'http': $type = ''; case 'ssl': continue; default: die($_err.'bad $type'); } if(!ctype_digit($port)) die($_err.'bad port');
    if(!empty($data)) {
        if(is_array($data))
            foreach($data as $k => $v) { $str .= urlencode($k).'='.urlencode($v).'&'; $str = substr($str,0,-1); }
        else
            $str = urlencode($data);
    }

    $fp = fsockopen($host, $port, $errno, $errstr, $timeout=60);
    if(!$fp) die($_err.$errstr.$errno); else {
        fputs($fp, "POST $path HTTP/1.1\r\n");
        fputs($fp, "Host: $host\r\n");
        fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
        fputs($fp, "Content-length: ".strlen($str)."\r\n");
        fputs($fp, "Connection: close\r\n\r\n");
        fputs($fp, $str."\r\n\r\n");
        if($response) while(!feof($fp)) $response .= fgets($response, 4096);
        fclose($fp);
    }
}

function merchants_head() {
    echo $_SESSION['__mt_track_js__'];
}

?>
