--
-- 表的结构 `wd_g_accounts`
--

DROP TABLE IF EXISTS `wd_g_accounts`;
CREATE TABLE `wd_g_accounts` (
  `accountid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `dateinserted` datetime NOT NULL,
  `rstatus` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`accountid`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `IDX_wd_g_accounts1` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_affclientrelationship`
--

DROP TABLE IF EXISTS `wd_g_affclientrelationship`;
CREATE TABLE `wd_g_affclientrelationship` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `affid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `outuserid` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `outusername` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateinserted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `outcustid` (`outuserid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_categories`
--

DROP TABLE IF EXISTS `wd_g_categories`;
CREATE TABLE `wd_g_categories` (
  `catid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `parentcatid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `rstatus` tinyint(4) NOT NULL,
  `product` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `dateinserted` datetime NOT NULL,
  `deleted` tinyint(4) NOT NULL,
  PRIMARY KEY (`catid`),
  UNIQUE KEY `IDX_wd_g_categories2` (`catid`),
  KEY `IDX_wd_g_categories1` (`parentcatid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_domains`
--

DROP TABLE IF EXISTS `wd_g_domains`;
CREATE TABLE `wd_g_domains` (
  `domainid` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `accountid` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `userid` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rtype` tinyint(4) NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dateinserted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `rstatus` tinyint(4) NOT NULL DEFAULT '0',
  `declinereason` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`domainid`),
  KEY `IDX_wd_g_domains1` (`accountid`),
  KEY `IDX_wd_g_domains2` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_dynamiclink`
--

DROP TABLE IF EXISTS `wd_g_dynamiclink`;
CREATE TABLE `wd_g_dynamiclink` (
  `dlid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `userid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `target` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(2000) COLLATE utf8_unicode_ci NOT NULL,
  `contentext` text COLLATE utf8_unicode_ci NOT NULL,
  `remark` text COLLATE utf8_unicode_ci NOT NULL,
  `insertdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`dlid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_emailtemplates`
--

DROP TABLE IF EXISTS `wd_g_emailtemplates`;
CREATE TABLE `wd_g_emailtemplates` (
  `emailtempsid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `categorycode` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `emailsubject` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `emailtext` text COLLATE utf8_unicode_ci,
  `deleted` tinyint(4) DEFAULT '0',
  `lang` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`emailtempsid`),
  KEY `IDX_wd_g_emailtemplates1` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_groups`
--

DROP TABLE IF EXISTS `wd_g_groups`;
CREATE TABLE `wd_g_groups` (
  `groupid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `rstatus` tinyint(4) NOT NULL,
  `product` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dateinserted` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  `parentgroupid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leftnumber` int(11) DEFAULT NULL,
  `rightnumber` int(11) DEFAULT NULL,
  PRIMARY KEY (`groupid`),
  UNIQUE KEY `IDX_wd_g_groups1` (`groupid`),
  KEY `IDX_wd_g_groups2` (`parentgroupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_history`
--

DROP TABLE IF EXISTS `wd_g_history`;
CREATE TABLE `wd_g_history` (
  `historyid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rtype` tinyint(4) NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `dateinserted` datetime NOT NULL,
  `hfile` text COLLATE utf8_unicode_ci,
  `line` int(11) DEFAULT NULL,
  `ip` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`historyid`),
  KEY `IDX_wd_g_history1` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_jobs`
--

DROP TABLE IF EXISTS `wd_g_jobs`;
CREATE TABLE `wd_g_jobs` (
  `jobid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `rtype` smallint(5) unsigned DEFAULT NULL,
  `rstatus` tinyint(3) unsigned DEFAULT NULL,
  `progress` bigint(20) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `datefinished` datetime DEFAULT NULL,
  PRIMARY KEY (`jobid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_listviews`
--

DROP TABLE IF EXISTS `wd_g_listviews`;
CREATE TABLE `wd_g_listviews` (
  `viewid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `userid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `rcolumns` text COLLATE utf8_unicode_ci NOT NULL,
  `listname` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`viewid`,`accountid`,`userid`),
  KEY `IDX_wd_g_listviews1` (`accountid`),
  KEY `IDX_wd_g_listviews2` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_messages`
--

DROP TABLE IF EXISTS `wd_g_messages`;
CREATE TABLE `wd_g_messages` (
  `messageid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `rtype` tinyint(4) NOT NULL,
  `dateinserted` datetime NOT NULL,
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `rtext` text COLLATE utf8_unicode_ci NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `datevalidfrom` datetime DEFAULT NULL,
  `datevalidto` datetime DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT '0',
  `showtoall` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`messageid`),
  UNIQUE KEY `IDX_wd_g_messages2` (`messageid`),
  KEY `IDX_wd_g_messages1` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_messagestousers`
--

DROP TABLE IF EXISTS `wd_g_messagestousers`;
CREATE TABLE `wd_g_messagestousers` (
  `messagetouserid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `messageid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `userid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fromuserid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rstatus` tinyint(4) NOT NULL,
  PRIMARY KEY (`messagetouserid`),
  KEY `IDX_wd_g_messagestousers1` (`messageid`),
  KEY `IDX_wd_g_messagestousers2` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_righttypes`
--

DROP TABLE IF EXISTS `wd_g_righttypes`;
CREATE TABLE `wd_g_righttypes` (
  `righttypeid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `parentrighttypeid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `righttype` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateinserted` datetime NOT NULL,
  `categorylangid` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  `rightlangid` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  `typelangid` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  `rorder` int(11) DEFAULT NULL,
  PRIMARY KEY (`righttypeid`),
  UNIQUE KEY `IDX_wd_g_righttypes1` (`righttypeid`),
  KEY `IDX_wd_g_righttypes2` (`parentrighttypeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_settings`
--

DROP TABLE IF EXISTS `wd_g_settings`;
CREATE TABLE `wd_g_settings` (
  `settingsid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `rtype` tinyint(3) unsigned NOT NULL,
  `code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `userid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `id1` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `id2` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`settingsid`),
  KEY `IDX_wd_g_settings1` (`accountid`),
  KEY `IDX_wd_g_settings2` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_usergroups`
--

DROP TABLE IF EXISTS `wd_g_usergroups`;
CREATE TABLE `wd_g_usergroups` (
  `usergroupid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `userid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `groupid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`usergroupid`),
  KEY `IDX_wd_g_usergroups1` (`userid`),
  KEY `IDX_wd_g_usergroups2` (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_userprofiles`
--

DROP TABLE IF EXISTS `wd_g_userprofiles`;
CREATE TABLE `wd_g_userprofiles` (
  `userprofileid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `rtype` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`userprofileid`),
  UNIQUE KEY `IDX_wd_g_userprofiles1` (`userprofileid`),
  KEY `IDX_wd_g_userprofiles2` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_userrights`
--

DROP TABLE IF EXISTS `wd_g_userrights`;
CREATE TABLE `wd_g_userrights` (
  `userrightid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `userprofileid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `righttypeid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`userrightid`),
  KEY `IDX_wd_g_userrights1` (`userprofileid`),
  KEY `IDX_wd_g_userrights2` (`righttypeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_g_users`
--

DROP TABLE IF EXISTS `wd_g_users`;
CREATE TABLE `wd_g_users` (
  `userid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `refid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `rpassword` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `surname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rstatus` tinyint(4) NOT NULL DEFAULT '0',
  `product` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dateinserted` datetime DEFAULT NULL,
  `dateapproved` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  `userprofileid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rtype` tinyint(4) NOT NULL,
  `parentuserid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leftnumber` int(11) DEFAULT NULL,
  `rightnumber` int(11) DEFAULT NULL,
  `company_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weburl` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `street` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zipcode` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_ssn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data1` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data2` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data3` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data4` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data5` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payoptid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `originalparentid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flags` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`userid`),
  UNIQUE KEY `IDX_wd_g_users3` (`userid`),
  UNIQUE KEY `IDX_wd_g_users9` (`username`),
  KEY `IDX_pa_affiliates_1` (`deleted`),
  KEY `IDX_pa_affiliates_2` (`username`,`rpassword`),
  KEY `IDX_wd_g_users4` (`accountid`),
  KEY `IDX_wd_g_users5` (`userprofileid`),
  KEY `IDX_wd_g_users6` (`parentuserid`),
  KEY `IDX_wd_g_users7` (`payoptid`),
  KEY `IDX_wd_g_users8` (`originalparentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_accounting`
--

DROP TABLE IF EXISTS `wd_pa_accounting`;
CREATE TABLE `wd_pa_accounting` (
  `accountingid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `dateinserted` datetime NOT NULL,
  `datefrom` datetime NOT NULL,
  `dateto` datetime NOT NULL,
  `note` text COLLATE utf8_unicode_ci,
  `rfile` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mbfile` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wirefile` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`accountingid`),
  UNIQUE KEY `IDX_wd_pa_accounting1` (`accountingid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_affiliatescampaigns`
--

DROP TABLE IF EXISTS `wd_pa_affiliatescampaigns`;
CREATE TABLE `wd_pa_affiliatescampaigns` (
  `affcampid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `campcategoryid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `campaignid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `rstatus` tinyint(4) NOT NULL,
  `declinereason` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`affcampid`),
  KEY `IDX_wd_pa_affiliatescampaigns1` (`campcategoryid`),
  KEY `IDX_wd_pa_affiliatescampaigns2` (`affiliateid`),
  KEY `IDX_wd_pa_affiliatescampaigns3` (`campaignid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_bannercategories`
--

DROP TABLE IF EXISTS `wd_pa_bannercategories`;
CREATE TABLE `wd_pa_bannercategories` (
  `bannercategoryid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`bannercategoryid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_banners`
--

DROP TABLE IF EXISTS `wd_pa_banners`;
CREATE TABLE `wd_pa_banners` (
  `bannerid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `destinationurl` text COLLATE utf8_unicode_ci,
  `sourceurl` text COLLATE utf8_unicode_ci,
  `bannertype` tinyint(4) DEFAULT NULL,
  `deleted` tinyint(4) DEFAULT '0',
  `campaignid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hidden` tinyint(4) DEFAULT '0',
  `size` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateinserted` datetime DEFAULT NULL,
  `bannercategory` char(8) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`bannerid`),
  UNIQUE KEY `IDX_wd_pa_banners2` (`bannerid`),
  KEY `IDX_pa_banners_1` (`campaignid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_campaigncategories`
--

DROP TABLE IF EXISTS `wd_pa_campaigncategories`;
CREATE TABLE `wd_pa_campaigncategories` (
  `campcategoryid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  `cpmcommission` float DEFAULT NULL,
  `clickcommission` float DEFAULT NULL,
  `salecommission` float DEFAULT NULL,
  `recurringcommission` float DEFAULT NULL,
  `recurringcommtype` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recurringcommdate` int(11) DEFAULT NULL,
  `recurringdatetype` tinyint(4) DEFAULT NULL,
  `campaignid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `salecommtype` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stsalecommtype` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st2clickcommission` float DEFAULT NULL,
  `st2salecommission` float DEFAULT NULL,
  `st3clickcommission` float DEFAULT NULL,
  `st3salecommission` float DEFAULT NULL,
  `st4clickcommission` float DEFAULT NULL,
  `st4salecommission` float DEFAULT NULL,
  `st5clickcommission` float DEFAULT NULL,
  `st5salecommission` float DEFAULT NULL,
  `st6clickcommission` float DEFAULT NULL,
  `st6salecommission` float DEFAULT NULL,
  `st7clickcommission` float DEFAULT NULL,
  `st7salecommission` float DEFAULT NULL,
  `st8clickcommission` float DEFAULT NULL,
  `st8salecommission` float DEFAULT NULL,
  `st9clickcommission` float DEFAULT NULL,
  `st9salecommission` float DEFAULT NULL,
  `st10clickcommission` float DEFAULT NULL,
  `st10salecommission` float DEFAULT NULL,
  `strecurringcommtype` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st2recurringcommission` float DEFAULT NULL,
  `st3recurringcommission` float DEFAULT NULL,
  `st4recurringcommission` float DEFAULT NULL,
  `st5recurringcommission` float DEFAULT NULL,
  `st6recurringcommission` float DEFAULT NULL,
  `st7recurringcommission` float DEFAULT NULL,
  `st8recurringcommission` float DEFAULT NULL,
  `st9recurringcommission` float DEFAULT NULL,
  `st10recurringcommission` float DEFAULT NULL,
  PRIMARY KEY (`campcategoryid`),
  UNIQUE KEY `IDX_wd_pa_campaigncategories2` (`campcategoryid`),
  KEY `IDX_pa_affiliatecategories_1` (`campaignid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_campaigns`
--

DROP TABLE IF EXISTS `wd_pa_campaigns`;
CREATE TABLE `wd_pa_campaigns` (
  `campaignid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `shortdescription` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateinserted` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  `disabled` tinyint(4) NOT NULL DEFAULT '0',
  `commtype` tinyint(4) NOT NULL,
  `products` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`campaignid`),
  UNIQUE KEY `IDX_wd_pa_campaigns1` (`campaignid`),
  KEY `IDX_wd_pa_campaigns2` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_impressions`
--

DROP TABLE IF EXISTS `wd_pa_impressions`;
CREATE TABLE `wd_pa_impressions` (
  `impressionid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateimpression` datetime NOT NULL,
  `bannerid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rotatorid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `all_imps_count` int(11) DEFAULT '0',
  `unique_imps_count` int(11) DEFAULT '0',
  `commissiongiven` tinyint(4) NOT NULL DEFAULT '0',
  `data1` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` char(2) COLLATE utf8_unicode_ci DEFAULT '__',
  PRIMARY KEY (`impressionid`),
  KEY `IDX_pa_impressions_3` (`bannerid`,`affiliateid`,`dateimpression`),
  KEY `IDX_wd_pa_impressions2` (`bannerid`),
  KEY `IDX_wd_pa_impressions3` (`affiliateid`),
  KEY `IDX_wd_pa_impressions4` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_impressions_tmp`
--

DROP TABLE IF EXISTS `wd_pa_impressions_tmp`;
CREATE TABLE `wd_pa_impressions_tmp` (
  `impressionid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateimpression` datetime NOT NULL,
  `bannerid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rotatorid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `all_imps_count` int(11) DEFAULT '0',
  `unique_imps_count` int(11) DEFAULT '0',
  `commissiongiven` tinyint(4) NOT NULL DEFAULT '0',
  `data1` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` char(2) COLLATE utf8_unicode_ci DEFAULT '__',
  PRIMARY KEY (`impressionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_integration`
--

DROP TABLE IF EXISTS `wd_pa_integration`;
CREATE TABLE `wd_pa_integration` (
  `integrationid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `integrationname` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `integrationlangconst` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `textbefore` text COLLATE utf8_unicode_ci,
  `textafter` text COLLATE utf8_unicode_ci,
  `deleted` tinyint(4) DEFAULT NULL,
  `rorder` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`integrationid`),
  UNIQUE KEY `IDX_wd_pa_integration1` (`integrationid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_integrationsteps`
--

DROP TABLE IF EXISTS `wd_pa_integrationsteps`;
CREATE TABLE `wd_pa_integrationsteps` (
  `intstepid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `integrationid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `rorder` tinyint(3) unsigned DEFAULT NULL,
  `textbefore` text COLLATE utf8_unicode_ci,
  `textarea` text COLLATE utf8_unicode_ci,
  `textafter` text COLLATE utf8_unicode_ci,
  `lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`intstepid`),
  KEY `IDX_wd_pa_integrationsteps1` (`integrationid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_payoutfields`
--

DROP TABLE IF EXISTS `wd_pa_payoutfields`;
CREATE TABLE `wd_pa_payoutfields` (
  `payfieldid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `payoptid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `langid` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  `rtype` tinyint(4) NOT NULL,
  `mandatory` tinyint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(4) NOT NULL,
  `availablevalues` text COLLATE utf8_unicode_ci,
  `rorder` tinyint(3) unsigned NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`payfieldid`),
  KEY `IDX_wd_pa_payoutfields1` (`payoptid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_payoutoptions`
--

DROP TABLE IF EXISTS `wd_pa_payoutoptions`;
CREATE TABLE `wd_pa_payoutoptions` (
  `payoptid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `exporttype` tinyint(4) NOT NULL,
  `exportformat` text COLLATE utf8_unicode_ci,
  `disabled` tinyint(4) NOT NULL DEFAULT '0',
  `langid` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  `rorder` tinyint(4) NOT NULL,
  `paybuttonformat` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`payoptid`),
  UNIQUE KEY `IDX_wd_pa_payoutoptions1` (`payoptid`),
  KEY `IDX_wd_pa_payoutoptions2` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_recurringcommissions`
--

DROP TABLE IF EXISTS `wd_pa_recurringcommissions`;
CREATE TABLE `wd_pa_recurringcommissions` (
  `recurringcommid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `commission` float NOT NULL,
  `commtype` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commdate` tinyint(4) NOT NULL,
  `datetype` tinyint(4) NOT NULL,
  `rstatus` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) DEFAULT '0',
  `campcategoryid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `originaltransid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateinserted` datetime NOT NULL,
  `stcommtype` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st2affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st2commission` float DEFAULT NULL,
  `st3affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st3commission` float DEFAULT NULL,
  `st4affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st4commission` float DEFAULT NULL,
  `st5affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st5commission` float DEFAULT NULL,
  `st6affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st6commission` float DEFAULT NULL,
  `st7affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st7commission` float DEFAULT NULL,
  `st8affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st8commission` float DEFAULT NULL,
  `st9affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st9commission` float DEFAULT NULL,
  `st10affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `st10commission` float DEFAULT NULL,
  PRIMARY KEY (`recurringcommid`),
  UNIQUE KEY `IDX_wd_pa_recurringcommissions4` (`recurringcommid`),
  KEY `IDX_wd_pa_recurringcommissions1` (`campcategoryid`),
  KEY `IDX_wd_pa_recurringcommissions2` (`affiliateid`),
  KEY `IDX_wd_pa_recurringcommissions3` (`originaltransid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_rules`
--

DROP TABLE IF EXISTS `wd_pa_rules`;
CREATE TABLE `wd_pa_rules` (
  `ruleid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cond_when` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cond_in` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cond_is` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cond_value1` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cond_value2` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cond_action` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cond_action_value` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `campaignid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ruleid`,`accountid`,`campaignid`),
  KEY `IDX_wd_pa_rules1` (`accountid`),
  KEY `IDX_wd_pa_rules2` (`campaignid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_tokens`
--

DROP TABLE IF EXISTS `wd_pa_tokens`;
CREATE TABLE `wd_pa_tokens` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `insertime` int(10) unsigned NOT NULL,
  `securitycode1` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `securitycode2` char(32) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `insertime` (`insertime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_transactions`
--

DROP TABLE IF EXISTS `wd_pa_transactions`;
CREATE TABLE `wd_pa_transactions` (
  `transid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rstatus` tinyint(4) NOT NULL DEFAULT '0',
  `dateinserted` datetime DEFAULT NULL,
  `dateapproved` datetime DEFAULT NULL,
  `transtype` smallint(6) DEFAULT '0',
  `payoutstatus` tinyint(4) DEFAULT '1',
  `datepayout` datetime DEFAULT NULL,
  `cookiestatus` tinyint(4) DEFAULT NULL,
  `orderid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `totalcost` float DEFAULT NULL,
  `bannerid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rotatorid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `transkind` tinyint(4) DEFAULT '0',
  `refererurl` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `campcategoryid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parenttransid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commission` float DEFAULT '0',
  `ip` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `countrycode` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recurringcommid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accountingid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `productid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data1` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data2` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data3` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `count` int(11) DEFAULT '1',
  PRIMARY KEY (`transid`),
  UNIQUE KEY `IDX_wd_pa_transactions7` (`transid`),
  KEY `IDX_pa_transactions_2` (`dateinserted`),
  KEY `IDX_pa_transactions_3` (`transkind`,`transtype`,`rstatus`),
  KEY `IDX_pa_transactions_4` (`campcategoryid`),
  KEY `IDX_wd_pa_transactions4` (`bannerid`),
  KEY `IDX_wd_pa_transactions5` (`affiliateid`),
  KEY `IDX_wd_pa_transactions6` (`parenttransid`),
  KEY `IDX_wd_pa_transactions8` (`recurringcommid`),
  KEY `IDX_wd_pa_transactions9` (`accountingid`),
  KEY `IDX_wd_pa_transactions10` (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pa_transactions_tmp`
--

DROP TABLE IF EXISTS `wd_pa_transactions_tmp`;
CREATE TABLE `wd_pa_transactions_tmp` (
  `transid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `accountid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rstatus` tinyint(4) NOT NULL DEFAULT '0',
  `dateinserted` datetime DEFAULT NULL,
  `dateapproved` datetime DEFAULT NULL,
  `transtype` smallint(6) DEFAULT '0',
  `payoutstatus` tinyint(4) DEFAULT '1',
  `datepayout` datetime DEFAULT NULL,
  `cookiestatus` tinyint(4) DEFAULT NULL,
  `orderid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `totalcost` float DEFAULT NULL,
  `bannerid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rotatorid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `transkind` tinyint(4) DEFAULT '0',
  `refererurl` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `affiliateid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `campcategoryid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parenttransid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commission` float DEFAULT '0',
  `ip` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `countrycode` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recurringcommid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accountingid` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `productid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data1` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data2` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data3` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `count` int(11) DEFAULT '1',
  PRIMARY KEY (`transid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pz_cates`
--

DROP TABLE IF EXISTS `wd_pz_cates`;
CREATE TABLE `wd_pz_cates` (
  `ID` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `catename` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `displaysort` int(2) NOT NULL,
  `catedesc` tinytext COLLATE utf8_unicode_ci,
  `dateinserted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `show2nav` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pz_links`
--

DROP TABLE IF EXISTS `wd_pz_links`;
CREATE TABLE `wd_pz_links` (
  `ID` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `sitetitle` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `siteurl` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `logourl` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rsort` int(2) NOT NULL DEFAULT '0',
  `rstatus` char(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'show',
  `dateinserted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pz_posts`
--

DROP TABLE IF EXISTS `wd_pz_posts`;
CREATE TABLE `wd_pz_posts` (
  `ID` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `cateid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `authorid` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `postime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `title` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `context` text COLLATE utf8_unicode_ci NOT NULL,
  `show2nav` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- 表的结构 `wd_pz_settings`
--

DROP TABLE IF EXISTS `wd_pz_settings`;
CREATE TABLE `wd_pz_settings` (
  `ID` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `svalue` text COLLATE utf8_unicode_ci NOT NULL,
  `autoload` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
