<?php
/**
* 公农历转换(1912 - 2012)
* 原作者：彭宏杰 ，由原Delphi Unit 转换为 PHP Class
* @author    hemon <[email=hemono@gmail.com]hemono@gmail.com[/email]>
* @Id: Lunar.php,v 1.0 2007/10/04 01:41:39$
*
* Usage:
*   // 公历1983-10-5转农历
*   $lunar = new Lunar();
*   $date = $lunar->getLar('1983-10-5',0);
*   echo date("Y-m-d", $date);
*   // 农历1983-8-29转公历
*   $date = $lunar->getLar('1983-8-29',1);
*   echo date("Y-m-d", $date);
*
* @param string 日期
* @param int    日期历法
*      - 0 公历
*        1 农历
*
* @return timestamp

   
   这是一个国历与农历互相转的Unit.

   其中年份皆用民国年份, 请自行转换 (西元年-1911 = 民国年).
   ***************************************************************************
   *国农历对映表之说明 :                                                     *
   ***************************************************************************
   *  前二数字 = 闰月月份, 如果为 13 则没有闰月                              *
   *  第叁至第六数字 = 12 个月之大小月之2进位码->10进位                      *
   *  例如:                                                                  *
   *       101010101010 = 2730                                               *
   *       1 : 代表大月(30天) 0 : 代表小月(29天) ==> 1月大2月小3月大.....    *
   *  第七位数字为闰月天数                                                   *
   *           0 : 没有闰月之天数                                            *
   *           1 : 闰月为小月(29天)                                          *
   *           2 : 闰月为大月(30天)                                          *
   *  最後2位数字代表阳历之1月1日与阴历之1月1日相差天数                      *
   ***************************************************************************
   这对映表只有民国一年至民国一百年, 如不敷您的使用请按照上述之方式自行增加.

   这个程式没有判断您所输入之年,月,日是否正确, 请自行判断.

   如果转换出来之农历的月份是闰月则传给您的值是***负数***
   如果农历要转换国历如果是闰月请输入***负数***

   此版本为FreeWare   Version : 0.1
   您可以自行修改, 但最好可以将修改过之程式Mail一份给我.
   如果您要用於商业用途, 请mail给我告知您的用途及原因.

   作者 : 彭宏杰
   E-Mail : [email=rexpeng@ms1.hinet.net]rexpeng@ms1.hinet.net[/email]
   
*/

/*
	云南省曲靖师范学院计算机科学与工程学院-杨海熙编写
	2009-9-3
*/	
class Lunar
{
	private  $_SMDay = array(1 => 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);//定义公历月分天数
	private  $_LStart = 1950 ;//农历从1950年开始
	private  $_LMDay = array(
	//差：该年的农历正月初一到该年公历1月1日的天数；1~12：农历月份天数；闰：如有闰月，记录该月平月天数
	//    差  1  2  3  4  5  6  7  8  9 10 11 12 闰
	array(47,29,30,30,29,30,30,29,29,30,29,30,29),
	array(36,30,29,30,30,29,30,29,30,29,30,29,30),
    array(6,29,30,29,30,59,29,30,30,29,30,29,30,29),    //五月29 闰五月30
   	array(44,29,30,29,29,30,30,29,30,30,29,30,29),
    array(33,30,29,30,29,29,30,29,30,30,29,30,30),
    array(23,29,30,59,29,29,30,29,30,29,30,30,30,29),    //三月29 闰三月30
    array(42,29,30,29,30,29,29,30,29,30,29,30,30),
    array(30,30,29,30,29,30,29,29,59,30,29,30,29,30),    //八月30 闰八月29
    array(48,30,30,30,29,30,29,29,30,29,30,29,30),
    array(38,29,30,30,29,30,29,30,29,30,29,30,29),
    array(27,30,29,30,29,30,59,30,29,30,29,30,29,30),    //六月30 闰六月29
    array(45,30,29,30,29,30,29,30,30,29,30,29,30),
    array(35,29,30,29,29,30,29,30,30,29,30,30,29),
    array(24,30,29,30,58,30,29,30,29,30,30,30,29,29),    //四月29 闰四月29
    array(43,30,29,30,29,29,30,29,30,29,30,30,30),
    array(32,29,30,29,30,29,29,30,29,29,30,30,29),
    array(20,30,30,59,30,29,29,30,29,29,30,30,29,30),    //三月30 闰三月29
    array(39,30,30,29,30,30,29,29,30,29,30,29,30),
    array(29,29,30,29,30,30,29,59,30,29,30,29,30,30),    //七月30 闰七月29
    array(47,29,30,29,30,29,30,30,29,30,29,30,29),
    array(36,30,29,29,30,29,30,30,29,30,30,29,30),
    array(26,29,30,29,29,59,30,29,30,30,30,29,30,30),    //五月30 闰五月29
    array(45,29,30,29,29,30,29,30,29,30,30,29,30),
    array(33,30,29,30,29,29,30,29,29,30,30,29,30),
    array(22,30,30,29,59,29,30,29,29,30,30,29,30,30),    //四月30 闰四月29
    array(41,30,30,29,30,29,29,30,29,29,30,29,30),
    array(30,30,30,29,30,29,30,29,59,29,30,29,30,30),    //八月30 闰八月29
    array(48,30,29,30,30,29,30,29,30,29,30,29,29),
    array(37,30,29,30,30,29,30,30,29,30,29,30,29),
    array(27,30,29,29,30,29,60,29,30,30,29,30,29,30),    //六月30 闰六月30
    array(46,30,29,29,30,29,30,29,30,30,29,30,30),
    array(35,29,30,29,29,30,29,29,30,30,29,30,30),
    array(24,30,29,30,58,30,29,29,30,29,30,30,30,29),    //四月29 闰四月29
    array(43,30,29,30,29,29,30,29,29,30,29,30,30),
    array(32,30,29,30,30,29,29,30,29,29,59,30,30,30),    //十月30 闰十月29
    array(50,29,30,30,29,30,29,30,29,29,30,29,30),
    array(39,29,30,30,29,30,30,29,30,29,30,29,29),
    array(28,30,29,30,29,30,59,30,30,29,30,29,29,30),    //六月30 闰六月29
    array(47,30,29,30,29,30,29,30,30,29,30,30,29),
    array(36,30,29,29,30,29,30,29,30,29,30,30,30),
    array(26,29,30,29,29,59,29,30,29,30,30,30,30,30),    //五月30 闰五月29
    array(45,29,30,29,29,30,29,29,30,29,30,30,30),
    array(34,29,30,30,29,29,30,29,29,30,29,30,30),
    array(22,29,30,59,30,29,30,29,29,30,29,30,29,30),    //三月30 闰三月29
    array(40,30,30,30,29,30,29,30,29,29,30,29,30),
    array(30,29,30,30,29,30,29,30,59,29,30,29,30,30),    //八月30 闰八月29
    array(49,29,30,29,30,30,29,30,29,30,30,29,29),
    array(37,30,29,30,29,30,29,30,30,29,30,30,29),
    array(27,30,29,29,30,58,30,30,29,30,30,29,30,29),    //五月29 闰五月29
    array(46,30,29,29,30,29,29,30,29,30,30,30,29),
    array(35,30,30,29,29,30,29,29,30,29,30,30,29),
    array(23,30,30,29,59,30,29,29,30,29,30,29,30,30),    //四月30 闰四月29
    array(42,30,30,29,30,29,30,29,29,30,29,30,29),
    array(31,30,30,29,30,30,29,30,29,29,30,29,30),
    array(21,29,59,30,30,29,30,29,30,29,30,29,30,30),    //二月30 闰二月29
    array(39,29,30,29,30,29,30,30,29,30,29,30,29),
    array(28,30,29,30,29,30,29,59,30,30,29,30,30,30),    //七月30 闰七月29
    array(48,29,29,30,29,29,30,29,30,30,30,29,30),
    array(37,30,29,29,30,29,29,30,29,30,30,29,30),
    array(25,30,30,29,29,59,29,30,29,30,29,30,30,30),    //五月30 闰五月29
    array(44,30,29,30,29,30,29,29,30,29,30,29,30),
    array(33,30,29,30,30,29,30,29,29,30,29,30,29),
    array(22,30,29,30,59,30,29,30,29,30,29,30,29,30),    //四月30 闰四月29
    array(40,30,29,30,29,30,30,29,30,29,30,29,30),
    array(30,29,30,29,30,29,30,29,30,59,30,29,30,30),    //九月30 闰九月29
    array(49,29,30,29,29,30,29,30,30,30,29,30,29),
    array(38,30,29,30,29,29,30,29,30,30,29,30,30),
    array(27,29,30,29,30,29,59,29,30,29,30,30,30,29),    //六月29 闰六月30
    array(46,29,30,29,30,29,29,30,29,30,29,30,30),
    array(35,30,29,30,29,30,29,29,30,29,29,30,30),
    array(24,29,30,30,59,30,29,29,30,29,30,29,30,30),    //四月30 闰四月29
    array(42,29,30,30,29,30,29,30,29,30,29,30,29),
    array(31,30,29,30,29,30,30,29,30,29,30,29,30),
    array(21,29,59,29,30,30,29,30,30,29,30,29,30,30),    //二月30 闰二月29
    array(40,29,30,29,29,30,29,30,30,29,30,30,29),
    array(28,30,29,30,29,29,59,30,29,30,30,30,29,30),    //六月30 闰六月29
    array(47,30,29,30,29,29,30,29,29,30,30,30,29),
    array(36,30,30,29,30,29,29,30,29,29,30,30,29),
    array(25,30,30,30,29,59,29,30,29,29,30,30,29,30),    //五月30 闰五月29
    array(43,30,30,29,30,29,30,29,30,29,29,30,30),
    array(33,29,30,29,30,30,29,30,29,30,29,30,29),
    array(22,29,30,59,30,29,30,30,29,30,29,30,29,30),    //三月30 闰三月29
    array(41,30,29,29,30,29,30,30,29,30,30,29,30),
    array(30,29,30,29,29,30,29,30,29,30,30,59,30,30),    //十一月30 闰十一月29
    array(49,29,30,29,29,30,29,30,29,30,30,29,30),
    array(38,30,29,30,29,29,30,29,29,30,30,29,30),
    array(27,30,30,29,30,29,59,29,29,30,29,30,30,29),    //六月29 闰六月30
    array(45,30,30,29,30,29,29,30,29,29,30,29,30),
    array(34,30,30,29,30,29,30,29,30,29,29,30,29),
    array(23,30,30,29,30,59,30,29,30,29,30,29,29,30),    //五月30 闰五月29
    array(42,30,29,30,30,29,30,29,30,30,29,30,29),
    array(31,29,30,29,30,29,30,30,29,30,30,29,30),
    array(21,29,59,29,30,29,30,29,30,30,29,30,30,30),    //二月30 闰二月29
    array(40,29,30,29,29,30,29,29,30,30,29,30,30),
    array(29,30,29,30,29,29,30,58,30,29,30,30,30,29),    //七月29 闰七月29
    array(47,30,29,30,29,29,30,29,29,30,29,30,30),
    array(36,30,29,30,29,30,29,30,29,29,30,29,30),
    array(25,30,29,30,30,59,29,30,29,29,30,29,30,29),    //五月29 闰五月30
    array(44,29,30,30,29,30,30,29,30,29,29,30,29),
    array(32,30,29,30,29,30,30,29,30,30,29,30,29),
    array(22,29,30,59,29,30,29,30,30,29,30,30,29,29),    //三月29 闰三月30		
	);
	//是否闰年
	private function IsLeapYear($AYear){
        return ($AYear % 4 == 0) && (($AYear % 100 != 0) || ($AYear % 400 == 0));
	}
	//公历该月的天数(year：年份； month：月份)
	private function GetSMon($year,$month)
	{
		if($this->IsLeapYear($year) && $month == 2)
			return 29;
		else
			return $this->_SMDay[$month];
	}
	//农历名称转换
	private function LYearName($year)
	{
		$Name = array("零","一","二","三","四","五","六","七","八","九");
		for($i=0;$i<4;$i++)
			for($k=0;$k<10;$k++)
				if($year[$i]==$k)
					$tmp.=$Name[$k];
		return $tmp;
	}
	
	private function LMonName($month)
	{
		if($month >=1 && $month <=12 )
		{
			$Name = array( 1=>"正","二","三","四","五","六","七","八","九","十","十一","十二");
			return $Name[$month];
		}
		return $month;
	}
	
	private function LDayName($day)
	{
		if($day >=1 && $day <=30 )
		{
			$Name = array( 1 =>
			"初一","初二","初三","初四","初五","初六","初七","初八","初九","初十",
			"十一","十二","十三","十四","十五","十六","十七","十八","十九","二十",
			"廿一","廿二","廿三","廿四","廿五","廿六","廿七","廿八","廿九","三十"
			);
			return $Name[$day];
		} 
		return $day;
	}
	
	public function getLar($date, $isLunar = 1){
        if($isLunar == 1)
            return $this->Lunar2Solar($date);
        else
            return $this->Solar2Lunar($date);
    }
	
	//公历转农历(Sdate：公历日期)
	public function Solar2Lunar($date)
	{
		list($year, $month, $day) = explode("-", $date);
		if($year <= 1951 || $month <= 0 || $day <= 0 || $year >= 2051 )	return false;
		//获取查询日期到当年1月1日的天数
		$date1 = strtotime($year."-01-01");//当年1月1日
		$date2 = strtotime($year."-".$month."-".$day);
		$days=round(($date2-$date1)/3600/24);
		$days += 1;
		//获取相应年度农历数据，化成数组Larray
		$Larray = $this->_LMDay[$year - $this->_LStart];
		if($days <= $Larray[0])
		{
			$Lyear = $year - 1;
			$days = $Larray[0] - $days;
			$Larray = $this->_LMDay[$Lyear - $this->_LStart];
			if($days < $Larray[12])
			{
				$Lmonth = 12;
				$Lday = $Larray[12] - $days;
			}
			else
			{
				$Lmonth = 11;
				$days = $days - $Larray[12];
				$Lday = $Larray[11] - $days;
			}			
		}
		else
		{
			$Lyear = $year;
			$days = $days - $Larray[0];
			for($i = 1;$i <= 12;$i++)
			{
				if($days > $Larray[$i]) $days = $days - $Larray[$i];
				else 
				{
					if ($days > 30){
						$days = $days - $Larray[13];
						$Ltype = 1;
					}
				
					$Lmonth = $i;
					$Lday = $days;
					break;
				}
			}
		}
		return mktime(0, 0, 0, $Lmonth, $Lday, $Lyear);
		//$Ldate = $Lyear."-".$Lmonth."-".$Lday;
		//$Ldate = $this->LYearName($Lyear)."年".$this->LMonName($Lmonth)."月".$this->LDayName($Lday);
		//if($Ltype) $Ldate.="(闰)";
		//return $Ldate;
	}
	//农历转公历(date：农历日期； type：是否闰月)
	public function Lunar2Solar($date,$type = 0)
	{
		list($year, $month, $day) = split("-",$date);
		if($year <= 1951 || $month <= 0 || $day <= 0 || $year >= 2051 )	return false;
		$Larray = $this->_LMDay[$year - $this->_LStart];
		if($type == 1 && count($Larray)<=12 ) return false;//要求查询闰，但查无闰月
		//如果查询的农历是闰月并该年度农历数组存在闰月数据就获取
		if($Larray[$month]>30 && $type == 1 && count($Larray) >=13)	$day = $Larray[13] + $day;
		//获取该年农历日期到公历1月1日的天数
		$days = $day;
		for($i=0;$i<=$month-1;$i++)
			$days += $Larray[$i];
		//当查询农历日期距离公历1月1日超过一年时
		if($days > 366 || ($this->GetSMon($month,2)!=29 && $days>365 ))
		{
			$Syear = $year +1;
			if($this->GetSMon($month,2)!=29) 
				$days-=366;
			else
				$days-=365;
			if($days > $this->_SMDay[1]) 
			{
				$Smonth = 2;
				$Sday = $days - $this->_SMDay[1];
			}
			else
			{
				$Smonth = 1;
				$Sday = $days;
			}		
		}
		else
		{
			$Syear =$year;
			for($i=1;$i<=12;$i++)
			{
				if($days > $this->GetSMon($Syear,$i))
					$days-=$this->GetSMon($Syear,$i);
				else
				{
					$Smonth = $i;
					$Sday = $days;
					break;
				}
			}
		}
		return mktime(0, 0, 0, $Smonth, $Sday, $Syear);
		//$Sdate = $Syear."-".$Smonth."-".$Sday;
		//return $Sdate;
	}
}

/*
$lunar = new Lunar();
$today = date("Y-m-d");
//公历转农历
$nl = date("Y-m-d",$lunar->Solar2Lunar($today));

//农历转公历
$gl = date("Y-m-d",$lunar->Lunar2Solar($nl));	

echo "今天公历是:$today<br/>";
echo "转为农历是:$nl<br/>";
echo "转回公历是:$gl<br/>";
exit;
*/

/*
class Lunar {
    var $LMDay = array();
    var $InterMonth = 0;
    var $InterMonthDays = 0;
    var $SLRangeDay = 0;

    var $SMDay = array(1 => 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    var $LongLife = array( 1 =>
    '132637048', '133365036', '053365225', '132900044', '131386034', '022778122', //6
    '132395041', '071175231', '131175050', '132635038', '052891127', '131701046', //12
    '131748035', '042741223', '130694043', '132391032', '021327122', '131175040', //18
    '061623129', '133402047', '133402036', '051769125', '131453044', '130694034', //24
    '032158223', '132350041', '073213230', '133221049', '133402038', '063466226', //30
    '132901045', '131130035', '042651224', '130605043', '132349032', '023371121', //36
    '132709040', '072901128', '131738047', '132901036', '051333226', '131210044', //42
    '132651033', '031111223', '131323042', '082714130', '133733048', '131706038', //48
    '062794127', '132741045', '131206035', '042734124', '132647043', '131318032', //54
    '033878120', '133477039', '071461129', '131386047', '132413036', '051245126', //60
    '131197045', '132637033', '043405122', '133365041', '083413130', '132900048', //66
    '132922037', '062394227', '132395046', '131179035', '042711124', '132635043', //72
    '102855132', '131701050', '131748039', '062804128', '132742047', '132359036', //78
    '051199126', '131175045', '131611034', '031866122', '133749040', '081717130', //84
    '131452049', '132742037', '052413127', '132350046', '133222035', '043477123', //90
    '133402042', '133493031', '021877121', '131386039', '072747128', '130605048', //96
    '132349037', '053243125', '132709044', '132890033');
   
    function getLar($date, $isLunar = 1){
        list($year, $month, $day) = explode("-", $date);
        if($isLunar == 1)
            return $this->Lunar2Solar($year, $month, $day);
        else
            return $this->Solar2Lunar($year, $month, $day);
    }
   
    function IsLeapYear($AYear){
      return ($AYear % 4 == 0) and (($AYear % 100 <> 0) or ($AYear % 400 == 0));
    }
   
    function CovertLunarMonth($magicno){
         $m = $magicno;
         for ($i = 12; $i >= 1; $i--){
             $size = $m % 2;
             if ($size == 0)
                $this->LMDay[$i] = 29;
             else
                $this->LMDay[$i] = 30;
             $m = floor($m / 2);
         }
    }
   
    function ProcessMagicStr($yy){
         $yy = $yy - 1911;
         $magicstr = isset( $this->LongLife[$yy] ) ? $this->LongLife[$yy] : '';
         $this->InterMonth = substr($magicstr, 0, 2);
         $LunarMonth = substr($magicstr, 2, 4);
         $this->CovertLunarMonth($LunarMonth);
         $dsize = substr($magicstr, 6, 1);
         switch ($dsize) {
              case 0 :
                $this->InterMonthDays = 0;
                break;
              case 1 :
                $this->InterMonthDays = 29;
                break;
              case 2 :
                $this->InterMonthDays = 30;
                break;
         }
         $this->SLRangeDay = substr($magicstr, 7, 2);
    }
   
    function DaysPerLunarMonth($LYear, $LMonth){
         $this->ProcessMagicStr($LYear);
         if ($LMonth < 0)
            return $this->InterMonthDays;
         else
            return $this->LMDay[$LMonth];
    }
   
    function Solar2Lunar($SYear, $SMonth, $SDay){
         if( !(1912 <= $SYear && $SYear <= 2012) ){
            return false;
         }
         $day = 0;
         if ($this->isLeapYear($SYear))
            $this->SMDay[2] = 29;
         $this->ProcessMagicStr($SYear);
         if ($SMonth == 1)
            $day = $SDay;
         else {
            for($i = 1; $i <= $SMonth-1; $i++)
                $day = $day + $this->SMDay[$i];
            $day = $day + $SDay;
         }
         if ($day <= $this->SLRangeDay) {
            $day = $day - $this->SLRangeDay;
            $this->processmagicstr($SYear-1);
            for ($i = 12; $i >= 1; $i--){
                $day = $day + $this->LMDay[$i];
                if ($day > 0)
                   break;
            }
            $LYear = $SYear - 1;
            $LMonth = $i;
            $LDay = $day;
         } else {
            $day = $day - $this->SLRangeDay;
            for($i = 1; $i <= $this->InterMonth-1; $i++){
                $day = $day - $this->LMDay[$i];
                if ($day <= 0)
                   break;
            }
            if ($day <= 0) {
               $LYear = $SYear;
               $LMonth = $i;
               $LDay = $day + $this->LMDay[$i];
            } else {
               $day = $day - $this->LMDay[$this->InterMonth];
               if ($day <= 0) {
                  $LYear = $SYear;
                  $LMonth = $this->InterMonth;
                  $LDay = $day + $this->LMDay[$this->InterMonth];
               } else {
                  $this->LMDay[$this->InterMonth] = $this->InterMonthDays;
				  var_dump($this->LMDay);
				  var_dump($day);
				  //exit;
                  for ($i = $this->InterMonth; $i <= 12; $i++){
                      $day = $day - $this->LMDay[$i];
					  var_dump( $day .'-'. $this->LMDay[$i] );
                      if ($day <= 0)
                         break;
                  }
                  if ($i == $this->InterMonth)
                     $LMonth = 0 - $this->InterMonth;
                  else
                     $LMonth = $i;
                  $LYear = $SYear;
                  $LDay = $day + $this->LMDay[$i];
               }
            }
         }
         return mktime(0, 0, 0, $LMonth, $LDay, $LYear);
    }
   
    function Lunar2Solar($LYear, $LMonth, $LDay){
         if( !(1912 <= $LYear && $LYear <= 2012) ){
            return false;
         }
         $day = 0;
         $SYear = $LYear;
         if ($this->isLeapYear($SYear))
            $this->SMDay[2] = 29;
         $this->processmagicstr($SYear);
         if ($LMonth < 0)
            $day = $this->LMDay[$this->InterMonth];
         if ($LMonth <> 1)
            for ($i = 1; $i <= $LMonth-1; $i++)
                $day = $day + $this->LMDay[$i];
         $day = $day + $LDay + $this->SLRangeDay;
         if (($this->InterMonth <> 13) and ($this->InterMonth < $LMonth))
            $day = $day + $this->InterMonthDays;
         for ($i = 1; $i <= 12; $i++){
             $day = $day - $this->SMDay[$i];
             if ($day <= 0)
                break;
         }
         if ($day > 0) {
            $SYear = $SYear + 1;
            if ($this->isLeapYear($SYear))
               $this->SMDay[2] = 29;
            for ($i = 1; $i <= 12; $i++){
                $day = $day - $this->SMDay[$i];
                if ($day <= 0)
                   break;
            }
         }
         $day = $day + $this->SMDay[$i];
         $SMonth = $i;
         $SDay = $day;
         return mktime(0, 0, 0, $SMonth, $SDay, $SYear);
    }
}
*/
?>