<?php

class Module{
	
	//类初始化
	public static function init(){
		//$s = microtime();
		//self :: hooks_push();
		//$e = microtime();
		//echo $e - $s;
		//echo '<br />';
		
		self :: get_list();
		
	}
	
	/*
			是否存在此模块
			$appid	模块ID
			$return         true | false
	*/
	public static function exists( $appid ){
		return file_exists( VI_ROOT . 'module/'. $appid ) && is_dir( VI_ROOT . 'module/'. $appid );                
	}
	
	 /*
			加载模块配置及函数（类）
			$appid	模块ID
			$return         true | false
	*/
	public static function loader( $appid ){
		global $_G;
		
		$appid = strtolower( $appid );

		//如果存在此模块
		if( self :: exists( $appid ) ){
		
			//加载配置
			require_once VI_ROOT . 'module/'. $appid .'/config.php';
			
			//加载设置
			if( file_exists( VI_ROOT . 'module/'. $appid .'/setting.php' ) ){
				require_once VI_ROOT . 'module/'. $appid .'/setting.php';
			}
			
			//加载导航
			if( file_exists( VI_ROOT . 'module/'. $appid .'/navigate.php' ) ){
				require_once VI_ROOT . 'module/'. $appid .'/navigate.php';
			}
			
			//加载函数
			if( file_exists( VI_ROOT . 'module/'. $appid .'/function.php' ) ){
				require_once VI_ROOT . 'module/'. $appid .'/function.php';
			}
			
			return true;
		}else{                        
			return false;
		}
						
	}
	
	//////////////////////////////////
	
	/*
		获取当前模块ID（只能使用于模块目录下）
	*/
	public static function get_appid(){
		global $_G;
		
		//当前相对目录
		$base = str_replace( array( VI_ROOT, '\\' ), array( '','/' ), getcwd() );
		
		//模块起始目录
		if( strpos( $base, 'module/' ) === 0 ){
			
			//模块根目录
			if( substr_count( $base, '/' ) == 1 ){
				return substr( $base, 7 );
			}else{
				//获得 module/ 之后最近一个斜线的索引
				$last = strpos( $base, '/', 7 );
				return substr( $base, 7, $last - 7 );
			}
			
		}
		
	}
	
	/*
			获取某模块前台访问地址
			$appid	模块ID
	*/
	public static function get_index( $appid ){
		global $_G;

		//如果存在此模块
		if( self :: exists( $appid ) ){

			//加载配置
			require_once VI_ROOT . 'module/'. $appid .'/setting.php';
			
			return $_G['setting'][$appid]['domain'] ? $_G['setting'][$appid]['domain'] : VI_HOST.'module/'.$appid.'/content/';                
		}
	
	}
	
	/*
			生成获取某模块前台访问地址
			$appid	模块ID
	*/
	public static function get_naver( $appid ){
		global $_G;
		global $_CACHE;

		//首页地址
		$link = self :: get_index( $appid );
		
		//如果需要关闭
		if( $link && $_G['setting'][$appid]['hooks'] == 'off' ) return;
		
		//模块名称
		$name = $_CACHE['system']['module'][$appid]['name'];
		
		return '<a href="'.$link.'">'.$name.'</a>';
	
	}
	
	/*
			创建并返回模块对应的编译目录
			$appid	模块ID
	*/
	public static function get_static( $appid ){
		return create_dir( VI_ROOT.'static/'.$appid );                
	}
	
	/*
			创建并返回模块对应的编译目录
			$appid	模块ID
	*/
	public static function get_content( $appid, $dir ){
		return VI_ROOT.'module/'.$appid.'/content/'.$dir;                
	}
	
			
	/*
			删除模块全部静态缓存
			$appid	模块ID
	*/
	public static function clear_static( $appid ){
	
			$base = VI_ROOT."static/".$appid;
	
			//先删除目录
			delete_dir( $base );
			
			//创建子目录
			create_dir( $self, true );
			
	}
	
	/*
		扫描模块，缓存所有Hock
		$modid 	模块ID
		$state	设置状态
				true 启用 false 禁用
	*/
	public static function hooks_push($debug=false){
		global $_G;
		global $_CACHE;
		
		$_G['hooks'] = array();
		
		//遍历模块
		foreach($_CACHE['system']['module'] as $key){
				
			if( isset($key["config"]) && $key["config"] && $key["state"] ){
			
				//conf
				$conf = VI_ROOT.$key["config"];
				
				//func
				$func = str_replace("config.php","function.php",$conf);
				
				//忽略不存在的模块
				if( !file_exists($conf) || !file_exists($func) ) continue;
				
				//载入 conf
				require_once($conf);
				
				//有配置hock选项
				if( isset($_G['module'][$key["appid"]]['hooks']) && is_array($_G['module'][$key["appid"]]['hooks']) ){
					
					//载入 func
					require_once($func);
					
					foreach( $_G['module'][$key["appid"]]['hooks'] as $hck => $fun ){
						
						if( function_exists($fun) ){						
							if( isset($_G['hooks'][$hck]) && is_array($_G['hooks'][$hck]) ){
								array_push($_G['hooks'][$hck],$fun);
							}else{
								$_G['hooks'][$hck] = array($fun);
							}					
						}
							
					}
				}
				
			}
		
		}
		
		if($debug){
			echo '<pre>';
			var_dump($_G['hooks']);
			echo '</pre>';
		}
		
		return $_G['hooks'];
		
	}
	
	public static function hooks_func( $func ){
		
		//匹配色子语句
		preg_match( "/(.*)\((.*)\)/", $func, $matche );
		
		//提取函数和参数
		list( , $func, $parm ) = $matche;
		$parm = split( ',', $parm );
		
		if( strpos( $func, '::' ) !== FALSE ){
			
			$fun = split( '::', $func );
			
			//加载模块
			self :: loader( $fun[0] );
			
			return call_user_func_array( array( $fun[0], $fun[1]), $parm );
		}else{
			return call_user_func_array( $func, $parm );
		}
		
	}
	
	/*
		输出当前 Hock
		$key	Hock索引
	*/
	public static function hooks_slice($key){
		global $_G;
		global $_CACHE;
		
		$res = '';
		
		foreach( $_CACHE['system']['module'] as $appid => $module ){
			$func = $module['hooks'][$key];
			if( isset( $module['hooks'] ) && isset( $func ) ){
				$res .= self :: hooks_func( $func );
			}
		}
		
		return $res;
		
		//var_dump($_G['hooks'][$key]);
		
		/*
		if( !isset($_G['hooks'][$key]) || !is_array($_G['hooks'][$key]) ) return "<!--hock $key null-->";
		
		//遍历模块
		foreach($_G['hooks'][$key] as $val){
			
			if( function_exists($val) ){
				$res .= $val();
			}else{
				$res .= $val;	
			}		
			
		}
		return $res."<!--$key hocked-->";
		*/
		
	}
	
	
	////////////////////////////////////////
	
	/*
			删除模块全部动态缓存
			$appid	模块ID
	*/
	public static function clear_cache( $appid ){
	
			$base = VI_ROOT."cache/".$appid;
	
			//先删除目录
			delete_dir( $base );
			
			//创建子目录
			create_dir( $self, true );
			
	}
	
	/*
			加载模块缓存信息并返回缓存文件地址
	*/
	public static function get_cache(){
			
	}
	
	/*
			加载模块缓存信息并返回缓存文件地址
	*/
	public static function get_list(){
		global $_CACHE;
		
		$file = VI_ROOT.'cache/system/files.module.php';
		file_exists( $file ) && require $file;
		return $file;
	}
	
	/*
			扫描关缓存模块信息
	*/
	public function search( $modid="", $state=true ){
		global $_G;
		global $_CACHE;
		
		//模块列表缓存文件
		$file = self :: get_list();
		
		$mod = loop_dir( dirname(__FILE__).'/../module/' );
		
		$cache ='<?php'.chr(13);
		$cache.=' /*'.date("Y-m-t H:i:s").'*/ '.chr(13);
		$cache.='$_CACHE[\'system\'][\'module\']=array('.chr(13);
		
		foreach( $mod as $appid ){
		
				//创建缓存目录
				create_dir( VI_ROOT.'cache/'.$appid );
				create_dir( VI_ROOT.'static/'.$appid );
												
				//配置文件
				$config = $_G['project']['module'].$appid.'/config.php';				
				
				//加载配置
				file_exists(VI_ROOT.$config) && require_once(VI_ROOT.$config);
				
				$item = '';
				
				//有配置文件
				if( is_array( $_G['module'][$appid] ) ){
						
					//设置模块状态
					if( $appid != $modid && $_G['module'][$appid]['model'] == "module" ){
							
							//发现新模块
							if( $_CACHE['system']['module'][$appid]['state'] || !$_SESSION['Manager']['id'] ){
									$sts = 'true';
							}else{
									$sts = 'false';
							}
							
					}else{
							$sts = ($state?'true':'false');
					}
					
					//新模块标识
					$newmod = '';
					if( !is_array( $_CACHE['system']['module'][$appid]) ){
							$newmod = ',"dateline" => '.time();
					}					
					
					$item = '	"'.$appid.'" => array("config" => "'.$config.'","name" => "'.$_G['module'][$appid]['name'].'","appid" => "'.$appid.'","serve" => "'.$_G['module'][$appid]["serve"].'","hooks" => '.var_export( $_G['module'][$appid]['hooks'], true ).',"state" => '.$sts.$newmod.'),'.chr(13).chr(13);
				
				//没有配置文件
				}else{
						$item = '	"'.$appid.'" => array("name" => "'.$appid.'","appid" => "'.$appid.'","state" => true),'.chr(13).chr(13);
				}
				
				$cache .= $item;
		}
		
		$cache.=");".chr(13).chr(13);
		$cache.="?>";
		
		//$cache = str_replace($item,str_replace('),',')',$item),$cache);
		
		//写入缓存
		return create_file( $file, $cache );
	}
	
	
	 /*
			扫描关缓存模块信息
			$appid	        模块ID
			$state          是否启用
	*/
	public static function set_state( $appid, $state=true ){
			global $_G;
			global $_CACHE;

			//模块列表缓存文件
			$file = self :: get_list();
			
			//设置状态
			$_CACHE['system']['module'][ $appid ]['state'] = $state;
			
			$text ='<?php'.chr(13);
			$text .=' /*'.date("Y-m-t H:i:s").'*/ '.chr(13);
			$text .= '$_CACHE[\'system\'][\'module\']='.var_export( $_CACHE['system']['module'], true );
			$text .= ';';
			
			if( $state ){
					//写入日志
					System :: insert_event($func,time(),time(),"启用模块成功：".$module);
			}else{
					//写入日志
					System :: insert_event($func,time(),time(),"禁用模块成功：".$module);
			}
			
			//写入缓存
			return create_file( $file, $text );
	
	}
	
	/*
			返回模块当前状态
			$appid	        模块ID
	*/
	public static function get_state( $appid ){
			global $_CACHE;

			//载入模块缓存
			$file = self :: get_list();
			
			//返回状态
			return $_CACHE['system']['module'][ $appid ]['state'];
				   
	}
	
	//////////////////////////////////
		
	//处理表单数据标签
	public static function parse_form($array){
		//global $_G['module'];
		
		$html = str_replace(chr(13),'<br />',$array["description"]);
		$html = str_replace("\$VIEW","<span id='form-".$array["id"]."-view'>0</span>",$html);
		$html = str_replace("\$COUNT","<span id='form-".$array["id"]."-count'>0</span>",$html);
		$html = str_replace("\$CLOCK","<span id='form-".$array["id"]."-clock' rel='".$array["expire"]."'></span>",$html);
		$html = str_replace("\$SEARCH",'<a href="?action=state&id='.$array["id"].'">用户列表</a>',$html);
		$html = ubb_basic($html);
			
		//Flash
		$html = preg_replace("/\[(header)=(.+?|),(.+?|),(.+?|)\]([^<>]*?)\[\/(header)\]/is",'<embed width="\\2" height="\\3" src="\\5" style="\\4" wmode="transparent"></header>',$html);
		
		return stripslashes( $html );
	}
	
	//////////////////////////////////
	
	/*
			安装某一模块
			$appid	        模块ID
	*/
	public static function install( $appid, $func ){
		global $_G;
			
			//缓存目录
			$dir = VI_ROOT.$_G['project']['cache']."system/";
			
			//创建子文件夹
			$folder = create_dir($dir);
			
			//当前模块目录
			$base = VI_ROOT.$_G['project']['module'].$appid;
	
			//脚本文件
			$exec = $base.'/install.sql';
	
			//锁文件
			$lock = $base.'/install.lock';
			
			if( file_exists($lock) ){
					
					//echo '<div id="state" class="failure">抱歉！当前模块已安装（'.$module.'）</div>';
					return 'lock';
					
			}elseif( !file_exists($exec) ){
					
					//echo '<div id="state" class="failure">抱歉！未找到安装脚本（'.$module.'）</div>';
					return 'exec';
					
			}else{
			
					//创建缓存目录
					create_dir( VI_ROOT.'cache/'.$appid );
					create_dir( VI_ROOT.'static/'.$appid );
			
					$sql = file_get_contents( $exec );                
					$array = Database :: query( $sql );
					
					if(!$array[0]){
					
							//写入锁
							create_file( $lock ,date("Y-m-d H:i:s"));
							
							//删除卸载锁
							@unlink( $base.'/uninstall.lock' );
							
							//启用本模块
							self :: set_state( $appid, true );
					
							//写入日志
							System :: insert_event( $func, time(),time(), "安装模块成功：".$appid );
							
							//echo '<div id="state">恭喜！成功安装模块（'.$module.'）</div>';
							return 'done';
							
					}else{
							
							//trigger_error(str_replace('class="error"','class="text-no"',preg_replace('/<h4>(.*?)<\/h4>/','',$array[1])), E_USER_ERROR);
							
							//echo '<div id="state" class="failure">抱歉！安装模块（'.$module.'）失败，以下是本错误信息详细报告：</div>';
							return 'stop';
							
					}
					
			}
			
	}
	
	/*
			卸载某一模块
			$appid	        模块ID
	*/
	public static function uninstall( $appid, $func ){
		global $_G;
	
			//当前模块目录
			$base = VI_ROOT.$_G['project']['module'].$appid;
	
			//脚本文件
			$exec = $base.'/uninstall.sql';
	
			//锁文件
			$lock = $base.'/uninstall.lock';
			
			if( file_exists($lock) ){
					
					//echo '<div id="state" class="failure">抱歉！当前模块已卸载（'.$module.'）</div>';
					return 'lock';
					
			}elseif( !file_exists($exec) ){
					
					//echo '<div id="state" class="failure">抱歉！未找到卸载脚本（'.$module.'）</div>';
					return 'lock';
					
			}else{
			
					$sql = file_get_contents($exec);			
					$array = Database :: query( $sql );
					
					if(!$array[0]){
					
							//写入锁
							create_file( $lock ,date("Y-m-d H:i:s"));
							
							//删除安装锁
							@unlink( $base.'/install.lock' );
							
							//禁用本模块
							self :: set_state( $appid, false );
					
							//写入日志
							System :: insert_event( $func,time(),time(),"卸载模块成功：".$appid );
							
							//echo '<div id="state">恭喜！成功卸载模块（'.$module.'）</div>';
							
							return 'lock';
							
					}else{
							
							//echo '<div id="state" class="failure">抱歉！卸载模块失败（'.$module.'），以下是本错误信息详细报告：</div>';
							
							return 'lock';
							
							//trigger_error(str_replace('class="error"','class="text-no"',preg_replace('/<h4>(.*?)<\/h4>/','',$array[1])), E_USER_ERROR);
					}
					
			}
	
	}

}

?>