<?php

/*
*	Copyright liq330
*	http://www.veryide.com/
*
*	$Url: http://blog.csdn.net/liq330/archive/2008/01/10/2032804.aspx ,v1.1 19:01 2009-4-22 Lay $
*/


class ImageReport{
   var $Image;//图片对像

   var $ImageName;//报表名称
   var $ImageType;//报表类型
   
   var $ImageWidth;//图片宽
   var $ImageHeight;//图片高
   

   var $BgImage;//背景图片
   var $BgR;//背景颜色R值
   var $BgG;//背景颜色G值
   var $BgB;//背景颜色B值

   var $FontSize;//字体大小
   var $FontColor;//字体颜色

   var $ItemArray;//数据数组
   var $ItemInterval;//两项间的间隔
   var $XName;//x轴的名称
   var $YName;//y轴的名称
   var $isScale;//是否显示刻度值
   var $margin;//边距

   //字体
   var $font = 'vrinda.ttf';    
   
    function ImageReport(){
    
		if(ini_get("safe_mode")){
			$self = realpath('.')."/";
		}else{
			putenv('GDFONTPATH=' . realpath('.'));
		}
		
        return ;
    }

   //设置图片基本信息
   function setImage($ImageName,$ImageType,$ImageWidth=500,$ImageHeight=400)
   {
        $this->ImageName  =$ImageName;
     $this->ImageType  =$ImageType;
     $this->ImageWidth =$ImageWidth;
     $this->ImageHeight=$ImageHeight;
   }
   
   //设置坐标
   function setItem($ItemArray,$ItemInterval="20",$XName="",$YName="",$isScale=true)
   {
        $this->ItemArray    =$ItemArray;
     $this->ItemInterval =$ItemInterval;
     $this->XName        =$XName;
     $this->YName        =$YName;
     $this->isScale      =$isScale;
   }
   
   //设置图片背景
   function setBg($BgR="235",$BgG="255",$BgB="255",$BgImage="")
   {
        $this->BgR     =$BgR;
     $this->BgG     =$BgG;
     $this->BgB     =$BgG;
     $this->BgImage =$BgImage;
   }
   
   //设置字体
   function setFont($FontSize,$FontPath="")
   {
     $this->FontSize  =$FontSize;
     $this->margin    =$FontSize*2+5;
     
     if($FontPath){
		$this->font    = $FontPath;
     }
     //$this->FontColor =$FontColor;
   }

   //画主体
   function drawReport()
   {
     //建立画布
     $this->Image=imagecreatetruecolor($this->ImageWidth,$this->ImageHeight);
     //填充背景色
     $background=ImageColorAllocate($this->Image,$this->BgR,$this->BgG,$this->BgB);
          
     //画背景颜色
     ImageFilledRectangle($this->Image,0,0,$this->ImageWidth,$this->ImageHeight,$background);

     //画背景图片
     if(!empty($this->BgImage))
     {
        $this->drawLogo();
     }
      //跟距参数,画不同的图片
     switch($this->ImageType)
     {
         case "1":
           $this->drawColumn();
           break;
         case "2":
           $this->drawCurve();
           break;
         case "3":
           $this->drawCircle();
           break;
         default:
             break;
     }

   }
   
   //画柱状图
   function drawColumn()
   {
     //调用画标题
     $this->drawTitle();
     //调用画坐标
     $this->drawXY();

     //获取数组的量
     $num=count($this->ItemArray);
     //获取数组中的最大值
     //最大值
     $max=$this->getArrayMax($this->ItemArray);
    

     for($i=0;$i<count($this->ItemArray);$i++)
     {
        //随机颜色
        srand((double)microtime()*1000000);  
        $R=Rand(50,200);   
        $G=Rand(50,200);
        $B=Rand(50,200);
      
        $color=ImageColorAllocate($this->Image,$R,$G,$B);
        
        $yColor=ImageColorAllocate($this->Image,$R-10,$G-10,$B-10);
        //柱体高度
        
        $height=(($this->ImageHeight-$this->margin*2-$this->FontSize-5)*$this->ItemArray[$i]["value"])/$max;

        //画柱体
        ImageFilledRectangle($this->Image,$this->margin+$this->ItemInterval*(2*$i+1),$this->ImageHeight-$height+$this->FontSize-5-$this->margin,$this->margin+$this->ItemInterval*(2*$i+2),$this->ImageHeight-$this->margin,$color);
        //画柱体上的阴影
        imagefilledarc($this->Image, $this->margin+$this->ItemInterval*(2*$i+3/2), $this->ImageHeight-$height+$this->FontSize-5-$this->margin,$this->ItemInterval, $this->margin/2, 0, 360, $yColor, IMG_ARC_PIE);
        
        //写柱体上面的数值
        imagestring($this->Image,$this->FontSize,$this->margin+$this->ItemInterval*(2*$i+1),$this->ImageHeight-$height+$this->FontSize-5-$this->margin-$this->FontSize-10,$this->ItemArray[$i]["value"],$color);
        
        //颜色
        $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 

        //写柱体的键值
        imagettftext($this->Image,$this->FontSize-2,0,$this->margin+$this->ItemInterval*(2*$i+1),$this->ImageHeight-$this->margin+$this->FontSize+2,$color,$this->font,$this->ItemArray[$i]["key"]);
     }
     //调用画LOGO
    // $this->drawLogo();

   }
   //画曲线图
   function drawCurve()
   {
     //调用画标题
     $this->drawTitle();
     //调用画坐标
     $this->drawXY(true);
     
     //最大值
     $max=$this->getArrayMax($this->ItemArray);
     
     //颜色
     $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 
     //背景刻度的颜色
     $bgSColor=ImageColorAllocate($this->Image,$this->BgR-10,$this->BgG-10,$this->BgB-10);
     //线条颜色

     $linkColor=ImageColorAllocate($this->Image,51,51,153);
  

     //画右X轴
     ImageLine($this->Image,$this->margin,$this->margin+$this->FontSize+5,$this->ImageWidth-$this->margin,$this->margin+$this->FontSize+5,$color);
     //画右Y轴
     ImageLine($this->Image,$this->ImageWidth-$this->margin,$this->margin+$this->FontSize+5,$this->ImageWidth-$this->margin,$this->ImageHeight-$this->margin+2,$color);
     
     $tdCount=count($this->ItemArray);
     $tdWidth=($this->ImageWidth-$this->margin*2)/$tdCount;
    
     for($i=0;$i<$tdCount-1;$i++){
        //线条高度
        $startHeight=(($this->ImageHeight-$this->margin*2-$this->FontSize-5)*$this->ItemArray[$i]["value"])/$max;
        //结束线线条高度
        $endHeight  =(($this->ImageHeight-$this->margin*2-$this->FontSize-5)*$this->ItemArray[$i+1]["value"])/$max;
        //画背景X轴刻度   
        ImageLine($this->Image,($i+1)*$tdWidth+$this->margin,$this->margin+$this->FontSize+6,($i+1)*$tdWidth+$this->margin,$this->ImageHeight-$this->margin,$bgSColor);
        //画线条
        ImageLine($this->Image,$i*$tdWidth+$this->margin,$this->ImageHeight-$startHeight+$this->FontSize-5-$this->margin,($i+1)*$tdWidth+$this->margin,$this->ImageHeight-$endHeight+$this->FontSize-5-$this->margin,$linkColor);
     }

     //画刻度的值
     for($i=0;$i<$tdCount;$i++)
     {
        //显示值 
        //ImageString($this->Image,5,$i*$tdWidth+$this->margin,$this->ImageHeight-$this->margin+1,$this->ItemArray[$i]["key"],$color);
        //画标题的字
        imagettftext($this->Image,$this->FontSize,0,$i*$tdWidth+$this->margin,$this->ImageHeight-$this->margin+1+10,$color,$this->font,$this->ItemArray[$i]["key"]);
     }

   } 

   //画饼图
   function drawCircle()
   {
      //一个扇区的角度
      $degree=0;
      //开始的角度
      $e=0;
      //用于保存颜色的数组
      $colorArray;
      //用于保存开始角度的数组
      $startDegree;
      //用于保存结束角度的数组
      $endDegree;
      
      //扇形的宽
      $width=($this->ImageWidth-$this->margin*2)-200;

         //获取数组的量
      $num=count($this->ItemArray);
      //调用画标题
      $this->drawTitle();
      //各项之和
      $total=0;
      
      //计算各项之和
      for($i=0;$i<$num;$i++)
      {
        $total+=$this->ItemArray[$i]["value"];
      }

      //保扇区的各项值保存到数组
      for($i=0;$i<count($this->ItemArray);$i++)
      {
        //随机颜色
        srand((double)microtime()*1000000);  

        $R=Rand(50,200);   
        $G=Rand(50,200);   
        $B=Rand(50,200);   
 
        //把颜色保存进数组
        $colorArray[$i]["R"]=$R;
        $colorArray[$i]["G"]=$G;
        $colorArray[$i]["B"]=$B;
        
        //计算一个区块的角度
        //echo $this->ItemArray[$i]["value"];
        //exit;
        $degree=$this->ItemArray[$i]["value"]/$total*360;
        $startDegree[$i]=$e;
        $endDegree[$i]=$e+$degree;
        $e+=$degree;
      }

       $j=$width/4+$this->margin+35;
       $mJ=$j-15;
       //画阴影
       for ($j;$j >$mJ; $j--)
       {  
         for($i=0;$i<$num;$i++)
         {
          $color=ImageColorAllocate($this->Image,$colorArray[$i]["R"]-10,$colorArray[$i]["G"]-10,$colorArray[$i]["B"]-10);
          imagefilledarc($this->Image, $width/2+$this->margin, $j, $width, $width/2, $startDegree[$i], $endDegree[$i], $color, IMG_ARC_PIE);
         }
       }
       //画区面和右边的标识字
      for($i=0;$i<$num;$i++)
      {
        //获取颜色
        $color=ImageColorAllocate($this->Image,$colorArray[$i]["R"],$colorArray[$i]["G"],$colorArray[$i]["B"]);
        
        //画区面
        imagefilledarc($this->Image, $width/2+$this->margin, $width/4+$this->margin+20, $width, $width/2, $startDegree[$i], $endDegree[$i], $color, IMG_ARC_PIE);
        

        //说明方块的上边距
        $top=$this->margin+20+$i*10;
        //画右边的距形
        ImageFilledRectangle($this->Image,$width+$this->margin+20,$top+($i*10),$width+$this->margin+30,$top+($i*10)+10,$color);
        //字体颜色为黑色 
        $fontColor=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB);
        
        //画右边的说明文字 
        $rightStr=$this->ItemArray[$i]["key"].": ".$this->ItemArray[$i]["value"]." (".round($this->ItemArray[$i]["value"]*100/$total,2)."%)";
        //ImageString($this->Image,10,$width+$this->margin+35,$top+($i*10)-3,$rightStr,$fontColor);
        imagettftext($this->Image, $this->FontSize,0,$width+$this->margin+35,$top+($i*10)+8,$fontColor,$this->font,$rightStr);
        
      }
      //清空各数组
      unset($colorArray,$startDegree,$endDegree);

   }

   //显示图片
   function showImage($ImageSavePath="")
   {
      // echo $ImageSavePath;
       //exit;
       if(empty($ImageSavePath))
       {
         ImagePNG($this->Image);  
       }
       else
       {
         ImagePNG($this->Image,$ImageSavePath);       
       }
      
       ImageDestroy($this->Image); 
   } 

   //画标题
   function drawTitle()
   {
     //颜色
     $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 
  
     //阴影色
    # $black = imagecolorallocate($this->Image, 0, 0, 0);
     
     //计算标题字体的宽度
     $fontWidth=strlen($this->ImageName)*($this->FontSize)-strlen($this->ImageName)*2;

     //画标题字的阴影
    # imagettftext($this->Image, $this->FontSize+3,0,$this->ImageWidth/2-$fontWidth/2+1,$this->FontSize+11,$black,$this->font,$this->ImageName);
     
     //画标题的字
     imagettftext($this->Image, $this->FontSize+3,0,$this->ImageWidth/2-$fontWidth/2,$this->FontSize+10,$color,$this->font,$this->ImageName);
     
     //画标题下面的线条
    # imageline($this->Image,$this->ImageWidth/2-$fontWidth/2-20,$this->FontSize+12,$this->ImageWidth/2-$fontWidth/2+1+$fontWidth+20,$this->FontSize+12,$color);
   }
   
   //画LOGO
   function drawLogo()
   {

      list($w,$h,$type) = getimagesize($this->BgImage);
      
      $source;
      switch($type)
      {
          //图片是GIF
         case 1:
          $source=imagecreatefromgif($this->BgImage);
          break;
          //图片是jPG
         case 2:
          $source = imagecreatefromjpeg($this->BgImage);
          break;
          //图片是PNG
         case 3:
          $source = imagecreatefrompng($this->BgImage);
      }
  
       imagecopymerge($this->Image,$source,0,0,0,0,$w,$h,20);
   } 

   //画坐标
   function drawXY($bgScale=false)
   {
        //最大值
     $max=$this->getArrayMax($this->ItemArray);
     
     //颜色
     $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 
     //背景刻度的颜色
     $bgSColor=ImageColorAllocate($this->Image,$this->BgR-10,$this->BgG-10,$this->BgB-10);

     //画X轴
     ImageLine($this->Image,$this->margin,$this->ImageHeight-$this->margin+2,$this->ImageWidth-$this->margin,$this->ImageHeight-$this->margin+2,$color);
     //画Y轴
     ImageLine($this->Image,$this->margin,$this->margin+$this->FontSize+5,$this->margin,$this->ImageHeight-$this->margin+2,$color);
       
          
     //阴影色
     $black = imagecolorallocate($this->Image, 0, 0, 0);
     
      //画Y轴字的阴影
     imagettftext($this->Image, $this->FontSize, 90, $this->FontSize+2, intval($this->ImageHeight/2)-1, $black, $this->font, $this->YName);
     //画Y轴的字
     imagettftext($this->Image, $this->FontSize, 90, $this->FontSize+2, intval($this->ImageHeight/2), $color, $this->font, $this->YName);
    
      //画X轴字的阴影
     imagettftext($this->Image, $this->FontSize,0,intval($this->ImageWidth/2)-1,$this->ImageHeight-$this->FontSize+5,$black,$this->font,$this->XName);
     //画X轴的字
     imagettftext($this->Image, $this->FontSize,0,intval($this->ImageWidth/2),$this->ImageHeight-$this->FontSize+5,$color,$this->font,$this->XName);
    
      
     //画0点坐标
     imagettftext($this->Image,8,90,$this->margin/2+$this->FontSize,$this->ImageHeight-$this->margin,$color,$this->font,"0");
     //画最大值数据
    // imagettftext($this->Image, $this->FontSize,90,$this->margin/2+7,$this->margin+20,$black,$font,$max);
     
     //画内容的实际高度
     $height=$this->ImageHeight-$this->margin*2-($this->FontSize+5);
     //每一刻度的值
     $scale=intval($height/10);
    

     for($i=0;$i<10;$i++)
     {
       //画刻度,如果设置了背景刻度
       if($bgScale)
       {
         ImageLine($this->Image,$this->margin+1,$this->margin+$i*$scale+$this->FontSize+5+$i,$this->ImageWidth-$this->margin,$this->margin+$i*$scale+$this->FontSize+5+$i,$bgSColor);
       }
       else
       {
         ImageLine($this->Image,$this->margin-2,$this->margin+$i*$scale+$this->FontSize+5+$i,$this->margin,$this->margin+$i*$scale+$this->FontSize+5+$i,$color);
       }
       //画刻度上的值
       if($this->isScale)
       {
        $num=round($max-$max/10*$i,1);
        imagettftext($this->Image, 7,90,$this->margin/2+$this->FontSize,$this->margin+$i*$scale+15+$this->FontSize,$color,$this->font,$num);
       }
     }
     //如果未画刻度值,则画最大值
     if(!$this->isScale)
     {
        imagettftext($this->Image, 7,90,$this->margin/2+$this->FontSize,$this->margin+15+$this->FontSize,$color,$this->font,$max);
     }

   }
   
   //获取数组中的最大值
   function getArrayMax($Array)
   {
     $temp=0;
        for($i=0;$i<count($Array);$i++)
     {
         if($temp<$Array[$i]["value"])
         {
             $temp=$Array[$i]["value"];
         }
     }
     return $temp;
	}
}
?>