<?php

class xml2array {
 
	function xml2array($xml) {
		
		//读取本地文件
		if( file_exists( $xml ) ){
			$fp = @fopen($xml, "r"); 
			$xml = fread($fp, filesize($xml)); 
			fclose($fp); 
		}
		
		if (is_string($xml)) {
			$this->dom = new DOMDocument;
			$this->dom->loadXml($xml);
		}
 
		return FALSE;
	}
 
	function _process($node) { 
		$occurance = array();
		
		//var_dump( $node );
		
		if( $node->childNodes ){
 
			foreach($node->childNodes as $child) {
				$occurance[$child->nodeName]++;
			}
		
		}
 
		if($node->nodeType == XML_TEXT_NODE) { 
			$result = html_entity_decode(htmlentities($node->nodeValue, ENT_COMPAT, 'UTF-8'), 
                                     ENT_COMPAT,'ISO-8859-15');
		} 
		else {
			if($node->hasChildNodes()){
				$children = $node->childNodes;
 
				for($i=0; $i<$children->length; $i++) {
					$child = $children->item($i);
 
					if($child->nodeName != '#text') {
						if($occurance[$child->nodeName] > 1) {
							$result[$child->nodeName][] = $this->_process($child);
						}
						else {
							$result[$child->nodeName] = $this->_process($child);
						}
					}
					else if ($child->nodeName == '#text') {
						$text = $this->_process($child);
 
						if (trim($text) != '') {
							$result[$child->nodeName] = $this->_process($child);
						}
					}
				}
			} 
 
			if($node->hasAttributes()) { 
				$attributes = $node->attributes;
 
				if(!is_null($attributes)) {
					foreach ($attributes as $key => $attr) {
						$result["@".$attr->name] = $attr->value;
					}
				}
			}
		}
 
		return $result;
	}
 
	function getResult() {
		return $this->_process($this->dom);
	}
}



////////////////////////////////////////

/** 
* 解析XML类 
* 
*/ 
class xmlParser{

	var $params = array();
	
	/** 
	* 读取XML文件 
	* 
	* @param unknown_type $file 
	*/ 
	function xmlOpen($file){
		$fp = @fopen($file, "r"); 
		if (!$fp) die("不能打开数据源"); 
		//读取文件 
		$this->data = fread($fp, filesize($file)); 
		fclose($fp); 
		$this->xmlToArray(); 
	}
	
	/** 
	* 把XML数据放入变量中 
	* 
	* @param unknown_type $data 
	*/ 
	function xmlData($d){
		$this->data = $d; 
		$this->xmlToArray(); 
	}
	
	/** 
	* 把变量中数据导成数组 
	* 
	* @return unknown 
	*/ 
	function xmlToArray(){
		$level = array(); 
		$xml_parser = xml_parser_create(); 

		// 将xml文件读入数组 
		xml_parse_into_struct($xml_parser, $this->data, $vals, $index); 
		xml_parser_free($xml_parser); 

		foreach ($vals as $xml_elem){ 
			// 元素结点展开 
			if ($xml_elem['type'] == 'open'){
				if (array_key_exists('attributes',$xml_elem)){ 
					list($level[$xml_elem['level']],$extra) = array_values($xml_elem['attributes']); 
				}else{ 
					$level[$xml_elem['level']] = $xml_elem['tag']; 
				} 
			}
			
			if ($xml_elem['type'] == 'complete'){
				$start_level = 1; 
				$php_stmt = '$this->params'; 
				while($start_level < $xml_elem['level']){ 
					$php_stmt .= '[$level['.$start_level.']]'; 
					$start_level++; 
				} 
				$php_stmt .= '[$xml_elem[\'tag\']] = $xml_elem[\'value\'];'; 
				eval($php_stmt); 
			} 
		}
		
		return $this->params; 
	} 
	//----------------------------------------------------------------------------- 
}





?>
