/*
	VeryIDE
	Version: 3.0
	Database: veryide
	Date: 16:40 2010/4/12
*/

-- ----------------------------
-- 即时消息
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}message`;
CREATE TABLE `{TablePre}message` (
  `id` int(11) NOT NULL auto_increment,
  `fromid` int(11) NOT NULL,
  `toid` int(11) default NULL,
  `message` tinytext,
  `ip` varchar(15) NOT NULL,
  `client` varchar(10) default NULL,
  `read` tinyint(4) default NULL,
  `dateline` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `fromid` (`fromid`),
  KEY `toid` (`toid`),
  KEY `read` (`read`)
) ENGINE=MyISAM;

-- ----------------------------
-- 内部公告
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}notice`;
CREATE TABLE `{TablePre}notice` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL,
  `account` varchar(30) NOT NULL,
  `gid` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `content` text,
  `dateline` int(11) NOT NULL,
  `modify` int(11) default NULL,
  `ip` varchar(15) NOT NULL,
  `state` tinyint(4) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `id` (`id`),
  KEY `aid` (`aid`),
  KEY `account` (`account`),
  KEY `gid` (`gid`),
  KEY `title` (`title`)
) ENGINE=MyISAM;

-- ----------------------------
-- 应用收藏
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}quick`;
CREATE TABLE `{TablePre}quick` (
  `aid` int(11) NOT NULL,
  `appid` varchar(30) NOT NULL,
  `sort` tinyint(4) NOT NULL,
  `dateline` int(11) NOT NULL,
  KEY `aid` (`aid`),
  KEY `appid` (`appid`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM;

-- ----------------------------
-- 插件收藏
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}widget`;
CREATE TABLE `{TablePre}widget` (
  `aid` int(11) NOT NULL,
  `appid` varchar(30) NOT NULL,
  `widget` varchar(30) NOT NULL,
  `x` varchar(10) NOT NULL,
  `y` varchar(10) NOT NULL,
  `z` smallint(4) NOT NULL,
  `fx` smallint(6) NOT NULL,
  `fy` smallint(6) NOT NULL,
  `dateline` int(11) NOT NULL,
  KEY `aid` (`aid`),
  KEY `appid` (`appid`)
) ENGINE=MyISAM;

-- ----------------------------
-- 附件表
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}attach`;
CREATE TABLE `{TablePre}attach` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL,
  `account` varchar(30) NOT NULL,
  `name` varchar(100) default NULL,
  `type` varchar(10) default NULL,
  `size` int(11) default NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `input` varchar(20) default NULL,
  `remote` tinyint(4) NOT NULL,
  `dateline` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `aid` (`aid`),
  KEY `account` (`account`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `width` (`width`),
  KEY `height` (`height`),
  KEY `input` (`input`),
  KEY `remote` (`remote`),
  KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

-- ----------------------------
-- 用户组
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}group`;
CREATE TABLE `{TablePre}group` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `aid` int(11) NOT NULL,
  `account` varchar(30) NOT NULL,
  `medal` varchar(30) default NULL,
  `config` text,
  `description` varchar(1000) default NULL,
  `quick` text NOT NULL,
  `widget` text NOT NULL,
  `state` tinyint(4) NOT NULL,
  `dateline` int(11) NOT NULL,
  `modify` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `name` (`name`),
  KEY `aid` (`aid`),
  KEY `account` (`account`)
) ENGINE=MyISAM;

-- ----------------------------
-- 系统日志
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}event`;
CREATE TABLE `{TablePre}event` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL default '0',
  `account` varchar(30) default NULL,
  `event` varchar(50) NOT NULL,
  `description` varchar(255) default NULL,
  `dateline` int(11) NOT NULL default '0',
  `modify` int(11) NOT NULL default '0',
  `quote` varchar(50) default NULL,
  `rank` tinyint(4) NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `aid` (`aid`),
  KEY `account` (`account`),
  KEY `event` (`event`),
  KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

-- ----------------------------
-- 管理员
-- ----------------------------
DROP TABLE IF EXISTS `{TablePre}admin`;
CREATE TABLE `{TablePre}admin` (
  `id` int(11) NOT NULL auto_increment,
  `gid` int(11) NOT NULL,
  `account` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `sex` tinyint(4) NOT NULL,
  `avatar` varchar(50) default NULL,
  `email` varchar(20) default NULL,
  `birthday` varchar(10) default NULL,
  `question` tinyint(4) NOT NULL,
  `answer` varchar(50) NOT NULL,
  `qq` varchar(20) default NULL,
  `blog` varchar(100) default NULL,
  `phone` varchar(20) default NULL,
  `theme` varchar(20) default NULL,
  `stat_login` mediumint(9) NOT NULL default '0',
  `stat_modify` mediumint(9) NOT NULL default '0',
  `last_login` int(11) NOT NULL,
  `last_active` int(11) NOT NULL default '0',
  `last_ip` varchar(15) default NULL,
  `dateline` int(11) NOT NULL,
  `modify` int(11) NOT NULL,
  `config` text NOT NULL,
  `state` tinyint(4) NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `gid` (`gid`),
  KEY `account` (`account`),
  KEY `password` (`password`)
) ENGINE=MyISAM;

-- ----------------------------
-- 初始分组
-- ----------------------------
INSERT INTO `{TablePre}group`(aid,account,name,medal,config,dateline,state,ip) VALUES ('1','{TableAdmin}','超级管理员', 'bronze_1.png', '{"*":"*"}',{TableNow}, '1', '{TableIP}');
INSERT INTO `{TablePre}group`(aid,account,name,medal,config,dateline,state,ip) VALUES ('1','{TableAdmin}','管理员', 'bronze_2.png', '{"*":"*"}',{TableNow}, '1', '{TableIP}');
INSERT INTO `{TablePre}group`(aid,account,name,medal,config,dateline,state,ip) VALUES ('1','{TableAdmin}','广告组', 'silver_1.png', '{"*":"*"}',{TableNow}, '1', '{TableIP}');
INSERT INTO `{TablePre}group`(aid,account,name,medal,config,dateline,state,ip) VALUES ('1','{TableAdmin}','编辑组', 'silver_1.png', '{"*":"*"}',{TableNow}, '1', '{TableIP}');

-- ----------------------------
-- 初始用户 admin:veryide
-- ----------------------------
INSERT INTO `{TablePre}admin`(gid,account,password,avatar,blog,stat_login,last_ip,theme,dateline,modify,state,ip) VALUES ('1', '{TableAdmin}', '{TablePass}', 'skull.jpg', 'http://www.veryide.com/', '1', '{TableIP}', 'panda', {TableNow},{TableNow}, '1', '{TableIP}');


-- ----------------------------
-- 初始用户设置
-- ----------------------------
INSERT INTO `{TablePre}widget` VALUES ('1', 'system', 'control', '100', '200', '0', '0', '0', {TableNow});
