<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	系统函数包
*
*	$Id: system.php,v2 10:12 2009-4-14 Lay $
*/

function getcookie($key) {
	global $_G;
	return isset($_G['cookie'][$key]) ? $_G['cookie'][$key] : '';
}

/*
	根据当前文件得到缩略图地址
	$file	源文件
	$size	尺寸
*/
function fix_thumb( $file , $size = null ){
	
	$size = is_array($size) ? $size[0] ."-". $size[1] : "thumb";
	
	return $file ? substr_replace($file,"-$size.",strrpos($file,"."),1) : '';
	
}

/*
	处理多域名下附件路径问题
	$text	内容块
*/
function fix_file($text){
	global $_G;
	
	return str_replace( VI_BASE.$_G['project']['upload'] , VI_HOST.$_G['project']['upload'] , $text );
	
}

/*
	过滤XML标准规定的无效字节
	$xml	XML内容块
*/
function fix_xml($xml){
	return preg_replace("/[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]/",'',$xml);
}

/*
	编码或解码JSON，并修正JSON不支持中文的问题	
	
	$data	JSON字符串或数组
	return	返回修正后的数组
*/
function fix_json( $data ){
	global $_G;
	
	$temp = '';
	
	//如果参数是JSON字符串，就转换为数组
	if( is_string( $data ) ){
		
		//删除空白字符
		$data = preg_replace("/([\r\n\t\f])/"," ",$data);
		
		$temp = array();
		
		//兼容GBK中文
		if( $_G['product']['charset'] == "gbk" ){
			$array = json_decode(iconv('GBK', 'UTF-8', $data),true);
			
			if( is_array($array) ){
				foreach ($array as $key => $val){
					$temp[ iconv('UTF-8',$_G['product']['charset'], $key) ] = iconv('UTF-8', $_G['product']['charset'], $val);
				}
			}
		}else{
			
			//json 解码
			$temp = json_decode($data,true);	
		}
		
		
	//否则将数组转换为JSON字符
	}elseif( is_array( $data ) ){
		
		$temp = array();
				
		//兼容GBK中文，PHP 5.2 以下使用第三方 JSON 库（已对编码处理）
		//if( $_G['product']['charset'] == "gbk" && PHP_VERSION >= '5.2' ){				
		if( $_G['product']['charset'] == "gbk" ){				
			foreach ($data as $key => $val){
				$temp[ iconv($_G['product']['charset'],'UTF-8', $key) ] = iconv( $_G['product']['charset'],'UTF-8', $val);
			}
		}else{
			$temp = $data;			
		}
		
		//json 编码
		$temp = json_encode($temp);
		
	}
	
	return $temp;
	
}

/*
	清除字符串或数组中的空白
*/
function fix_white( $data ){
	
	//如果参数数组
	if(  is_array( $data ) ){
		
		$temp = array();		
				
		foreach ($data as $key => $val){
			$temp[$key] = fix_white( $val );
		}
		
	//否则是字符串
	}else{
		
		$temp = preg_replace("/([\r\n\t\f])/","",$data);
		
	}
	
	return $temp;
	
}

/*
	格式化GET中的数组
	$name	参数名称
	$array	数组值
	$ignore	要忽略的值
*/
function format_get($name,$array,$ignore=array()){
	
	//兼容 Smarty
	//if( is_array($name) ) extract($name);
	
	//var_dump( $ignore );
	
	if( !is_array($array) ) return;
	
	$arg = '';
	foreach( $array as $key => $val ){
		if (!in_array($key, $ignore)) {
			$arg .= "&".$name."[$key]=".urlencode($val);
		}
	}
	
	//return  substr($arg,0,strlen($arg)-1);
	//exit( $arg );
	return $arg;
}


/*格式化数据表名称*/
function format_table($table){
	$table = str_replace("{TableManPre}",VI_DBMANPRE,$table);
	$table = str_replace("{TableModPre}",VI_DBMODPRE,$table);
	return $table;	
}

/*编码JSON中的中文字符*/
function format_json($code){
	global $_G;
	
	return preg_replace("#\\\u([0-9a-f]{4}+)#ie", "iconv('".VI_UCS."', '".$_G['product']['charset']."//IGNORE', pack('H4', '\\1'))", $code);	
}

/*格式化字符集名称*/
function format_charset($charset,$reset=false){
	if( $reset ){
		return str_replace('utf8', 'utf-8', $charset);	
	}else{
		return str_replace('-', '', $charset);	
	}
}

/*字符截取,自动区分编码*/
function format_substr($str,$slen,$ext=""){
	global $_G;
	if($_G['product']['charset']=="utf-8"){
		return utf_substr($str,$slen,$ext);
	}else{
		return gbk_substr($str,$slen,$ext);
	}
}

/*
	加载样式
	$src			路径
	$charset	字符集
	$version		版本号
*/
function loader_style($src,$charset,$version){
	$style = '';
	if(is_array($src)){
		foreach ($src as $key => $value) {
			$style.= '<link type="text/css" rel="stylesheet" charset="'.$charset.'" href="'.$value.'?ver='.$version.'" />'.chr(13);
		}
	}else{
		return '<link type="text/css" rel="stylesheet" charset="'.$charset.'" href="'.$src.'?ver='.$version.'" />'.chr(13);
	}
	
	return $style;
}

/*
	加载脚本
	$src			路径
	$charset	字符集
	$version		版本号
*/
function loader_script($src,$charset,$version){
	$script = '';
	if(is_array($src)){
		foreach ($src as $key => $value) {
			$script.= '<script type="text/javascript" charset="'.$charset.'" src="'.$value.'?ver='.$version.'"></script>'.chr(13);
		}
	}else{
		return '<script type="text/javascript" charset="'.$charset.'" src="'.$src.'?ver='.$version.'"></script>'.chr(13);
	}
	
	return $script;
}


/*
	加载图片
	$src			路径
	$title			标题
	$class			样式
	$click			点击事件
*/
function loader_image( $src, $title="", $class="", $click=""){
	global $_G;
	return '<img src="'.VI_BASE."image/".$src.'" title="'.$title.'" alt="'.$title.'" class="'.$class.'" '.($click?'onclick="'.$click.'" style="cursor:pointer;"':'').' />';
}

?>