<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	系统上传函数库
*
*	$Id: upload.php,v2.0 14:01 2009-03-31 Lay $
*/

//检查上传文件
function uploader_check($file){
	global $_G;
	
	//类型
	$extra = fileext($file);
	
	foreach($_G['upload'] as $item=>$array){
		if( in_array($extra,$array) ){
			
			//type 类型 extra 扩展名
			return array( "type"=>$item, "extra"=>$extra, "path"=>$path );
		}	
	}
	
	return array("extra"=>$extra);
}

//检查上传文件
function uploader_check__($file){
	global $_G;
	
	//类型
	$ext = fileext($file);
	
	foreach($_G['upload'] as $item=>$array){
		if( in_array($ext,$array) ){
			
			$type=$item;
			$path=$_G['project']['upload']."/".$item;
			
			//创建附件文件夹
			if(!file_exists($_G['project']['upload'])){
				create_dir($_G['project']['upload']);
			}
			
			//创建附件子文件夹
			if(!file_exists($path)){
				create_dir($path);
			}
		}	
	}
	
	return array("type"=>$type,"path"=>$path);
}

/*
	保存上传文件
	
	$path		保存目录
	$temp		临时文件
	$name		本地名称
	$ext		扩展名
	$replace	重名处理方式：true 替换；false 重命名
*/
function uploader_save($path,$temp,$name,$ext,$replace=""){

	//创建目录
    $path = $path."/".date("Y/md/");
	create_dir($path);
    
    //存在老文件
    if( file_exists($path.$name) ){    
    	if( $replace == "false" ){
            $name = $path.substr($name,0,strlen($name)-strlen($ext)-1)."-".mt_rand().".".$ext;
        }else{
            $name = $path.$name;
        }    
    }else{
    	$name = $path.date("H-i-s-").mt_rand().".".$ext;
    }
	
	//移动
	move_uploaded_file($temp,$name);
	
	return $name;
}

//切图文件名称
function uploader_imager($file,$sNew){
	//新图片名称
	$sExt=fileext($file);
	$sName=substr($file,0,strlen($file)-strlen($sExt)-1).$sNew.".".$sExt;
	return $sName;
}


//删除文件
function uploader_delete($file,$mysql){
	global $_G;
	
	//查询数据库
	$sql="SELECT id,type from `sys:attach` WHERE name='$file'";
	
	$row = System :: $db -> getOne( $sql );
	
	if( $row ){

		//删除数据
		$sql="DELETE FROM `sys:attach` WHERE id=".$row['id'];
		System :: $db -> execute( $sql );
		
		//删除文件
		if( file_exists($file) ){
			unlink($file);
			
			//删除图片缩略图
			$thumb = str_replace(".".$row["type"],".thumb.".$row["type"],$file);
			if( in_array($row["type"],$_G['upload']['image']) && file_exists($thumb) ){
				unlink($thumb);
			}
		}
	}

}


/*
	上传文件到服务器
	$field		文件域名称
	$index		索引名称，用于批量上传，-1 为单文件上传
	$type		限制类型，数组
	
	$config		配置
		size	大小限制
		crop	裁切尺寸
		thumb	数组，缩略图尺寸
		group	二维数组，缩略图尺寸，可以生成多张图片
	
	返回值
	1		没有上传文件或出错
	2		不被允许文件的类型
	3		文件类型不在上传配置中
	4		文件太大
	5		移动文件出错
*/
function file_upload( $field ,$index = -1 , $type , $config ){
	global $_G;

	//本地文件名称
	$local = $index > -1 && is_int($index) ? $_FILES[$field]["name"][$index] : $_FILES[$field]["name"] ;
	
	//错误信息
	$error = $index > -1 && is_int($index) ? $_FILES[$field]["error"][$index] : $_FILES[$field]["error"] ;
		
	//没有上传文件或出错
	if( !$local || $error ){	
		return 1;	
	}

	//文件大小
	$size = $index > -1 && is_int($index) ? $_FILES[$field]["size"][$index] : $_FILES[$field]["size"];

	//临时名称
	$temp = $index > -1 && is_int($index) ? $_FILES[$field]["tmp_name"][$index] : $_FILES[$field]["tmp_name"];

	//当前文件类型
	$mime = fileext($local);

	//不被允许的类型
	if( !in_array($mime,$type) ){
		return 2;
	}

	//搜索所在分类
	foreach( $_G['upload'] as $item => $array ){		
		//定位到分类
		if( in_array($mime,$array) ){

			//文件分类
			$cate = $item;

			break;
		}	
	}

	//文件类型不在上传配置中
	if( !$cate ) return 3;
	
	//根文件夹
	$folder = VI_ROOT.$_G['project']['upload'].$cate;
	
	//创建子文件夹
	if( !file_exists($folder) ) create_dir($folder);

	//限制文件大小
	if( is_int($config["size"]) && $size > $config["size"] ) return 4;
	
	/*******保存文件_开始*******/	
	
	//创建目录	
	$path = create_dir( $folder."/".date("Y/md/") );

	//生成文件名
	$name = $path.date("H-i-s-").mt_rand().".".$mime;

	//移动文件失败
	if( !copy( realpath($temp) ,$name ) ) return 5;
	
	/*******保存文件_结束*******/	

	//图片则计算尺寸
	$width = $height = 0;
	if( $cate == "image" ){

		//返回图片尺寸
		list($width, $height) = getimagesize($name);
	
		//包含类
		require_once(dirname(__FILE__)."/../class/thumb.php");
		
		//生成缩略图
		if( is_array( $config["thumb"] ) ){

			//缩略图            
			$t = new ThumbHandler();

			//源图片地址
			$t->setSrcImg($name);

			//输出文件名
			$t->setDstImg( str_replace( ".".$mime, "-thumb.".$mime , $name ) );

			//生成图片
			$t->createImg( $config["thumb"][0] , $config["thumb"][1] );

		}
		
		//生成组图
		if( is_array( $config["group"] ) ){
			
			foreach( $config["group"] as $g ){
				
				if( is_array($g) ){

					//缩略图            
					$t = new ThumbHandler();
		
					//源图片地址
					$t->setSrcImg($name);
		
					//输出文件名
					$t->setDstImg( str_replace( ".".$mime, "-".$g[0] ."-". $g[1].".".$mime , $name ) );
		
					//生成图片
					$t->createImg( $g[0] , $g[1] );
				
				}
			
			}

		}
		
		//生成裁切图
		if( is_array( $config["crop"] ) ){

			//缩略图            
			$t = new ThumbHandler();

			//源图片地址
			$t->setSrcImg($name);

			//输出文件名
			$t->setDstImg($name);

			//生成图片
			$t->createImg( $config["crop"][0] , $config["crop"][1] );

		}

	}
	
	//exit(  );
	
	//合并路径
	$file = url_merge( str_replace( VI_ROOT , "" , VI_BASE.$name ) );
	
	//echo $file;
	
	//exit($file);
	
	//写入数据库
	$sql = "INSERT INTO `sys:attach`(name,input,dateline,type,size,ip,width,height,remote) values('".$file."','".$field."',".time().",'".$mime."',$size,'".GetIP()."',$width,$height,0)";
	System :: $db -> execute( $sql );
	
	//返回文件名
	return $file;

}

?>