<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	$Id: index.php,v2 10:10 2009-7-28 Lay $
*/

/**********/

//载入全局配置和函数包
require '../../../include/global.php';
require(VI_ROOT."function/client.php");
require(VI_ROOT."module/adsview/function.php");
require(VI_ROOT."module/adsview/config.php");
require VI_ROOT.'module/analytic/function.php';

//当前 APPID
$appid = Module :: get_appid();

/////////////////////////////////////////////

//开启页面压缩
ob_start("compress");

//动作
$action = getgpc('action');

//未知操作时跳转
if( !$action && file_exists("service.php") ) header("location:service.php?ref=index");

//跳转的URL
$url = getgpc("url");

//是否开启日志
$log = getgpc("log");

//广告ID
$aid = getgpc("id");

//广告位Key
$key = strtolower(getgpc('key'));

//输出编码
$charset = strtolower(getgpc('charset'));

//过期秒数
$second=10;

//缓存目录
$base = VI_ROOT.'static/adsview/';

switch($action){
	
	//广告网关
	case "proxy":
	
		//禁止缓存
		header("Cache-Control: max-age=0, must-revalidate, max-age=0");
		header('Content-Type:text/javascript; charset='.$charset.'');
		
		$queue = explode( ',', $key );
		
		foreach( $queue as $key ){

			$script = $base . $key.'.js';
			
			if( file_exists($script) ){
				$text = file_get_contents($script);			
				if( in_array($charset, array('gbk', 'big5', 'utf-8')) && $text && $charset != $_G['product']['charset'] ){
					header('Content-Type:text/html; charset='.$charset);
					$text = iconv($_G['product']['charset'],$charset,$text);
				}
				echo $text;
			}
			
		}
		
		//如果是列队
		if( count($queue) > 1 ){
			echo 'VAD.adStatis();';
		}

	break;
	
	//单文件引用
	case "single":
	
		header("Cache-Control: max-age=0, must-revalidate, max-age=0");   
		header('Content-Type:text/javascript; charset='.$charset.'');

		$script = './adsview.js';		
		$text = file_get_contents($script);		
		echo $text;
		
		/****************/		
		
		$script = $base . $key.'.js';
		
		if( file_exists($script) ){
			$text = file_get_contents($script);
			
			if( in_array($charset, array('gbk', 'big5', 'utf-8')) && $text && $charset != $_G['product']['charset'] ){
				header('Content-Type:text/html; charset='.$charset);
				$text = iconv($_G['product']['charset'],$charset,$text);
			}
			
			echo $text;
		}

	break;
	
	//链出统计
	case "click":
	
		if( $url && $aid ){
			
			//$config["MAX-CLICKS"]
			
			//连接数据库
			System :: connect();
			
			//ping
			Analytic :: ping( $appid, $aid, 'clicks' );
			
			//关闭数据库
			System :: connect();
			
			//redirect
			header("Location: ".$url);
			
		}
		
	break;
	
	//搜索广告
	case "search":
	
		header('Content-Type:text/javascript; charset='.$charset.'');

		$tag = getgpc("tag");
	
		//连接数据库
		System :: connect();
		
		if( !in_array($charset, array('gbk', 'big5', 'utf-8')) ){
			$charset='';
		}
		
		$ads = Adsview :: create("SELECT * FROM `mod:adsarea` WHERE `key` ='".$key."'" ,$tag,false,$charset);
		
		echo $ads;
	
		//关闭数据库
		System :: connect();
	
	break;
	
	//刷新广告位缓存
	case "flush":
	
		header('Content-Type:image/png');

		//连接数据库
		System :: connect();
		
		Adsview :: create("SELECT * FROM `mod:adsarea` WHERE `key` ='".$key."'");
		
		//关闭数据库
		System :: connect();
	
	break;
	
	//展示统计
	//DELETE
	case "view":
	
		header('Content-Type:image/png');
						
		//连接数据库
		System :: connect();
	
		$list = explode( ',', $aid );
				
		foreach( $list as $aid ){
		
			if( !is_int(intval($aid)) ) return;
			
			//$config["MAX-VIEWS"]
			
			Cached :: loader($appid,"adsview.".$aid);
			
			//$config = fix_json( $_CACHE['adsview']['adsview']["config"] );
			
			//更新状态为在播
			if( $_CACHE['adsview']['adsview']['state'] == 1 ){
	
				//展示广告并更新广告状态为在播
				System :: $db -> execute( "UPDATE `mod:adsview` SET `state`= 2 WHERE `state`> 0 and id=".$aid." LIMIT 1" );
				
				//更新缓存
				Cached :: rows( $appid, "SELECT * FROM `mod:adsview` WHERE id=".$aid, array( 'jsonde' => array('config') ) );
				
				echo 'OK';
				
			}
			
			//如果开启了统计
			if( $_CACHE['adsview']['adsview']["config"]['STAT-VIEWS'] == "Y" ){
				
				//ping
				Analytic :: ping( $appid, $aid, 'views' );
				
			}
			
		}		
			  
		//关闭数据库
		System :: connect();
		
	break;
	
	//过期处理
	case "expire":
	
		header('Content-Type:image/png');
			
		//连接数据库
		System :: connect();
	
		$list = explode( ',', $aid );
		
		foreach( $list as $aid ){
		
			if( !is_int(intval($aid)) ) return;
			
			Cached :: loader($appid,"adsview.".$aid);
			
			if( $_CACHE['adsview']['adsview']['expire'] < time() && $_CACHE['adsview']['adsview']["state"] > 0 ){
			
				//停止广告并更新广告状态为停止
				System :: $db -> execute( "UPDATE `mod:adsview` SET `end` = ".time().", `state`=0 WHERE id=".$aid );
				
				//更新缓存
				Cached :: rows( $appid, "SELECT * FROM `mod:adsview` WHERE id=".$aid, array( 'jsonde' => array('config') ) );

				//更新脚本缓存
				Adsview :: create("SELECT * FROM `mod:adsarea` WHERE id =".$_CACHE['adsview']['adsview']['type'] );
				
				echo 'OK';
				
			}
			
		}		
				
		//关闭数据库
		System :: connect();
		
	break;
}

?>