<?php

//载入全局配置和函数包
require '../../../include/global.php';
require '../../../include/cacher.php';

//载入配置模块
Module :: loader( 'form' );
Module :: loader( 'analytic' );

//当前 APPID
$appid = Module :: get_appid();

/////////////////////////////////////////////
	
//获取参数
$mode = getgpc("mode");
$action = getgpc('action');
$do = getgpc('do');
$fid = getnum('id',0);

//加载缓存
if( !Cached :: loader($appid,"form.".$fid) ){
	exit('Cache Error!');
}

//回收站中
if( $_CACHE[$appid]['form']['state'] == -1 ){
	exit('Forbidden');
}

//数据统计
if( $action == "stat" ){
	//JSON 文件头（不加时在 IE6 中有时不能响应）
	header('Content-type: text/javascript; charset='.$_G['product']['charset']);
	exit('document.write('.$_CACHE[$appid]['form']["stat"].');');
}

$skin = $_CACHE['form']['form']['skin'];

//连接数据库
System :: connect();
		
////////// 载入通行证模块 ////////////

if( $_G['licence']['type'] != 'free' ){
	
	//载入函数包
	Module :: loader( 'passport' );
	
	//重定义模板
	if( $_G['setting'][$appid]['templet'] ) $_G['setting']['passport']['theme'] = $_G['setting'][$appid]['templet'];
	$_G['setting']['passport']['hidenaver'] = $_CACHE[$appid]['form']['config']['HIDE_NAVER'];
	$_G['setting']['passport']['hideright'] = $_CACHE[$appid]['form']['config']['HIDE_RIGHT'];
	
	//主动初始用户信息
	Passport :: check( false, false );
	
}

////////// 验证模板 ////////////

if ( !file_exists( 'theme/'.$skin.'/index.htm' ) ) {
	$skin = 'default';
}

/////////////////////////////////////////////
	
//加载 Smarty 类
require VI_ROOT.'smarty/Smarty.class.php';

$smarty = new Smarty;

//模板路径
$smarty->template_dir = 'theme/'.$skin.'/';

//编译路径
$smarty->compile_dir = create_dir( VI_ROOT.'static/'.$appid );

//编译编号（防止冲突）
$smarty->compile_id = $skin;

$smarty->compile_check = true;

$smarty->debugging = false;

/////////// 全局变量 //////////

//系统变量
$smarty->assign("_G",$_G);


//当前页面绝对地址
$smarty->assign("SELF",GetAbsUrl());

//前台目录绝对地址
$smarty->assign("Index", Module :: get_index($appid) );

//随机颜色函数
$smarty->register_function('color',"rand_color");

//公共导航
$smarty->assign("Naver",Module :: hooks_slice('passport/naver'));

/////////// 表单变量 //////////

//重组选项组配置
foreach( $_CACHE["form"]["group"] as $gid => $group ){
	//$_CACHE["form"]["group"][$gid]["config"] = fix_json( $group["config"] );
	$_CACHE["form"]["group"][$gid]["description"] = stripslashes( str_replace(chr(13),'<br />',ubb_basic($group["description"])) );
}

//处理描述内容
$_CACHE["form"]["form"]["description"] = Module :: parse_form( $_CACHE['form']['form'] );

//处理表单配置
//$config = $_CACHE[$appid]['form']["config"] = fix_json( $_CACHE['form']['form']["config"] );
$config = $_CACHE[$appid]['form']["config"];

//表单模式
$smarty->assign("mode",$mode);

//动作名称
$smarty->assign("action",$action);

//表单验证
$smarty->assign("verify",rand_string(10));

//表单结构
$smarty->assign("form", $_CACHE['form'] );

//表单名称
$smarty->assign("Member", $_SESSION['Member']['id'] && $_G['licence']['type'] != 'free' ? Passport :: member( $_SESSION['Member']['id'] ) : array() );

/////////// 个性化 //////////
	
//背景图片
$bg = '';
if( !empty($config["PAGE_BG"]) || !empty($config["PAGE_BG_COLOR"]) ){
	$bg = "background:".$config["PAGE_BG_COLOR"].( $config["PAGE_BG"] ? " url(".$config["PAGE_BG"].") " : "" ).$config["PAGE_BG_REPEAT"]." ".$config["PAGE_BG_ATTACHMENT"]." ".$config["PAGE_BG_X"]." ".$config["PAGE_BG_Y"].";";
}

//主体透明
$op = '';
if( !empty($config["PAGE_BG_OPACITY"]) ){
	$op .= "filter:alpha(opacity=".$config["PAGE_BG_OPACITY"].");opacity:".($config["PAGE_BG_OPACITY"]/100).";";
}

//页面宽度
if( !empty($config["PAGE_WIDTH"]) ){
	$op .= "width:".$config["PAGE_WIDTH"].$config["PAGE_UNIT"].";";
}

//背景音乐
$bs = '';
if( !empty($config["PAGE_SOUND"]) && !$action ){
	$bs = '<bgsound src="'.$config["PAGE_SOUND"].'" autostart="true" loop="'.$config["PAGE_SOUND-LOOP"].'" />';
}

//背景图片
$smarty->assign("background", $bg );

//背景音乐
$smarty->assign("bgsound", $bs );

//页面主体
$smarty->assign("main", $op );

/////////// 加载资源 //////////

//脚本资源
$smarty->assign("script", array(VI_HOST."js/mo.js",VI_HOST."js/mo.ajax.js",VI_HOST."js/mo.ui.js",VI_HOST."js/mo.effect.js",VI_HOST."js/mo.drag.js",VI_HOST."js/mo.form.js") );

//处理动作
switch( $action ){

	//查看表单
	case "":
		//统计系统
		Analytic :: ping( $appid, $fid, 'views' );
	break;

	//提交表单
	case "post":
		require 'include.post.php';
	break;

	//用户结果
	case "state":
		require 'include.state.php';
	break;
	
	//订单处理
	case "trade":
		include("include.trade.php");
	break;

}

////////////////////////////

//用户登录验证
if( $_G['licence']['type'] != 'free' && $config['USER_MODE'] == "REG" && !in_array( $action , array('result','status') ) ){
	
	//载入会员配置
	require VI_ROOT.'module/member/config.php';

	$arr = array();
	
	//记录需要更新的字段
	foreach ($_G['module']['member']["fieds"] as $fied => $name){				
		if( isset( $config["REG_".strtoupper($fied)] ) ){
			$arr[] = $fied;
		}					
	}
	
	//更新特定字段
	if( count($arr) ){
	
		//显示登录窗口，并需要更新资料
		$LOGIN = Passport :: check( true , "['". implode("','",$arr) ."']" );
	}else{
		
		//显示登录窗口
		$LOGIN = Passport :: check( true , false );
		
	}			
				
}

//登录检查
$smarty->assign("LOGIN", isset( $LOGIN ) ? $LOGIN : '' );

$smarty->display('index.htm');

////////////////////////////

//关闭数据库
System :: connect();
		
?>