﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
<xsl:output method="html" encoding="utf-8" />
<xsl:template match="/">

	<!--HEAD-->
	<!--xsl:element name="head">
		<xsl:element name="meta">
			<xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
			<xsl:attribute name="content">text/html; charset=gb2312</xsl:attribute>
		</xsl:element>
		<xsl:element name="title">
			XSLT Test!
		</xsl:element>
	</xsl:element-->
    <!--/HEAD-->
    
    <!--TABLE-->
    <xsl:element name="table">
    <xsl:attribute name="cellpadding">0</xsl:attribute>
    <xsl:attribute name="cellspacing">0</xsl:attribute>
    <xsl:attribute name="class">form</xsl:attribute>
	
	<xsl:for-each select="//key|//item">
    
    	<xsl:param name="last_name">
   			<xsl:value-of select="name()"/>
        </xsl:param>
   		<!--xsl:value-of select="@tip"/-->
		
        <!--TR-->
		<xsl:element name="tr">
        
        	<!--xsl:if test="$last_name != 'key'">            
                <xsl:element name="td">
                    <xsl:attribute name="colspan">2</xsl:attribute>
                    <xsl:attribute name="class">section</xsl:attribute>
                    <xsl:element name="strong"><xsl:value-of select="@label"/></xsl:element>
                </xsl:element>
            </xsl:if-->
            
            <xsl:choose>
            
            	<xsl:when test="$last_name = 'item'">
                    <xsl:element name="td">
                        <xsl:attribute name="colspan">2</xsl:attribute>
                        <xsl:attribute name="class">section</xsl:attribute>
                        <xsl:element name="strong"><xsl:value-of select="@label"/></xsl:element>
                    </xsl:element>
                </xsl:when>
                
                <xsl:when test="$last_name = 'key'"> 
 
                    <xsl:if test="@tip != ''">
                        <xsl:attribute name="text">
                            <xsl:apply-templates select="@tip"/>
                        </xsl:attribute>
                    </xsl:if>
                     
                    <!--TD-->
                    <xsl:element name="td"><xsl:attribute name="width">60</xsl:attribute><xsl:element name="strong"><xsl:value-of select="@label"/>：</xsl:element></xsl:element>
                    <!--/TD-->
                    
                    <!--TD-->
                    <xsl:element name="td">
                    
                    <xsl:choose>
                    
                        <xsl:when test="@type = 'hidden'">
                            <xsl:element name="input">
                                <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                <xsl:attribute name="size"><xsl:value-of select="@size"/></xsl:attribute>
                                <xsl:attribute name="class">text</xsl:attribute>
                                <xsl:attribute name="type">hidden</xsl:attribute>
                            </xsl:element>
                        </xsl:when>
                    
                        <xsl:when test="@type = 'input'">
                            <xsl:element name="input">
                                <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                <xsl:attribute name="size"><xsl:value-of select="@size"/></xsl:attribute>
                                <xsl:attribute name="class">text</xsl:attribute>
                            </xsl:element>
                        </xsl:when>
                        
                        <xsl:when test="@type = 'select'">
                            <xsl:element name="select">
                                <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                <xsl:for-each select="option">
                                    <xsl:element name="option">
                                        <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                        <xsl:if test="../@value = @value">
                                            <xsl:attribute name="selected">selected</xsl:attribute>
                                        </xsl:if>
                                        <xsl:apply-templates select="text()"/>
                                    </xsl:element>
                                </xsl:for-each>
                            </xsl:element>
                        </xsl:when>
                        
                        <xsl:when test="@type = 'radio'">
                            <xsl:for-each select="option">
                                <xsl:element name="label">
                                    <xsl:element name="input">
                                        <xsl:attribute name="type">radio</xsl:attribute>
                                        <xsl:attribute name="class">radio</xsl:attribute>
                                        <xsl:attribute name="name"><xsl:value-of select="../@name"/></xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                        <xsl:if test="../@value = @value">
                                            <xsl:attribute name="checked">checked</xsl:attribute>
                                        </xsl:if>
                                    </xsl:element>
                                    <xsl:apply-templates select="text()"/>
                                </xsl:element>
                            </xsl:for-each>
                        </xsl:when>
                        
                        <xsl:when test="@type = 'checkbox'">
                            
                            <xsl:for-each select="option">
                                <xsl:element name="label">
                                    <xsl:element name="input">
                                        <xsl:attribute name="type">checkbox</xsl:attribute>
                                        <xsl:attribute name="class">checkbox</xsl:attribute>
                                        <xsl:attribute name="name"><xsl:value-of select="../@name"/></xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                        
                                        <xsl:if test="@checked = 'true'">
                                            <xsl:attribute name="checked">checked</xsl:attribute>
                                        </xsl:if>
                                        
                                    </xsl:element>
                                    <xsl:apply-templates select="text()"/>
                                </xsl:element>
                            </xsl:for-each>
                        </xsl:when>
                        
                        <xsl:when test="@type = 'textarea'">
                            <xsl:element name="textarea">
                                <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                <xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute>
                                <xsl:apply-templates select='text()' />
                            </xsl:element>
                        </xsl:when>
                        
                        <xsl:otherwise>
                            未知元素，请检查插件配置文件。
                        </xsl:otherwise>
                    </xsl:choose>
                    
                    <xsl:text disable-output-escaping="yes"><![CDATA[ ]]></xsl:text>
                    
                    <xsl:if test="@null = 'false'">
                        <xsl:text disable-output-escaping="yes"><![CDATA[*]]></xsl:text>
                    </xsl:if>
                    
                    <xsl:apply-templates select="@description"/>
                    
                    </xsl:element> 
                
                </xsl:when>
            
            </xsl:choose>
        
            
            <!--/TD-->
			
		</xsl:element>		
		<!--/TR-->
	</xsl:for-each>
	
    <!--TR-->
	<xsl:element name="tr">
		<xsl:element name="td">
			<!--xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text-->
			<xsl:text disable-output-escaping="yes"><![CDATA[ ]]></xsl:text>
		</xsl:element>
        
        <xsl:element name="td">
            <xsl:element name="input">
                <xsl:attribute name="name">action</xsl:attribute>
                <xsl:attribute name="type">hidden</xsl:attribute>
                <xsl:attribute name="value">update</xsl:attribute>
            </xsl:element>
            
            <xsl:element name="input">
                <xsl:attribute name="name">submit</xsl:attribute>
                <xsl:attribute name="type">submit</xsl:attribute>
                <xsl:attribute name="class">submit</xsl:attribute>
                <xsl:attribute name="value">保存配置</xsl:attribute>
            </xsl:element>
        </xsl:element>
	</xsl:element>
    <!--/TR-->

	</xsl:element>
	<!--TABLE-->

    
</xsl:template>
</xsl:stylesheet>