<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	$Id: upload.php,v2 2011/10/08 Lay $
*/

error_reporting(E_ERROR | E_WARNING | E_PARSE);

$_POST["session"] ? session_id($_POST["session"]) : "";

//载入依赖库以及配置
require_once dirname(__FILE__).'/include/global.php';
require_once dirname(__FILE__).'/include/cacher.php';

require 'class/ftp.php';
require 'class/upload.php';
require 'class/thumb.php';

header('Content-Type:text/html; charset='.$_G['product']['charset']);

/*	
	上传模式
	
	[空]	普通上传模式
	flash 	Flash 上传
*/
$model = getgpc("model");

//script start
echo $model != "flash" ? "<script type='text/javascript'>" : "";

//存储位置
$remote		= getgpc("remote");

//是否始终返回绝对地址
$absolute	= getgpc("absolute") ? getgpc("absolute") : 'false';

//文件域
$input = $_POST["input"] ? $_POST["input"] : "file";

//水印地址
$water = getgpc("watermark") ? $_G['setting']['attach']['MARK_FILE'] : '';

//水印位置
$position= getnum( "position", $_G['setting']['attach']['MARK_POSITION'] );

//原图是水印图尺寸的几倍时打上水印
$multiple= getnum("multiple", $_G['setting']['attach']['MARK_MULTIPLE'] );

//缩略图
$thumb = getgpc("thumb") ? explode("*",getgpc("thumb")) : 0;

//组图配置
$group = $_POST["group"];

//时间
$start = time();

if(!$_SESSION['Manager']['account']){
	
	//echo "top.Mo.Alert('warning','文件上传','文件上传被禁止!<br />您当前不在登录状态!');";	
	echo "parent.Serv.Upload.Error( '".$input."', 0 );";
	
}elseif( $_G['setting']['global']["upload"] != "on" ){
	
	//echo "top.Mo.Alert('warning','文件上传','文件上传失败!<br />系统已禁用文件上传!');";
	echo "parent.Serv.Upload.Error( '".$input."', 1);";
	
}elseif( System :: check_func('sys-upload-add') == false ){
	
	//echo "top.Mo.Alert('warning','文件上传','文件上传被取消!<br />您当前没有上传文件的权限!');";
	echo "parent.Serv.Upload.Error( '".$input."', 2);";
	
}elseif ( !$input ){
	
	//echo "top.Mo.Alert('warning','文件上传','文件上传失败!<br />没有收到任何数据!');";
	echo "parent.Serv.Upload.Error( '".$input."', 3);";
	
}else{	

	//延长程序运行时间（10分钟）
	@set_time_limit( 600 );
	
	//设置内存占用大小
	@ini_set('memory_limit','128M');
	
	//设置内存占用大小
	@ini_set('post_max_size','10M');
	
	//错误信息
	$error = $_FILES["file"]['error'];
	
	//临时文件
	$tmp_name = $_FILES["file"]["tmp_name"];
	
	//原始名称
	$name = $_FILES["file"]["name"];
	
	//文件大小
	$size = $_FILES["file"]["size"];
	
	//检查上传文件
	$result = uploader_check( $_FILES["file"]["name"] );
	
	if( $error ){
		
		switch ($error){
			case 1:
				//echo "top.Mo.Alert('warning','文件上传','上传失败！<br />您上传的文件超出服务器的限制,最大".get_cfg_var(upload_max_filesize)."');";
				echo "parent.Serv.Upload.Error( '".$input."', 4,'".get_cfg_var(upload_max_filesize)."');";
			break;
			
			case 2:
				//echo "top.Mo.Alert('warning','文件上传','上传文件的大小超过了 HTML 表单中 MAX_FILE_SIZE 选项指定的值。');";
				echo "parent.Serv.Upload.Error( '".$input."', 5);";
			break;
			
			case 3:
				//echo "top.Mo.Alert('warning','文件上传','上传失败！<br />您的文件只有部分被上传');";
				echo "parent.Serv.Upload.Error( '".$input."', 6);";
			break;
				
			case 4:
				//echo "top.Mo.Alert('warning','文件上传','上传失败！<br />没有文件被上传');";
				echo "parent.Serv.Upload.Error( '".$input."', 7);";
			break;
		}
		
	}elseif( !$result['type'] ){	//没有找到对应的目录
		
		//echo "top.Mo.Alert('warning','文件上传','该文件类型（".$result["extra"]."）不允许上传!');parent.Serv.Upload.Error('".$input."');";
		echo "parent.Serv.Upload.Error( '".$input."', 8,'".$result["extra"]."');";
		
	}else{		
	
		//源图信息
		if( $result['type']=="image" ){
			list($width, $height, $type, $attr) = getimagesize($tmp_name);
		}else{
			$width=0;
			$height=0;	
		}		
				
		//水印信息
		if( file_exists( $water ) ){				
			list($water_w, $water_h) = getimagesize($water);				
		}
		
		//FTP上传文件 
		if( $_G['setting']["attach"]["FTP_OPEN"] == "true" && $remote != "false" ){
		
			//连接 FTP
			$ftp = new ClsFTP($_G['setting']["attach"]["FTP_USER"], $_G['setting']["attach"]["FTP_PASS"], $_G['setting']["attach"]["FTP_HOST"], $_G['setting']["attach"]["FTP_PORT"]);
			
			//创建子文件夹
			$dir = $_G['setting']["attach"]["FTP_ROOT"]."/".$result['type'];
			
			//创建根目录
			$res = $ftp->mkdir($dir);
			
			//创建年文件夹
			$res = $ftp->mkdir($dir."/".date("Y/"));
			
			//创建月日文件夹
			$res = $ftp->mkdir($dir."/".date("Y/md/"));
			
			//新文件名称
			$name = date("Y/md/")."/".date("H-i-s-").mt_rand().".".$result["extra"];
			
			/*****************/
			
			//源图地址
			$file = $tmp_name;
			
			//临时文件
			$temp = $file."_tmp_".$result["extra"];
				
			//生成缩略
			if( $result['type']=="image" && $thumb ){

				//缩略图            
				$t = new ThumbHandler();
				
				//源图片地址
				$t->setSrcImg($file);
				
				//输出文件名
				$t->setDstImg($temp);
				
				//给缩略_打上水印
				if( $_G['setting']["attach"]["MARK_OPEN"] == "true" && $water_w && $water_h && ( $thumb[0] / $water_w > $multiple ) && ( $thumb[1] / $water_h > $multiple ) ){
					
					$t->setMaskImg( $water );
					$t->setMaskPosition( $position );
				
				}
				
				//生成图片
				$t->createImg( $thumb[0] , $thumb[1] );
				
				//上传文件
				$post = @$ftp->put( $dir."/".str_replace(".".$result["extra"],"-thumb.".$result["extra"],$name) , $temp );
				
				//删除临时文件
				@unlink($temp);
			
			}
			
		
			//生成组图
			if( $result['type']=="image" && is_array( $group ) ){
				
				foreach( $group as $g ){
					
					$thumb = explode("*",$g);
					
					if( is_array($thumb) ){
						
						//create_file("x.txt",$file);
	
						//缩略图            
						$t = new ThumbHandler();
			
						//源图片地址
						$t->setSrcImg($file);
			
						//输出文件名
						$t->setDstImg($temp);
				
						//给组图_打上水印
						if( $_G['setting']["attach"]["MARK_OPEN"] == "true" && $water_w && $water_h && ( $thumb[0] / $water_w > $multiple ) && ( $thumb[1] / $water_h > $multiple ) ){
							
							$t->setMaskImg( $water );
							$t->setMaskPosition( $position );
						
						}
				
						//生成图片
						$t->createImg( $thumb[0] , $thumb[1] );						
				
						//上传文件
						$post = @$ftp->put( $dir."/".str_replace( ".".$result["extra"], "-".$thumb[0] ."-". $thumb[1].".".$result["extra"],$name) , $temp );
						
						//删除临时文件
						@unlink($temp);			
					
					}
				
				}
	
			}			
					
			//给原图_打上水印
			if( $_G['setting']["attach"]["MARK_OPEN"] == "true" && $water_w && $water_h && ( $width / $water_w > $multiple ) && ( $height / $water_h > $multiple ) ){
				
				//缩略图            
				$t = new ThumbHandler();
				
				//源图片地址
				$t->setSrcImg($file);
				
				//输出文件名
				$t->setDstImg($file);					
				
				$t->setMaskImg( $water );
				$t->setMaskPosition( $position );
				
				//生成图片
				$t->createImg( $width , $height );
			
			}				
			
			/*****************/
				
			
			//上传文件
			$post = @$ftp->put($dir."/".$name,$tmp_name);
			
			if( $post === false ){
				
				//没有写权限或远程目录不存在
				echo "parent.Serv.Upload.Error( '".$input."', 9);";
				
			}else{
				
				//合并文件名
				$file = url_merge($dir."/".$name);
			
				//远程文件
				$remote = 1;
				
				//绝对地址
				$url = url_merge($_G['setting']["attach"]["FTP_SITE"]."/".$result['type']."/".$name);
							
				//上传成功
				echo $model != "flash" ? "parent.Serv.Upload.Ok('".$input."', '".$url."','".$size."', { 'width' : $width, 'height' : $height });" : $url;
							
			}
			
			//关闭 FTP
			$ftp->close();
			
		
		//普通方式上传
		}else{
			
			//IIS + PHP 部分环境下存储路径会出错
			//chdir( VI_ROOT );
			
			//子文件夹
			//$folder = $_G['project']['upload'].$result['type'];
			$folder = VI_ROOT.$_G['project']['upload'].$result['type'];
			
			//$water = "logo.png";
			
			//创建子文件夹
			if( !file_exists($folder) ){
				create_dir($folder);
			}
			
			if( !file_exists( $folder ) ){
				
				//不能创建目录
				echo "parent.Serv.Upload.Error( '".$input."', 10,'".$folder."');";
				
			}else{
				
				//移动上传文件
				$file = uploader_save($folder,$tmp_name,$name,$result["extra"],$_POST["NewName"]);
				
				//本地文件
				$remote = 0;
				
				//生成缩略
				if( $result['type']=="image" && $thumb ){
				
					//缩略图            
					$t = new ThumbHandler();
					
					//源图片地址
					$t->setSrcImg($file);
					
					//输出文件名
					$t->setDstImg( str_replace(".".$result["extra"],"-thumb.".$result["extra"],$file) );
					
					//给缩略_打上水印
					if( $_G['setting']["attach"]["MARK_OPEN"] == "true" && $water_w && $water_h && ( $thumb[0] / $water_w > $multiple ) && ( $thumb[1] / $water_h > $multiple ) ){
						
						$t->setMaskImg( $water );
						$t->setMaskPosition( $position );
					
					}
					
					//生成图片
					$t->createImg( $thumb[0] , $thumb[1] );
				
				}				
		
				//生成组图
				if( $result['type']=="image" && is_array( $group ) ){
					
					foreach( $group as $g ){
						
						$thumb = explode("*",$g);
						
						if( is_array($thumb) ){
		
							//缩略图            
							$t = new ThumbHandler();
				
							//源图片地址
							$t->setSrcImg($file);
				
							//输出文件名
							$t->setDstImg( str_replace( ".".$result["extra"], "-".$thumb[0] ."-". $thumb[1].".".$result["extra"] , $file ) );
					
							//给组图_打上水印
							if( $_G['setting']["attach"]["MARK_OPEN"] == "true" && $water_w && $water_h && ( $thumb[0] / $water_w > $multiple ) && ( $thumb[1] / $water_h > $multiple ) ){
								
								$t->setMaskImg( $water );
								$t->setMaskPosition( $position );
							
							}
					
							//生成图片
							$t->createImg( $thumb[0] , $thumb[1] );
						
						}
					
					}
		
				}				
					
				//给原图_打上水印
				if( $_G['setting']["attach"]["MARK_OPEN"] == "true" && $water_w && $water_h && ( $width / $water_w > $multiple ) && ( $height / $water_h > $multiple ) ){
					
					//缩略图            
					$t = new ThumbHandler();
					
					//源图片地址
					$t->setSrcImg($file);
					
					//输出文件名
					$t->setDstImg($file);					
					
					$t->setMaskImg( $water );
					$t->setMaskPosition( $position );
					
					//生成图片
					$t->createImg( $width , $height );
				
				}					
				
				//相对地址
				//$url = url_merge(VI_BASE.$file);
				$return = $local = str_replace( VI_ROOT, VI_BASE, $file );
				
				//绝对地址
				if( $absolute == 'true' ){
					$return = str_replace( VI_ROOT, VI_HOST, $file );
				}
								
				//上传成功
				echo $model != "flash" ? "parent.Serv.Upload.Ok( '".$input."', '".$return."','".$size."', { 'width' : '$width', 'height' : '$height' });" : $return;
				
			}
			
		}
		
		//上传成功
		if( $file ){
			
			//连接数据库
			System :: connect();

			//写入数据库
			$sql="INSERT INTO `sys:attach`(aid,account,name,input,dateline,type,size,ip,width,height,remote) values(".$_SESSION['Manager']['id'].",'".$_SESSION['Manager']['account']."','".$local."','".$input."',".time().",'".$result["extra"]."',$size,'".GetIP()."',$width,$height,$remote)";
			
			System :: $db -> execute( $sql );
			
			//写入日志
			System :: insert_event("sys-upload-add",$start,time(),'通过 '.( $model != "flash" ? 'VeryIDE' : 'Flash' ).' 上传文件 <a href="'.$local.'" target="_blank">'.$local.'</a>，大小 '.sizecount($size).'，类型 '.$result["extra"]);
  
			//关闭数据库
			System :: connect();
			
		}
		
	}
}

//script end
echo $model != "flash" ? "</script>" : "";

?>