<?php
# Sqlite 3 PDO Database Class
# Created by Gideon Graphics Studio
# Date: October 12, 2008
/* 
Description: SQLITE 3 Class designed to intereact with database and output 	results for html, flash and xml.
* Uses Nine Methods:
* Database Interaction Methods
* (1) $object->query() - executes a database query
* (2) $object->fetchobject() - return query result as object
* (3) $object->fetcharray() - returns query results as an array
* (4) $object->fetchnum() - returns query results as column number reference
* (5) $object->checkrowCount() - checks total number of rows in a table
* (6) $object->connect()

* Special Formatting Methods
* (6) $object->showDataAsTable() - outputs results as html tables
* (7) $object->showDataAsURLEncoded() - outputs results as url data
* (8) $object->showDataAsXML() - outputs results as xml
* (9) $object->writeDataToXMLFile() - sends xml data to a filename of your choice.
*/

class sqlitePDO {

	#instantiate variables;
	
	private $dbase;		//ݿ
	private $result;
	private $link;
	private $row;
	public  $ext;
	private $qry;
	
	/**
    * @desc 캯
    * @param string ݿ
	* @param string 
    */
	function __construct($dbase,$ext) {
		$this->dbase = $dbase;
		$this->link	 = $link;
		$this->ext   = $ext;		
	}
	
	/**
    * @desc ݿ
    */
	function connect() {
		$this->link = new PDO("sqlite:".$this->dbase.".".$this->ext);
	}
	
	/*
		ִݲѯ
		$sql	ѯ
	*/
	#Query sqlite database results.
	
	/**
    * @desc ִݿѯ
	* @param string ݿѯ
    */
	function query( $sql ) {				
		$this->result = $this->link->query( $sql );
		$this->result->execute;
	}
	
	#Show result SET as an object
	
	/**
    * @desc ȡִSELECTȡĽض
	* @return object   example: $row->id
    */
	function fetchobject() {
		$row = $this->result->fetch(PDO::FETCH_OBJ);
		return $row;
	}
	
	#Show result SET as an array
	/**
    * @desc ȡִSELECTȡĽ
	* @return array   example: $row['id']
    */
	function fetcharray() {
		$row = $this->result->fetch(PDO::FETCH_ASSOC);
		return $row;
	}
	
	#Show result SET as a number
	/**
    * @desc ȡִSELECTȡĽ
	* @return array   example: $row[0]
    */
	function fetchnum() {
		$row = $this->result->fetch(PDO::FETCH_NUM);
		return $row;
	}
	
	#check total number of rows in database
	
	/**
    * @desc ȡ
	* @return int
    */
	function checkrowCount() {
		$count = count($this->result->fetchAll());
		return $count;
	}
	
	////////////////////////

	/**
	* @desc ִSQLȡм¼
	* @param string SQL
	* @param string ָ
	* @param        
	* @return array SQLн
	*/
	function getAll($sql,$primaryKey="",$result_type=PDO::FETCH_ASSOC){
	
		$this -> query($sql);		
		$row = $this->result->fetchAll($result_type);
	
		return $row;

	}
    
	/*
	صǰѯ
	$sql	ѯ
	$index  
	*/
	function getCount( $sql, $index = 'id' ){
		return $this->getValue( preg_replace( '/select (.+?) from/is', 'select count('.$index.') from', $sql ) );
	}
	
	/*
	һݽ⣬ʽ
	$sql	ѯ
	*/
	function getOne($sql,$result_type=PDO::FETCH_ASSOC){
	
		$this -> query($sql);
		
		if( $this->result ){		
			$row = $this->result->fetchAll($result_type);
			return $row[0];			
		}else{
			return $row;
		}
	}
	
	/**
	* @desc õֶָεֵ
	* @sql 		string SQL      
	* @colset intger   ֶ0ʼ
	* @return 
	*/
	function getValue($sql, $colset = 0){
		
		$this -> query($sql);		
		$row = $this -> fetchnum();
		
		if ( $row ){
			return $row[$colset];
		}else{
			return false;
		}
	}
	
	/**
	* @desc ȡһINSERTIDֵ 
	* @return int һINSERTIDֵ 
	*/
	function getInsertId(){
		return $this->link->lastInsertId();
	}
	
	/**
	* @desc жǷһм¼ǷEOF   
	* @return bool TRUE FALSE
	*/
	function next($result_type=MYSQL_ASSOC) {
		$this->fetchRow($result_type); 
		return is_array($this->_record);
	}
	
	#special formatting functions	
	#---------------------------------------------------------------------
	
	#Show data in html tabulated fashion 
	#takes three parameters (1) Table Header name ($tharr)
	#						(2) Table Cell values ($tdarr);
	#						(3) Table CSS class ($class) - optional
	
	/**
    * @desc Աʽʾ
	* @param array ֶ,Ϊͷ  array('id','name','age','sex')
	* @param array ֶԶʽȡ¼ѭʾ
	* @param string ʽ
    */
	function showDataAsTable($tharr, $tdarr, $class = '') {		
		#determine if a table class exists
		if($class == '') {
			echo "<table>";
		}
		else {
			echo '<table class="'.$class.'">';
		}
		
		#list table header values;
		echo '<tr>';
		for ($i=0; $i < count($tharr); $i++) {
			echo "<th>".$tharr[$i]."</th>";
		}
		echo'</tr>';
		
		#list table cell values;
		while($row = $this->fetchobject()) {
			echo "<tr>";
			for ($i=0; $i < count($tdarr); $i++) {
				echo "<td>".$row->$tdarr[$i]."</td>";				
			}
			echo "</tr>";
		}		
		echo "</table>";
	}
	#---------------------------------------------------------------------
	
	#Show data in a url encoded fashion (flash datafeed)
	#takes three parameters (1) name of variable to store values ($varname)
	#						(2> database row title ($titlearr)
	#						(3) database row value ($titleval)
	
	/**
    * @desc ȡĽURL
	* @param string ӦURL    http://aa.com/a.php?dbext={Ϊϵ}
	* @param array ֶΪҪϵֶ
	* @param array ֶԶʽȡ¼ѭʾ
    */
	function showDataAsURLEncoded($varname, $rowtitle, $rowval) {	
		echo "{$varname}=";
		while($row = $this->fetchobject()) {
			for($i=0; $i < count($rowtitle); $i++) {
				echo urlencode("&{$rowtitle[$i]}=".$row->$rowval[$i]); 
			}
			
		}		
	}
	
	#---------------------------------------------------------------------
	
	#Creates xml formatted data
	#takes four parameters (1) opening and closing outer xml tags to wrap data ($tag)
	#						(2) inner xml tags to wrap data
	#						(3) database row title ($titlearr)
	#						(4) database row value ($titleval)
	
	/**
    * @desc XMLĵʾõĽ
	* @param string ǩ
	* @param string ӱǩ
	* @param array ֶԶʽȡ¼ѭʾ
    */
	function showDataAsXML($otag, $itag, $rowtitle, $rowval) {	
		$str = "<".$otag."> \n";
		while($row = $this->fetchobject()) {
			$str .= " \t<".$itag."> \n";
			
			for($i=0; $i < count($rowval); $i++) {
				$str.= "\t \t<".$rowtitle[$i].">".$row->$rowval[$i]."</".$rowtitle[$i]."> \n";
			}
			$str.="\t</".$itag.">\n";
		}
		$str .= "</".$otag.">";
		$xml = simplexml_load_string($str);
		echo $xml->asXML();
	}
	
	#---------------------------------------------------------------------
	# Sends xml formatted database information to a file
	# takes two parameters file path and filename
	
	/**
    * @desc XMLļ
	* @param string ǩ,ļ
	* @param string ӱǩ
	* @param array ֶԶʽȡ¼ѭʾ
    */
	function writeDataToXMLFile($otag, $itag, $rowtitle, $rowval) {
		$str = "<".$otag."> \n";
		while($row = $this->fetchobject()) {
			$str .= " \t<".$itag."> \n";
			
			for($i=0; $i < count($rowval); $i++) {
				$str.= "\t \t<".$rowtitle[$i].">".$row->$rowval[$i]."</".$rowtitle[$i]."> \n";
			}
			$str.="\t</".$itag.">\n";
		}
		$str .= "</".$otag.">";
		$xml = simplexml_load_string($str);
		
		$data = $xml->asXML();
		$fh = fopen("{$otag}.xml", "at");
		fwrite($fh, $data);
		fclose($fh);
	}
}


?>