<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	$Id: class.setting.php,v2 11:46 2009-9-10 Lay $
*/

/*
	*
	PHPXMLģ
	ȡXMLڵ
	޸ĺͶȡվļ
	ע xml ʹ utf-8 룬Զת
	*2008-4-3 
	*LIQUAN
	*eg.get config
	
	*$c = new Setting('templet.xslt','config.xml');
	* $c->transform();
	* $c->save();
	* $c->save();
*/

class Setting{
	
	//ļ
	private $xsl;
	
	//ģļ
	private $xml;
	
	//
	private $arr;
	
	//Ƿд
	private $err = true;

	//캯
	function __construct( $data, $xml, $arr ){
		global $_G;
		
		$this->xsl = $data;
		$this->xml = $xml;
		$this->arr = $arr;
		
		//ļ
		if( file_exists($this->xml) ){
			$this->err = false;
		}
		
		//ػ
		if( file_exists($this->xsl) ){
			include( $this->xsl );
		}else{
			$_G['setting'][$this->arr] = array();
		}
	}

	//תHTML
	function transform(){		
		global $_G;
		
		if($this->err) return 'File not found!';
		
		//ʱ
		$arr = $_G['setting'][$this->arr];
	
		//ת룬תΪUTF-8
		if( $_G['product']['charset'] != "utf-8" ){			
			foreach( $arr as $key => $val ){				
				if( is_string($val) ){				
					$arr[$key] = iconv($_G['product']['charset'],"UTF-8",$val);
				}else{
					$arr[$key] = $val;
				}
			}
		}
							
		// Load the XML source
		$xml = new DOMDocument;
		$xml->load($this->xml);		
		
		$doc = $xml->getElementsByTagName('*');
		
		//
		$res = '';
		
		for ($i=0;$i<$doc->length;$i++){
			
			$ele = $doc->item($i);
			
			switch( $ele -> tagName ){
				
				//
				case "item":
				
					$res .= '<tr><td colspan="2" class="section"><span>'.$ele -> getAttribute("desc").'</span><strong>'.$ele -> getAttribute("label").'</strong></td></tr>';
				
				break;
				
				//ѡ
				case "key":
				
					$res .= '<tr text="'.$ele -> getAttribute("tip").'">';
						$res .= '<td width="'.$ele -> getAttribute("width").'" align="'.$ele -> getAttribute("align").'"><strong>'.$ele -> getAttribute("label").'</strong></td>';
						$res .= '<td>';
						
						//
						switch( $ele -> getAttribute("type") ){
							
							case "hidden":
								$res .= '<input name="'.$ele -> getAttribute("name").'" type="hidden" value="'.$arr[$ele -> getAttribute("name")].'" />';
								$res .= $arr[$ele -> getAttribute("name")];
							break;
							
							case "password":
								$res .= '<input name="'.$ele -> getAttribute("name").'" type="password" class="text" size="'.$ele -> getAttribute("size").'" value="'.$arr[$ele -> getAttribute("name")].'" />';
							break;
							
							case "input":
							case "text":
							
								//$this -> fixAttr( $ele );
				
								//$v = array('idcard'=>"fix_id='yes'",'email'=>"fix_email='yes'",'url'=>"fix_url='yes'",'number'=>"fix_number='yes'",'datetime'=>"fix_date='yes' readonly='true' onclick='return showCalendar(this.id,\"y-mm-dd\");' title='--'",''=>'');				
							
								//$res .= '<input name="'.$ele -> getAttribute("name").'" size="'.$ele -> getAttribute("size").'" class="text" value="'.stripcslashes($arr[$ele -> getAttribute("name")]).'" fix_name="'.$ele -> getAttribute("label").'" '.$v[$ele -> getAttribute("format")].'  fix_null="'.( $ele -> getAttribute("null") == "false" ? "yes" : "" ).'" />';
								
								if( $ele -> getAttribute("readonly") ){
									$res .= '<input name="'.$ele -> getAttribute("name").'" size="'.$ele -> getAttribute("size").'" class="text" value="'.$ele -> getAttribute("value").'" '. $this -> fixAttr( $ele ) .' readonly="true" />';	
								}else{
									$res .= '<input name="'.$ele -> getAttribute("name").'" size="'.$ele -> getAttribute("size").'" class="text" value="'.stripcslashes($arr[$ele -> getAttribute("name")]).'" '. $this -> fixAttr( $ele ) .' />';
								}
								
							break;
							
							case "textarea":
								$res .= '<textarea name="'.$ele -> getAttribute("name").'" rows="'.$ele -> getAttribute("rows").'" cols="'.$ele -> getAttribute("cols").'" '. $this -> fixAttr( $ele ) .'>'.stripcslashes($arr[$ele -> getAttribute("name")]).'</textarea>';							
							break;
							
							case "select":
								$res .= '<select name="'.$ele -> getAttribute("name").'" style="width:'.$ele -> getAttribute("size").'px;">';
								
								//ѡ
								$sub = $ele->getElementsByTagName('option');
								
								for ($s=0; $s<$sub->length; $s++){														
									$res .= '<option value="'.$sub ->item($s) -> getAttribute("value").'" '. ( $arr[$ele -> getAttribute("name")] == $sub ->item($s) -> getAttribute("value") ? 'selected="selected"' : '') .'>'.$sub ->item($s) -> nodeValue.'</option>';								
								}
								
								//////////////////////////
								
								//ļ
								if( $ele -> getAttribute("folder") ){
									
									//ƤĿ¼
									$root = VI_ROOT.$ele -> getAttribute("folder");
									
									if ($handle = opendir($root)) {
										while (false !== ($file = readdir($handle))) {
											if( ($file  !=   ".") && ($file   !=   "..") && is_dir($root.$file) ){
												$res .= '<option value="'.$file.'" '. ( $arr[$ele -> getAttribute("name")] == $file ? 'selected="selected"' : '') .'>'.$file.'</option>';							
											}
										}
										closedir($handle);
									}	
									
								}
															
								$res .= '</select>';							
							break;
							
							case "radio":								
								
								//ѡ
								$sub = $ele->getElementsByTagName('option');
								
								for ($s=0; $s<$sub->length; $s++){														
									$res .= '<label><input name="'.$ele -> getAttribute("name").'" value="'.$sub ->item($s) -> getAttribute("value").'" class="radio" type="radio" '. ( $arr[$ele -> getAttribute("name")] == $sub ->item($s) -> getAttribute("value") ? 'checked="checked"' : '') .' />'.$sub ->item($s) -> nodeValue.'</option></label>';
								}															
															
							break;
							
							case "checkbox":
								
								//ѡ
								$sub = $ele->getElementsByTagName('option');
								
								for ($s=0; $s<$sub->length; $s++){														
									$res .= '<label><input name="'.$ele -> getAttribute("name").'[]" value="'.$sub ->item($s) -> getAttribute("value").'" class="checkbox" type="checkbox" '. ( in_array($sub ->item($s) -> getAttribute("value"),$arr[$ele -> getAttribute("name")]) ? 'checked="checked"' : '') .' />'.$sub ->item($s) -> nodeValue.'</option></label>';								
								}															
															
							break;
							
							case "notice":
							
								$res .= '<div class="highlight">'.$ele -> getAttribute("desc").'</div>';
								
								$ele -> setAttribute("desc",'');
								
							break;
							
							default:
								
								$res .= 'ERROR';								
															
							break;
							
						}						
						$res .= $ele -> getAttribute("desc");
						$res .= '</td>';					
					$res .= '</tr>';
				
				break;				
				
			}
			
		}
	
		//ת룬UTF-8תΪǰ
		if( $_G['product']['charset'] != "utf-8" ){
			$res = iconv("UTF-8",$_G['product']['charset'],$res);
		}
		
		//
		return $res;
	
	}
	
	//дȨ޲
	function writable(){
		return is_writable( $this->xsl );
	}
	
	function fixAttr( $ele ){
		$ext = '';		
		foreach( $ele -> attributes as $att ){
			if( strpos( $att -> name,  'fix_' ) !== FALSE ){
				$ext .= $att -> name.'="'.$att -> value.'" ';
			}
		}
		return $ext;
	}
	

	//ȡXML
	function get(){		
		global $_G;
		
		if($this->err) return 'File not found!';
							
		//ȡ
		$xml = simplexml_load_file($this->xml);
		$dom = simplexml_import_dom($xml);
		
		$array = array();
		
		//ڵ
		foreach ($dom->xpath('//key') as $key) {
			$name = $key['name'];
			$type = $key["type"];
			$format = $key["format"];
			
			switch($type){
				case "input":
				case "radio":
				case "hidden":
				case "select":
					$value = $key['value'];					
				break;
				
				case "checkbox":				
					$value = "";
					//Ԫ
					foreach ($key->xpath('option') as $input) {
						if( $input["checked"] == "true" ){
							$value .= $input["value"].",";
						}						
					}
					$value = substr($value,0,-1);
				break;
				
				case "textarea":
					$value = $key;
				break;
			}
			
			//ת
			if( $_G['product']['charset'] && $_G['product']['charset'] != "utf-8" ){
				$value = iconv("UTF-8",$_G['product']['charset'],$value);
			}
			
			$array[(string) $key['name']] = (string) $value;
			
		}
		
		return $array;		
	}
	
	/*
		
	
		make	д
	*/
	function save( $method , $make = TRUE ){		
		global $_G;
		
		if($this->err) return 'File not found!';
		
		$query = ( $method=='POST'? $_POST : $_GET ) ;
		
		//ֻ²
		if( !$make ){
		
			//ʱ
			$arr = $_G['setting'][$this->arr];
			
			//дύֵ
			foreach( $query as $key => $val ){				
				$arr[$key] = $val;
			}
			
			$query = $arr ;			
		}
		
		//תַ
		foreach( $query as $key => $val ){				
			if( is_string($val) ){				
				$query[$key] = stripcslashes($val);
			}else{
				$query[$key] = $val;
			}
			if( $key == 'platform' ) $this -> rewrite( $val, $query['domain'] );
		}
		
		$str = '<?php'.chr(13);
		$str .= ' /*'.date("Y-m-t H:i:s").'*/ '.chr(13);		
		$str .= '$_G[\'setting\'][\''.$this->arr.'\'] = ';		
		$str .= var_export( $query , TRUE );		
		$str .= ';?>';
		
		//д뻺
		return create_file($this->xsl,$str);
		
	}
	
	/*
		α̬
		
	*/
	function rewrite( $mode, $domain ){
		global $_G;
		
		//ǰĿ¼
		$base = dirname( $this->xml );
		
		//XML ַ
		$data = $base . '/rewrite.xml';
		
		//洢Ŀ¼
		$save = $base . '/content/.htaccess';
		
		// Load the XML source
		$xml = new DOMDocument;
		$xml->load( $data );		
		$doc = $xml->getElementsByTagName('key');		
		for ($i=0;$i<$doc->length;$i++){			
			$ele = $doc->item($i);			
			if( $ele -> getAttribute("name") == $mode ){
				$text = trim( $ele -> nodeValue );
				
				//а
				if( $domain ){
					$text = str_replace( '{BASE}', '/', $text );
				}else{					
					$text = str_replace( '{BASE}', VI_BASE.'module/'.$this->arr.'/content/', $text );
				}
				
				//ת루Linux Ϊ ANSI ʽ
				$text = iconv('UTF-8','GBK',$text);
				
				return create_file( $save , $text );
				break;
			}
			
		}
	
	}

}
?>