<?php
/**
 * KindEditor PHP
 * 
 * 本PHP程序是演示程序，建议不要直接在实际项目中使用。
 * 如果您确定直接使用本程序，使用之前请仔细确认相关安全设置。
 * 
 */

//载入全局配置和函数包
require dirname(__FILE__)."/../include/global.php";

require VI_ROOT.'class/thumb.php';

/***********************/

//会话域
$session = $session ? $session : 'Manager';

//水印地址
$water = getgpc("watermark") ? VI_ROOT.$_G['setting']['attach']['MARK_FILE'] : '';

//水印位置
$position= getnum( "position", $_G['setting']['attach']['MARK_POSITION'] );

//原图是水印图尺寸的几倍时打上水印
$multiple= getnum("multiple", $_G['setting']['attach']['MARK_MULTIPLE'] );

/***********************/

//文件保存目录路径
$save_path = VI_ROOT.$_G['project']['upload'];

//文件保存目录URL
$save_url = VI_HOST.$_G['project']['upload'];

//定义允许上传的文件扩展名
$ext_arr = array(
	'image' => array('gif', 'jpg', 'jpeg', 'png', 'bmp'),
	'flash' => array('swf', 'flv'),
	'media' => array('swf', 'flv', 'mp3', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb'),
	'files' => array('doc', 'docx', 'xls', 'xlsx', 'ppt', 'htm', 'html', 'txt', 'zip', 'rar', 'gz', 'bz2'),
);

//最大文件大小
$max_size = 1000000;

$save_path = realpath($save_path) . '/';

if ( $_G['setting']['global']['upload'] != "on" ){
	
	alert( 1, "系统已禁用本功能!");
	
}elseif ( !$_SESSION[$session]['account'] && !$_SESSION[$session]['id'] ){
	
	alert( 1, "您当前不在登录状态!");

}elseif (empty($_FILES) === false) {
	
	//原文件名
	$file_name = $_FILES['imgFile']['name'];
	
	//服务器上临时文件名
	$tmp_name = $_FILES['imgFile']['tmp_name'];
	
	//文件大小
	$file_size = $_FILES['imgFile']['size'];
	
	//检查文件名
	if (!$file_name) {
		alert( 1, "请选择文件。");
	}
	//检查目录
	if (@is_dir($save_path) === false) {
		alert( 1, "上传目录不存在。");
	}
	//检查目录写权限
	if (@is_writable($save_path) === false) {
		alert( 1, "上传目录没有写权限。");
	}
	//检查是否已上传
	if (@is_uploaded_file($tmp_name) === false) {
		alert( 1, "临时文件可能不是上传文件。");
	}
	//检查文件大小
	if ($file_size > $max_size) {
		alert( 1, "上传文件大小超过限制。");
	}
	//检查目录名
	$dir_name = empty($_GET['dir']) ? 'image' : trim($_GET['dir']);
	if (empty($ext_arr[$dir_name])) {
		alert( 1, "目录名不正确。");
	}
	
	//获得文件扩展名
	$temp_arr = explode(".", $file_name);
	$file_ext = array_pop($temp_arr);
	$file_ext = trim($file_ext);
	$file_ext = strtolower($file_ext);
	
	//检查扩展名
	if (in_array($file_ext, $ext_arr[$dir_name]) === false) {
		alert( 1, "上传文件扩展名是不允许的扩展名。\n只允许" . implode(",", $ext_arr[$dir_name]) . "格式。");
	}
	
	//创建文件夹
	if ($dir_name !== '') {
		$save_path .= $dir_name . "/";
		$save_url .= $dir_name . "/";
		if (!file_exists($save_path)) {
			mkdir($save_path);
		}
	}
	
	$ymd = date("Y/md/");
	$save_path .= $ymd;
	$save_url .= $ymd;
	
	/*
	if (!file_exists($save_path)) {
		mkdir($save_path);
	}
	*/
	
	//创建子文件夹
	//$save_path = $save_path.date("Y/md/");
	create_dir( $save_path );
	
	//新文件名
	$new_file_name = date("H-i-s-").mt_rand().'.' . $file_ext;
	
	//移动文件
	$file_path = $save_path . $new_file_name;
	if (move_uploaded_file($tmp_name, $file_path) === false) {
		alert( 1, "上传文件失败。");
	}
	@chmod($file_path, 0644);
	
	$file_url = $save_url . $new_file_name;	
	
	list($width, $height, $image_type, $attr) = getimagesize($file_path);
	
	/**************************/

	//给组图_打上水印
	if( $_G['setting']['attach']['MARK_OPEN'] == "true" && file_exists( $water ) ){
	
		list($water_w, $water_h) = getimagesize($water);
			
		//水印信息
		if( $water_w && $water_h && ( $width / $water_w > $multiple ) && ( $height / $water_h > $multiple ) ){
			
			//缩略图            
			$t = new ThumbHandler();
	
			//源图片地址
			$t->setSrcImg( $file_path );
	
			//输出文件名
			$t->setDstImg( $file_path );
	
			$t->setMaskImg( $water );
			
			$t->setMaskPosition( $position );
	
			//生成图片
			$t->createImg( 100 );
			
		}
		
	}
	
	/**************************/

	//连接数据库
	System :: connect();
	
	//写入数据库
	$sql="INSERT INTO `sys:attach`(aid,account,name,input,dateline,type,size,ip,width,height,remote) values('".$_SESSION[$session]["id"]."','".$_SESSION[$session]["account"]."','".str_replace(VI_HOST,VI_BASE,$file_url)."','KindEditor',".time().",'".$file_ext."',$file_size,'".GetIP()."',$width,$height,0)";
	
	System :: $db -> execute( $sql );

	//关闭数据库
	System :: connect();
	
	/**************************/

	/*
	header('Content-type: text/html; charset=UTF-8');
	
	//跨域支持（子域名必需）
	echo '<script>document.domain="'. $_G['setting']['global']['domain'] .'";</script>';
	
	echo json_encode(array('error' => 0, 'url' => $file_url));
	exit;
	*/
	
	alert( 0, '', $file_url );
	
}

/*
	输出消息
	$err	0 无错 1 有错
	$msg	消息内容
	$url	附件地址
*/
function alert( $err, $msg, $url ) {
	global $_G;
	
	header('Content-type: text/html; charset=UTF-8');
	
	//跨域支持（子域名必需）
	echo $_GET['crossdomain'] ? '<script>'. System :: cross_domain() .'</script>' : '';
	
	echo json_encode(array('error' => $err, 'message' => $msg, 'url' => $url));
	exit;
}
?>