/*
 * Decompiled with CFR 0.152.
 */
package org.openads.proxy;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.openads.proxy.AdvertiserService;
import org.openads.proxy.AgencyService;
import org.openads.proxy.BannerService;
import org.openads.proxy.CampaignService;
import org.openads.proxy.LogonService;
import org.openads.proxy.PublisherService;
import org.openads.proxy.ZoneService;

public class OpenAdsApiXmlRpcProxy {
    private String host;
    private String basepath;
    private int port;
    private boolean ssl;
    private String sessionId;
    private LogonService logonService;
    private AgencyService agencyService;
    private AdvertiserService advertiserService;
    private CampaignService campaignService;
    private BannerService bannerService;
    private PublisherService publisherService;
    private ZoneService zoneService;

    public OpenAdsApiXmlRpcProxy(String string, String string2, int n, boolean bl) {
        this.host = string;
        this.basepath = string2;
        this.port = n;
        this.ssl = bl;
        try {
            String string3 = this.ssl ? "https" : "http";
            URL uRL = new URL(string3, this.host, this.port, "/" + this.basepath);
            this.logonService = new LogonService(uRL.toString());
            this.agencyService = new AgencyService(uRL.toString());
            this.advertiserService = new AdvertiserService(uRL.toString());
            this.campaignService = new CampaignService(uRL.toString());
            this.bannerService = new BannerService(uRL.toString());
            this.publisherService = new PublisherService(uRL.toString());
            this.zoneService = new ZoneService(uRL.toString());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public OpenAdsApiXmlRpcProxy(String string, String string2) {
        this(string, string2, -1, false);
    }

    public Boolean logon(String string, String string2) throws XmlRpcException, IOException {
        try {
            this.sessionId = this.logonService.logon(string, string2);
            if (this.isValidSessionId()) {
                this.logonService.setSessionId(this.sessionId);
                this.agencyService.setSessionId(this.sessionId);
                this.advertiserService.setSessionId(this.sessionId);
                this.campaignService.setSessionId(this.sessionId);
                this.bannerService.setSessionId(this.sessionId);
                this.publisherService.setSessionId(this.sessionId);
                this.zoneService.setSessionId(this.sessionId);
                return true;
            }
            return false;
        }
        catch (XmlRpcException xmlRpcException) {
            this.sessionId = null;
            throw xmlRpcException;
        }
    }

    private boolean isValidSessionId() {
        return this.sessionId != null;
    }

    private void verifyLogon() {
        if (!this.isValidSessionId()) {
            throw new IllegalArgumentException("Not logined to server");
        }
    }

    public Boolean logoff() throws XmlRpcException, IOException {
        this.verifyLogon();
        Boolean bl = this.logonService.logoff();
        if (bl.booleanValue()) {
            this.sessionId = null;
        }
        return bl;
    }

    public Integer addAgency(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.addAgency(map);
    }

    public Boolean modifyAgency(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.modifyAgency(map);
    }

    public Boolean deleteAgency(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.deleteAgency(n);
    }

    public Map getAgency(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.getAgency(n);
    }

    public Map[] getAgencyList() throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.getAgencyList();
    }

    public Map[] agencyZoneStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyZoneStatistics(n);
    }

    public Map[] agencyZoneStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyZoneStatistics(n, date);
    }

    public Map[] agencyZoneStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyZoneStatistics(n, date, date2);
    }

    public Map[] agencyAdvertiserStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyAdvertiserStatistics(n);
    }

    public Map[] agencyAdvertiserStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyAdvertiserStatistics(n, date);
    }

    public Map[] agencyAdvertiserStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyAdvertiserStatistics(n, date, date2);
    }

    public Map[] agencyBannerStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyBannerStatistics(n);
    }

    public Map[] agencyBannerStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyBannerStatistics(n, date);
    }

    public Map[] agencyBannerStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyBannerStatistics(n, date, date2);
    }

    public Map[] agencyCampaignStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyCampaignStatistics(n);
    }

    public Map[] agencyCampaignStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyCampaignStatistics(n, date);
    }

    public Map[] agencyCampaignStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyCampaignStatistics(n, date, date2);
    }

    public Map[] agencyDailyStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyDailyStatistics(n);
    }

    public Map[] agencyDailyStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyDailyStatistics(n, date);
    }

    public Map[] agencyDailyStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyDailyStatistics(n, date, date2);
    }

    public Map[] agencyPublisherStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyPublisherStatistics(n);
    }

    public Map[] agencyPublisherStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyPublisherStatistics(n, date);
    }

    public Map[] agencyPublisherStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.agencyService.agencyPublisherStatistics(n, date, date2);
    }

    public Integer addAdvertiser(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.addAdvertiser(map);
    }

    public Boolean modifyAdvertiser(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.modifyAdvertiser(map);
    }

    public Boolean deleteAdvertiser(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.deleteAdvertiser(n);
    }

    public Map getAdvertiser(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.getAdvertiser(n);
    }

    public Map[] getAdvertiserListByAgencyIdAllFields(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.getAdvertiserListByAgencyIdAllFields(n);
    }

    public Map[] advertiserZoneStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserZoneStatistics(n);
    }

    public Map[] advertiserZoneStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserZoneStatistics(n, date);
    }

    public Map[] advertiserZoneStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserZoneStatistics(n, date, date2);
    }

    public Map[] advertiserBannerStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserBannerStatistics(n);
    }

    public Map[] advertiserBannerStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserBannerStatistics(n, date);
    }

    public Map[] advertiserBannerStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserBannerStatistics(n, date, date2);
    }

    public Map[] advertiserCampaignStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserCampaignStatistics(n);
    }

    public Map[] advertiserCampaignStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserCampaignStatistics(n, date);
    }

    public Map[] advertiserCampaignStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserCampaignStatistics(n, date, date2);
    }

    public Map[] advertiserDailyStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserDailyStatistics(n);
    }

    public Map[] advertiserDailyStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserDailyStatistics(n, date);
    }

    public Map[] advertiserDailyStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserDailyStatistics(n, date, date2);
    }

    public Map[] advertiserPublisherStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserPublisherStatistics(n);
    }

    public Map[] advertiserPublisherStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserPublisherStatistics(n, date);
    }

    public Map[] advertiserPublisherStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.advertiserService.advertiserPublisherStatistics(n, date, date2);
    }

    public Integer addCampaign(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.addCampaign(map);
    }

    public Boolean modifyCampaign(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.modifyCampaign(map);
    }

    public Boolean deleteCampaign(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.deleteCampaign(n);
    }

    public Map getCampaign(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.getCampaign(n);
    }

    public Map[] getCampaignListByAdvertiserID(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.getCampaignListByAdvertiserID(n);
    }

    public Map[] campaignZoneStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignZoneStatistics(n);
    }

    public Map[] campaignZoneStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignZoneStatistics(n, date);
    }

    public Map[] campaignZoneStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignZoneStatistics(n, date, date2);
    }

    public Map[] campaignBannerStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignBannerStatistics(n);
    }

    public Map[] campaignBannerStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignBannerStatistics(n, date);
    }

    public Map[] campaignBannerStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignBannerStatistics(n, date, date2);
    }

    public Map[] campaignDailyStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignDailyStatistics(n);
    }

    public Map[] campaignDailyStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignDailyStatistics(n, date);
    }

    public Map[] campaignDailyStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignDailyStatistics(n, date, date2);
    }

    public Map[] campaignPublisherStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignPublisherStatistics(n);
    }

    public Map[] campaignPublisherStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignPublisherStatistics(n, date);
    }

    public Map[] campaignPublisherStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.campaignService.campaignPublisherStatistics(n, date, date2);
    }

    public Integer addBanner(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.addBanner(map);
    }

    public Boolean modifyBanner(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.modifyBanner(map);
    }

    public Boolean deleteBanner(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.deleteBanner(n);
    }

    public Map getBanner(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.getBanner(n);
    }

    public Map[] getBannerListByAdvertiserID(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.getBannerListByAdvertiserID(n);
    }

    public Map[] bannerZoneStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerZoneStatistics(n);
    }

    public Map[] bannerZoneStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerZoneStatistics(n, date);
    }

    public Map[] bannerZoneStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerZoneStatistics(n, date, date2);
    }

    public Map[] bannerDailyStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerDailyStatistics(n);
    }

    public Map[] bannerDailyStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerDailyStatistics(n, date);
    }

    public Map[] bannerDailyStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerDailyStatistics(n, date, date2);
    }

    public Map[] bannerPublisherStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerPublisherStatistics(n);
    }

    public Map[] bannerPublisherStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerPublisherStatistics(n, date);
    }

    public Map[] bannerPublisherStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.bannerService.bannerPublisherStatistics(n, date, date2);
    }

    public Integer addZone(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.addZone(map);
    }

    public Boolean modifyZone(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.modifyZone(map);
    }

    public Boolean deleteZone(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.deleteZone(n);
    }

    public Map getZone(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.getZone(n);
    }

    public Map[] getZoneListByPublisherId(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.getZoneListByPublisherId(n);
    }

    public Map[] zoneAdvertiserStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneAdvertiserStatistics(n);
    }

    public Map[] zoneAdvertiserStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneAdvertiserStatistics(n, date);
    }

    public Map[] zoneAdvertiserStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneAdvertiserStatistics(n, date, date2);
    }

    public Map[] zoneBannerStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneBannerStatistics(n);
    }

    public Map[] zoneBannerStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneBannerStatistics(n, date);
    }

    public Map[] zoneBannerStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneBannerStatistics(n, date, date2);
    }

    public Map[] zoneCampaignStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneCampaignStatistics(n);
    }

    public Map[] zoneCampaignStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneCampaignStatistics(n, date);
    }

    public Map[] zoneCampaignStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneCampaignStatistics(n, date, date2);
    }

    public Map[] zoneDailyStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneDailyStatistics(n);
    }

    public Map[] zoneDailyStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneDailyStatistics(n, date);
    }

    public Map[] zoneDailyStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.zoneService.zoneDailyStatistics(n, date, date2);
    }

    public Integer addPublisher(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.addPublisher(map);
    }

    public Boolean modifyPublisher(Map map) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.modifyPublisher(map);
    }

    public Boolean deletePublisher(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.deletePublisher(n);
    }

    public Map getPublisher(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.getPublisher(n);
    }

    public Map[] getPublisherListByAgencyId(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.getPublisherListByAgencyId(n);
    }

    public Map[] publisherZoneStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherZoneStatistics(n);
    }

    public Map[] publisherZoneStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherZoneStatistics(n, date);
    }

    public Map[] publisherZoneStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherZoneStatistics(n, date, date2);
    }

    public Map[] publisherCampaignStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherCampaignStatistics(n);
    }

    public Map[] publisherCampaignStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherCampaignStatistics(n, date);
    }

    public Map[] publisherCampaignStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherCampaignStatistics(n, date, date2);
    }

    public Map[] publisherDailyStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherDailyStatistics(n);
    }

    public Map[] publisherDailyStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherDailyStatistics(n, date);
    }

    public Map[] publisherDailyStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherDailyStatistics(n, date, date2);
    }

    public Map[] publisherBannerStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherBannerStatistics(n);
    }

    public Map[] publisherBannerStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherBannerStatistics(n, date);
    }

    public Map[] publisherBannerStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherBannerStatistics(n, date, date2);
    }

    public Map[] publisherAdvertiserStatistics(Integer n) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherAdvertiserStatistics(n);
    }

    public Map[] publisherAdvertiserStatistics(Integer n, Date date) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherAdvertiserStatistics(n, date);
    }

    public Map[] publisherAdvertiserStatistics(Integer n, Date date, Date date2) throws XmlRpcException, IOException {
        this.verifyLogon();
        return this.publisherService.publisherAdvertiserStatistics(n, date, date2);
    }
}

