<?php

/*
+---------------------------------------------------------------------------+
| OpenX v2.8                                                                |
| ==========                                                                |
|                                                                           |
| Copyright (c) 2003-2009 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: SystemUser.php 62345 2010-09-14 21:16:38Z chris.nutting $
*/

require_once MAX_PATH . '/lib/OA/Permission/User.php';

/**
 * A class for managing users.
 *
 * @package    OpenXPermission
 */
class OA_Permission_SystemUser extends OA_Permission_User
{

    /**
     * Class constructor
     *
     * @return OA_Permission_User
     */
    function OA_Permission_SystemUser($userName)
    {
        // Store user information as array
        $this->aUser = array(
            'user_id'  => 0,
            'username' => $userName,
        );

        // Make sure we start with an empty account
        $this->_clearAccountData();
    }
}

?>
