/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50726
Source Host           : 127.0.0.1:3306
Source Database       : manual

Target Server Type    : MYSQL
Target Server Version : 50726
File Encoding         : 65001

Date: 2020-08-22 20:17:32
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for prefix_xielei_manual_manual
-- ----------------------------
DROP TABLE IF EXISTS `prefix_xielei_manual_manual`;
CREATE TABLE `prefix_xielei_manual_manual` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `alias` varchar(255) NOT NULL DEFAULT '' COMMENT '目录',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `tpl_manual` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `tpl_post` varchar(255) NOT NULL DEFAULT '' COMMENT '内容页模板',
  `state` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否发布',
  `body` text,
  `cover` varchar(255) NOT NULL DEFAULT '' COMMENT '目录',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='内容栏目表';

-- ----------------------------
-- Records of prefix_xielei_manual_manual
-- ----------------------------
INSERT INTO `prefix_xielei_manual_manual` VALUES ('1', 'ebcms/framework 手册', 'ebcms_framework', '', '', '', '', '1', '## 写在最前\r\n\r\n很多人好奇，全球那么多php框架，为什么还要重复造轮子？\r\n\r\n本人从事php开发超过5年，用过很多的框架，thinkphp、laravel、zendframework...，也用过很多成熟的基于php开发的产品，比如wordpress、discuz、phpcms、dedecms...，但总是这里或者哪里不让我如意的地方。\r\n\r\n**我心中理想的框架应该具备：**\r\n\r\n- 标准化：常用的操作、通用的类库，应该遵守统一的规范或接口\r\n- 应用生态：应该有很好的应用分享机制\r\n- 国际化：世界各地的开发者都能够无缝参与进来\r\n\r\n于是ebcms/framework出来了\r\n\r\n## 项目特点\r\n\r\n#### 1.严格遵守PSR规范\r\n\r\n本项目严格遵守PSR规范，`消息`、`日志`、`缓存`、`容器`、`事件`、`代码规范`...\r\n\r\n遵守PSR规范带来的直接好处是即刻拥有了composer上的海量的生态资源，并且更容易让其他php开发者无缝参与进来。\r\n\r\n#### 2.先进的应用生态理念\r\n\r\n本项目原生理念就是为应用分享，基于composer优秀的包依赖机制，您开发的APP可以通过composer被世界各地的人使用，您也可以使用别人开发的APP。\r\n\r\n#### 3.极简内核\r\n\r\n得益于遵守PSR规范，我们的内核极度简单，概括来讲就是`流程`+`路由`+`配置`，系统没有其他多余的东西，因为PSR已经帮我们规定好了，你只需要符合PSR规范。\r\n\r\n***项目开源地址：[Github](https://github.com/ebcms/framework)，欢迎PR ^_^***', '', '1595486640', '1598097567');
INSERT INTO `prefix_xielei_manual_manual` VALUES ('2', 'jQuery手册', 'jquery', '', '', '', '', '1', '1', '', '1598097553', '1598098239');
INSERT INTO `prefix_xielei_manual_manual` VALUES ('3', 'Redis手册', 'redis', '', '', '', '', '1', 'redis是缓存系统', '', '1598098337', '1598098427');
INSERT INTO `prefix_xielei_manual_manual` VALUES ('4', 'PHP手册', 'php', '', '', '', '', '1', 'php是优秀的web开发语言，是全世界最好的语言', '', '1598098357', '1598098403');

-- ----------------------------
-- Table structure for prefix_xielei_manual_post
-- ----------------------------
DROP TABLE IF EXISTS `prefix_xielei_manual_post`;
CREATE TABLE `prefix_xielei_manual_post` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `manual_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1 目录 2文档',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键词',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '摘要',
  `body` text,
  `alias` varchar(255) NOT NULL DEFAULT '' COMMENT '文件名称',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `state` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `rank` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `list` (`manual_id`,`state`) USING BTREE,
  FULLTEXT KEY `ft_index` (`title`,`keywords`,`description`,`body`) /*!50100 WITH PARSER `ngram` */ 
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='内容基本表';

-- ----------------------------
-- Records of prefix_xielei_manual_post
-- ----------------------------
INSERT INTO `prefix_xielei_manual_post` VALUES ('1', '1', '12', '2', '流程', '', '', '系统流程执行如下：\r\n\r\n1. 入口文件`index.php`\r\n2. 载入文件`bootstrap.php`\r\n3. 执行钩子`app.start`\r\n4. 解析路由\r\n5. 执行钩子`app.start@包`\r\n6. 执行程序\r\n7. 执行钩子`app.end@包`\r\n8. 执行钩子`app.end`\r\n9. 结束\r\n\r\n`app.start`：系统开始解析路由之前\r\n\r\n`app.start@包`：路由解析完成后，此时可以得到请求的`包名`、`控制器名`\r\n\r\n`app.end@包`：此时系统已经完成执行，可以得到`响应`\r\n\r\n`app.end`：同上，只是`app.end@包`仅会在请求某个包的url下执行\r\n\r\n**特别说明**\r\n\r\n*若配置路由直接路由到闭包的时候，则不会执行相关包的钩子（即无5和7），因为没有经过包。*', '', '0', '1595486686', '1595733746', '1', '6');
INSERT INTO `prefix_xielei_manual_post` VALUES ('2', '1', '12', '2', '钩子', '', '', '**整个系统有且仅有四个钩子**\r\n\r\n* `app.start`\r\n* `app.start@包`\r\n* `app.end@包`\r\n* `app.end`\r\n\r\n钩子的作用主要是在系统执行到某个点的时候，进行切面操作，例如：\r\n\r\n* 在`app.start`的时候注册路由\r\n* 在`app.end`的时候操作`响应`\r\n* 在`app.start@包`的时候，对该包的执行进行一些配置\r\n\r\n钩子会自动载入包对应文件夹下的**所有文件**，如下：\r\n\r\n* /hook/钩子名/\\*\\*.php\r\n* /所有安装了的包/src/hook/钩子名/\\*\\*.php\r\n\r\n**可以跨包操作**\r\n\r\n例如在`xielei/manual`包下面配置钩子`/hook/app.start@xielei.test/foo.php`,`/hook/app.start@xielei.test/bar.php`文件夹，在文件加下的文件就会在**`xielei/test`**包执行的时候引入上述两个文件\r\n\r\n常见的使用场景如下：\r\n\r\n* 设置模板路径，做主题包\r\n* 对其他包做插件\r\n* ...\r\n\r\n**钩子示例**\r\n\r\n记录全局请求日志 `/hook/app.start/log.php`\r\n```php\r\nuse Ebcms\\App;\r\nuse Ebcms\\Container;\r\nuse Monolog\\Handler\\StreamHandler;\r\nuse Monolog\\Logger;\r\nuse Psr\\Log\\LoggerInterface;\r\n\r\nApp::getInstance()->execute(function (\r\n    Container $container,\r\n    App $app\r\n) {\r\n    $container->set(LoggerInterface::class, function () use ($app): LoggerInterface {\r\n        $log = new Logger($_SERVER[\'HTTP_HOST\']);\r\n        $log->pushHandler(new StreamHandler($app->getAppPath() . \'/runtime/log/\' . date(\'Y-m-d\') . \'/debug.log\', Logger::DEBUG));\r\n        return $log;\r\n    });\r\n    $container->get(LoggerInterface::class)->debug($_SERVER[\'REQUEST_METHOD\'] . \':\' . $_SERVER[\'REQUEST_URI\'], [$_POST, $_GET]);\r\n});\r\n```\r\n\r\n给`xielei/article`包自定义函数 `/hook/app.start@xielei.article/functions.php`\r\n```php\r\nfunction test(): array\r\n{\r\n    return [];\r\n}\r\n```\r\n\r\n给`xielei/article`包注入中间件 `/hook/app.start@xielei.article/middleware.php`\r\n```php\r\nuse Ebcms\\App;\r\nuse Ebcms\\RequestHandler;\r\n\r\nApp::getInstance()->execute(function (\r\n    RequestHandler $requestHandler,\r\n    App $app\r\n) {\r\n    $requestHandler->lazyMiddleware(SomeMiddleware::class);\r\n});\r\n```\r\n\r\n...还有很多，这里就不一一列举。', '', '0', '1595486693', '1595733753', '1', '5');
INSERT INTO `prefix_xielei_manual_post` VALUES ('3', '1', '12', '2', '配置', '', '', '**配置类`\\Ebcms\\Config`**\r\n\r\n配置分类三块：\r\n\r\n**用户配置**\r\n\r\n此配置位于系统的`config`文件夹下面，拥有最高的优先级，例如：\r\n\r\n`/config/xielei/article/site.php`\r\n\r\n**模块配置**\r\n\r\n模块配置有开发者事先配置，在对应包的`config`文件夹下面，例如：\r\n\r\n`包路径/src/config/site.php`\r\n\r\n**默认配置**\r\n\r\n默认配置是固定在代码中，无模块配置和用户配置的时候的默认值，例如：\r\n\r\n```php\r\n$config->get(\'key\',\'默认值\');\r\n$config->get(\'siteconfig@xielei.article\', [...]);\r\n$config->get(\'site.title@xielei.article\', \'某某网站\');\r\n```\r\n\r\n**优先级顺序**\r\n\r\n`用户配置`>`模块配置`>`默认配置`\r\n\r\n意思就是 在有用户配置的情况下会优先使用用户配置，否则就使用模块配置，若没有模块配置，再使用默认配置\r\n\r\n用法：\r\n\r\n```php\r\n$config->get(\'foo.bar@包\', \'默认值\');\r\n```\r\n\r\n例如：\r\n\r\n```php\r\n// 获取包xielei/article的配置文件site.php下的title值\r\n$config->get(\'site.title@xielei.article\');\r\n\r\n// 获取包xielei/article的配置文件site.php下的所有值\r\n$config->get(\'site@xielei/article\');\r\n```\r\n\r\n**只能获取已经安装的模块的配置数据**\r\n\r\n**包可以用`.`分割，也可以用`/`分割**', '', '0', '1595486703', '1595733760', '1', '4');
INSERT INTO `prefix_xielei_manual_post` VALUES ('4', '1', '12', '2', '中间件', '', '', '**中间件遵守标准的PSR规范！**\r\n\r\n中间件由`\\Ebcms\\RequestHandler`管理\r\n\r\n支持如下方法：\r\n\r\n* `middleware(MiddlewareInterface $middleware)` 注册一个中间件\r\n* `middlewares(array $middlewares)` 注册多个中间件\r\n* `prependMiddleware(MiddlewareInterface $middleware)` 注册一个中间件(顶部追加)\r\n* `lazyMiddleware(string $middleware)` 注册一个中间件(字符串形式、命名空间形式)\r\n* `lazyMiddlewares(array $middlewares)` 注册多个中间件(字符串形式、命名空间形式)\r\n* `lazyPrependMiddleware(string $middleware)` 注册一个中间件(字符串形式、命名空间形式)(顶部追加)\r\n\r\n**前置中间件**\r\n\r\n前置中间件就是在获得响应之前进行条件判断返回其他响应，主要是用作拦截，比如权限认证、跳转等等\r\n\r\n一个前置中间件的示例：\r\n\r\n```php\r\nuse Psr\\Http\\Message\\ResponseInterface;\r\nuse Psr\\Http\\Message\\ServerRequestInterface;\r\nuse Psr\\Http\\Server\\MiddlewareInterface;\r\nuse Psr\\Http\\Server\\RequestHandlerInterface;\r\n\r\nclass Auth implements MiddlewareInterface\r\n{\r\n    public function process(\r\n        ServerRequestInterface $request,\r\n        RequestHandlerInterface $handler\r\n    ): ResponseInterface {\r\n        if (\'未登录\') {\r\n            // 在响应之前返回跳转\r\n            return new JumpResponse(\'http://...\', 302);\r\n        }\r\n        return $handler->handle($request);\r\n    }\r\n}\r\n\r\n```\r\n\r\n**后置中间件**\r\n\r\n后置中间件主要是在获得响应后，对`响应`做变更，例如往响应的代码中注入代码，比如加入统计代码之类的。\r\n\r\n一个后置中间件的示例：\r\n\r\n```php\r\nuse Ebcms\\StreamFactory;\r\nuse Psr\\Http\\Message\\ServerRequestInterface;\r\nuse Psr\\Http\\Message\\ResponseInterface;\r\nuse Psr\\Http\\Server\\MiddlewareInterface;\r\nuse Psr\\Http\\Server\\RequestHandlerInterface;\r\n\r\nclass RejectTongjiCode implements MiddlewareInterface\r\n{\r\n\r\n    public function process(\r\n        ServerRequestInterface $request,\r\n        RequestHandlerInterface $handler\r\n    ): ResponseInterface {\r\n        $response = $handler->handle($request);\r\n        // 在响应之后，对响应注入其他代码\r\n        $tongji_code = \'<script>...</script>\';\r\n        $contents = str_replace(\'</body>\', $tongji_code . \'</body>\', $response->getBody());\r\n        return $response->withBody((new StreamFactory())->createStream($contents));\r\n    }\r\n}\r\n\r\n```\r\n\r\n*前置中间件和后置中间件的代码区别就是前置是在`$handler->handle($request)`处理之前返回其他`响应`，后置是在获取`$handler->handle($request)`响应之后对`响应`做出处理*\r\n\r\n**将中间件注入到系统**\r\n\r\n注入到系统中有很多方式，比如在钩子上注入，也可以在控制器中注入，也可以在路由上注入\r\n\r\n**通过钩子注入示例**\r\n\r\n```php\r\n// /hook/app.start/aaa.php\r\nuse Ebcms\\App;\r\nuse Ebcms\\RequestHandler;\r\n\r\nApp::getInstance()->execute(function (\r\n    RequestHandler $requestHandler\r\n) {\r\n    $requestHandler->lazyMiddleware(SomeMiddleware::class);\r\n});\r\n```\r\n\r\n**在控制器中注入示例**\r\n\r\n```php\r\nuse Ebcms\\RequestHandler;\r\n\r\nclass Index\r\n{\r\n    public function __construct(\r\n        RequestHandler $requestHandler\r\n    ) {\r\n        $requestHandler->lazyMiddleware(SomeMiddleware::class);\r\n    }\r\n}\r\n```', '', '0', '1595486714', '1595733767', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('5', '1', '12', '2', '路由', '', '', '**路由类`\\Ebcms\\Router`**\r\n\r\n**路由来自开源项目[ebcms/router](https://github.com/ebcms/router)，欢迎PR ^-^.**\r\n\r\n## 特性\r\n\r\n* 支持中间件绑定\r\n* 支持参数绑定\r\n* 支持静态路由\r\n* 支持分组路由\r\n* 支持正则路由\r\n* 支持可选参数\r\n* 支持地址生成\r\n\r\n## 注册路由\r\n\r\n方法如下：\r\n\r\n```php\r\n$router->getCollector()->get(\'/index\', Index::class);\r\n$router->getCollector()->post(\'/index\', Index::class);\r\n$router->getCollector()->delete(\'/index\', Index::class);\r\n$router->getCollector()->... \r\n```\r\n\r\n**支持`get`,`post`,`put`,`delete`,`patch`,`head`等方法。**\r\n\r\n## 路由分组\r\n\r\n另外也支持路由分组，例如：\r\n\r\n```php\r\n$router->getCollector()->addGroup(\'/group\', function($collector){\r\n	$collector->get(\'/path1\', ControlerA::class);\r\n	$collector->get(\'/path2\', ControllerB::class);\r\n	$collector->addGroup(\'/subgroup\', function($collector){\r\n		$collector->get(\'/subpath\', ControllerC::class);\r\n	});\r\n});\r\n```\r\n\r\n> 支持多级嵌套\r\n\r\n## 绑定中间件\r\n\r\n``` php\r\n// 单个绑定\r\n$router->getCollector()->get(\'/index\', Index::class, \'\', [\'middleware1\', \'middleware2\']);\r\n\r\n// 绑定到分组（该分组下所有的路由都会绑定）\r\n$router->getCollector()->addGroup(\'/group\', function($collector){\r\n	$collector->bindMiddlewares([\'somemiddleware1\', \'somemiddleware2\']);\r\n	$collector->get...\r\n});\r\n```\r\n\r\n## 绑定参数\r\n\r\n``` php\r\n// 单个绑定\r\n$router->getCollector()->get(\'/index\', Index::class, \'\', [], [\'somekey\'=>\'someval\']);\r\n\r\n// 绑定到分组（该分组下所有的路由都会绑定）\r\n$router->getCollector()->addGroup(\'/group\', function($collector){\r\n	$collector->bindParams([\'somekey\'=>\'someval\']);\r\n	$collector->get...\r\n});\r\n```\r\n\r\n## 路由命名\r\n\r\n``` php\r\n$router->getCollector()->get(\'/foo\', Index::class, \'/name1\');\r\n$router->getCollector()->get(\'/bar/{id:\\d+}\', Index::class, \'/name2\');\r\n$router->getCollector()->addGroup(\'/group\', function($collector){\r\n	$collector->get(\'/sub[/{id:\\d+}]\', Index::class, \'/name3\');\r\n});\r\n```\r\n\r\n## 地址生成\r\n\r\n*第一个参数填写路由到命名，参考上文提到的命名*\r\n\r\n`$router->buildUrl(\'/name1\')`就会生成`/foo`\r\n\r\n`$router->buildUrl(\'/name2\', [\'id\'=>333])`就会生成`/bar/333`\r\n\r\n`$router->buildUrl(\'/name3\')`就会生成`/group/sub`\r\n\r\n`$router->buildUrl(\'/name3\', [\'id\'=>122])`就会生成`/group/sub/122`\r\n\r\n## 默认路由\r\n\r\n上面讲的是自定义路由的情况，若是没有定义路由，系统会有默认路由，规则如下：\r\n\r\n`/包/路径`\r\n\r\n举例：\r\n\r\n* `/xielei/article/index` 路由到 `App\\Xielei\\Article\\Http\\Index`\r\n* `/xielei/article/admin/article/create` 路由到 `App\\Xielei\\Article\\Http\\Admin\\Article\\Create`\r\n* `/xielei/article/admin/create-category` 路由到 `App\\Xielei\\Article\\Http\\Admin\\CreateCategory`\r\n* `/xielei/my-demo/show-item` 路由到 `App\\Xielei\\MyDemo\\Http\\ShowItem`\r\n\r\n## 绑定域名\r\n\r\n示例代码如下：\r\n\r\n```php\r\n$router->getCollector()->addGroup(\'http://www.ebcms.com/sub\', function($collector){\r\n	$collector->get(\'/foo\', ControlerA::class,\'/name-1\');\r\n	$collector->addGroup(\'/sub2\', function($collector){\r\n		$collector->get(\'/cc\', ControllerC::class, \'/name-2\');\r\n		$collector->get(\'/cc/ddd.html\', ControllerC::class, \'/name-houzui\');\r\n	});\r\n});\r\n\r\n$router->buildUrl(\'/name-1\'); // http://www.ebcms.com/sub/foo\r\n\r\n$router->buildUrl(\'/name-2\'); // http://www.ebcms.com/sub/sub2/cc\r\n\r\n$router->buildUrl(\'/name-houzui\'); // http://www.ebcms.com/sub/sub2/cc/ddd.html\r\n```\r\n\r\n**通常，要是不绑定域名，不限制https或http的话 `http://www.ebcms.com/` 可以通过代码获取当前的域名而不必固定写死**\r\n', '', '0', '1595486720', '1596074011', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('6', '1', '12', '2', '依赖注入', '', '', '**容器类`\\Ebcms\\Container`**\r\n\r\n**依赖注入来自开源项目[ebcms/psr11](https://github.com/ebcms/psr11)，欢迎PR ^-^.**\r\n\r\n依赖注入的好处就是可以全局管理类，无须实例化直接获取。\r\n\r\n**自动实例化类**\r\n\r\n```php\r\nclass Bar\r\n{\r\n    public function __construct()\r\n    {\r\n    }\r\n}\r\n\r\nclass Foo\r\n{\r\n    public function __construct(Bar $bar)\r\n    {\r\n        $this->bar = $bar;\r\n    }\r\n    \r\n    public function getBar()\r\n    {\r\n        return $this->bar;\r\n    }\r\n}\r\n\r\n$foo = $container->get(Foo::class); //Foo\r\n$foo->getBar(); //Bar\r\n```\r\n\r\n而无须实例化Foo类，也不需要实例化Bar类，这一切都通过$container帮您完成。\r\n\r\n**默认的，执行的控制器的构造方法`__construct()`支持依赖注入，例如：**\r\n\r\n```php\r\nuse Ebcms\\App;\r\nuse Ebcms\\Config;\r\nuse Ebcms\\Router;\r\nuse Xielei\\Template;\r\n\r\nclass Index\r\n{\r\n    public function __construct(\r\n        App $app,\r\n        Router $router,\r\n        Config $config,\r\n        Template $template,\r\n        ...\r\n    ) {\r\n        $config->get(......);\r\n        $router->buildUrl(..);\r\n    }\r\n}\r\n```\r\n\r\n**通过容器获取的类支持依赖注入，例如：**\r\n\r\n```php\r\n$container->get(Foo::class);\r\n```\r\n\r\n那么 此处的Foo类的构造函数就可以依赖注入\r\n\r\n**通过`App::getInstrance()->execute(function(...){})`实现依赖注入，例如：**\r\n\r\n```php\r\nApp::getInstance()->execute(function (\r\n    App $app,\r\n    RequestHandler $requestHandler,\r\n    RequestFilter $input,\r\n    Router $router,\r\n    Config $config,\r\n    Template $template,\r\n    ....\r\n) {\r\n    $app->....\r\n});\r\n```\r\n', '', '0', '1595486816', '1595733793', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('7', '1', '12', '2', '说明', '', '', '为了文档的简洁，本文档对一些常用的、标准的术语或变量等作了简写，具体如下：\r\n\r\n## 系统\r\n\r\n| 变量      | 实体                | 备注 |\r\n| --------- | ------------------- | ---- |\r\n| `$app`    | `\\Ebcms\\App`实例    | 应用 |\r\n| `$router` | `\\Ebcms\\Router`实例 | 路由 |\r\n| `$config` | `\\Ebcms\\Config`实例 | 配置 |\r\n\r\n## Psr 标准\r\n\r\n| 变量               | 实体                                     | 备注     |\r\n| ------------------ | ---------------------------------------- | -------- |\r\n| `$uriFactory`      | 实现接口`UriFactoryInterface`的实例      | URI 工厂 |\r\n| `$responseFactory` | 实现接口`ResponseFactoryInterface`的实例 | 响应工厂 |\r\n| `$response`        | 实现接口`ResponseInterface`的实例        | 响应     |\r\n| `响应`             | 实现接口`ResponseInterface`的实例        |          |\r\n| `$container`       | 实现接口`ContainerInterface`的实例       | 容器     |\r\n| `$cache`           | 实现接口`CacheInterface`的实例           | 缓存     |\r\n| `$logger`          | 实现接口`LoggerInterface`的实例          | 日志     |\r\n| `$simplecache`     | 实现接口`SimpleCacheInterface`的实例     | 简单缓存 |\r\n| `$...`             | ...                                      | ...      |\r\n\r\n_还有很多，具体请看[PSR](https://www.php-fig.org/)官方文档_\r\n\r\n', '', '0', '1595488340', '1595733738', '1', '8');
INSERT INTO `prefix_xielei_manual_post` VALUES ('12', '1', '0', '1', '核心手册', '', '', null, '', '0', '1595665449', '1595665481', '1', '5');
INSERT INTO `prefix_xielei_manual_post` VALUES ('13', '1', '0', '1', '小试牛刀', '', '', null, '', '0', '1595665480', '1595855287', '1', '4');
INSERT INTO `prefix_xielei_manual_post` VALUES ('14', '1', '13', '2', '文件结构', '', '', '``` php\r\nxiao-wang\\hello-world\r\n├─library               类库目录\r\n│  ├─Http               控制器目录\r\n│  │  ├─Index.php       Index控制器\r\n│\r\n├─composer.json         composer 定义文件（此文件相当重要，必须要有）\r\n```\r\n\r\n这是这个包的目录结构，一共只有两个文件：\r\n\r\n* composer.json 包配置\r\n* Index.php 控制器\r\n', '', '0', '1595665524', '1595856848', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('15', '1', '13', '2', '包配置', '', '', '该包的composer.json配置文件如下：\r\n\r\n``` json\r\n{\r\n    \"name\": \"xiao-wang/hello-world\",\r\n    \"description\": \"小王的学习项目\",\r\n    \"type\": \"ebcms-app\", //该参数非常重要，必须要填写为ebcms-app\r\n    \"license\": \"MIT\",\r\n    \"require\": {\r\n        \"ebcms/framework\": \"1.*\"\r\n    },\r\n    \"autoload\": {\r\n        \"psr-4\": {\r\n            \"App\\\\XiaoWang\\\\HelloWorld\\\\\": \"src/library/\"\r\n        }\r\n    }\r\n}\r\n```\r\n\r\n**重点：**\r\n\r\n其中有一个重要配置项就是`type`，该参数必须填`ebcms-app`，ebcms会通过该参数判断这个包是否是ebcms的包，若判断是，则会注册，注册后，`config`以及`hook`里面的配置在需要的时候才会被读取，否则该包不会被认为是一个ebcms包，也无法通过`$config`读取其配置项，也不会执行相应的钩子。\r\n\r\n另外，此处定义了`App\\\\Xiaowang\\\\HelloWorld\\\\`命名空间的路径是`src/library/`，那么当访问/xiao-wang/hello-world/xxx的时候，就会路由到`App\\\\Xiaowang\\\\HelloWorld\\\\Http\\\\Xxx`控制器，这点很重要，当然，你也可以定义到其他目录。', '', '0', '1595665537', '1595856918', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('16', '1', '13', '2', '控制器文件', '', '', '```php\r\nnamespace App\\XiaoWang\\HelloWorld\\Http;\r\n\r\nclass Index\r\n{\r\n    public function handle()\r\n    {\r\n        return \'Hello World!\';\r\n    }\r\n}\r\n```\r\n\r\n**注意：**\r\n\r\n控制器必须要有一个handle方法，ebcms和其他系统不一样，ebcms是路由到控制器而不是路由到控制器中的方法，路由到控制器后规定了执行handle方法，handle方法直至自动注入。', '', '0', '1595665568', '1595857575', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('17', '1', '0', '1', '第二个APP(进阶)', '', '', null, '', '0', '1595665829', '1595733697', '2', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('18', '1', '0', '1', '杂项', '', '', null, '', '0', '1595665833', '1595665837', '1', '0');
INSERT INTO `prefix_xielei_manual_post` VALUES ('19', '1', '18', '2', 'App全网发布', '', '', '访问[packagist.org](https://packagist.org/)，这是composer的官方仓库\r\n\r\n注册账户后，点击右上角的`submit`按钮，填入您的开源仓库地址（推荐使用[github](https://github.com)）,提交即可', '', '0', '1595665851', '1595738065', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('20', '1', '27', '2', '实现restful风格的控制器', '', '', '首先定义一个 trait\r\n\r\n``` php\r\nuse Ebcms\\App;\r\nuse Psr\\Http\\Message\\ResponseFactoryInterface;\r\nuse Psr\\Http\\Message\\ServerRequestInterface;\r\n\r\ntrait RestfulTrait\r\n{\r\n    final public function handle(\r\n        ServerRequestInterface $request,\r\n        ResponseFactoryInterface $response_factory\r\n    ) {\r\n        $method = strtolower($request->getMethod());\r\n        if (in_array($method, [\'get\', \'put\', \'post\', \'delete\', \'head\', \'patch\', \'options\']) && is_callable([$this, $method])) {\r\n            return App::getInstance()->execute([$this, $method]);\r\n        } else {\r\n            return $response_factory->createResponse(405);\r\n        }\r\n    }\r\n}\r\n```\r\n\r\n然后在需要的地方引入\r\n\r\n``` php\r\nuse Psr\\Http\\Message\\ResponseInterface;\r\n\r\nclass Demo\r\n{\r\n    use RestfulTrait;\r\n\r\n    public function get(\r\n        // ...\r\n    ): ResponseInterface {\r\n        return $responseFactory->createResponse(.....);\r\n    }\r\n\r\n    public function post(\r\n        // ...\r\n    ): ResponseInterface {\r\n        return $responseFactory->createResponse(.....);\r\n    }\r\n\r\n    public function delete(\r\n        // ...\r\n    ): ResponseInterface {\r\n        return $responseFactory->createResponse(.....);\r\n    }\r\n}\r\n```', '', '0', '1595665911', '1595737035', '1', '4');
INSERT INTO `prefix_xielei_manual_post` VALUES ('21', '1', '18', '2', '制作私有APP', '', '', null, '', '0', '1595666121', '1595666123', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('22', '1', '0', '1', '优秀APP推荐', '', '', null, '', '0', '1595670345', '1595670388', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('23', '1', '22', '2', 'xielei/manual 文档系统', '', '', '## 特点\r\n\r\n* 采用markdown书写\r\n* 多级目录\r\n* 搜索\r\n* 代码作色\r\n\r\n## 安装方式\r\n\r\n```\r\ncomposer require xielei/manual\r\n```\r\n\r\n***本文档即采用此系统***\r\n\r\n## 开源地址\r\n\r\n[Github](https://github.com/xielei/manual)', '', '0', '1595670367', '1595737361', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('24', '1', '22', '2', 'xielei/info 分类信息管理系统', '', '', '## 特点\r\n\r\n* 支持`单选`、`多选`、`范围`、`多属性`、`树型筛选`等多种筛选方式混合\r\n* 支持自定义字段\r\n\r\n## 安装方式\r\n\r\n..\r\n\r\n', '', '0', '1595670454', '1595737759', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('25', '1', '22', '2', 'xielei/article 文章管理系统', '', '', '## 特点\r\n\r\n* 简单，适合做文章站\r\n* 支持全文检索（无须其他扩展）\r\n\r\n## 安装方式\r\n\r\n``` bash\r\ncomposer require xielei/article\r\n```\r\n', '', '0', '1595670468', '1595737549', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('26', '1', '22', '2', 'xielei/installer 安装引导系统', '', '', '## 特点\r\n\r\n* ...\r\n\r\n## 安装方式\r\n\r\n```\r\ncomposer require xielei/installer\r\n```\r\n\r\n开源地址 [github](https://github.com/xiele/installer)', '', '0', '1595670569', '1595737838', '1', '0');
INSERT INTO `prefix_xielei_manual_post` VALUES ('27', '1', '0', '1', '代码参考', '', '', null, '', '0', '1595817521', '1596074481', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('28', '1', '27', '2', '自定义404页面', '', '', '自定义404可以通过中间件来实现，在响应之前，判断状态码，若是404，这返回一个自定义页面\r\n\r\n中间件代码：\r\n\r\n``` php\r\nuse Ebcms\\StreamFactory;\r\nuse Psr\\Http\\Message\\ServerRequestInterface;\r\nuse Psr\\Http\\Message\\ResponseInterface;\r\nuse Psr\\Http\\Server\\MiddlewareInterface;\r\nuse Psr\\Http\\Server\\RequestHandlerInterface;\r\n\r\nclass Page404 implements MiddlewareInterface\r\n{\r\n\r\n    public function process(\r\n        ServerRequestInterface $request,\r\n        RequestHandlerInterface $handler\r\n    ): ResponseInterface {\r\n        $response = $handler->handle($request);\r\n        if($response->getStatusCode() == 404){\r\n            $html = <<<\'html\'\r\n<h1>404</h1>\r\n<p>页面不存在~</p>\r\nhtml;\r\n            return $response->withBody((new StreamFactory())->createStream($html));\r\n        }\r\n        return $response;\r\n    }\r\n}\r\n```\r\n\r\n通过app.start将中间件注册到系统\r\n\r\n```\r\nuse Ebcms\\App;\r\nuse Ebcms\\RequestHandler;\r\n\r\nApp::getInstance()->execute(function (\r\n    RequestHandler $requestHandler,\r\n    App $app\r\n) {\r\n    $requestHandler->lazyMiddleware(Page404::class);\r\n});\r\n```', '', '0', '1595817557', '1596075625', '1', '5');
INSERT INTO `prefix_xielei_manual_post` VALUES ('29', '1', '12', '2', '包结构', '', '', 'ebcms的应用都是通过包发布的，一个包就是一个应用，一个包可以是私有的，也可以将包发布到composer上供他人使用。\r\n\r\n**这是推荐的包结构**\r\n\r\n``` php\r\n包结构\r\n├─tests                 单元测试\r\n│  ├─...                \r\n│\r\n├─config                配置目录\r\n│  ├─foo.php            一些配置文件\r\n│  ├─...                \r\n│\r\n├─hook                  钩子目录\r\n│  ├─app.start          app.start 挂载点\r\n│  │  ├─xxx.php         挂在的文件\r\n│  ├─app.start@包名     app.start@包名 挂载点\r\n│  ├─app.end@包名       app.end@包名 挂载点\r\n│  ├─app.end            app.end 挂载点\r\n│\r\n├─template              视图目录\r\n│  ├─...                \r\n│\r\n├─library               类库目录\r\n│  ├─Http               控制器\r\n│  ├─Model              模型\r\n│  ├─Middleware         中间件\r\n│  ├─Traits             Traits\r\n│  ├─...                \r\n│\r\n├─.gitignore            gitignore 定义文件\r\n├─composer.json         composer 定义文件（此文件相当重要，必须要有）\r\n├─LICENSE               授权说明文件\r\n├─README.md             README 文件\r\n```', '', '0', '1595856298', '1596289665', '1', '0');
INSERT INTO `prefix_xielei_manual_post` VALUES ('30', '1', '13', '2', '将包安装到系统', '', '', '包已经开发完毕，需要将包安装到ebcms上面。\r\n\r\n首先要创建工程：\r\n\r\n``` bash\r\ncomposer create-project ebcms/project\r\n```\r\n\r\n然后将刚刚开发的包安装到该工程上面。\r\n\r\n**EBCMS的包安装方式只有一种，那就是composer!!**\r\n\r\n你可以选择将包发布到[packagist.org](https://packagist.org)上面，然后通过：\r\n\r\n``` bash\r\ncomposer require xiao-wang/hello-world\r\n```\r\n\r\n也可以不发布直接本地安装，新建一个composer.json：\r\n\r\n``` json\r\n{\r\n    \"repositories\": [\r\n        {\r\n            \"type\": \"path\",\r\n            \"url\": \"E:\\\\你的包路径\\\\xiao-wang\\\\hello-world\"\r\n        }\r\n    ],\r\n}\r\n```\r\n\r\n然后执行\r\n\r\n``` bash\r\ncomposer require xiao-wang/hello-world\r\n```\r\n\r\n*当然，你也可以将你的仓库地址或者其他..加入到`repositories`配置里面，然后安装也可以，当然，这是composer的内容了，有兴趣可以去官网看看*\r\n\r\n现在该demo已经可以访问了 `http://xxxx/刚刚你的工程目录/public/index.php/xiao-wang/hello-world/index`', '', '0', '1595857639', '1596290326', '1', '0');
INSERT INTO `prefix_xielei_manual_post` VALUES ('31', '1', '27', '2', '自定义错误页面', '', '', '参考[自定义404页面](https://www.ebcms.com/manual/search/ebcms_framework?q=%E8%87%AA%E5%AE%9A%E4%B9%89404%E9%A1%B5%E9%9D%A2)', '', '0', '1596074474', '1596076092', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('32', '1', '27', '2', '记录请求日志', '', '', '将代码挂载到`app.start`即可\r\n\r\n若要记录某包的请求日志，挂载到`app.start@包`即可\r\n\r\n``` php\r\n// /hook/app.start/log.php\r\nuse Ebcms\\App;\r\nuse Ebcms\\Container;\r\nuse Monolog\\Handler\\StreamHandler;\r\nuse Monolog\\Logger;\r\nuse Psr\\Log\\LoggerInterface;\r\n\r\nApp::getInstance()->execute(function (\r\n    Container $container,\r\n    App $app\r\n) {\r\n    $container->set(LoggerInterface::class, function () use ($app): LoggerInterface {\r\n        $log = new Logger($_SERVER[\'HTTP_HOST\']);\r\n        $log->pushHandler(new StreamHandler($app->getAppPath() . \'/runtime/log/\' . date(\'Y-m-d\') . \'/debug.log\', Logger::DEBUG));\r\n        return $log;\r\n    });\r\n    $container->get(LoggerInterface::class)->debug($_SERVER[\'REQUEST_METHOD\'] . \':\' . $_SERVER[\'REQUEST_URI\'], [$_POST, $_GET]);\r\n});\r\n```', '', '0', '1596074551', '1596074679', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('33', '1', '27', '2', '创建自定义函数', '', '', '将代码挂载到`app.start`就能够创建全局函数\r\n\r\n若只要某特定包生效，这挂载到`app.start@包`即可\r\n\r\n``` php\r\nfunction test(): array\r\n{\r\n    return [];\r\n}\r\n```', '', '0', '1596074750', '1596074860', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('34', '1', '27', '2', '判断请求方式', '', '', '``` php\r\n/**\r\n * 判断是否为get请求\r\n *\r\n * @return bool\r\n */\r\nfunction is_get():bool\r\n{\r\n    return $_SERVER[\'REQUEST_METHOD\'] == \'GET\' ? true : false;\r\n}\r\n\r\n/**\r\n * 判断是否为post请求\r\n *\r\n * @return bool\r\n */\r\nfunction is_post():bool\r\n{\r\n    return $_SERVER[\'REQUEST_METHOD\'] == \'POST\' ? true : false;\r\n}\r\n\r\n/**\r\n * 判断是否为ajax请求\r\n *\r\n * @return bool\r\n */\r\nfunction is_ajax():bool\r\n{\r\n    return ((isset($_SERVER[\'HTTP_X_REQUESTED_WITH\']) && strtolower($_SERVER[\'HTTP_X_REQUESTED_WITH\']) == \'xmlhttprequest\')) ? true : false;\r\n}\r\n```', '', '0', '1596099765', '1596099823', '1', '0');
INSERT INTO `prefix_xielei_manual_post` VALUES ('35', '1', '12', '2', '目录结构', '', '', '这里是一个ebcms-framework推荐的工程目录结构。\r\n\r\n可以基于这个工程，安装其他应用包，例如文章系统 商城系统等等。\r\n\r\n具体请看[ebcms/project](https://github.com/ebcms/project)\r\n\r\n``` txt\r\n工程目录结构\r\n├─tests                  单元测试\r\n│  ├─...                \r\n│\r\n├─config                 配置目录\r\n│  │  ├─vendor_name      提供者\r\n│  │  │  ├─project_name  包名\r\n│  │  │  │  ├─foo.php    配置文件\r\n│  ├─...                \r\n│\r\n├─hook                   钩子目录\r\n│  ├─app.start           app.start 挂载点\r\n│  │  ├─xxx.php          挂在的文件\r\n│  ├─app.start@包名      app.start@包名 挂载点\r\n│  ├─app.end@包名        app.end@包名 挂载点\r\n│  ├─...                \r\n│  ├─app.end             app.end 挂载点\r\n│  ├─...                \r\n│\r\n├─public                 网站目录\r\n│  ├─index.php           入口文件\r\n│  ├─...                \r\n│\r\n├─vendor                 composer包目录\r\n│\r\n├─.gitignore             gitignore 定义文件\r\n├─composer.json          composer 定义文件（此文件相当重要，必须要有）\r\n├─LICENSE                授权说明文件\r\n├─README.md              README 文件\r\n```\r\n\r\n这只是一个最基本的项目结构，每个项目都由很多应用包组成，这些应用包可以是自己开发的，也可以是通过composer安装的别人开发的。', '', '0', '1596289477', '1596291197', '1', '7');
INSERT INTO `prefix_xielei_manual_post` VALUES ('36', '2', '0', '1', '核心', '', '', null, '', '0', '1598097603', '1598097683', '1', '10');
INSERT INTO `prefix_xielei_manual_post` VALUES ('37', '2', '0', '1', '属性', '', '', null, '', '0', '1598097613', '1598097684', '1', '9');
INSERT INTO `prefix_xielei_manual_post` VALUES ('40', '2', '0', '1', '文档处理', '', '', null, '', '0', '1598097644', '1598097685', '1', '8');
INSERT INTO `prefix_xielei_manual_post` VALUES ('41', '2', '0', '1', '筛选', '', '', null, '', '0', '1598097648', '1598097686', '1', '7');
INSERT INTO `prefix_xielei_manual_post` VALUES ('42', '2', '0', '1', '事件', '', '', null, '', '0', '1598097655', '1598097686', '1', '6');
INSERT INTO `prefix_xielei_manual_post` VALUES ('43', '2', '0', '1', '效果', '', '', null, '', '0', '1598097661', '1598097687', '1', '5');
INSERT INTO `prefix_xielei_manual_post` VALUES ('44', '2', '0', '1', 'AJAX', '', '', null, '', '0', '1598097664', '1598097687', '1', '4');
INSERT INTO `prefix_xielei_manual_post` VALUES ('45', '2', '0', '1', '工具', '', '', null, '', '0', '1598097671', '1598097687', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('46', '2', '0', '1', '事件对象', '', '', null, '', '0', '1598097681', '1598097688', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('47', '2', '0', '1', 'CSS', '', '', null, '', '0', '1598097704', '1598097717', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('48', '2', '0', '1', '选择器', '', '', null, '', '0', '1598097709', '1598097717', '1', '0');
INSERT INTO `prefix_xielei_manual_post` VALUES ('49', '2', '36', '1', '核心函数', '', '', null, '', '0', '1598097734', '1598097773', '1', '5');
INSERT INTO `prefix_xielei_manual_post` VALUES ('50', '2', '36', '1', '对象访问', '', '', null, '', '0', '1598097743', '1598097774', '1', '4');
INSERT INTO `prefix_xielei_manual_post` VALUES ('51', '2', '36', '1', '数据缓存', '', '', null, '', '0', '1598097747', '1598097774', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('52', '2', '36', '1', '队列控制', '', '', null, '', '0', '1598097755', '1598097774', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('53', '2', '36', '1', '插件机制', '', '', null, '', '0', '1598097758', '1598097775', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('54', '2', '36', '1', '多库共存', '', '', null, '', '0', '1598097772', '1598097775', '1', '0');
INSERT INTO `prefix_xielei_manual_post` VALUES ('55', '2', '49', '2', 'jQuery([selector,[context]])', '', '', '## 概述\r\n\r\n这个函数接收一个包含 CSS 选择器的字符串，然后用这个字符串去匹配一组元素。\r\n\r\njQuery 的核心功能都是通过这个函数实现的。 jQuery中的一切都基于这个函数，或者说都是在以某种方式使用这个函数。这个函数最基本的用法就是向它传递一个表达式（通常由 CSS 选择器组成），然后根据这个表达式来查找所有匹配的元素。\r\n\r\n默认情况下, 如果没有指定context参数，$()将在当前的 HTML document中查找 DOM 元素；如果指定了 context 参数，如一个 DOM 元素集或 jQuery 对象，那就会在这个 context 中查找。在jQuery 1.3.2以后，其返回的元素顺序等同于在context中出现的先后顺序。\r\n\r\n参考文档中 选择器 部分获取更多用于 expression 参数的 CSS 语法的信息。\r\n\r\n## 参数\r\n\r\nselector,[context]String,Element,/jQueryV1.0selector:用来查找的字符串\r\n\r\ncontext:作为待查找的 DOM 元素集、文档或 jQuery 对象。\r\n\r\nelementElementV1.0一个用于封装成jQuery对象的DOM元素\r\n\r\nobjectobjectV1.0一个用于封装成jQuery对象\r\n\r\nelementArrayElementV1.0一个用于封装成jQuery对象的DOM元素数组。\r\n\r\njQuery objectobjectV1.0一个用于克隆的jQuery对象。\r\n\r\njQuery()V1.4返回一个空的jQuery对象。\r\n\r\n## 示例\r\n\r\n描述:\r\n\r\n找到所有 p 元素，并且这些元素都必须是 div 元素的子元素。\r\n\r\njQuery 代码:\r\n\r\n``` javascript\r\n$(\"div > p\");\r\n```\r\n\r\n描述:\r\n\r\n设置页面背景色。\r\n\r\njQuery 代码:\r\n\r\n``` javascript\r\n$(document.body).css( \"background\", \"black\" );\r\n```\r\n\r\n描述:\r\n\r\n隐藏一个表单中所有元素。\r\n\r\njQuery 代码:\r\n\r\n``` javascript\r\n$(myForm.elements).hide()\r\n```\r\n\r\n描述:\r\n\r\n在文档的第一个表单中，查找所有的单选按钮(即: type 值为 radio 的 input 元素)。\r\n\r\njQuery 代码:\r\n\r\n``` javascript\r\n$(\"input:radio\", document.forms[0]);\r\n```\r\n\r\n描述:\r\n\r\n在一个由 AJAX 返回的 XML 文档中，查找所有的 div 元素。\r\n\r\njQuery 代码:\r\n\r\n``` javascript\r\n$(\"div\", xml.responseXML);\r\n```', '', '0', '1598097798', '1598098150', '1', '4');
INSERT INTO `prefix_xielei_manual_post` VALUES ('56', '2', '49', '2', 'jQuery(html,[ownerDocument])', '', '', null, '', '0', '1598097808', '1598097835', '1', '3');
INSERT INTO `prefix_xielei_manual_post` VALUES ('57', '2', '49', '2', 'jQuery(callback)', '', '', null, '', '0', '1598097817', '1598097836', '1', '2');
INSERT INTO `prefix_xielei_manual_post` VALUES ('58', '2', '49', '2', 'holdReady(hold)', '', '', null, '', '0', '1598097826', '1598098239', '1', '1');
INSERT INTO `prefix_xielei_manual_post` VALUES ('59', '2', '49', '2', 'each(callback)', '', '', null, '', '0', '1598097834', '1598098234', '1', '0');
