<?php

declare(strict_types=1);

namespace App\Xielei\Admin\Http\Admin;

use App\Xielei\Admin\Middleware\Auth;
use App\Xielei\Admin\Traits\ResponseTrait;
use App\Xielei\Admin\Traits\RestfulTrait;
use Ebcms\App;
use Ebcms\Config;
use Ebcms\Container;
use Ebcms\Hook;
use Ebcms\RequestHandler;
use Ebcms\Router;
use Psr\SimpleCache\CacheInterface;
use Xielei\RequestFilter;
use Xielei\Template;

abstract class Common
{
    use RestfulTrait;
    use ResponseTrait;

    public function __construct()
    {
        App::getInstance()->execute(function (
            RequestHandler $requestHandler,
            Container $container
        ) {
            $requestHandler->lazyMiddleware(Auth::class);

            $container->set(Template::class, function () use ($container) {
                $template = new Template(
                    $container->has(CacheInterface::class) ? $container->get(CacheInterface::class) : null
                );
                $config = (function () use ($container): Config {
                    return $container->get(Config::class);
                })();
                $app = (function () use ($container): App {
                    return $container->get(App::class);
                })();
                $template->assign([
                    'input' => $container->get(RequestFilter::class),
                    'config' => $config,
                    'router' => $container->get(Router::class),
                    'hook' => $container->get(Hook::class),
                ]);
                foreach ($app->getPackages() as $app_name => $cfg) {
                    if ($app_name == $app->getRequestPackage()) {
                        $template->setRoot(
                            $config->get('admin.template_root@' . str_replace('/', '.', $app_name))
                                ?: ($cfg['dir'] . '/src/template/admin')
                        );
                        break;
                    }
                }
                return $template;
            });
        });
    }
}
